/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import sun.awt.X11GraphicsConfig;

public class X11GraphicsDevice
extends GraphicsDevice {
    int screen;
    GraphicsConfiguration[] configs;
    GraphicsConfiguration defaultConfig;

    public X11GraphicsDevice(int n) {
        this.screen = n;
    }

    private native int getConfigVisualId(int var1);

    public GraphicsConfiguration[] getConfigurations() {
        GraphicsConfiguration[] graphicsConfigurationArray = this.configs;
        if (graphicsConfigurationArray == null) {
            int n = 0;
            int n2 = this.getNumConfigs();
            graphicsConfigurationArray = new GraphicsConfiguration[n2];
            if (this.defaultConfig != null) {
                graphicsConfigurationArray[0] = this.defaultConfig;
                ++n;
            }
            while (n < n2) {
                int n3 = this.getConfigVisualId(n);
                graphicsConfigurationArray[n] = X11GraphicsConfig.getConfig(this, n3);
                ++n;
            }
            this.configs = graphicsConfigurationArray;
        }
        return graphicsConfigurationArray;
    }

    public GraphicsConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null) {
            int n = this.getConfigVisualId(0);
            this.defaultConfig = X11GraphicsConfig.getConfig(this, n);
        }
        return this.defaultConfig;
    }

    public native int getDisplay();

    public String getIDstring() {
        return ":0." + this.screen;
    }

    private native int getNumConfigs();

    public int getScreen() {
        return this.screen;
    }

    public int getType() {
        return 0;
    }

    public String toString() {
        return "X11GraphicsDevice[screen=" + this.screen + "]";
    }
}

