/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.TAreaDiscretiser;
import sun.awt.Albert.TCAGRoot;
import sun.awt.Albert.TCAGUnary;
import sun.awt.Albert.TGEllipse;
import sun.awt.Albert.TGLoop;
import sun.awt.Albert.TGParametricArray;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGPointArray;
import sun.awt.Albert.TGPolygon;
import sun.awt.Albert.TGRPoint;
import sun.awt.Albert.TGRPointArray;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.TGrafExtractor;
import sun.awt.Albert.TGrafMatrix;
import sun.awt.Albert.TOutlineMakerVertexEngine;

public class TSamplingExtractor
extends TGrafExtractor {
    private static final TGRect fkInfiniteRect = new TGRect(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private TOutlineMakerVertexEngine fVertexEngine;
    private TGRect fClipBounds;
    private double fEpsilon;

    public TSamplingExtractor(TOutlineMakerVertexEngine tOutlineMakerVertexEngine, double d) {
        this.fVertexEngine = tOutlineMakerVertexEngine;
        this.fClipBounds = fkInfiniteRect;
        this.fEpsilon = d;
    }

    public final void SetClipBounds(TGRect tGRect) {
        this.fClipBounds = tGRect;
    }

    public void extractEllipse(TGEllipse tGEllipse, TCAGUnary tCAGUnary, TGrafMatrix tGrafMatrix) {
        this.extractLoop(new TGLoop(tGEllipse), tCAGUnary, tGrafMatrix);
    }

    public void extractLoop(TGLoop tGLoop, TCAGUnary tCAGUnary, TGrafMatrix tGrafMatrix) {
        int n;
        if (!tGLoop.isEmpty() && (n = tGLoop.getNumberOfPoints()) > 0) {
            Object object;
            int n2 = tGLoop.getOrder();
            boolean bl = tGLoop.isCloseable();
            TGRPointArray tGRPointArray = tGLoop.fPoints;
            TGRPoint[] tGRPointArray2 = tGRPointArray.getArray();
            TGParametricArray tGParametricArray = tGLoop.fKnots;
            double[] dArray = tGParametricArray.getArray();
            if (bl || tGrafMatrix != null) {
                object = tGRPointArray2;
                tGRPointArray = new TGRPointArray(n + (bl ? n2 - 1 : 0));
                tGRPointArray2 = tGRPointArray.getArray();
                System.arraycopy(object, 0, tGRPointArray2, 0, n);
                if (tGrafMatrix != null && !tGrafMatrix.isIdentity()) {
                    tGrafMatrix.transformPoints(tGRPointArray);
                }
                if (bl) {
                    int n3 = n;
                    while (n3 < n + n2 - 1) {
                        tGRPointArray2[n3].copyFrom(tGRPointArray2[n3 - n]);
                        ++n3;
                    }
                    if (n2 > 2) {
                        double[] dArray2 = dArray;
                        int n4 = 2 * n2 + n - 1;
                        tGParametricArray = new TGParametricArray(n4);
                        dArray = tGParametricArray.getArray();
                        System.arraycopy(dArray2, 0, dArray, 0, n2 + n);
                        double d = dArray[1] - dArray[0];
                        int n5 = n2 + n;
                        while (n5 < n4) {
                            dArray[n5] = dArray[n5 - 1] + d;
                            ++n5;
                        }
                    }
                }
            }
            object = new TAreaDiscretiser(this.fVertexEngine, tCAGUnary, fkInfiniteRect, this.fEpsilon);
            ((TAreaDiscretiser)object).DiscretizeLoop(n2, tGParametricArray, tGRPointArray, true);
        }
    }

    public void extractPolygon(TGPolygon tGPolygon, TCAGUnary tCAGUnary, TGrafMatrix tGrafMatrix) {
        int n = tGPolygon.getNumberOfPoints();
        if (n > 0) {
            TGPoint[] tGPointArray = tGPolygon.getPoints();
            if (tGrafMatrix != null && !tGrafMatrix.isIdentity()) {
                TGPointArray tGPointArray2 = new TGPointArray();
                tGPolygon.getPoints(tGPointArray2);
                tGrafMatrix.transformPoints(tGPointArray2);
                tGPointArray = tGPointArray2.getArray();
            }
            this.fVertexEngine.SetCAGNode(tCAGUnary);
            int n2 = 0;
            while (n2 < n) {
                this.fVertexEngine.AddVertex(tGPointArray[n2]);
                ++n2;
            }
            this.fVertexEngine.End();
        }
    }

    public void extractRect(TGRect tGRect, TCAGUnary tCAGUnary, TGrafMatrix tGrafMatrix) {
        this.fVertexEngine.SetCAGNode(tCAGUnary);
        if (tGrafMatrix == null || tGrafMatrix.isIdentity()) {
            this.fVertexEngine.AddVertex(tGRect.getTopLeft());
            this.fVertexEngine.AddVertex(tGRect.getTopRight());
            this.fVertexEngine.AddVertex(tGRect.getBottomRight());
            this.fVertexEngine.AddVertex(tGRect.getBottomLeft());
        } else {
            this.fVertexEngine.AddVertex(tGrafMatrix.transformPoint(tGRect.getTopLeft()));
            this.fVertexEngine.AddVertex(tGrafMatrix.transformPoint(tGRect.getTopRight()));
            this.fVertexEngine.AddVertex(tGrafMatrix.transformPoint(tGRect.getBottomRight()));
            this.fVertexEngine.AddVertex(tGrafMatrix.transformPoint(tGRect.getBottomLeft()));
        }
        this.fVertexEngine.End();
    }

    public void render(TCAGRoot tCAGRoot) {
        this.fVertexEngine.Render(tCAGRoot);
        this.deleteCAGNodes();
    }
}

