/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.MAreaGeometry;
import sun.awt.Albert.TCAGEvenOdd;
import sun.awt.Albert.TCAGNode;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.TGrafExtractor;
import sun.awt.Albert.TGrafMatrix;

public class TRectGeometry
extends MAreaGeometry {
    public TGRect fRect;

    public TRectGeometry() {
        this.fRect = new TGRect(0.0, 0.0, 0.0, 0.0);
    }

    public TRectGeometry(TGRect tGRect) {
        this.fRect = (TGRect)tGRect.clone();
        this.updateTimeStamp();
    }

    public TRectGeometry(TRectGeometry tRectGeometry) {
        super(tRectGeometry);
        this.fRect = null;
        if (tRectGeometry.fRect != null) {
            this.fRect = (TGRect)tRectGeometry.fRect.clone();
        }
    }

    public Object clone() {
        return new TRectGeometry(this);
    }

    public MAreaGeometry cloneAndAdd(MAreaGeometry mAreaGeometry) {
        if (mAreaGeometry.contains(this.fRect)) {
            return mAreaGeometry;
        }
        return super.cloneAndAdd(mAreaGeometry);
    }

    public MAreaGeometry cloneAndExclusiveOr(MAreaGeometry mAreaGeometry) {
        return super.cloneAndExclusiveOr(mAreaGeometry);
    }

    public MAreaGeometry cloneAndIntersect(MAreaGeometry mAreaGeometry) {
        if (mAreaGeometry.contains(this.fRect)) {
            return this;
        }
        if (mAreaGeometry.isRectangular()) {
            TRectGeometry tRectGeometry = (TRectGeometry)this.clone();
            tRectGeometry.fRect.intersectWith(mAreaGeometry.getBounds());
            tRectGeometry.updateTimeStamp();
            return tRectGeometry;
        }
        return super.cloneAndIntersect(mAreaGeometry);
    }

    public MAreaGeometry cloneAndSubtract(MAreaGeometry mAreaGeometry) {
        if (mAreaGeometry.contains(this.fRect)) {
            return null;
        }
        return super.cloneAndSubtract(mAreaGeometry);
    }

    public MAreaGeometry cloneAndTransform(TGrafMatrix tGrafMatrix) {
        if (tGrafMatrix.isRectilinear()) {
            TRectGeometry tRectGeometry = (TRectGeometry)this.clone();
            tRectGeometry.fRect = tGrafMatrix.transformBounds(this.fRect);
            return tRectGeometry;
        }
        return super.cloneAndTransform(tGrafMatrix);
    }

    public boolean contains(TGPoint tGPoint) {
        return this.fRect.contains(tGPoint);
    }

    public boolean contains(TGRect tGRect) {
        return this.fRect.contains(tGRect);
    }

    public final TRectGeometry copyFrom(TRectGeometry tRectGeometry) {
        if (this != tRectGeometry) {
            super.copyFrom(tRectGeometry);
            this.fRect = tRectGeometry.fRect;
        }
        return this;
    }

    public boolean equals(MAreaGeometry mAreaGeometry) {
        if (this.getClass().equals(mAreaGeometry.getClass())) {
            TRectGeometry tRectGeometry = (TRectGeometry)mAreaGeometry;
            return super.equals(mAreaGeometry) && (this.fRect == tRectGeometry.fRect || this.fRect != null && tRectGeometry.fRect != null && this.fRect.equals(tRectGeometry.fRect));
        }
        return false;
    }

    public void extract(TGrafExtractor tGrafExtractor, TCAGNode tCAGNode, TGrafMatrix tGrafMatrix) {
        TCAGEvenOdd tCAGEvenOdd = new TCAGEvenOdd(tCAGNode);
        tGrafExtractor.adoptCAGNode(tCAGEvenOdd);
        tGrafExtractor.extractRect(this.fRect, tCAGEvenOdd, tGrafMatrix);
    }

    public TGRect getBounds() {
        return this.fRect;
    }

    public boolean intersects(TGRect tGRect) {
        return this.fRect.intersects(tGRect);
    }

    public boolean isEmpty() {
        return this.fRect.isEmpty();
    }

    public boolean isPolygonal() {
        return true;
    }

    public boolean isRectangular() {
        return true;
    }
}

