/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import sun.awt.Albert.TGPoint;

public final class TGRect
extends Rectangle2D.Double {
    private static final TGRect fkZeroRect = new TGRect(0.0, 0.0, 0.0, 0.0);

    public TGRect() {
    }

    public TGRect(double d, double d2, double d3, double d4) {
        this.set(d, d2, d3, d4);
    }

    public TGRect(Rectangle2D rectangle2D) {
        this.set(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY());
    }

    public TGRect(RectangularShape rectangularShape) {
        this.set(rectangularShape.getMinX(), rectangularShape.getMinY(), rectangularShape.getMaxX(), rectangularShape.getMaxY());
    }

    public TGRect(TGPoint tGPoint) {
        this(tGPoint, tGPoint);
    }

    public TGRect(TGPoint tGPoint, TGPoint tGPoint2) {
        this.set(tGPoint, tGPoint2);
    }

    public TGRect(TGRect tGRect) {
        super.setRect(tGRect);
    }

    public Object clone() {
        return new TGRect(this);
    }

    public TGRect copyFrom(TGRect tGRect) {
        this.x = tGRect.x;
        this.y = tGRect.y;
        this.width = tGRect.width;
        this.height = tGRect.height;
        return this;
    }

    public boolean equalSize(TGRect tGRect) {
        return this.width == tGRect.width && this.height == tGRect.height;
    }

    public boolean equals(TGRect tGRect) {
        return this.x == tGRect.x && this.y == tGRect.y && this.width == tGRect.width && this.height == tGRect.height;
    }

    public void extendTo(double d, double d2) {
        boolean bl = false;
        double d3 = this.x + this.width;
        if (d < this.x) {
            this.x = d;
            bl |= true;
        } else if (d > d3) {
            d3 = d;
            bl |= true;
        }
        if (bl) {
            this.width = d3 - this.x;
        }
        bl = false;
        d3 = this.y + this.height;
        if (d2 < this.y) {
            this.y = d2;
            bl |= true;
        } else if (d2 > d3) {
            d3 = d2;
            bl |= true;
        }
        if (bl) {
            this.height = d3 - this.y;
        }
    }

    public void extendTo(TGPoint tGPoint) {
        this.extendTo(tGPoint.x, tGPoint.y);
    }

    public void extendTo(TGRect tGRect) {
        if (!this.isEmpty()) {
            double d;
            boolean bl = false;
            double d2 = this.x + this.width;
            if (tGRect.x < this.x) {
                this.x = tGRect.x;
                bl |= true;
            }
            if ((d = tGRect.x + tGRect.width) > d2) {
                d2 = d;
                bl |= true;
            }
            if (bl) {
                this.width = d2 - this.x;
            }
            bl = false;
            d2 = this.y + this.height;
            if (tGRect.y < this.y) {
                this.y = tGRect.y;
                bl |= true;
            }
            if ((d = tGRect.y + tGRect.height) > d2) {
                d2 = d;
                bl |= true;
            }
            if (bl) {
                this.height = d2 - this.y;
            }
        } else {
            this.x = tGRect.x;
            this.y = tGRect.y;
            this.width = tGRect.width;
            this.height = tGRect.height;
        }
    }

    public TGPoint getBottomLeft() {
        return new TGPoint(this.x, this.y + this.height);
    }

    public TGPoint getBottomRight() {
        return new TGPoint(this.x + this.width, this.y + this.height);
    }

    public TGPoint getCenter() {
        return new TGPoint(this.x + this.width * 0.5, this.y + this.height * 0.5);
    }

    public TGPoint getSize() {
        return new TGPoint(this.width, this.height);
    }

    public TGPoint getTopLeft() {
        return new TGPoint(this.x, this.y);
    }

    public TGPoint getTopRight() {
        return new TGPoint(this.x + this.width, this.y);
    }

    public void inset(TGPoint tGPoint) {
        this.x += tGPoint.x;
        this.y += tGPoint.y;
        this.width -= tGPoint.x + tGPoint.x;
        this.height -= tGPoint.y + tGPoint.y;
    }

    public TGPoint interpolate(double d, double d2) {
        return new TGPoint(this.x * (1.0 - d) + (this.x + this.width) * d, this.y * (1.0 - d2) + (this.y + this.height) * d2);
    }

    public void intersectWith(TGRect tGRect) {
        if (this.intersects(tGRect)) {
            double d;
            boolean bl = false;
            double d2 = this.x + this.width;
            if (tGRect.x > this.x) {
                this.x = tGRect.x;
                bl |= true;
            }
            if ((d = tGRect.x + tGRect.width) < d2) {
                d2 = d;
                bl |= true;
            }
            if (bl) {
                this.width = d2 - this.x;
            }
            bl = false;
            d2 = this.y + this.height;
            if (tGRect.y > this.y) {
                this.y = tGRect.y;
                bl |= true;
            }
            if ((d = tGRect.y + tGRect.height) < d2) {
                d2 = d;
                bl |= true;
            }
            if (bl) {
                this.height = d2 - this.y;
            }
        } else {
            this.copyFrom(fkZeroRect);
        }
    }

    public void offset(TGPoint tGPoint) {
        this.x += tGPoint.x;
        this.y += tGPoint.y;
    }

    public void pin(TGPoint tGPoint) {
        double d;
        if (tGPoint.x < this.x) {
            tGPoint.x = this.x;
        } else {
            d = this.x + this.width;
            if (tGPoint.x > d) {
                tGPoint.x = d;
            }
        }
        if (tGPoint.y < this.y) {
            tGPoint.y = this.y;
        } else {
            d = this.y + this.height;
            if (tGPoint.y > d) {
                tGPoint.y = d;
            }
        }
    }

    public void set(double d, double d2, double d3, double d4) {
        if (d <= d3) {
            this.x = d;
            this.width = d3 - d;
        } else {
            this.x = d3;
            this.width = d - d3;
        }
        if (d2 <= d4) {
            this.y = d2;
            this.height = d4 - d2;
        } else {
            this.y = d4;
            this.height = d2 - d4;
        }
    }

    public void set(TGPoint tGPoint, TGPoint tGPoint2) {
        this.set(tGPoint.x, tGPoint.y, tGPoint2.x, tGPoint2.y);
    }

    public void setBottomLeft(TGPoint tGPoint) {
        this.x = tGPoint.x;
        this.height = tGPoint.y - this.y;
    }

    public void setBottomRight(TGPoint tGPoint) {
        this.width = tGPoint.x - this.x;
        this.height = tGPoint.y - this.y;
    }

    public void setCenter(TGPoint tGPoint) {
        TGPoint tGPoint2 = TGPoint.subtract(tGPoint, this.getCenter());
        this.x += tGPoint2.x;
        this.y += tGPoint2.y;
    }

    public void setSize(TGPoint tGPoint) {
        TGPoint tGPoint2 = TGPoint.subtract(tGPoint, this.getSize());
        this.width += tGPoint2.x;
        this.height += tGPoint2.y;
        tGPoint2.divideBy(2.0);
        this.x -= tGPoint2.x;
        this.y -= tGPoint2.y;
    }

    public void setToPoint(TGPoint tGPoint) {
        this.x = tGPoint.x;
        this.y = tGPoint.y;
        this.height = 0.0;
        this.width = 0.0;
    }

    public void setTopLeft(TGPoint tGPoint) {
        this.x = tGPoint.x;
        this.y = tGPoint.y;
    }

    public void setTopRight(TGPoint tGPoint) {
        this.width = tGPoint.x - this.x;
        this.y = tGPoint.y;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "), width:" + this.width + ", height:" + this.height;
    }
}

