/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import java.awt.Polygon;
import sun.awt.Albert.TGLine;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGPolyline;
import sun.awt.Albert.TGRect;

public class TGPolygon
extends TGPolyline
implements Cloneable {
    private boolean fEOFill;

    public TGPolygon() {
        this.fEOFill = true;
    }

    public TGPolygon(int n) {
        this(n, true);
    }

    public TGPolygon(int n, boolean bl) {
        super(n);
        this.fEOFill = bl;
    }

    public TGPolygon(Polygon polygon) {
        this(polygon, true);
    }

    public TGPolygon(Polygon polygon, boolean bl) {
        super(polygon.npoints);
        int n = polygon.npoints;
        TGPoint tGPoint = new TGPoint();
        int n2 = 0;
        while (n2 < n) {
            tGPoint.x = polygon.xpoints[n2];
            tGPoint.y = polygon.ypoints[n2];
            this.setPoint(n2, tGPoint);
            ++n2;
        }
        this.fEOFill = bl;
    }

    public TGPolygon(TGPolygon tGPolygon) {
        super(tGPolygon);
        this.fEOFill = tGPolygon.fEOFill;
    }

    public TGPolygon(TGRect tGRect) {
        this(tGRect, true);
    }

    public TGPolygon(TGRect tGRect, boolean bl) {
        super(4);
        this.setPoint(0, tGRect.getTopLeft());
        this.setPoint(1, tGRect.getTopRight());
        this.setPoint(2, tGRect.getBottomRight());
        this.setPoint(3, tGRect.getBottomLeft());
        this.fEOFill = bl;
    }

    public final boolean contains(TGPoint tGPoint) {
        if (this.isDegenerateToAPoint()) {
            return false;
        }
        int n = 0;
        int n2 = this.getNumberOfPoints();
        double d = tGPoint.y;
        double d2 = tGPoint.x;
        TGPoint[] tGPointArray = this.fPoints.getArray();
        TGPoint tGPoint2 = tGPointArray[n2 - 1];
        int n3 = 0;
        while (n3 < n2) {
            double d3;
            TGPoint tGPoint3 = tGPointArray[n3];
            if (tGPoint.equals(tGPoint3)) {
                return false;
            }
            double d4 = tGPoint3.x - tGPoint2.x;
            double d5 = tGPoint3.y - tGPoint2.y;
            if (tGPoint2.y <= d) {
                if (tGPoint3.y > d && (d3 = tGPoint2.x + (d - tGPoint2.y) * d4 / d5) < d2) {
                    n = (short)(n + 1);
                }
            } else if (tGPoint3.y <= d && (d3 = tGPoint2.x + (d - tGPoint2.y) * d4 / d5) < d2) {
                n = (short)(n - 1);
            }
            tGPoint2 = tGPoint3;
            ++n3;
        }
        if (this.fEOFill) {
            return (n & 1) > 0;
        }
        return n != 0;
    }

    public final TGPolygon copyFrom(TGPolygon tGPolygon) {
        if (tGPolygon != this) {
            super.copyFrom(tGPolygon);
            this.fEOFill = tGPolygon.fEOFill;
        }
        return this;
    }

    public boolean equals(TGPolygon tGPolygon) {
        return this.fEOFill == tGPolygon.fEOFill && super.equals(tGPolygon);
    }

    public final boolean getEOFill() {
        return this.fEOFill;
    }

    public final boolean intersects(TGRect tGRect) {
        int n = 0;
        int n2 = this.getNumberOfPoints();
        double d = tGRect.x;
        double d2 = tGRect.y;
        TGPoint[] tGPointArray = this.fPoints.getArray();
        TGPoint tGPoint = tGPointArray[n2 - 1];
        int n3 = 0;
        while (n3 < n2) {
            double d3;
            TGPoint tGPoint2 = tGPointArray[n3];
            TGLine tGLine = new TGLine(tGPoint, tGPoint2);
            if (tGLine.intersects(tGRect)) {
                return true;
            }
            double d4 = tGPoint2.x - tGPoint.x;
            double d5 = tGPoint2.y - tGPoint.y;
            if (tGPoint.y <= d2) {
                if (tGPoint2.y > d2 && (d3 = tGPoint.x + (d2 - tGPoint.y) * d4 / d5) < d) {
                    n = (short)(n + 1);
                }
            } else if (tGPoint2.y <= d2 && (d3 = tGPoint.x + (d2 - tGPoint.y) * d4 / d5) < d) {
                n = (short)(n - 1);
            }
            tGPoint = tGPoint2;
            ++n3;
        }
        if (this.fEOFill) {
            return (n & 1) > 0;
        }
        return n > 0;
    }

    public final boolean isRectilinear() {
        TGPoint tGPoint = this.fPoints.getPoint(0);
        TGPoint tGPoint2 = this.fPoints.getPoint(this.getNumberOfPoints() - 1);
        return (tGPoint.x == tGPoint2.x || tGPoint.y == tGPoint2.y) && super.isRectilinear();
    }

    public final void setEOFill(boolean bl) {
        this.fEOFill = bl;
    }

    public String toString() {
        String string = "TGPolygon : ";
        int n = this.fPoints.getNumberOfPoints();
        if (n == 0) {
            string = String.valueOf(string) + "Zero Points";
        } else {
            string = String.valueOf(string) + "( " + n + " ) ";
            int n2 = 0;
            while (n2 < n) {
                string = String.valueOf(string) + " " + this.fPoints.getPoint(n2);
                ++n2;
            }
        }
        return string;
    }
}

