/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import java.awt.geom.Point2D;

public final class TGPoint
extends Point2D.Double {
    private static final double kHalfValue = 0.5;

    public TGPoint() {
    }

    public TGPoint(double d, double d2) {
        super(d, d2);
    }

    public TGPoint(Point2D point2D) {
        this(point2D.getX(), point2D.getY());
    }

    public static TGPoint add(TGPoint tGPoint, TGPoint tGPoint2) {
        return new TGPoint(tGPoint.x + tGPoint2.x, tGPoint.y + tGPoint2.y);
    }

    public TGPoint addBy(TGPoint tGPoint) {
        this.x += tGPoint.x;
        this.y += tGPoint.y;
        return this;
    }

    public Object clone() {
        return new TGPoint(this);
    }

    public final TGPoint copyFrom(TGPoint tGPoint) {
        this.x = tGPoint.x;
        this.y = tGPoint.y;
        return this;
    }

    public TGPoint divideBy(double d) {
        this.x /= d;
        this.y /= d;
        return this;
    }

    public TGPoint divideBy(TGPoint tGPoint) {
        this.x /= tGPoint.x;
        this.y /= tGPoint.y;
        return this;
    }

    public double dotProduct(TGPoint tGPoint) {
        return this.x * tGPoint.x + this.y * tGPoint.y;
    }

    public boolean equals(TGPoint tGPoint) {
        return this.x == tGPoint.x && this.y == tGPoint.y;
    }

    public static TGPoint multiply(double d, TGPoint tGPoint) {
        return new TGPoint(tGPoint.x * d, tGPoint.y * d);
    }

    public static TGPoint multiply(TGPoint tGPoint, double d) {
        return new TGPoint(tGPoint.x * d, tGPoint.y * d);
    }

    public TGPoint multiplyBy(double d) {
        this.x *= d;
        this.y *= d;
        return this;
    }

    public TGPoint multiplyBy(TGPoint tGPoint) {
        this.x *= tGPoint.x;
        this.y *= tGPoint.y;
        return this;
    }

    public TGPoint negate() {
        return new TGPoint(-this.x, -this.y);
    }

    public void setPolarCoordinates(double d) {
        this.setPolarCoordinates(d, 1.0);
    }

    public void setPolarCoordinates(double d, double d2) {
        this.x = Math.cos(d * (Math.PI / 180)) * d2;
        this.y = Math.sin(d * (Math.PI / 180)) * d2;
    }

    public static TGPoint subtract(TGPoint tGPoint, TGPoint tGPoint2) {
        return new TGPoint(tGPoint.x - tGPoint2.x, tGPoint.y - tGPoint2.y);
    }

    public TGPoint subtractBy(TGPoint tGPoint) {
        this.x -= tGPoint.x;
        this.y -= tGPoint.y;
        return this;
    }

    public double vectorAngle() {
        double d = 0.0;
        if (this.x == 0.0) {
            if (this.y == 0.0) {
                return 0.0;
            }
            if (this.y > 0.0) {
                return 90.0;
            }
            return 270.0;
        }
        if (this.x > 0.0 && this.y < 0.0) {
            d = 360.0;
        } else if (this.x < 0.0) {
            d = 180.0;
        }
        return Math.atan(this.y / this.x) * 57.29577951308232 + d;
    }

    public double vectorLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double vectorSquaredLength() {
        return this.x * this.x + this.y * this.y;
    }
}

