/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.TGrafMatrix;

class TConicInfo {
    static final int arc_t = 1;
    static final int ellipse_t = 2;
    int fIsArc;
    TGRect fArcBounds;
    boolean fDirection;

    TConicInfo(int n, TGRect tGRect, boolean bl) {
        this.fIsArc = n;
        this.fArcBounds = (TGRect)tGRect.clone();
        this.fDirection = bl;
    }

    TConicInfo(TConicInfo tConicInfo) {
        this.copyFrom(tConicInfo);
    }

    double calculatePointAngle(TGPoint tGPoint) {
        TGPoint tGPoint2 = this.fArcBounds.getCenter().subtractBy(tGPoint);
        return tGPoint2.vectorAngle() - 180.0;
    }

    TConicInfo copyFrom(TConicInfo tConicInfo) {
        this.fIsArc = tConicInfo.fIsArc;
        this.fArcBounds = (TGRect)tConicInfo.fArcBounds.clone();
        this.fDirection = tConicInfo.fDirection;
        return this;
    }

    boolean equals(TConicInfo tConicInfo) {
        return this.fIsArc == tConicInfo.fIsArc && this.fArcBounds.equals(tConicInfo.fArcBounds) && this.fDirection == tConicInfo.fDirection;
    }

    boolean transformBy(TGrafMatrix tGrafMatrix) {
        if (!tGrafMatrix.isIdentity()) {
            if (tGrafMatrix.isRectilinear()) {
                this.fArcBounds = tGrafMatrix.transformBounds(this.fArcBounds);
                double d = tGrafMatrix.getElement(0);
                double d2 = tGrafMatrix.getElement(3);
                if (d > 0.0 && d2 < 0.0 || d < 0.0 && d2 > 0.0) {
                    this.fDirection ^= true;
                }
            } else {
                return false;
            }
        }
        return true;
    }
}

