/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.TBezier;
import sun.awt.Albert.TGLoop;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGPolygon;
import sun.awt.Albert.TGRPoint;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.TGrafMatrix;

class TBezierList {
    private double[] fPointSequence = null;
    private boolean fEOFill = true;
    public static final double parameterEpsilon = 1.0E-4;

    public TBezierList() {
        this.fPointSequence = null;
    }

    public TBezierList(TBezierList tBezierList) {
        this.fEOFill = tBezierList.fEOFill;
        if (tBezierList.fPointSequence != null) {
            int n = tBezierList.fPointSequence.length;
            this.fPointSequence = new double[n];
            System.arraycopy(tBezierList.fPointSequence, 0, this.fPointSequence, 0, n);
        } else {
            this.fPointSequence = null;
        }
    }

    public TBezierList(TGLoop tGLoop) {
        TGLoop tGLoop2 = new TGLoop(tGLoop);
        tGLoop2.closeLoop();
        this.fEOFill = tGLoop.getEOFill();
        int n = tGLoop.getOrder();
        if (n != 2) {
            if (n > 4) {
                throw new IllegalArgumentException("TBezierList: Cannot deal with curve of higher order than cubic!");
            }
            if (n < 4 && n > 2) {
                tGLoop2.raiseOrder(4);
            }
            int n2 = tGLoop2.getNumberOfPoints();
            this.fPointSequence = new double[n2 * 2];
            int n3 = 0;
            while (n3 < n2) {
                TGRPoint tGRPoint = tGLoop2.getPoint(n3);
                TGPoint tGPoint = tGRPoint.divW();
                this.fPointSequence[2 * n3] = tGPoint.x;
                this.fPointSequence[2 * n3 + 1] = tGPoint.y;
                ++n3;
            }
        } else {
            int n4 = tGLoop2.getNumberOfPoints();
            this.fPointSequence = new double[n4 * 6 - 4];
            int n5 = 0;
            while (n5 < n4) {
                TGRPoint tGRPoint = tGLoop2.getPoint(n5);
                TGPoint tGPoint = tGRPoint.divW();
                int n6 = 6 * n5;
                if (n5 > 0) {
                    this.fPointSequence[n6 - 2] = tGPoint.x;
                    this.fPointSequence[n6 - 1] = tGPoint.y;
                }
                this.fPointSequence[n6] = tGPoint.x;
                this.fPointSequence[n6 + 1] = tGPoint.y;
                if (n5 < n4 - 1) {
                    this.fPointSequence[n6 + 2] = tGPoint.x;
                    this.fPointSequence[n6 + 3] = tGPoint.y;
                }
                ++n5;
            }
        }
    }

    int BreakIntoCurveSegments(int n, double[] dArray) {
        if ((dArray = this.RemoveZerosAndOnes(dArray)) == null) {
            return 0;
        }
        int n2 = dArray.length;
        int n3 = 0;
        this.SplitCurveAtParameter(n, dArray[0]);
        ++n3;
        while (n3 < n2) {
            double d = (dArray[n3] - dArray[n3 - 1]) / (1.0 - dArray[n3 - 1]);
            this.SplitCurveAtParameter(n + n3, d);
            ++n3;
        }
        return n2;
    }

    private double[] RemoveZerosAndOnes(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            return null;
        }
        int n = dArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (dArray[n3] >= 1.0E-4 && dArray[n3] <= 0.9999) {
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            return null;
        }
        double[] dArray2 = new double[n2];
        int n4 = 0;
        n3 = 0;
        while (n3 < n) {
            if (dArray[n3] >= 1.0E-4 && dArray[n3] <= 0.9999) {
                dArray2[n4++] = dArray[n3];
            }
            ++n3;
        }
        return dArray2;
    }

    public void SplitAtInfiniteDerivatives() {
        int n = 0;
        int n2 = this.getNumberOfCurves();
        int n3 = 0;
        while (n3 < n2) {
            TBezier tBezier = this.getCurve(n3 + n);
            double[] dArray = tBezier.findInfiniteDerivatives();
            if (dArray != null) {
                int n4 = this.BreakIntoCurveSegments(n3 + n, dArray);
                n += n4;
            }
            ++n3;
        }
    }

    public final void SplitAtInflexionPoints() {
        int n = 0;
        double[] dArray = null;
        int n2 = this.getNumberOfCurves();
        int n3 = 0;
        while (n3 < n2) {
            if (this.getCurve(n3 + n).hasInflexion()) {
                if (dArray == null) {
                    dArray = new double[]{0.5};
                }
                int n4 = this.BreakIntoCurveSegments(n3 + n, dArray);
                n += n4;
            }
            ++n3;
        }
    }

    public void SplitAtIntersectionsWith(TBezierList tBezierList) {
        int n;
        int n2 = this.getNumberOfCurves();
        int n3 = tBezierList.getNumberOfCurves();
        double[][] dArray = new double[n2][0];
        double[][] dArray2 = new double[n3][0];
        int n4 = 0;
        while (n4 < n2) {
            n = 0;
            while (n < n3) {
                TBezier tBezier;
                TBezier tBezier2 = this.getCurve(n4);
                double[][] dArray3 = TBezier.findIntersections(tBezier2, tBezier = tBezierList.getCurve(n));
                if (dArray3 != null) {
                    if (dArray3[0] != null && dArray3[0].length > 0) {
                        dArray[n4] = this.mergeArray(dArray[n4], dArray3[0]);
                    }
                    if (dArray3[1] != null && dArray3[1].length > 0) {
                        dArray2[n] = this.mergeArray(dArray2[n], dArray3[1]);
                    }
                }
                ++n;
            }
            ++n4;
        }
        int n5 = 0;
        int n6 = 0;
        n4 = 0;
        while (n4 < n2) {
            TBezier.Sort(dArray[n4]);
            int n7 = this.BreakIntoCurveSegments(n4 + n5, dArray[n4]);
            n5 += n7;
            ++n4;
        }
        n = 0;
        while (n < n3) {
            TBezier.Sort(dArray2[n]);
            int n8 = tBezierList.BreakIntoCurveSegments(n + n6, dArray2[n]);
            n6 += n8;
            ++n;
        }
    }

    public void SplitAtOverlapsWith(TBezierList tBezierList) {
        boolean bl = false;
        while (!bl) {
            boolean bl2 = false;
            int n = this.getNumberOfCurves();
            int n2 = tBezierList.getNumberOfCurves();
            int n3 = 0;
            while (n3 < n && !bl2) {
                int n4 = 0;
                while (n4 < n2 && !bl2) {
                    TBezier tBezier;
                    TBezier tBezier2 = this.getCurve(n3);
                    double[] dArray = TBezier.findOverlaps(tBezier2, tBezier = tBezierList.getCurve(n4));
                    if (dArray != null && !tBezier2.isDegenerate() && !tBezier.isDegenerate() && !tBezier2.isClose(tBezier) && dArray[0] >= 1.0E-4 && dArray[0] <= 0.9999 && dArray[1] >= 1.0E-4 && dArray[1] <= 0.9999) {
                        this.SplitCurveAtParameter(n3, this.nearestGoodParameter(dArray[0]));
                        tBezierList.SplitCurveAtParameter(n4, this.nearestGoodParameter(dArray[1]));
                        bl2 = true;
                    }
                    ++n4;
                }
                ++n3;
            }
            if (bl2) continue;
            bl = true;
        }
    }

    public void SplitAtSelfIntersections() {
        int n = this.getNumberOfCurves();
        double[][] dArray = new double[n][0];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + 1;
            while (n3 < n) {
                TBezier tBezier;
                TBezier tBezier2 = this.getCurve(n2);
                double[][] dArray2 = TBezier.findIntersections(tBezier2, tBezier = this.getCurve(n3));
                if (dArray2 != null) {
                    if (dArray2[0] != null && dArray2[0].length > 0) {
                        dArray[n2] = this.mergeArray(dArray[n2], dArray2[0]);
                    }
                    if (dArray2[1] != null && dArray2[1].length > 0) {
                        dArray[n3] = this.mergeArray(dArray[n3], dArray2[1]);
                    }
                }
                ++n3;
            }
            ++n2;
        }
        int n4 = 0;
        n2 = 0;
        while (n2 < n) {
            TBezier.Sort(dArray[n2]);
            int n5 = this.BreakIntoCurveSegments(n2 + n4, dArray[n2]);
            n4 += n5;
            ++n2;
        }
    }

    public void SplitAtZeroDerivatives() {
        int n = 0;
        int n2 = this.getNumberOfCurves();
        int n3 = 0;
        while (n3 < n2) {
            TBezier tBezier = this.getCurve(n3 + n);
            double[] dArray = tBezier.findZeroDerivatives();
            if (dArray != null) {
                int n4 = this.BreakIntoCurveSegments(n3 + n, dArray);
                n += n4;
            }
            ++n3;
        }
    }

    public void SplitCurveAtParameter(int n, double d) {
        int n2 = this.getNumberOfCurves();
        if (n >= n2) {
            throw new IndexOutOfBoundsException("Requested curve doesn't exist in the list");
        }
        double[] dArray = this.fPointSequence;
        int n3 = this.fPointSequence.length;
        this.fPointSequence = new double[n3 + 6];
        int n4 = n * 6;
        int n5 = n4 + 6;
        int n6 = n5 + 6;
        System.arraycopy(dArray, 0, this.fPointSequence, 0, n4 + 2);
        System.arraycopy(dArray, n5, this.fPointSequence, n6, n3 - n5);
        this.fPointSequence[n4 + 2] = dArray[n4] + d * (dArray[n4 + 2] - dArray[n4]);
        this.fPointSequence[n4 + 3] = dArray[n4 + 1] + d * (dArray[n4 + 3] - dArray[n4 + 1]);
        double d2 = dArray[n4 + 2] + d * (dArray[n4 + 4] - dArray[n4 + 2]);
        double d3 = dArray[n4 + 3] + d * (dArray[n4 + 5] - dArray[n4 + 3]);
        this.fPointSequence[n4 + 10] = dArray[n4 + 4] + d * (dArray[n4 + 6] - dArray[n4 + 4]);
        this.fPointSequence[n4 + 11] = dArray[n4 + 5] + d * (dArray[n4 + 7] - dArray[n4 + 5]);
        this.fPointSequence[n4 + 8] = d2 + d * (this.fPointSequence[n4 + 10] - d2);
        this.fPointSequence[n4 + 9] = d3 + d * (this.fPointSequence[n4 + 11] - d3);
        this.fPointSequence[n4 + 4] = this.fPointSequence[n4 + 2] + d * (d2 - this.fPointSequence[n4 + 2]);
        this.fPointSequence[n4 + 5] = this.fPointSequence[n4 + 3] + d * (d3 - this.fPointSequence[n4 + 3]);
        this.fPointSequence[n4 + 6] = this.fPointSequence[n4 + 4] + d * (this.fPointSequence[n4 + 8] - this.fPointSequence[n4 + 4]);
        this.fPointSequence[n4 + 7] = this.fPointSequence[n4 + 5] + d * (this.fPointSequence[n4 + 9] - this.fPointSequence[n4 + 5]);
    }

    public void appendBezierList(TBezierList tBezierList) {
        if (!tBezierList.isEmpty()) {
            if (this.fPointSequence == null) {
                this.copyFrom(tBezierList);
                return;
            }
            double[] dArray = this.fPointSequence;
            int n = this.fPointSequence.length;
            int n2 = tBezierList.fPointSequence.length;
            if (this.fPointSequence[n - 2] != tBezierList.fPointSequence[0] || this.fPointSequence[n - 1] != tBezierList.fPointSequence[1]) {
                throw new IllegalArgumentException("Unable to append two disconnected Bezier lists.");
            }
            this.fPointSequence = new double[n + n2 - 2];
            System.arraycopy(dArray, 0, this.fPointSequence, 0, n);
            System.arraycopy(tBezierList.fPointSequence, 2, this.fPointSequence, n, n2 - 2);
        }
    }

    public void appendBezierSegment(TBezier tBezier) {
        int n = 0;
        if (this.fPointSequence == null) {
            this.fPointSequence = new double[8];
            this.fPointSequence[n] = tBezier.fPoint0_fX;
            this.fPointSequence[++n] = tBezier.fPoint0_fY;
            ++n;
        } else {
            double[] dArray = this.fPointSequence;
            n = this.fPointSequence.length;
            if (this.fPointSequence[n - 2] != tBezier.fPoint0_fX || this.fPointSequence[n - 1] != tBezier.fPoint0_fY) {
                throw new IndexOutOfBoundsException("Unable to join two disjoint Bezier curves");
            }
            this.fPointSequence = new double[n + 6];
            System.arraycopy(dArray, 0, this.fPointSequence, 0, n);
        }
        this.fPointSequence[n] = tBezier.fPoint1_fX;
        this.fPointSequence[++n] = tBezier.fPoint1_fY;
        this.fPointSequence[++n] = tBezier.fPoint2_fX;
        this.fPointSequence[++n] = tBezier.fPoint2_fY;
        this.fPointSequence[++n] = tBezier.fPoint3_fX;
        this.fPointSequence[++n] = tBezier.fPoint3_fY;
    }

    public final boolean contains(TGPoint tGPoint) {
        TBezierList tBezierList = new TBezierList(this);
        tBezierList.joinEnds();
        tBezierList.SplitAtInflexionPoints();
        tBezierList.SplitAtInfiniteDerivatives();
        tBezierList.SplitAtZeroDerivatives();
        TGPolygon tGPolygon = new TGPolygon();
        tGPolygon.setEOFill(this.fEOFill);
        int n = this.getNumberOfCurves();
        int n2 = 0;
        while (n2 < n) {
            TBezier tBezier = this.getCurve(n2);
            if (!tBezier.isDegenerate()) {
                if (n2 == 0) {
                    tGPolygon.append(tBezier.getPoint(0));
                }
                if (tBezier.containsWithinConvexHull(tGPoint)) {
                    TGPoint tGPoint2 = new TGPoint();
                    double d = tBezier.findNearestParametric(tGPoint, tGPoint2);
                    tGPolygon.append(tGPoint2);
                }
                tGPolygon.append(tBezier.getPoint(3));
            }
            ++n2;
        }
        return tGPolygon.contains(tGPoint);
    }

    public final TBezierList copyFrom(TBezierList tBezierList) {
        this.fEOFill = tBezierList.fEOFill;
        if (tBezierList.fPointSequence != null) {
            int n = tBezierList.fPointSequence.length;
            this.fPointSequence = new double[n];
            System.arraycopy(tBezierList.fPointSequence, 0, this.fPointSequence, 0, n);
        } else {
            this.fPointSequence = null;
        }
        return this;
    }

    public void deleteAll() {
        this.fPointSequence = null;
    }

    public TGRect getBounds() {
        if (this.isEmpty()) {
            return new TGRect(0.0, 0.0, 0.0, 0.0);
        }
        TBezierList tBezierList = new TBezierList(this);
        tBezierList.SplitAtInfiniteDerivatives();
        tBezierList.SplitAtZeroDerivatives();
        int n = tBezierList.fPointSequence.length / 2;
        TGPoint tGPoint = new TGPoint(tBezierList.fPointSequence[0], tBezierList.fPointSequence[1]);
        TGRect tGRect = new TGRect(tGPoint, tGPoint);
        int n2 = 3;
        while (n2 < n) {
            tGRect.extendTo(new TGPoint(tBezierList.fPointSequence[2 * n2], tBezierList.fPointSequence[2 * n2 + 1]));
            n2 += 3;
        }
        return tGRect;
    }

    public TBezier getCurve(int n) {
        int n2 = this.getNumberOfCurves();
        if (n >= n2) {
            throw new IndexOutOfBoundsException("Requested curve doesn't exist in the list");
        }
        int n3 = n * 6;
        TBezier tBezier = new TBezier();
        tBezier.fPoint0_fX = this.fPointSequence[n3];
        tBezier.fPoint0_fY = this.fPointSequence[n3 + 1];
        tBezier.fPoint1_fX = this.fPointSequence[n3 + 2];
        tBezier.fPoint1_fY = this.fPointSequence[n3 + 3];
        tBezier.fPoint2_fX = this.fPointSequence[n3 + 4];
        tBezier.fPoint2_fY = this.fPointSequence[n3 + 5];
        tBezier.fPoint3_fX = this.fPointSequence[n3 + 6];
        tBezier.fPoint3_fY = this.fPointSequence[n3 + 7];
        return tBezier;
    }

    public TGPoint getDiscontinuity(int n) {
        int n2 = this.getNumberOfCurves() + 1;
        if (n >= n2) {
            throw new IndexOutOfBoundsException("Requested discontinuity doesn't exist in the list");
        }
        int n3 = n * 6;
        return new TGPoint(this.fPointSequence[n3], this.fPointSequence[n3 + 1]);
    }

    public int getNumberOfCurves() {
        if (this.fPointSequence == null) {
            return 0;
        }
        int n = this.fPointSequence.length;
        if (n > 0) {
            return (n - 2) / 6;
        }
        return 0;
    }

    public int getNumberOfDiscontinuities() {
        return this.getNumberOfCurves() + 1;
    }

    public boolean intersects(TGRect tGRect) {
        int n = this.getNumberOfCurves();
        TBezierList tBezierList = new TBezierList(new TGLoop(tGRect));
        int n2 = tBezierList.getNumberOfCurves();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                TBezier tBezier = this.getCurve(n3);
                TBezier tBezier2 = tBezierList.getCurve(n4);
                double[][] dArray = TBezier.findIntersections(tBezier, tBezier2);
                dArray[0] = this.RemoveZerosAndOnes(dArray[0]);
                if (dArray[0] != null && dArray[0].length > 0) {
                    bl = true;
                    break;
                }
                dArray[1] = this.RemoveZerosAndOnes(dArray[1]);
                if (dArray[1] != null && dArray[1].length > 0) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (bl) break;
            ++n3;
        }
        if (!bl && tGRect.contains(new TGPoint(this.fPointSequence[0], this.fPointSequence[1]))) {
            bl = true;
        }
        return bl;
    }

    boolean isEmpty() {
        return this.fPointSequence.length < 8;
    }

    public void joinBezierList(TBezierList tBezierList, boolean bl) {
        if (!tBezierList.isEmpty()) {
            int n = tBezierList.fPointSequence.length;
            TBezierList tBezierList2 = tBezierList;
            if (this.fPointSequence == null) {
                if (n > 8 && !bl) {
                    tBezierList2 = new TBezierList(tBezierList);
                    tBezierList2.reverseDirection();
                }
                this.copyFrom(tBezierList2);
            } else {
                double[] dArray = this.fPointSequence;
                int n2 = this.fPointSequence.length;
                if (n > 8 && !bl || n == 8 && this.fPointSequence[n2 - 2] == tBezierList.fPointSequence[n - 2] && this.fPointSequence[n2 - 1] == tBezierList.fPointSequence[n - 1]) {
                    tBezierList2 = new TBezierList(tBezierList);
                    tBezierList2.reverseDirection();
                }
                if (this.fPointSequence[n2 - 2] == tBezierList2.fPointSequence[0] && this.fPointSequence[n2 - 1] == tBezierList2.fPointSequence[1]) {
                    this.fPointSequence = new double[n2 + n - 2];
                    System.arraycopy(dArray, 0, this.fPointSequence, 0, n2);
                    System.arraycopy(tBezierList2.fPointSequence, 2, this.fPointSequence, n2, n - 2);
                } else {
                    throw new IllegalArgumentException("Unable to find a common end-point between two Bezier lists.");
                }
            }
        }
    }

    public void joinEnds() {
        if (this.isEmpty()) {
            return;
        }
        int n = this.fPointSequence.length;
        if (this.fPointSequence[0] == this.fPointSequence[n - 2] && this.fPointSequence[1] == this.fPointSequence[n - 1]) {
            return;
        }
        double[] dArray = this.fPointSequence;
        this.fPointSequence = new double[n + 6];
        System.arraycopy(dArray, 0, this.fPointSequence, 0, n);
        this.fPointSequence[n + 4] = dArray[0];
        this.fPointSequence[n + 5] = dArray[1];
        this.fPointSequence[n] = this.fPointSequence[n - 2];
        this.fPointSequence[n + 1] = this.fPointSequence[n - 1];
        this.fPointSequence[n + 2] = this.fPointSequence[n + 4];
        this.fPointSequence[n + 3] = this.fPointSequence[n + 5];
    }

    private double[] mergeArray(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = dArray2.length;
        double[] dArray3 = new double[n + n2];
        System.arraycopy(dArray, 0, dArray3, 0, n);
        System.arraycopy(dArray2, 0, dArray3, n, n2);
        return dArray3;
    }

    private double nearestGoodParameter(double d) {
        if (d <= 0.1) {
            return 0.1;
        }
        if (d >= 0.9) {
            return 0.9;
        }
        return d;
    }

    private void printArray(String string, double[] dArray) {
        int n = dArray.length;
        System.out.print(String.valueOf(string) + "-> Size : " + n + ". Elements : ");
        int n2 = 0;
        while (n2 < n) {
            System.out.print("[" + dArray[n2] + "] ");
            ++n2;
        }
        System.out.println();
    }

    public void reverseDirection() {
        int n = this.fPointSequence.length;
        double[] dArray = this.fPointSequence;
        this.fPointSequence = new double[n];
        int n2 = n / 2;
        int n3 = 0;
        while (n3 < n2) {
            this.fPointSequence[2 * n3] = dArray[2 * (n2 - n3 - 1)];
            this.fPointSequence[2 * n3 + 1] = dArray[2 * (n2 - n3 - 1) + 1];
            ++n3;
        }
    }

    public String toString() {
        String string = "TBezierList : ";
        if (this.fPointSequence == null) {
            string = String.valueOf(string) + this.fPointSequence;
        } else {
            int n = this.fPointSequence.length / 2;
            int n2 = 0;
            while (n2 < n) {
                string = String.valueOf(string) + "(" + this.fPointSequence[2 * n2] + "," + this.fPointSequence[2 * n2 + 1] + ") ";
                ++n2;
            }
        }
        return string;
    }

    public void transformBy(TGrafMatrix tGrafMatrix) {
        int n = this.fPointSequence.length / 2;
        int n2 = 0;
        while (n2 < n) {
            TGPoint tGPoint = new TGPoint(this.fPointSequence[2 * n2], this.fPointSequence[2 * n2 + 1]);
            TGPoint tGPoint2 = tGrafMatrix.transformPoint(tGPoint);
            this.fPointSequence[2 * n2] = tGPoint2.x;
            this.fPointSequence[2 * n2 + 1] = tGPoint2.y;
            ++n2;
        }
    }
}

