/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.QSort;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGPolygon;

class TBezier {
    public double fPoint0_fX;
    public double fPoint0_fY;
    public double fPoint1_fX;
    public double fPoint1_fY;
    public double fPoint2_fX;
    public double fPoint2_fY;
    public double fPoint3_fX;
    public double fPoint3_fY;
    private static final double M_SQRT2 = Math.sqrt(2.0);
    private static final double INITIAL_VALUE = 173778.56254440593;
    private static final double INV_EPS = 65536.0;
    static final double curveClosenessEpsilon = 5.0E-6;
    private static final double pointEpsilon = 0.005;
    private static final int W_DEGREE = 5;
    private static final int DEGREE = 3;
    private static final int MAXDEPTH = 64;

    public TBezier() {
    }

    public TBezier(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.fPoint0_fX = d;
        this.fPoint0_fY = d2;
        this.fPoint1_fX = d3;
        this.fPoint1_fY = d4;
        this.fPoint2_fX = d5;
        this.fPoint2_fY = d6;
        this.fPoint3_fX = d7;
        this.fPoint3_fY = d8;
    }

    static final boolean Eq(double d, double d2) {
        return TBezier.Eq(d, d2, 0.005);
    }

    static final boolean Eq(double d, double d2, double d3) {
        return Math.abs(d - d2) < d3;
    }

    private static boolean IntersectBB(TBezier tBezier, TBezier tBezier2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        if (tBezier.fPoint0_fX > tBezier.fPoint3_fX) {
            d8 = tBezier.fPoint3_fX;
            d7 = tBezier.fPoint0_fX;
        } else {
            d8 = tBezier.fPoint0_fX;
            d7 = tBezier.fPoint3_fX;
        }
        if (tBezier.fPoint2_fX < d8) {
            d8 = tBezier.fPoint2_fX;
        } else if (tBezier.fPoint2_fX > d7) {
            d7 = tBezier.fPoint2_fX;
        }
        if (tBezier.fPoint1_fX < d8) {
            d8 = tBezier.fPoint1_fX;
        } else if (tBezier.fPoint1_fX > d7) {
            d7 = tBezier.fPoint1_fX;
        }
        if (tBezier.fPoint0_fY > tBezier.fPoint3_fY) {
            d6 = tBezier.fPoint3_fY;
            d5 = tBezier.fPoint0_fY;
        } else {
            d6 = tBezier.fPoint0_fY;
            d5 = tBezier.fPoint3_fY;
        }
        if (tBezier.fPoint2_fY < d6) {
            d6 = tBezier.fPoint2_fY;
        } else if (tBezier.fPoint2_fY > d5) {
            d5 = tBezier.fPoint2_fY;
        }
        if (tBezier.fPoint1_fY < d6) {
            d6 = tBezier.fPoint1_fY;
        } else if (tBezier.fPoint1_fY > d5) {
            d5 = tBezier.fPoint1_fY;
        }
        if (tBezier2.fPoint0_fX > tBezier2.fPoint3_fX) {
            d4 = tBezier2.fPoint3_fX;
            d3 = tBezier2.fPoint0_fX;
        } else {
            d4 = tBezier2.fPoint0_fX;
            d3 = tBezier2.fPoint3_fX;
        }
        if (tBezier2.fPoint2_fX < d4) {
            d4 = tBezier2.fPoint2_fX;
        } else if (tBezier2.fPoint2_fX > d3) {
            d3 = tBezier2.fPoint2_fX;
        }
        if (tBezier2.fPoint1_fX < d4) {
            d4 = tBezier2.fPoint1_fX;
        } else if (tBezier2.fPoint1_fX > d3) {
            d3 = tBezier2.fPoint1_fX;
        }
        if (tBezier2.fPoint0_fY > tBezier2.fPoint3_fY) {
            d2 = tBezier2.fPoint3_fY;
            d = tBezier2.fPoint0_fY;
        } else {
            d2 = tBezier2.fPoint0_fY;
            d = tBezier2.fPoint3_fY;
        }
        if (tBezier2.fPoint2_fY < d2) {
            d2 = tBezier2.fPoint2_fY;
        } else if (tBezier2.fPoint2_fY > d) {
            d = tBezier2.fPoint2_fY;
        }
        if (tBezier2.fPoint1_fY < d2) {
            d2 = tBezier2.fPoint1_fY;
        } else if (tBezier2.fPoint1_fY > d) {
            d = tBezier2.fPoint1_fY;
        }
        return !(d8 > d3 || d6 > d || d4 > d7) && !(d2 > d5);
    }

    private static double MeanValue(double d, double d2) {
        return (d + d2) / 2.0;
    }

    private void ParameterSplitLeft(double d, TBezier tBezier) {
        tBezier.fPoint0_fX = this.fPoint0_fX;
        tBezier.fPoint0_fY = this.fPoint0_fY;
        tBezier.fPoint1_fX = TBezier.evalValue(d, this.fPoint0_fX, this.fPoint1_fX);
        tBezier.fPoint1_fY = TBezier.evalValue(d, this.fPoint0_fY, this.fPoint1_fY);
        tBezier.fPoint2_fX = TBezier.evalValue(d, this.fPoint1_fX, this.fPoint2_fX);
        tBezier.fPoint2_fY = TBezier.evalValue(d, this.fPoint1_fY, this.fPoint2_fY);
        this.fPoint2_fX = TBezier.evalValue(d, this.fPoint2_fX, this.fPoint3_fX);
        this.fPoint2_fY = TBezier.evalValue(d, this.fPoint2_fY, this.fPoint3_fY);
        this.fPoint1_fX = TBezier.evalValue(d, tBezier.fPoint2_fX, this.fPoint2_fX);
        this.fPoint1_fY = TBezier.evalValue(d, tBezier.fPoint2_fY, this.fPoint2_fY);
        tBezier.fPoint2_fX = TBezier.evalValue(d, tBezier.fPoint1_fX, tBezier.fPoint2_fX);
        tBezier.fPoint2_fY = TBezier.evalValue(d, tBezier.fPoint1_fY, tBezier.fPoint2_fY);
        this.fPoint0_fX = TBezier.evalValue(d, tBezier.fPoint2_fX, this.fPoint1_fX);
        this.fPoint0_fY = TBezier.evalValue(d, tBezier.fPoint2_fY, this.fPoint1_fY);
        tBezier.fPoint3_fX = this.fPoint0_fX;
        tBezier.fPoint3_fY = this.fPoint0_fY;
    }

    private static void RecursivelyIntersect(TBezier tBezier, double d, double d2, int n, TBezier tBezier2, double d3, double d4, int n2, double[][] dArray, int[] nArray) {
        double[][] dArray2 = new double[2][2];
        if (tBezier.tracesOver(tBezier2, dArray2)) {
            if (dArray2[0][0] != Double.POSITIVE_INFINITY) {
                dArray[0][nArray[0]] = dArray2[0][0];
            }
            if (dArray2[1][0] != Double.POSITIVE_INFINITY) {
                dArray[1][nArray[0]] = dArray2[1][0];
            }
            nArray[0] = nArray[0] + 1;
            if (dArray2[0][1] != Double.POSITIVE_INFINITY || dArray2[1][1] != Double.POSITIVE_INFINITY) {
                if (dArray2[0][1] != Double.POSITIVE_INFINITY) {
                    dArray[0][nArray[0]] = dArray2[0][1];
                }
                if (dArray2[1][1] != Double.POSITIVE_INFINITY) {
                    dArray[1][nArray[0]] = dArray2[1][1];
                }
                nArray[0] = nArray[0] + 1;
            }
            return;
        }
        if (n > 0) {
            TBezier[] tBezierArray = tBezier.Split();
            double d5 = (d + d2) * 0.5;
            --n;
            if (n2 > 0) {
                TBezier[] tBezierArray2 = tBezier2.Split();
                double d6 = (d3 + d4) * 0.5;
                --n2;
                if (TBezier.IntersectBB(tBezierArray[0], tBezierArray2[0])) {
                    TBezier.RecursivelyIntersect(tBezierArray[0], d, d5, n, tBezierArray2[0], d3, d6, n2, dArray, nArray);
                }
                if (TBezier.IntersectBB(tBezierArray[1], tBezierArray2[0])) {
                    TBezier.RecursivelyIntersect(tBezierArray[1], d5, d2, n, tBezierArray2[0], d3, d6, n2, dArray, nArray);
                }
                if (TBezier.IntersectBB(tBezierArray[0], tBezierArray2[1])) {
                    TBezier.RecursivelyIntersect(tBezierArray[0], d, d5, n, tBezierArray2[1], d6, d4, n2, dArray, nArray);
                }
                if (TBezier.IntersectBB(tBezierArray[1], tBezierArray2[1])) {
                    TBezier.RecursivelyIntersect(tBezierArray[1], d5, d2, n, tBezierArray2[1], d6, d4, n2, dArray, nArray);
                }
            } else {
                if (TBezier.IntersectBB(tBezierArray[0], tBezier2)) {
                    TBezier.RecursivelyIntersect(tBezierArray[0], d, d5, n, tBezier2, d3, d4, n2, dArray, nArray);
                }
                if (TBezier.IntersectBB(tBezierArray[1], tBezier2)) {
                    TBezier.RecursivelyIntersect(tBezierArray[1], d5, d2, n, tBezier2, d3, d4, n2, dArray, nArray);
                }
            }
        } else if (n2 > 0) {
            TBezier[] tBezierArray = tBezier2.Split();
            double d7 = (d3 + d4) * 0.5;
            --n2;
            if (TBezier.IntersectBB(tBezier, tBezierArray[0])) {
                TBezier.RecursivelyIntersect(tBezier, d, d2, n, tBezierArray[0], d3, d7, n2, dArray, nArray);
            }
            if (TBezier.IntersectBB(tBezier, tBezierArray[1])) {
                TBezier.RecursivelyIntersect(tBezier, d, d2, n, tBezierArray[0], d7, d4, n2, dArray, nArray);
            }
        } else {
            double d8 = tBezier.fPoint3_fX - tBezier.fPoint0_fX;
            double d9 = tBezier.fPoint3_fY - tBezier.fPoint0_fY;
            double d10 = tBezier2.fPoint3_fX - tBezier2.fPoint0_fX;
            double d11 = tBezier2.fPoint3_fY - tBezier2.fPoint0_fY;
            double d12 = tBezier2.fPoint0_fX - tBezier.fPoint0_fX;
            double d13 = tBezier2.fPoint0_fY - tBezier.fPoint0_fY;
            double d14 = d10 * d9 - d11 * d8;
            if (nArray[0] > 8) {
                return;
            }
            if (1.0 + d14 == 1.0) {
                return;
            }
            double d15 = 1.0 / d14;
            double d16 = (d10 * d13 - d11 * d12) * d15;
            double d17 = (d8 * d13 - d9 * d12) * d15;
            if (d16 < 0.0 || d16 > 1.0 || d17 < 0.0 || d17 > 1.0) {
                return;
            }
            dArray[0][nArray[0]] = d + d16 * (d2 - d);
            dArray[1][nArray[0]] = d3 + d17 * (d4 - d3);
            nArray[0] = nArray[0] + 1;
        }
    }

    private static int SGN(double d) {
        return d < 0.0 ? -1 : 1;
    }

    double[] SolveQuadratic(double d, double d2, double d3) {
        double d4;
        if (Math.abs(d3) < 1.0E-9 && (d4 = -d / d2) >= 0.0 && d4 <= 1.0) {
            double[] dArray = new double[]{d4};
            return dArray;
        }
        d4 = d2 / (2.0 * d3);
        double d5 = d / d3;
        double d6 = d4 * d4 - d5;
        if (Math.abs(d6) < 1.0E-9) {
            double d7 = -d4;
            if (d7 >= 0.0 && d7 <= 1.0) {
                double[] dArray = new double[]{d7};
                return dArray;
            }
        } else {
            if (d6 < 0.0) {
                return null;
            }
            if (d6 > 0.0) {
                double d8 = Math.sqrt(d6);
                double d9 = d8 - d4;
                double d10 = -d8 - d4;
                if (d9 >= 0.0 && d9 <= 1.0) {
                    if (d10 >= 0.0 && d10 <= 1.0) {
                        double[] dArray = new double[]{d9, d10};
                        TBezier.Sort(dArray);
                        return dArray;
                    }
                    double[] dArray = new double[]{d9};
                    return dArray;
                }
                if (d10 >= 0.0 && d10 <= 1.0) {
                    double[] dArray = new double[]{d10};
                    return dArray;
                }
                return null;
            }
        }
        return null;
    }

    public static void Sort(double[] dArray) {
        QSort.sort(dArray, dArray.length);
    }

    private static double[] SortAndEliminateDuplicates(double[] dArray, int n) {
        if (dArray == null || n < 1) {
            return null;
        }
        if (n == 1) {
            return dArray;
        }
        QSort.sort(dArray, n);
        int n2 = 0;
        int n3 = 1;
        while (n3 < n) {
            if (dArray[n2] != dArray[n3] && ++n2 != n3) {
                dArray[n2] = dArray[n3];
            }
            ++n3;
        }
        if (++n2 == n) {
            return dArray;
        }
        double[] dArray2 = new double[n2];
        System.arraycopy(dArray, 0, dArray2, 0, n2);
        return dArray2;
    }

    public TBezier[] Split() {
        TBezier[] tBezierArray = new TBezier[]{new TBezier(), new TBezier()};
        tBezierArray[0].fPoint0_fX = this.fPoint0_fX;
        tBezierArray[0].fPoint0_fY = this.fPoint0_fY;
        tBezierArray[1].fPoint3_fX = this.fPoint3_fX;
        tBezierArray[1].fPoint3_fY = this.fPoint3_fY;
        tBezierArray[0].fPoint1_fX = TBezier.MeanValue(this.fPoint0_fX, this.fPoint1_fX);
        tBezierArray[0].fPoint1_fY = TBezier.MeanValue(this.fPoint0_fY, this.fPoint1_fY);
        tBezierArray[1].fPoint2_fX = TBezier.MeanValue(this.fPoint2_fX, this.fPoint3_fX);
        tBezierArray[1].fPoint2_fY = TBezier.MeanValue(this.fPoint2_fY, this.fPoint3_fY);
        tBezierArray[1].fPoint1_fX = TBezier.MeanValue(this.fPoint1_fX, this.fPoint2_fX);
        tBezierArray[1].fPoint1_fY = TBezier.MeanValue(this.fPoint1_fY, this.fPoint2_fY);
        tBezierArray[0].fPoint2_fX = TBezier.MeanValue(tBezierArray[0].fPoint1_fX, tBezierArray[1].fPoint1_fX);
        tBezierArray[0].fPoint2_fY = TBezier.MeanValue(tBezierArray[0].fPoint1_fY, tBezierArray[1].fPoint1_fY);
        tBezierArray[1].fPoint1_fX = TBezier.MeanValue(tBezierArray[1].fPoint1_fX, tBezierArray[1].fPoint2_fX);
        tBezierArray[1].fPoint1_fY = TBezier.MeanValue(tBezierArray[1].fPoint1_fY, tBezierArray[1].fPoint2_fY);
        tBezierArray[1].fPoint0_fX = TBezier.MeanValue(tBezierArray[0].fPoint2_fX, tBezierArray[1].fPoint1_fX);
        tBezierArray[1].fPoint0_fY = TBezier.MeanValue(tBezierArray[0].fPoint2_fY, tBezierArray[1].fPoint1_fY);
        tBezierArray[0].fPoint3_fX = TBezier.MeanValue(tBezierArray[0].fPoint2_fX, tBezierArray[1].fPoint1_fX);
        tBezierArray[0].fPoint3_fY = TBezier.MeanValue(tBezierArray[0].fPoint2_fY, tBezierArray[1].fPoint1_fY);
        return tBezierArray;
    }

    private static double computeXIntercept(TGPoint[] tGPointArray, int n) {
        double d = 1.0;
        double d2 = 0.0;
        double d3 = tGPointArray[n].x - tGPointArray[0].x;
        double d4 = tGPointArray[n].y - tGPointArray[0].y;
        double d5 = tGPointArray[0].x;
        double d6 = tGPointArray[0].y;
        double d7 = d3 * d2 - d4 * d;
        double d8 = 1.0 / d7;
        double d9 = (d3 * d6 - d4 * d5) * d8;
        double d10 = 0.0 + d * d9;
        return d10;
    }

    public final boolean containsWithinConvexHull(TGPoint tGPoint) {
        TGPolygon tGPolygon = new TGPolygon(4);
        tGPolygon.setPoint(0, this.getPoint(0));
        tGPolygon.setPoint(1, this.getPoint(1));
        tGPolygon.setPoint(2, this.getPoint(2));
        tGPolygon.setPoint(3, this.getPoint(3));
        return tGPolygon.contains(tGPoint);
    }

    private TGPoint[] convertToBezierForm(TGPoint tGPoint, TGPoint[] tGPointArray) {
        TGPoint[] tGPointArray2 = new TGPoint[4];
        TGPoint[] tGPointArray3 = new TGPoint[3];
        double[][] dArray = new double[3][4];
        double[][] dArrayArray = new double[][]{{1.0, 0.6, 0.3, 0.1}, {0.4, 0.6, 0.6, 0.4}, {0.1, 0.3, 0.6, 1.0}};
        int n = 0;
        while (n <= 3) {
            tGPointArray2[n] = TGPoint.subtract(tGPointArray[n], tGPoint);
            ++n;
        }
        n = 0;
        while (n <= 2) {
            tGPointArray3[n] = TGPoint.subtract(tGPointArray[n + 1], tGPointArray[n]);
            tGPointArray3[n].multiplyBy(3.0);
            ++n;
        }
        int n2 = 0;
        while (n2 <= 2) {
            int n3 = 0;
            while (n3 <= 3) {
                dArray[n2][n3] = tGPointArray3[n2].dotProduct(tGPointArray2[n3]);
                ++n3;
            }
            ++n2;
        }
        TGPoint[] tGPointArray4 = new TGPoint[6];
        n = 0;
        while (n <= 5) {
            tGPointArray4[n] = new TGPoint((double)n / 5.0, 0.0);
            ++n;
        }
        int n4 = 3;
        int n5 = 2;
        int n6 = 0;
        while (n6 <= n4 + n5) {
            int n7 = Math.max(0, n6 - n5);
            int n8 = Math.min(n6, n4);
            n = n7;
            while (n <= n8) {
                int n9 = n6 - n;
                tGPointArray4[n + n9].y += dArray[n9][n] * dArrayArray[n9][n];
                ++n;
            }
            ++n6;
        }
        return tGPointArray4;
    }

    private static int crossingCount(TGPoint[] tGPointArray, int n) {
        int n2;
        int n3 = 0;
        int n4 = n2 = TBezier.SGN(tGPointArray[0].y);
        int n5 = 1;
        while (n5 <= n) {
            n4 = TBezier.SGN(tGPointArray[n5].y);
            if (n4 != n2) {
                ++n3;
            }
            n2 = n4;
            ++n5;
        }
        return n3;
    }

    public boolean equals(TBezier tBezier) {
        return this.fPoint0_fX == tBezier.fPoint0_fX && this.fPoint0_fY == tBezier.fPoint0_fY && this.fPoint1_fX == tBezier.fPoint1_fX && this.fPoint1_fY == tBezier.fPoint1_fY && this.fPoint2_fX == tBezier.fPoint2_fX && this.fPoint2_fY == tBezier.fPoint2_fY && this.fPoint3_fX == tBezier.fPoint3_fX && this.fPoint3_fY == tBezier.fPoint3_fY;
    }

    static double evalValue(double d, double d2, double d3) {
        return d2 + d * (d3 - d2);
    }

    public TGPoint evaluate(double d) {
        double d2 = (1.0 - d) * (1.0 - d) * (1.0 - d) * this.fPoint0_fX + 3.0 * d * (1.0 - d) * (1.0 - d) * this.fPoint1_fX + 3.0 * d * d * (1.0 - d) * this.fPoint2_fX + d * d * d * this.fPoint3_fX;
        double d3 = (1.0 - d) * (1.0 - d) * (1.0 - d) * this.fPoint0_fY + 3.0 * d * (1.0 - d) * (1.0 - d) * this.fPoint1_fY + 3.0 * d * d * (1.0 - d) * this.fPoint2_fY + d * d * d * this.fPoint3_fY;
        return new TGPoint(d2, d3);
    }

    private static TGPoint evaluateWithFill(TGPoint[] tGPointArray, int n, double d, TGPoint[] tGPointArray2, TGPoint[] tGPointArray3) {
        TGPoint[][] tGPointArray4 = new TGPoint[6][6];
        int n2 = 0;
        while (n2 <= n) {
            tGPointArray4[0][n2] = tGPointArray[n2];
            ++n2;
        }
        int n3 = 1;
        while (n3 <= n) {
            n2 = 0;
            while (n2 <= n - n3) {
                tGPointArray4[n3][n2] = new TGPoint((1.0 - d) * tGPointArray4[n3 - 1][n2].x + d * tGPointArray4[n3 - 1][n2 + 1].x, (1.0 - d) * tGPointArray4[n3 - 1][n2].y + d * tGPointArray4[n3 - 1][n2 + 1].y);
                ++n2;
            }
            ++n3;
        }
        if (tGPointArray2 != null) {
            n2 = 0;
            while (n2 <= n) {
                tGPointArray2[n2] = tGPointArray4[n2][0];
                ++n2;
            }
        }
        if (tGPointArray3 != null) {
            n2 = 0;
            while (n2 <= n) {
                tGPointArray3[n2] = tGPointArray4[n - n2][n2];
                ++n2;
            }
        }
        return tGPointArray4[n][0];
    }

    double[] findInfiniteDerivatives() {
        if (this.isLinear()) {
            return null;
        }
        double d = -this.fPoint0_fX + 3.0 * this.fPoint1_fX - 3.0 * this.fPoint2_fX + this.fPoint3_fX;
        double d2 = 2.0 * this.fPoint0_fX - 4.0 * this.fPoint1_fX + 2.0 * this.fPoint2_fX;
        double d3 = -this.fPoint0_fX + this.fPoint1_fX;
        return this.SolveQuadratic(d3, d2, d);
    }

    public static double[][] findIntersections(TBezier tBezier, TBezier tBezier2) {
        double[][] dArray = new double[2][9];
        int[] nArray = new int[]{0};
        if (TBezier.IntersectBB(tBezier, tBezier2)) {
            int n = tBezier.subDivisionDepth();
            int n2 = tBezier2.subDivisionDepth();
            TBezier.RecursivelyIntersect(tBezier, 0.0, 1.0, n, tBezier2, 0.0, 1.0, n2, dArray, nArray);
        }
        double[][] dArray2 = new double[2][nArray[0]];
        dArray2[0] = TBezier.SortAndEliminateDuplicates(dArray[0], nArray[0]);
        dArray2[1] = TBezier.SortAndEliminateDuplicates(dArray[1], nArray[0]);
        return dArray2;
    }

    public double findNearestParametric(TGPoint tGPoint, TGPoint tGPoint2) {
        double d;
        double[] dArray = new double[5];
        TGPoint[] tGPointArray = new TGPoint[]{this.getPoint(0), this.getPoint(1), this.getPoint(2), this.getPoint(3)};
        TGPoint[] tGPointArray2 = this.convertToBezierForm(tGPoint, tGPointArray);
        int n = TBezier.findRoots(tGPointArray2, 5, dArray, 0);
        TGPoint tGPoint3 = TGPoint.subtract(tGPoint, tGPointArray[0]);
        double d2 = tGPoint3.vectorSquaredLength();
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            TGPoint tGPoint4 = TBezier.evaluateWithFill(tGPointArray, 3, dArray[n2], null, null);
            d = TGPoint.subtract(tGPoint, tGPoint4).vectorSquaredLength();
            if (d < d2) {
                d2 = d;
                d3 = dArray[n2];
            }
            ++n2;
        }
        d = TGPoint.subtract(tGPoint, tGPointArray[3]).vectorSquaredLength();
        if (d < d2) {
            d2 = d;
            d3 = 1.0;
        }
        tGPoint2.copyFrom(TBezier.evaluateWithFill(tGPointArray, 3, d3, null, null));
        return d3;
    }

    public static double[] findOverlaps(TBezier tBezier, TBezier tBezier2) {
        TGPoint tGPoint = tBezier.getPoint(0);
        TGPoint tGPoint2 = tBezier.getPoint(3);
        TGPoint tGPoint3 = tBezier2.getPoint(0);
        TGPoint tGPoint4 = tBezier2.getPoint(3);
        if (TBezier.isClose(tGPoint, tGPoint3) && TBezier.isClose(tGPoint2, tGPoint4) || TBezier.isClose(tGPoint, tGPoint4) && TBezier.isClose(tGPoint2, tGPoint3)) {
            boolean bl = tBezier.isLinear();
            boolean bl2 = tBezier2.isLinear();
            if (!bl && !bl2) {
                double[] dArray = new double[]{0.5, 0.5};
                return dArray;
            }
            if (!bl && bl2) {
                double[] dArray = new double[]{0.5, 0.0};
                return dArray;
            }
            if (bl && !bl2) {
                double[] dArray = new double[]{0.0, 0.5};
                return dArray;
            }
            return null;
        }
        if (tGPoint.equals(tGPoint3) || tGPoint.equals(tGPoint4) || tGPoint2.equals(tGPoint3) || tGPoint2.equals(tGPoint4)) {
            return null;
        }
        double d = (tGPoint2.x - tGPoint.x) * (tGPoint4.y - tGPoint3.y) - (tGPoint2.y - tGPoint.y) * (tGPoint4.x - tGPoint3.x);
        if (d == 0.0) {
            return null;
        }
        double d2 = (tGPoint3.x - tGPoint.x) * (tGPoint4.y - tGPoint3.y) - (tGPoint3.y - tGPoint.y) * (tGPoint4.x - tGPoint3.x);
        double d3 = d2 / d;
        double d4 = (tGPoint2.x - tGPoint.x) * (tGPoint.y - tGPoint3.y) - (tGPoint2.y - tGPoint.y) * (tGPoint.x - tGPoint3.x);
        double d5 = d4 / d;
        if (d3 > 0.0 && d3 < 1.0 && d5 > 0.0 && d5 < 1.0) {
            double[] dArray = new double[]{d3, d5};
            return dArray;
        }
        return null;
    }

    static int findRoots(TGPoint[] tGPointArray, int n, double[] dArray, int n2) {
        TGPoint[] tGPointArray2 = new TGPoint[6];
        TGPoint[] tGPointArray3 = new TGPoint[6];
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        switch (TBezier.crossingCount(tGPointArray, n)) {
            case 0: {
                return 0;
            }
            case 1: {
                if (n2 >= 64) {
                    dArray[0] = (tGPointArray[0].x + tGPointArray[5].x) / 2.0;
                    return 1;
                }
                if (!TBezier.isControlPolygonFlatEnough(tGPointArray, n)) break;
                dArray[0] = TBezier.computeXIntercept(tGPointArray, n);
                return 1;
            }
        }
        TBezier.evaluateWithFill(tGPointArray, n, 0.5, tGPointArray2, tGPointArray3);
        int n3 = TBezier.findRoots(tGPointArray2, n, dArray2, n2 + 1);
        int n4 = TBezier.findRoots(tGPointArray3, n, dArray3, n2 + 1);
        int n5 = 0;
        while (n5 < n3) {
            dArray[n5] = dArray2[n5];
            ++n5;
        }
        n5 = 0;
        while (n5 < n4) {
            dArray[n5 + n3] = dArray3[n5];
            ++n5;
        }
        return n3 + n4;
    }

    double[] findZeroDerivatives() {
        if (this.isLinear()) {
            return null;
        }
        double d = -this.fPoint0_fY + 3.0 * this.fPoint1_fY - 3.0 * this.fPoint2_fY + this.fPoint3_fY;
        double d2 = 2.0 * this.fPoint0_fY - 4.0 * this.fPoint1_fY + 2.0 * this.fPoint2_fY;
        double d3 = -this.fPoint0_fY + this.fPoint1_fY;
        return this.SolveQuadratic(d3, d2, d);
    }

    TGPoint getPoint(int n) {
        if (n < 0 || n > 3) {
            throw new IndexOutOfBoundsException("TBezier.getPoint(): index");
        }
        switch (n) {
            case 0: {
                return new TGPoint(this.fPoint0_fX, this.fPoint0_fY);
            }
            case 1: {
                return new TGPoint(this.fPoint1_fX, this.fPoint1_fY);
            }
            case 2: {
                return new TGPoint(this.fPoint2_fX, this.fPoint2_fY);
            }
            case 3: {
                return new TGPoint(this.fPoint3_fX, this.fPoint3_fY);
            }
        }
        return null;
    }

    public final boolean hasInflexion() {
        TGPoint tGPoint;
        TGPoint tGPoint2;
        TGPoint tGPoint3;
        TGPoint tGPoint4 = this.getPoint(0);
        return TBezier.linesIntersect(tGPoint4, tGPoint3 = this.getPoint(1), tGPoint2 = this.getPoint(2), tGPoint = this.getPoint(3)) || TBezier.linesIntersect(tGPoint3, tGPoint2, tGPoint4, tGPoint);
    }

    public boolean isClose(TBezier tBezier) {
        return TBezier.Eq(this.fPoint0_fX, tBezier.fPoint0_fX, 5.0E-6) && TBezier.Eq(this.fPoint0_fY, tBezier.fPoint0_fY, 5.0E-6) && TBezier.Eq(this.fPoint1_fX, tBezier.fPoint1_fX, 5.0E-6) && TBezier.Eq(this.fPoint1_fY, tBezier.fPoint1_fY, 5.0E-6) && TBezier.Eq(this.fPoint2_fX, tBezier.fPoint2_fX, 5.0E-6) && TBezier.Eq(this.fPoint2_fY, tBezier.fPoint2_fY, 5.0E-6) && TBezier.Eq(this.fPoint3_fX, tBezier.fPoint3_fX, 5.0E-6) && TBezier.Eq(this.fPoint3_fY, tBezier.fPoint3_fY, 5.0E-6) || TBezier.Eq(this.fPoint0_fX, tBezier.fPoint3_fX, 5.0E-6) && TBezier.Eq(this.fPoint0_fY, tBezier.fPoint3_fY, 5.0E-6) && TBezier.Eq(this.fPoint1_fX, tBezier.fPoint2_fX, 5.0E-6) && TBezier.Eq(this.fPoint1_fY, tBezier.fPoint2_fY, 5.0E-6) && TBezier.Eq(this.fPoint2_fX, tBezier.fPoint1_fX, 5.0E-6) && TBezier.Eq(this.fPoint2_fY, tBezier.fPoint1_fY, 5.0E-6) && TBezier.Eq(this.fPoint3_fX, tBezier.fPoint0_fX, 5.0E-6) && TBezier.Eq(this.fPoint3_fY, tBezier.fPoint0_fY, 5.0E-6);
    }

    public static final boolean isClose(TGPoint tGPoint, TGPoint tGPoint2) {
        return TBezier.Eq(tGPoint.x, tGPoint2.x) && TBezier.Eq(tGPoint.y, tGPoint2.y);
    }

    public static final boolean isClose(TGPoint tGPoint, TGPoint tGPoint2, double d) {
        return TBezier.Eq(tGPoint.x, tGPoint2.x, d) && TBezier.Eq(tGPoint.y, tGPoint2.y, d);
    }

    private static boolean isControlPolygonFlatEnough(TGPoint[] tGPointArray, int n) {
        double d;
        double[] dArray = new double[n + 1];
        double d2 = tGPointArray[0].y - tGPointArray[n].y;
        double d3 = tGPointArray[n].x - tGPointArray[0].x;
        double d4 = tGPointArray[0].x * tGPointArray[n].y - tGPointArray[n].x * tGPointArray[0].y;
        double d5 = d2 * d2 + d3 * d3;
        int n2 = 1;
        while (n2 < n) {
            dArray[n2] = d2 * tGPointArray[n2].x + d3 * tGPointArray[n2].y + d4;
            if (dArray[n2] > 0.0) {
                dArray[n2] = dArray[n2] * dArray[n2] / d5;
            }
            if (dArray[n2] < 0.0) {
                dArray[n2] = -(dArray[n2] * dArray[n2] / d5);
            }
            ++n2;
        }
        double d6 = 0.0;
        double d7 = 0.0;
        n2 = 1;
        while (n2 < n) {
            if (dArray[n2] < 0.0) {
                d7 = Math.min(d7, dArray[n2]);
            }
            if (dArray[n2] > 0.0) {
                d6 = Math.max(d6, dArray[n2]);
            }
            ++n2;
        }
        double d8 = 0.0;
        double d9 = 1.0;
        double d10 = 0.0;
        double d11 = d2;
        double d12 = d3;
        double d13 = d4 + d6;
        double d14 = d8 * d12 - d11 * d9;
        double d15 = 1.0 / d14;
        double d16 = (d9 * d13 - d12 * d10) * d15;
        d11 = d2;
        d12 = d3;
        d13 = d4 + d7;
        d14 = d8 * d12 - d11 * d9;
        d15 = 1.0 / d14;
        double d17 = (d9 * d13 - d12 * d10) * d15;
        double d18 = Math.min(d16, d17);
        double d19 = Math.max(d16, d17);
        double d20 = 0.5 * (d19 - d18);
        return d20 < (d = Math.exp(-65.0));
    }

    public boolean isDegenerate() {
        return TBezier.Eq(this.fPoint0_fX, this.fPoint1_fX) && TBezier.Eq(this.fPoint0_fY, this.fPoint1_fY) && TBezier.Eq(this.fPoint1_fX, this.fPoint2_fX) && TBezier.Eq(this.fPoint1_fY, this.fPoint2_fY) && TBezier.Eq(this.fPoint2_fX, this.fPoint3_fX) && TBezier.Eq(this.fPoint2_fY, this.fPoint3_fY);
    }

    public boolean isLinear() {
        double d;
        double d2;
        double d3;
        double d4;
        if (this.fPoint0_fX == this.fPoint1_fX && this.fPoint0_fY == this.fPoint1_fY && this.fPoint2_fX == this.fPoint3_fX && this.fPoint2_fY == this.fPoint3_fY) {
            return true;
        }
        double d5 = this.fPoint1_fY - this.fPoint0_fY;
        double d6 = d5 == 0.0 ? Double.POSITIVE_INFINITY : (this.fPoint1_fX - this.fPoint0_fX) / d5;
        return d6 == (d4 = (d3 = this.fPoint2_fY - this.fPoint1_fY) == 0.0 ? Double.POSITIVE_INFINITY : (this.fPoint2_fX - this.fPoint1_fX) / d3) && d4 == (d2 = (d = this.fPoint3_fY - this.fPoint2_fY) == 0.0 ? Double.POSITIVE_INFINITY : (this.fPoint3_fX - this.fPoint2_fX) / d);
    }

    private boolean isSegmentOf(TBezier tBezier, double[] dArray) {
        boolean bl = tBezier.passesThrough(this.evaluate(0.25), dArray, 0);
        boolean bl2 = tBezier.passesThrough(this.evaluate(0.5), dArray, 0);
        boolean bl3 = tBezier.passesThrough(this.evaluate(0.75), dArray, 0);
        boolean bl4 = tBezier.passesThrough(this.getPoint(0), dArray, 0);
        boolean bl5 = tBezier.passesThrough(this.getPoint(3), dArray, 1);
        return bl && bl2 && bl3 && bl4 && bl5;
    }

    private double lengthEstimateSquare() {
        double d = (this.fPoint0_fX - this.fPoint1_fX) * (this.fPoint0_fX - this.fPoint1_fX) + (this.fPoint0_fY - this.fPoint1_fY) * (this.fPoint0_fY - this.fPoint1_fY) + (this.fPoint1_fX - this.fPoint2_fX) * (this.fPoint1_fX - this.fPoint2_fX) + (this.fPoint1_fY - this.fPoint2_fY) * (this.fPoint1_fY - this.fPoint2_fY) + (this.fPoint2_fX - this.fPoint3_fX) * (this.fPoint2_fX - this.fPoint3_fX) + (this.fPoint2_fY - this.fPoint3_fY) * (this.fPoint2_fY - this.fPoint3_fY);
        return d;
    }

    private static boolean linesIntersect(TGPoint tGPoint, TGPoint tGPoint2, TGPoint tGPoint3, TGPoint tGPoint4) {
        if (tGPoint.equals(tGPoint3) || tGPoint.equals(tGPoint4) || tGPoint2.equals(tGPoint3) || tGPoint2.equals(tGPoint4)) {
            return false;
        }
        double d = (tGPoint2.x - tGPoint.x) * (tGPoint4.y - tGPoint3.y) - (tGPoint2.y - tGPoint.y) * (tGPoint4.x - tGPoint3.x);
        if (d == 0.0) {
            return false;
        }
        double d2 = ((tGPoint3.x - tGPoint.x) * (tGPoint4.y - tGPoint3.y) - (tGPoint3.y - tGPoint.y) * (tGPoint4.x - tGPoint3.x)) / d;
        double d3 = ((tGPoint2.x - tGPoint.x) * (tGPoint.y - tGPoint3.y) - (tGPoint2.y - tGPoint.y) * (tGPoint.x - tGPoint3.x)) / d;
        return d2 > 0.0 && d2 < 1.0 && d3 > 0.0 && d3 < 1.0;
    }

    private static double log4(double d) {
        return 0.5 * Math.log(d) / Math.log(2.0);
    }

    public final TGPoint normal(double d) {
        double d2 = -3.0 * (1.0 - d) * (1.0 - d) * this.fPoint0_fX + 3.0 * ((1.0 - d) * (1.0 - d) - 2.0 * d * (1.0 - d)) * this.fPoint1_fX + 3.0 * (-d * d + 2.0 * d * (1.0 - d)) * this.fPoint2_fX + 3.0 * d * d * this.fPoint3_fX;
        double d3 = -3.0 * (1.0 - d) * (1.0 - d) * this.fPoint0_fY + 3.0 * ((1.0 - d) * (1.0 - d) - 2.0 * d * (1.0 - d)) * this.fPoint1_fY + 3.0 * (-d * d + 2.0 * d * (1.0 - d)) * this.fPoint2_fY + 3.0 * d * d * this.fPoint3_fY;
        return new TGPoint(-d3, d2);
    }

    private boolean passesThrough(TGPoint tGPoint, double[] dArray, int n) {
        TGPoint tGPoint2 = new TGPoint();
        dArray[n] = this.findNearestParametric(tGPoint, tGPoint2);
        TGPoint tGPoint3 = this.evaluate(dArray[n]);
        boolean bl = TBezier.isClose(tGPoint, tGPoint2);
        return bl;
    }

    void reverseDirection() {
        double d = this.fPoint0_fX;
        this.fPoint0_fX = this.fPoint3_fX;
        this.fPoint3_fX = d;
        d = this.fPoint0_fY;
        this.fPoint0_fY = this.fPoint3_fY;
        this.fPoint3_fY = d;
        d = this.fPoint1_fX;
        this.fPoint1_fX = this.fPoint2_fX;
        this.fPoint2_fX = d;
        d = this.fPoint1_fY;
        this.fPoint1_fY = this.fPoint2_fY;
        this.fPoint2_fY = d;
    }

    void setPoint(int n, TGPoint tGPoint) {
        if (n < 0 || n > 3) {
            throw new IndexOutOfBoundsException("TBezier.setPoint(): index");
        }
        switch (n) {
            case 0: {
                this.fPoint0_fX = tGPoint.x;
                this.fPoint0_fY = tGPoint.y;
                break;
            }
            case 1: {
                this.fPoint1_fX = tGPoint.x;
                this.fPoint1_fY = tGPoint.y;
                break;
            }
            case 2: {
                this.fPoint2_fX = tGPoint.x;
                this.fPoint2_fY = tGPoint.y;
                break;
            }
            case 3: {
                this.fPoint3_fX = tGPoint.x;
                this.fPoint3_fY = tGPoint.y;
                break;
            }
        }
    }

    final int subDivisionDepth() {
        double d = Math.abs(this.fPoint2_fX - this.fPoint1_fX - (this.fPoint1_fX - this.fPoint0_fX));
        double d2 = Math.abs(this.fPoint3_fX - this.fPoint2_fX - (this.fPoint2_fX - this.fPoint1_fX));
        double d3 = Math.abs(this.fPoint2_fY - this.fPoint1_fY - (this.fPoint1_fY - this.fPoint0_fY));
        double d4 = Math.abs(this.fPoint3_fY - this.fPoint2_fY - (this.fPoint2_fY - this.fPoint1_fY));
        double d5 = Math.max(Math.max(d, d2), Math.max(d3, d4));
        if (d5 * 0.75 * M_SQRT2 + 1.0 == 1.0) {
            return 0;
        }
        return (int)Math.ceil(TBezier.log4(173778.56254440593));
    }

    public String toString() {
        return "TBezier : (" + this.fPoint0_fX + "," + this.fPoint0_fY + ")" + " (" + this.fPoint1_fX + "," + this.fPoint1_fY + ")" + " (" + this.fPoint2_fX + "," + this.fPoint2_fY + ")" + " (" + this.fPoint3_fX + "," + this.fPoint3_fY + ")\n";
    }

    private boolean tracesOver(TBezier tBezier, double[][] dArray) {
        dArray[1][1] = Double.POSITIVE_INFINITY;
        dArray[1][0] = Double.POSITIVE_INFINITY;
        dArray[0][1] = Double.POSITIVE_INFINITY;
        dArray[0][0] = Double.POSITIVE_INFINITY;
        if (this.isSegmentOf(tBezier, dArray[1])) {
            dArray[0][0] = 0.0;
            dArray[0][1] = 1.0;
            return true;
        }
        if (tBezier.isSegmentOf(this, dArray[0])) {
            dArray[1][0] = 0.0;
            dArray[1][1] = 1.0;
            return true;
        }
        TGPoint tGPoint = this.getPoint(0);
        TGPoint tGPoint2 = this.getPoint(3);
        TGPoint tGPoint3 = tBezier.getPoint(0);
        TGPoint tGPoint4 = tBezier.getPoint(3);
        if (tBezier.passesThrough(tGPoint, dArray[1], 0)) {
            if (this.passesThrough(tGPoint3, dArray[0], 0)) {
                return !tGPoint3.equals(tGPoint);
            }
            if (this.passesThrough(tBezier.getPoint(3), dArray[0], 0)) {
                return !tGPoint4.equals(tGPoint);
            }
            return false;
        }
        if (tBezier.passesThrough(tGPoint2, dArray[1], 0)) {
            if (this.passesThrough(tGPoint3, dArray[0], 0)) {
                return !tGPoint3.equals(tGPoint2);
            }
            if (this.passesThrough(tGPoint4, dArray[0], 0)) {
                return !tGPoint4.equals(tGPoint2);
            }
            return false;
        }
        return false;
    }
}

