/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.TBezier;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGPointArray;
import sun.awt.Albert.TRawPrimitiveArray;

class TArrayOfTBezier
extends TRawPrimitiveArray {
    private TBezier[] fValues = null;

    public TArrayOfTBezier() {
        super(0);
    }

    void allocateArray(int n) {
        this.fValues = null;
        if (n > 0) {
            this.fValues = new TBezier[n];
        }
    }

    public void append(TBezier tBezier) {
        int n = this.fNumberOfValues;
        this.resize(n + 1);
        this.fValues[n] = tBezier;
    }

    public TBezier getValue(int n) {
        if (n < 0 || n >= this.fNumberOfValues) {
            throw new IndexOutOfBoundsException("RawArray.value(index)");
        }
        return this.fValues[n];
    }

    public static int isInsideArray(TGPointArray tGPointArray, TGPoint tGPoint) {
        int n = tGPointArray.getNumberOfValues();
        int n2 = 0;
        while (n2 < n) {
            if (TBezier.isClose(tGPointArray.getValue(n2), tGPoint)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    void reallocateArray(int n) {
        TBezier[] tBezierArray = this.fValues;
        this.allocateArray(n);
        if (n > 0) {
            System.arraycopy(tBezierArray, 0, this.fValues, 0, this.fArraySize > n ? n : this.fArraySize);
        }
    }

    int searchBezier(TGPoint tGPoint, TGPoint tGPoint2) {
        int n = 0;
        while (n < this.fNumberOfValues) {
            if (TBezier.isClose(tGPoint, this.fValues[n].getPoint(0), 0.1) && TBezier.isClose(tGPoint2, this.fValues[n].getPoint(3), 0.1) || TBezier.isClose(tGPoint, this.fValues[n].getPoint(3), 0.1) && TBezier.isClose(tGPoint2, this.fValues[n].getPoint(0), 0.1)) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

