/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public class StyleSheet
extends StyleContext {
    static final Border noBorder = new EmptyBorder(0, 0, 0, 0);
    static final int DEFAULT_FONT_SIZE = 3;
    private Style selectors = this.addStyle(null, null);
    private CssParser parser;
    private transient Hashtable valueConvertor;
    private transient Vector searchContext;
    private int baseFontIndex;
    private int baseFontSize;
    static int[] sizeMap = new int[]{8, 10, 12, 14, 18, 24, 36};
    static final SheetAttribute RULE = new SheetAttribute("rule", false);
    static final SheetAttribute WEIGHT = new SheetAttribute("rule-weight", false);
    static final SheetAttribute BOX_PAINTER = new SheetAttribute("box-painter", true);
    static final SheetAttribute LIST_PAINTER = new SheetAttribute("list-painter", true);
    private static final Hashtable htmlAttrToCssAttrMap = new Hashtable(20);

    static {
        htmlAttrToCssAttrMap.put(HTML.Attribute.COLOR, new CSS.Attribute[]{CSS.Attribute.COLOR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.TEXT, new CSS.Attribute[]{CSS.Attribute.COLOR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.CLEAR, new CSS.Attribute[]{CSS.Attribute.CLEAR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.BACKGROUND, new CSS.Attribute[]{CSS.Attribute.BACKGROUND_IMAGE});
        htmlAttrToCssAttrMap.put(HTML.Attribute.BGCOLOR, new CSS.Attribute[]{CSS.Attribute.BACKGROUND_COLOR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.WIDTH, new CSS.Attribute[]{CSS.Attribute.WIDTH});
        htmlAttrToCssAttrMap.put(HTML.Attribute.HEIGHT, new CSS.Attribute[]{CSS.Attribute.HEIGHT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.BORDER, new CSS.Attribute[]{CSS.Attribute.BORDER_WIDTH});
        htmlAttrToCssAttrMap.put(HTML.Attribute.CELLPADDING, new CSS.Attribute[]{CSS.Attribute.PADDING});
        htmlAttrToCssAttrMap.put(HTML.Attribute.CELLSPACING, new CSS.Attribute[]{CSS.Attribute.MARGIN});
        htmlAttrToCssAttrMap.put(HTML.Attribute.MARGINWIDTH, new CSS.Attribute[]{CSS.Attribute.MARGIN_LEFT, CSS.Attribute.MARGIN_RIGHT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.MARGINHEIGHT, new CSS.Attribute[]{CSS.Attribute.MARGIN_TOP, CSS.Attribute.MARGIN_BOTTOM});
        htmlAttrToCssAttrMap.put(HTML.Attribute.HSPACE, new CSS.Attribute[]{CSS.Attribute.PADDING_LEFT, CSS.Attribute.PADDING_RIGHT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.VSPACE, new CSS.Attribute[]{CSS.Attribute.PADDING_BOTTOM, CSS.Attribute.PADDING_TOP});
        htmlAttrToCssAttrMap.put(HTML.Attribute.FACE, new CSS.Attribute[]{CSS.Attribute.FONT_FAMILY});
        htmlAttrToCssAttrMap.put(HTML.Attribute.SIZE, new CSS.Attribute[]{CSS.Attribute.FONT_SIZE});
        htmlAttrToCssAttrMap.put(HTML.Attribute.VALIGN, new CSS.Attribute[]{CSS.Attribute.VERTICAL_ALIGN});
        htmlAttrToCssAttrMap.put(HTML.Attribute.ALIGN, new CSS.Attribute[]{CSS.Attribute.VERTICAL_ALIGN, CSS.Attribute.TEXT_ALIGN, CSS.Attribute.FLOAT});
        CSS.Attribute[] attributeArray = CSS.Attribute.allAttributes;
        try {
            int n = 0;
            while (n < attributeArray.length) {
                StyleContext.registerStaticAttributeKey(attributeArray[n]);
                ++n;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        StyleContext.registerStaticAttributeKey(RULE);
        StyleContext.registerStaticAttributeKey(WEIGHT);
        StyleContext.registerStaticAttributeKey(BOX_PAINTER);
        StyleContext.registerStaticAttributeKey(LIST_PAINTER);
    }

    public StyleSheet() {
        this.selectors.addAttribute(StyleConstants.NameAttribute, ":");
        this.searchContext = new Vector();
        this.valueConvertor = new Hashtable();
        this.valueConvertor.put(CSS.Attribute.FONT_SIZE, new FontSize());
        this.valueConvertor.put(CSS.Attribute.FONT_FAMILY, new FontFamily());
        this.valueConvertor.put(CSS.Attribute.FONT_WEIGHT, new FontWeight());
        this.valueConvertor.put(CSS.Attribute.BORDER_STYLE, new BorderStyle());
        ColorValue colorValue = new ColorValue();
        this.valueConvertor.put(CSS.Attribute.COLOR, colorValue);
        this.valueConvertor.put(CSS.Attribute.BACKGROUND_COLOR, colorValue);
        this.valueConvertor.put(CSS.Attribute.BORDER_COLOR, colorValue);
        LengthValue lengthValue = new LengthValue();
        this.valueConvertor.put(CSS.Attribute.MARGIN_TOP, lengthValue);
        this.valueConvertor.put(CSS.Attribute.MARGIN_BOTTOM, lengthValue);
        this.valueConvertor.put(CSS.Attribute.MARGIN_LEFT, lengthValue);
        this.valueConvertor.put(CSS.Attribute.MARGIN_RIGHT, lengthValue);
        this.valueConvertor.put(CSS.Attribute.PADDING_TOP, lengthValue);
        this.valueConvertor.put(CSS.Attribute.PADDING_BOTTOM, lengthValue);
        this.valueConvertor.put(CSS.Attribute.PADDING_LEFT, lengthValue);
        this.valueConvertor.put(CSS.Attribute.PADDING_RIGHT, lengthValue);
        this.valueConvertor.put(CSS.Attribute.BORDER_WIDTH, lengthValue);
        this.valueConvertor.put(CSS.Attribute.BORDER_TOP_WIDTH, lengthValue);
        this.valueConvertor.put(CSS.Attribute.BORDER_BOTTOM_WIDTH, lengthValue);
        this.valueConvertor.put(CSS.Attribute.BORDER_LEFT_WIDTH, lengthValue);
        this.valueConvertor.put(CSS.Attribute.BORDER_RIGHT_WIDTH, lengthValue);
        CssValue cssValue = new CssValue();
        int n = CSS.Attribute.allAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            CSS.Attribute attribute = CSS.Attribute.allAttributes[n2];
            if (this.valueConvertor.get(attribute) == null) {
                this.valueConvertor.put(attribute, cssValue);
            }
            ++n2;
        }
        this.baseFontSize = 3;
    }

    public void addRule(String string) {
    }

    void addRule(String[] stringArray, AttributeSet attributeSet) {
        String string = "";
        int n = stringArray.length - 1;
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + stringArray[n2] + " ";
            ++n2;
        }
        Style style = this.getStyle(string = String.valueOf(string) + stringArray[n]);
        if (style == null) {
            style = this.addStyle(string, null);
            Style style2 = this.selectors;
            int n3 = 0;
            while (n3 <= n) {
                style2 = this.addSelector(style2, stringArray[n3]);
                ++n3;
            }
            style2.addAttribute(RULE, style);
        }
        style.addAttributes(attributeSet);
    }

    Style addSelector(Style style, String string) {
        Style style2;
        HTML.Tag tag = HTML.getTag(string);
        if (tag != null) {
            Style style3;
            if (!style.isDefined(tag)) {
                style3 = this.addStyle(null, style);
                String string2 = String.valueOf(String.valueOf(style.getAttribute(StyleConstants.NameAttribute))) + string + ":";
                style3.addAttribute(StyleConstants.NameAttribute, string2);
                style.addAttribute(tag, style3);
            } else {
                style3 = (Style)style.getAttribute(tag);
            }
            return style3;
        }
        if (!style.isDefined(string)) {
            style2 = this.addStyle(null, style);
            style.addAttribute(string, style2);
        } else {
            style2 = (Style)style.getAttribute(string);
        }
        return style2;
    }

    static String colorToHex(Color color) {
        String string = new String("#");
        String string2 = Integer.toHexString(color.getRed());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? String.valueOf(string) + "0" + string2 : String.valueOf(string) + string2;
        }
        string2 = Integer.toHexString(color.getGreen());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? String.valueOf(string) + "0" + string2 : String.valueOf(string) + string2;
        }
        string2 = Integer.toHexString(color.getBlue());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? String.valueOf(string) + "0" + string2 : String.valueOf(string) + string2;
        }
        return string;
    }

    public Color getBackground(AttributeSet attributeSet) {
        ColorValue colorValue = (ColorValue)attributeSet.getAttribute(CSS.Attribute.BACKGROUND_COLOR);
        Color color = colorValue != null ? colorValue.getValue() : null;
        return color;
    }

    public BoxPainter getBoxPainter(AttributeSet attributeSet) {
        return new BoxPainter(attributeSet);
    }

    private CSS.Attribute getCssAlignAttribute(HTML.Tag tag, AttributeSet attributeSet) {
        return CSS.Attribute.TEXT_ALIGN;
    }

    private CSS.Attribute[] getCssAttribute(HTML.Attribute attribute) {
        return (CSS.Attribute[])htmlAttrToCssAttrMap.get(attribute);
    }

    private Object getCssValue(CSS.Attribute attribute, String string) {
        CssValue cssValue = (CssValue)this.valueConvertor.get(attribute);
        Object object = cssValue.parseHtmlValue(string);
        return object;
    }

    public AttributeSet getDeclaration(String string) {
        return null;
    }

    public Font getFont(AttributeSet attributeSet) {
        String string;
        FontFamily fontFamily;
        FontSize fontSize = (FontSize)attributeSet.getAttribute(CSS.Attribute.FONT_SIZE);
        int n = fontSize != null ? (int)fontSize.getValue(attributeSet) : 12;
        String string2 = (String)attributeSet.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
        if (string2 != null && (string2.indexOf("sup") >= 0 || string2.indexOf("sub") >= 0)) {
            n -= 2;
        }
        String string3 = (fontFamily = (FontFamily)attributeSet.getAttribute(CSS.Attribute.FONT_FAMILY)) != null ? fontFamily.getValue() : "SansSerif";
        int n2 = 0;
        FontWeight fontWeight = (FontWeight)attributeSet.getAttribute(CSS.Attribute.FONT_WEIGHT);
        if (fontWeight != null && fontWeight.getValue() > 400) {
            n2 |= 1;
        }
        if ((string = (String)attributeSet.getAttribute(CSS.Attribute.FONT_STYLE)) != null && string.equals("italic")) {
            n2 |= 2;
        }
        Font font = super.getFont(string3, n2, n);
        return font;
    }

    public Color getForeground(AttributeSet attributeSet) {
        ColorValue colorValue = (ColorValue)attributeSet.getAttribute(CSS.Attribute.COLOR);
        Color color = colorValue != null ? colorValue.getValue() : Color.black;
        return color;
    }

    private HTML.Tag getHTMLTag(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object instanceof HTML.Tag) {
            HTML.Tag tag = (HTML.Tag)object;
            return tag;
        }
        return null;
    }

    public static int getIndexOfSize(float f) {
        int n = 0;
        while (n < sizeMap.length) {
            if (f <= (float)sizeMap[n]) {
                return n;
            }
            ++n;
        }
        return sizeMap.length - 1;
    }

    public ListPainter getListPainter(AttributeSet attributeSet) {
        return new ListPainter(attributeSet);
    }

    public float getPointSize(int n) {
        if (n < 0) {
            return sizeMap[0];
        }
        if (n > sizeMap.length - 1) {
            return sizeMap[sizeMap.length - 1];
        }
        return sizeMap[n];
    }

    public float getPointSize(String string) {
        if (string != null) {
            if (string.startsWith("+")) {
                int n = Integer.valueOf(string.substring(1));
                return this.getPointSize(this.baseFontSize + n);
            }
            if (string.startsWith("-")) {
                int n = -Integer.valueOf(string.substring(1)).intValue();
                return this.getPointSize(this.baseFontSize + n);
            }
            int n = Integer.valueOf(string);
            return this.getPointSize(n);
        }
        return 0.0f;
    }

    public Style getRule(String string) {
        return null;
    }

    public Style getRule(HTML.Tag tag, Element element) {
        Style style;
        AttributeSet attributeSet;
        this.searchContext.removeAllElements();
        Element element2 = element.getParentElement();
        while (element2 != null) {
            attributeSet = element2.getAttributes();
            this.searchContext.addElement(attributeSet.getAttribute(StyleConstants.NameAttribute));
            element2 = element2.getParentElement();
        }
        attributeSet = this.selectors;
        int n = this.searchContext.size();
        int n2 = this.searchContext.size() - 1;
        while (n2 >= 0) {
            style = (Style)attributeSet.getAttribute(this.searchContext.elementAt(n2));
            if (style != null) {
                attributeSet = style;
            }
            --n2;
        }
        style = (Style)attributeSet.getAttribute(tag);
        if (style != null) {
            return (Style)style.getAttribute(RULE);
        }
        return null;
    }

    public AttributeSet getViewAttributes(View view) {
        return new ViewAttributeSet(view);
    }

    static final Color hexToColor(String string) {
        if (string.startsWith("#")) {
            String string2 = string.substring(1, Math.min(string.length(), 7));
            String string3 = "0x" + string2;
            Color color = Color.decode(string3);
            return color;
        }
        return null;
    }

    private boolean isFloater(String string) {
        return string.equals("left") || string.equals("right");
    }

    private boolean isHTMLFontTag(HTML.Tag tag) {
        return tag != null && (tag == HTML.Tag.FONT || tag == HTML.Tag.BASEFONT);
    }

    public void loadRules(Reader reader, URL uRL) throws IOException {
        if (this.parser == null) {
            this.parser = new CssParser();
        }
        this.parser.parse(reader);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.searchContext = new Vector();
        int n = objectInputStream.readInt();
        this.valueConvertor = new Hashtable(Math.max(1, n));
        while (n-- > 0) {
            Object object;
            Object object2 = objectInputStream.readObject();
            Object object3 = objectInputStream.readObject();
            Object object4 = StyleContext.getStaticAttribute(object2);
            if (object4 != null) {
                object2 = object4;
            }
            if ((object = StyleContext.getStaticAttribute(object3)) != null) {
                object3 = object;
            }
            if (object2 == null || object3 == null) continue;
            this.valueConvertor.put(object2, object3);
        }
    }

    public void setBaseFontSize(int n) {
        this.baseFontSize = n < 1 ? 0 : (n > 7 ? 7 : n);
    }

    public void setBaseFontSize(String string) {
        if (string != null) {
            if (string.startsWith("+")) {
                int n = Integer.valueOf(string.substring(1));
                this.setBaseFontSize(this.baseFontSize + n);
            } else if (string.startsWith("-")) {
                int n = -Integer.valueOf(string.substring(1)).intValue();
                this.setBaseFontSize(this.baseFontSize + n);
            } else {
                this.setBaseFontSize(Integer.valueOf(string));
            }
        }
    }

    public Color stringToColor(String string) {
        Color color = null;
        if (string.charAt(0) == '#') {
            color = StyleSheet.hexToColor(string);
        } else if (string.equalsIgnoreCase("Black")) {
            color = StyleSheet.hexToColor("#000000");
        } else if (string.equalsIgnoreCase("Silver")) {
            color = StyleSheet.hexToColor("#C0C0C0");
        } else if (string.equalsIgnoreCase("Gray")) {
            color = StyleSheet.hexToColor("#808080");
        } else if (string.equalsIgnoreCase("White")) {
            color = StyleSheet.hexToColor("#FFFFFF");
        } else if (string.equalsIgnoreCase("Maroon")) {
            color = StyleSheet.hexToColor("#800000");
        } else if (string.equalsIgnoreCase("Red")) {
            color = StyleSheet.hexToColor("#FF0000");
        } else if (string.equalsIgnoreCase("Purple")) {
            color = StyleSheet.hexToColor("#800080");
        } else if (string.equalsIgnoreCase("Fuchsia")) {
            color = StyleSheet.hexToColor("#FF00FF");
        } else if (string.equalsIgnoreCase("Green")) {
            color = StyleSheet.hexToColor("#008000");
        } else if (string.equalsIgnoreCase("Lime")) {
            color = StyleSheet.hexToColor("#00FF00");
        } else if (string.equalsIgnoreCase("Olive")) {
            color = StyleSheet.hexToColor("#808000");
        } else if (string.equalsIgnoreCase("Yellow")) {
            color = StyleSheet.hexToColor("#FFFF00");
        } else if (string.equalsIgnoreCase("Navy")) {
            color = StyleSheet.hexToColor("#000080");
        } else if (string.equalsIgnoreCase("Blue")) {
            color = StyleSheet.hexToColor("#0000FF");
        } else if (string.equalsIgnoreCase("Teal")) {
            color = StyleSheet.hexToColor("#008080");
        } else if (string.equalsIgnoreCase("Aqua")) {
            color = StyleSheet.hexToColor("#00FFFF");
        }
        return color;
    }

    void translateAttribute(HTML.Attribute attribute, AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        CSS.Attribute[] attributeArray = this.getCssAttribute(attribute);
        String string = (String)attributeSet.getAttribute(attribute);
        if (attributeArray == null || string == null) {
            return;
        }
        int n = 0;
        while (n < attributeArray.length) {
            Object object = this.getCssValue(attributeArray[n], string);
            if (object != null) {
                mutableAttributeSet.addAttribute(attributeArray[n], object);
            }
            ++n;
        }
    }

    private void translateAttributes(HTML.Tag tag, AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (!(object instanceof HTML.Attribute)) continue;
            HTML.Attribute attribute = (HTML.Attribute)object;
            if (attribute == HTML.Attribute.ALIGN) {
                Object object2;
                CSS.Attribute attribute2;
                String string = (String)attributeSet.getAttribute(HTML.Attribute.ALIGN);
                if (string == null || (attribute2 = this.getCssAlignAttribute(tag, attributeSet)) == null || (object2 = this.getCssValue(attribute2, string)) == null) continue;
                mutableAttributeSet.addAttribute(attribute2, object2);
                continue;
            }
            if (attribute == HTML.Attribute.SIZE && !this.isHTMLFontTag(tag)) continue;
            this.translateAttribute(attribute, attributeSet, mutableAttributeSet);
        }
    }

    private void translateEmbeddedAttributes(AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            HTML.Tag tag;
            Object object;
            Object object2 = enumeration.nextElement();
            if (!(object2 instanceof HTML.Tag) || (object = attributeSet.getAttribute(tag = (HTML.Tag)object2)) == null || !(object instanceof AttributeSet)) continue;
            this.translateAttributes(tag, (AttributeSet)object, mutableAttributeSet);
        }
    }

    public AttributeSet translateHTMLToCSS(AttributeSet attributeSet) {
        AttributeSet attributeSet2;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        Element element = (Element)((Object)attributeSet);
        HTML.Tag tag = this.getHTMLTag(attributeSet);
        if (tag == HTML.Tag.TD || tag == HTML.Tag.TH) {
            attributeSet2 = element.getParentElement().getParentElement().getAttributes();
            this.translateAttribute(HTML.Attribute.BORDER, attributeSet2, simpleAttributeSet);
        }
        if (element.isLeaf()) {
            this.translateEmbeddedAttributes(attributeSet, simpleAttributeSet);
        } else {
            this.translateAttributes(tag, attributeSet, simpleAttributeSet);
        }
        attributeSet2 = this.addStyle(null, null);
        attributeSet2.addAttributes(simpleAttributeSet);
        return attributeSet2;
    }

    private boolean validTextAlignValue(String string) {
        return this.isFloater(string) || string.equals("center");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Enumeration enumeration = this.valueConvertor.keys();
        objectOutputStream.writeInt(this.valueConvertor.size());
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                Object object2 = this.valueConvertor.get(object);
                if (!(object instanceof Serializable) && (object = StyleContext.getStaticAttributeKey(object)) == null) {
                    object = null;
                    object2 = null;
                } else if (!(object2 instanceof Serializable) && (object2 = StyleContext.getStaticAttributeKey(object2)) == null) {
                    object = null;
                    object2 = null;
                }
                objectOutputStream.writeObject(object);
                objectOutputStream.writeObject(object2);
            }
        }
    }

    public static class BoxPainter
    implements Serializable {
        Border border;
        Insets binsets;

        BoxPainter(AttributeSet attributeSet) {
            this.border = this.getBorder(attributeSet);
            this.binsets = this.border.getBorderInsets(null);
        }

        Border getBorder(AttributeSet attributeSet) {
            Border border = noBorder;
            Object object = attributeSet.getAttribute(CSS.Attribute.BORDER_STYLE);
            if (object != null) {
                String string = object.toString();
                int n = (int)this.getLength(CSS.Attribute.BORDER_WIDTH, attributeSet);
                if (n > 0) {
                    if (string.equals("inset")) {
                        Color color = this.getBorderColor(attributeSet);
                        border = new BevelBorder(1, color.brighter(), color.darker());
                    } else if (string.equals("outset")) {
                        Color color = this.getBorderColor(attributeSet);
                        border = new BevelBorder(0, color.brighter(), color.darker());
                    } else if (string.equals("solid")) {
                        Color color = this.getBorderColor(attributeSet);
                        border = new LineBorder(color);
                    }
                }
            }
            return border;
        }

        Color getBorderColor(AttributeSet attributeSet) {
            Object object = attributeSet.getAttribute(CSS.Attribute.BORDER_COLOR);
            if (object == null) {
                object = attributeSet.getAttribute(CSS.Attribute.COLOR);
            }
            if (object != null) {
                ColorValue colorValue = (ColorValue)object;
                return colorValue.getValue();
            }
            return Color.black;
        }

        public float getInset(int n, View view) {
            AttributeSet attributeSet = view.getAttributes();
            float f = 0.0f;
            switch (n) {
                case 2: {
                    f += this.getLength(CSS.Attribute.MARGIN_LEFT, attributeSet);
                    f += (float)this.binsets.left;
                    f += this.getLength(CSS.Attribute.PADDING_LEFT, attributeSet);
                    break;
                }
                case 4: {
                    f += this.getLength(CSS.Attribute.MARGIN_RIGHT, attributeSet);
                    f += (float)this.binsets.right;
                    f += this.getLength(CSS.Attribute.PADDING_RIGHT, attributeSet);
                    break;
                }
                case 1: {
                    f += this.getLength(CSS.Attribute.MARGIN_TOP, attributeSet);
                    f += (float)this.binsets.top;
                    f += this.getLength(CSS.Attribute.PADDING_TOP, attributeSet);
                    break;
                }
                case 3: {
                    f += this.getLength(CSS.Attribute.MARGIN_BOTTOM, attributeSet);
                    f += (float)this.binsets.bottom;
                    f += this.getLength(CSS.Attribute.PADDING_BOTTOM, attributeSet);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid side: " + n);
                }
            }
            return f;
        }

        float getLength(CSS.Attribute attribute, AttributeSet attributeSet) {
            LengthValue lengthValue = (LengthValue)attributeSet.getAttribute(attribute);
            float f = lengthValue != null ? lengthValue.getValue() : 0.0f;
            return f;
        }

        public void paint(Graphics graphics, float f, float f2, float f3, float f4, View view) {
            AttributeSet attributeSet = view.getAttributes();
            StyleSheet styleSheet = ((HTMLDocument)view.getDocument()).getStyleSheet();
            float f5 = this.getLength(CSS.Attribute.MARGIN_TOP, attributeSet);
            float f6 = this.getLength(CSS.Attribute.MARGIN_LEFT, attributeSet);
            f += f6;
            f2 += f5;
            f3 -= f6 + this.getLength(CSS.Attribute.MARGIN_RIGHT, attributeSet);
            f4 -= f5 + this.getLength(CSS.Attribute.MARGIN_BOTTOM, attributeSet);
            Color color = styleSheet.getBackground(attributeSet);
            if (color != null) {
                graphics.setColor(color);
                graphics.fillRect((int)f, (int)f2, (int)f3, (int)f4);
            }
            this.border.paintBorder(null, graphics, (int)f, (int)f2, (int)f3, (int)f4);
        }
    }

    public static class ListPainter
    implements Serializable {
        static final char[][] romanChars = new char[][]{{'i', 'v'}, {'x', 'l'}, {'c', 'd'}, {'m', '?'}};
        private String type;
        private int start = 1;
        URL imageurl;
        Icon img = null;
        private int bulletgap = 5;

        ListPainter(AttributeSet attributeSet) {
            String string;
            String string2 = (String)attributeSet.getAttribute(CSS.Attribute.LIST_STYLE_IMAGE);
            if (string2 == null) {
                string2 = (String)attributeSet.getAttribute(CSS.Attribute.LIST_STYLE);
            }
            if (string2 == null) {
                this.type = null;
            } else if (string2.equalsIgnoreCase("none")) {
                this.type = new String("none");
            } else {
                try {
                    string = null;
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, "()");
                    if (stringTokenizer.hasMoreTokens()) {
                        string = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string = stringTokenizer.nextToken();
                    }
                    URL uRL = new URL(string);
                    this.img = new ImageIcon(uRL);
                    this.type = new String("html-image");
                }
                catch (MalformedURLException malformedURLException) {
                    this.type = null;
                }
            }
            string = (String)attributeSet.getAttribute(CSS.Attribute.LIST_STYLE_TYPE);
            if (string == null) {
                string = new String("disc");
            }
        }

        void drawIcon(Graphics graphics, int n, int n2, int n3, float f, Component component) {
            graphics.setColor(Color.black);
            int n4 = n - this.img.getIconWidth() - this.bulletgap;
            int n5 = n2 + (int)((float)n3 * f) - 3;
            this.img.paintIcon(component, graphics, n4, n5);
        }

        void drawLetter(Graphics graphics, char c, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.black);
            String string = String.valueOf(this.formatItemNum(n4 + this.start, c)) + ".";
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = fontMetrics.stringWidth(string);
            int n6 = n - n5 - this.bulletgap;
            int n7 = n2 + fontMetrics.getAscent() + fontMetrics.getLeading();
            graphics.drawString(string, n6, n7);
        }

        void drawShape(Graphics graphics, String string, int n, int n2, int n3, float f) {
            graphics.setColor(Color.black);
            int n4 = n - this.bulletgap - 7;
            int n5 = n2 + (int)((float)n3 * f) - 3;
            if (string.equalsIgnoreCase("square")) {
                graphics.drawRect(n4, n5, 7, 7);
            } else if (string.equalsIgnoreCase("circle")) {
                graphics.drawOval(n4, n5, 7, 7);
            } else {
                graphics.fillOval(n4, n5, 7, 7);
            }
        }

        String formatAlphaNumerals(int n) {
            String string = "";
            string = n > 26 ? String.valueOf(this.formatAlphaNumerals(n / 26)) + this.formatAlphaNumerals(n % 26) : String.valueOf((char)(97 + n - 1));
            return string;
        }

        String formatItemNum(int n, char c) {
            String string;
            String string2 = "1";
            boolean bl = false;
            switch (c) {
                default: {
                    string = String.valueOf(n);
                    break;
                }
                case 'A': {
                    bl = true;
                }
                case 'a': {
                    string = this.formatAlphaNumerals(n);
                    break;
                }
                case 'I': {
                    bl = true;
                }
                case 'i': {
                    string = this.formatRomanNumerals(n);
                }
            }
            if (bl) {
                string = string.toUpperCase();
            }
            return string;
        }

        String formatRomanDigit(int n, int n2) {
            String string = "";
            if (n2 == 9) {
                string = String.valueOf(string) + romanChars[n][0];
                string = String.valueOf(string) + romanChars[n + 1][0];
                return string;
            }
            if (n2 == 4) {
                string = String.valueOf(string) + romanChars[n][0];
                string = String.valueOf(string) + romanChars[n][1];
                return string;
            }
            if (n2 >= 5) {
                string = String.valueOf(string) + romanChars[n][1];
                n2 -= 5;
            }
            int n3 = 0;
            while (n3 < n2) {
                string = String.valueOf(string) + romanChars[n][0];
                ++n3;
            }
            return string;
        }

        String formatRomanNumerals(int n) {
            return this.formatRomanNumerals(0, n);
        }

        String formatRomanNumerals(int n, int n2) {
            if (n2 < 10) {
                return this.formatRomanDigit(n, n2);
            }
            return String.valueOf(this.formatRomanNumerals(n + 1, n2 / 10)) + this.formatRomanDigit(n, n2 % 10);
        }

        private String getChildType(View view) {
            View view2 = view.getParent();
            AttributeSet attributeSet = view2.getElement().getAttributes();
            String string = (String)attributeSet.getAttribute(HTML.Attribute.TYPE);
            if (string == null) {
                HTMLDocument hTMLDocument;
                string = this.type == null ? ((hTMLDocument = (HTMLDocument)view2.getDocument()).matchNameAttribute(view2.getElement().getAttributes(), HTML.Tag.OL) ? "decimal" : "disc") : this.type;
            }
            return string;
        }

        public void paint(Graphics graphics, float f, float f2, float f3, float f4, View view, int n) {
            View view2 = view.getView(n);
            String string = this.getChildType(view2);
            float f5 = view2.getAlignment(1);
            if (string.equalsIgnoreCase("square")) {
                this.drawShape(graphics, string, (int)f, (int)f2, (int)f4, f5);
            } else if (string.equalsIgnoreCase("circle")) {
                this.drawShape(graphics, string, (int)f, (int)f2, (int)f4, f5);
            } else if (string.equalsIgnoreCase("1") || string.equalsIgnoreCase("decimal")) {
                this.drawLetter(graphics, '1', (int)f, (int)f2, (int)f4, n);
            } else if (string.equals("a") || string.equalsIgnoreCase("lower-alpha")) {
                this.drawLetter(graphics, 'a', (int)f, (int)f2, (int)f4, n);
            } else if (string.equals("A") || string.equalsIgnoreCase("upper-alpha")) {
                this.drawLetter(graphics, 'A', (int)f, (int)f2, (int)f4, n);
            } else if (string.equals("i") || string.equalsIgnoreCase("lower-roman")) {
                this.drawLetter(graphics, 'i', (int)f, (int)f2, (int)f4, n);
            } else if (string.equals("I") || string.equalsIgnoreCase("upper-roman")) {
                this.drawLetter(graphics, 'I', (int)f, (int)f2, (int)f4, n);
            } else if (string.equalsIgnoreCase("html-image")) {
                this.drawIcon(graphics, (int)f, (int)f2, (int)f4, f5, view.getContainer());
            } else if (!string.equals("none")) {
                this.drawShape(graphics, string, (int)f, (int)f2, (int)f4, f5);
            }
        }
    }

    class CssValue
    implements Serializable {
        String svalue;

        CssValue() {
        }

        Object parseCssValue(String string) {
            return string;
        }

        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }

        public String toString() {
            return this.svalue;
        }
    }

    class FontSize
    extends CssValue {
        float value;
        boolean relative;
        boolean index;
        boolean percentage;

        FontSize() {
        }

        float getValue(AttributeSet attributeSet) {
            if (this.index) {
                return StyleSheet.this.getPointSize((int)this.value);
            }
            return this.value;
        }

        boolean isRelative() {
            return this.relative;
        }

        Object parseCssValue(String string) {
            FontSize fontSize = new FontSize();
            fontSize.svalue = string;
            try {
                if (string.equals("xx-small")) {
                    fontSize.value = 0.0f;
                    fontSize.index = true;
                } else if (string.equals("x-small")) {
                    fontSize.value = 1.0f;
                    fontSize.index = true;
                } else if (string.equals("small")) {
                    fontSize.value = 2.0f;
                    fontSize.index = true;
                } else if (string.equals("medium")) {
                    fontSize.value = 3.0f;
                    fontSize.index = true;
                } else if (string.equals("large")) {
                    fontSize.value = 4.0f;
                    fontSize.index = true;
                } else if (string.equals("x-large")) {
                    fontSize.value = 5.0f;
                    fontSize.index = true;
                } else if (string.equals("xx-large")) {
                    fontSize.value = 6.0f;
                    fontSize.index = true;
                } else if (string.equals("bigger")) {
                    fontSize.value = 1.0f;
                    fontSize.index = true;
                    fontSize.relative = true;
                } else if (string.equals("smaller")) {
                    fontSize.value = -1.0f;
                    fontSize.index = true;
                    fontSize.relative = true;
                } else if (string.endsWith("pt")) {
                    String string2 = string.substring(0, string.length() - 2);
                    fontSize.value = Float.valueOf(string2).floatValue();
                } else {
                    fontSize.value = Float.valueOf(string).floatValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                fontSize = null;
            }
            return fontSize;
        }

        Object parseHtmlValue(String string) {
            FontSize fontSize = new FontSize();
            fontSize.svalue = string;
            try {
                if (string != null && string.charAt(0) == '+') {
                    int n = Integer.valueOf(string.substring(1));
                    fontSize.value = StyleSheet.this.baseFontSize + n;
                    fontSize.index = true;
                } else if (string != null && string.charAt(0) == '-') {
                    int n = -Integer.valueOf(string.substring(1)).intValue();
                    fontSize.value = StyleSheet.this.baseFontSize + n;
                    fontSize.index = true;
                } else {
                    fontSize.value = Integer.parseInt(string);
                    if (fontSize.value > 6.0f) {
                        fontSize.value = 6.0f;
                    } else if (fontSize.value < 0.0f) {
                        fontSize.value = 0.0f;
                    }
                    fontSize.index = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                fontSize = null;
            }
            return fontSize;
        }
    }

    class FontFamily
    extends CssValue {
        String family;

        FontFamily() {
        }

        String getValue() {
            return this.family;
        }

        Object parseCssValue(String string) {
            FontFamily fontFamily = new FontFamily();
            fontFamily.svalue = string;
            fontFamily.family = string;
            return fontFamily;
        }

        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }
    }

    class FontWeight
    extends CssValue {
        int weight;

        FontWeight() {
        }

        int getValue() {
            return this.weight;
        }

        Object parseCssValue(String string) {
            FontWeight fontWeight = new FontWeight();
            fontWeight.svalue = string;
            if (string.equals("bold")) {
                fontWeight.weight = 700;
            } else if (string.equals("normal")) {
                fontWeight.weight = 400;
            } else {
                try {
                    fontWeight.weight = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    fontWeight = null;
                }
            }
            return fontWeight;
        }
    }

    class ColorValue
    extends CssValue {
        Color c;

        ColorValue() {
        }

        Color getValue() {
            return this.c;
        }

        Object parseCssValue(String string) {
            Color color = StyleSheet.this.stringToColor(string);
            if (color != null) {
                ColorValue colorValue = new ColorValue();
                colorValue.svalue = string;
                colorValue.c = color;
                return colorValue;
            }
            return null;
        }

        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }
    }

    class BorderStyle
    extends CssValue {
        private transient CSS.Value style;

        BorderStyle() {
        }

        CSS.Value getValue() {
            return this.style;
        }

        Object parseCssValue(String string) {
            CSS.Value value = CSS.getValue(string);
            if (value != null && (value == CSS.Value.INSET || value == CSS.Value.OUTSET || value == CSS.Value.NONE || value == CSS.Value.DOTTED || value == CSS.Value.DASHED || value == CSS.Value.SOLID || value == CSS.Value.DOUBLE || value == CSS.Value.GROOVE || value == CSS.Value.RIDGE)) {
                BorderStyle borderStyle = new BorderStyle();
                borderStyle.svalue = string;
                borderStyle.style = value;
                return borderStyle;
            }
            return null;
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            Object object = objectInputStream.readObject();
            if (object != null) {
                this.style = CSS.getValue((String)object);
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            if (this.style == null) {
                objectOutputStream.writeObject(null);
            } else {
                objectOutputStream.writeObject(this.style.toString());
            }
        }
    }

    class LengthValue
    extends CssValue {
        float span;

        LengthValue() {
        }

        float getValue() {
            return this.span;
        }

        Object parseCssValue(String string) {
            LengthValue lengthValue = new LengthValue();
            try {
                if (string.endsWith("pt")) {
                    String string2 = string.substring(0, string.length() - 2);
                    lengthValue.span = Float.valueOf(string2).floatValue();
                } else {
                    lengthValue.span = Float.valueOf(string).floatValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                lengthValue = null;
            }
            return lengthValue;
        }

        Object parseHtmlValue(String string) {
            if (string.equals("#DEFAULT")) {
                string = "1";
            }
            return this.parseCssValue(string);
        }
    }

    static class ViewAttributeSet
    implements AttributeSet {
        static Vector muxList = new Vector();
        AttributeSet[] attrs;
        View host;

        ViewAttributeSet(View view) {
            this.host = view;
            Document document = view.getDocument();
            if (document instanceof HTMLDocument) {
                StyleSheet styleSheet = ((HTMLDocument)document).getStyleSheet();
                Element element = view.getElement();
                AttributeSet attributeSet = element.getAttributes();
                muxList.removeAllElements();
                AttributeSet attributeSet2 = styleSheet.translateHTMLToCSS(attributeSet);
                if (attributeSet2.getAttributeCount() != 0) {
                    muxList.addElement(attributeSet2);
                }
                if (element.isLeaf()) {
                    Enumeration enumeration = attributeSet.getAttributeNames();
                    while (enumeration.hasMoreElements()) {
                        AttributeSet attributeSet3;
                        Object object;
                        Object object2 = enumeration.nextElement();
                        if (!(object2 instanceof HTML.Tag) || (HTML.Tag)object2 == HTML.Tag.A && (object = attributeSet.getAttribute((HTML.Tag)object2)) != null && object instanceof AttributeSet && (attributeSet3 = (AttributeSet)object).getAttribute(HTML.Attribute.HREF) == null || (object = styleSheet.getRule((HTML.Tag)object2, element)) == null) continue;
                        muxList.addElement(object);
                    }
                } else {
                    Style style;
                    HTML.Tag tag = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute);
                    if (tag == HTML.Tag.IMPLIED) {
                        tag = HTML.Tag.P;
                    }
                    if ((style = styleSheet.getRule(tag, element)) != null) {
                        muxList.addElement(style);
                    }
                }
            }
            this.attrs = new AttributeSet[muxList.size()];
            muxList.copyInto(this.attrs);
        }

        public boolean containsAttribute(Object object, Object object2) {
            return object2.equals(this.getAttribute(object));
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            boolean bl = true;
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (bl && enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                bl = attributeSet.getAttribute(object).equals(this.getAttribute(object));
            }
            return bl;
        }

        public AttributeSet copyAttributes() {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            boolean bl = false;
            int n = 0;
            while (n < this.attrs.length) {
                simpleAttributeSet.addAttributes(this.attrs[n]);
                ++n;
            }
            return simpleAttributeSet;
        }

        public Object getAttribute(Object object) {
            AttributeSet attributeSet;
            Object object2;
            int n = this.attrs.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = this.attrs[n2].getAttribute(object);
                if (object2 != null) {
                    return object2;
                }
                ++n2;
            }
            if (object instanceof CSS.Attribute && ((CSS.Attribute)(object2 = (CSS.Attribute)object)).isInherited() && (attributeSet = this.getResolveParent()) != null) {
                return attributeSet.getAttribute(object);
            }
            return null;
        }

        public int getAttributeCount() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.attrs.length) {
                n += this.attrs[n2].getAttributeCount();
                ++n2;
            }
            return n;
        }

        public Enumeration getAttributeNames() {
            return null;
        }

        public AttributeSet getResolveParent() {
            View view = this.host.getParent();
            String string = view != null ? view.getElement().getName() : "*none*";
            return view != null ? view.getAttributes() : null;
        }

        public boolean isDefined(Object object) {
            boolean bl = false;
            int n = 0;
            while (n < this.attrs.length) {
                if (this.attrs[n].isDefined(object)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public boolean isEqual(AttributeSet attributeSet) {
            return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
        }
    }

    static class SheetAttribute {
        private boolean cache;
        private String name;

        SheetAttribute(String string, boolean bl) {
            this.name = string;
            this.cache = bl;
        }

        public boolean isCache() {
            return this.cache;
        }

        public String toString() {
            return this.name;
        }
    }

    class CssParser
    implements Serializable {
        Vector selectors = new Vector();
        Vector selectorTokens = new Vector();
        String key;
        Vector ruleTokens = new Vector();
        MutableAttributeSet declaration = new SimpleAttributeSet();

        CssParser() {
        }

        void addKeyValueToDeclaration() {
            Object object;
            CSS.Attribute attribute = CSS.getAttribute(this.key);
            if (attribute != null && (object = this.getValue(attribute)) != null) {
                this.declaration.addAttribute(attribute, object);
            }
            this.ruleTokens.removeAllElements();
        }

        void addRule() {
            int n = this.selectors.size();
            int n2 = 0;
            while (n2 < n) {
                String[] stringArray = (String[])this.selectors.elementAt(n2);
                if (stringArray.length > 0) {
                    StyleSheet.this.addRule(stringArray, this.declaration);
                }
                ++n2;
            }
            this.declaration.removeAttributes(this.declaration);
            this.selectors.removeAllElements();
        }

        void addSelector() {
            Object[] objectArray = new String[this.selectorTokens.size()];
            this.selectorTokens.copyInto(objectArray);
            this.selectors.addElement(objectArray);
            this.selectorTokens.removeAllElements();
        }

        String getDeclarationString() {
            String string = "";
            int n = this.ruleTokens.size();
            int n2 = 0;
            while (n2 < n) {
                string = String.valueOf(string) + this.ruleTokens.elementAt(n2);
                ++n2;
            }
            this.ruleTokens.removeAllElements();
            return string;
        }

        Object getValue(CSS.Attribute attribute) {
            CssValue cssValue = (CssValue)StyleSheet.this.valueConvertor.get(attribute);
            String string = this.getDeclarationString();
            return cssValue.parseCssValue(string);
        }

        void parse(Reader reader) throws IOException {
            StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
            streamTokenizer.ordinaryChar(47);
            streamTokenizer.slashStarComments(true);
            boolean bl = false;
            int n = streamTokenizer.nextToken();
            while (n != -1) {
                block0 : switch (n) {
                    case -3: {
                        if (bl) {
                            this.ruleTokens.addElement(streamTokenizer.sval);
                            break;
                        }
                        this.selectorTokens.addElement(streamTokenizer.sval);
                        break;
                    }
                    case -2: {
                        if (bl) {
                            this.ruleTokens.addElement(new Integer((int)streamTokenizer.nval));
                            break;
                        }
                        String string = (String)this.selectorTokens.lastElement();
                        string = String.valueOf(string) + (int)streamTokenizer.nval;
                        this.selectorTokens.setElementAt(string, this.selectorTokens.size() - 1);
                        break;
                    }
                    default: {
                        switch (streamTokenizer.ttype) {
                            case 123: {
                                this.addSelector();
                                bl = true;
                                break block0;
                            }
                            case 125: {
                                this.addKeyValueToDeclaration();
                                this.addRule();
                                bl = false;
                                break block0;
                            }
                            case 59: {
                                this.addKeyValueToDeclaration();
                                break block0;
                            }
                            case 58: {
                                this.key = this.getDeclarationString();
                                break block0;
                            }
                            case 44: {
                                if (bl) {
                                    this.ruleTokens.addElement(new Character(','));
                                    break block0;
                                }
                                this.addSelector();
                                break block0;
                            }
                        }
                        if (bl) {
                            this.ruleTokens.addElement(new Character(','));
                            break;
                        }
                        String string = (String)this.selectorTokens.lastElement();
                        string = String.valueOf(string) + (char)streamTokenizer.ttype;
                        this.selectorTokens.setElementAt(string, this.selectorTokens.size() - 1);
                    }
                    case 10: 
                }
                n = streamTokenizer.nextToken();
            }
        }
    }
}

