/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.Option;
import javax.swing.text.html.OptionComboBoxModel;
import javax.swing.text.html.OptionListModel;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.TextAreaDocument;

public class HTMLDocument
extends DefaultStyledDocument {
    private boolean frameDocument = false;
    private boolean preservesUnknownTags = true;
    private ButtonGroup radioButtonGroup;
    static final String TokenThreshold = "token threshold";
    public static final String AdditionalComments = "AdditionalComments";
    URL base;
    private static AttributeSet contentAttributeSet = new SimpleAttributeSet();
    private static char[] NEWLINE;

    static {
        ((MutableAttributeSet)contentAttributeSet).addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
        NEWLINE = new char[1];
        HTMLDocument.NEWLINE[0] = 10;
    }

    public HTMLDocument() {
        this((AbstractDocument.Content)new GapContent(4096), new StyleSheet());
    }

    public HTMLDocument(AbstractDocument.Content content, StyleSheet styleSheet) {
        super(content, styleSheet);
    }

    public HTMLDocument(StyleSheet styleSheet) {
        this((AbstractDocument.Content)new GapContent(4096), styleSheet);
    }

    private void ampersand(StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append('&');
        }
    }

    private void appendBuffer(StringBuffer stringBuffer, String string, String string2) {
        this.ampersand(stringBuffer);
        String string3 = URLEncoder.encode(string);
        stringBuffer.append(string3);
        stringBuffer.append('=');
        String string4 = URLEncoder.encode(string2);
        stringBuffer.append(string4);
    }

    protected void create(DefaultStyledDocument.ElementSpec[] elementSpecArray) {
        super.create(elementSpecArray);
    }

    protected Element createBranchElement(Element element, AttributeSet attributeSet) {
        return new BlockElement(element, attributeSet);
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        this.writeLock();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.HTML);
        BlockElement blockElement = new BlockElement(null, simpleAttributeSet.copyAttributes());
        simpleAttributeSet.removeAttributes(simpleAttributeSet);
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.BODY);
        BlockElement blockElement2 = new BlockElement((Element)blockElement, simpleAttributeSet.copyAttributes());
        simpleAttributeSet.removeAttributes(simpleAttributeSet);
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.P);
        BlockElement blockElement3 = new BlockElement((Element)blockElement2, simpleAttributeSet.copyAttributes());
        simpleAttributeSet.removeAttributes(simpleAttributeSet);
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
        RunElement runElement = new RunElement((Element)blockElement3, (AttributeSet)simpleAttributeSet, 0, 1);
        Element[] elementArray = new Element[]{runElement};
        blockElement3.replace(0, 0, elementArray);
        elementArray[0] = blockElement3;
        blockElement2.replace(0, 0, elementArray);
        elementArray[0] = blockElement2;
        blockElement.replace(0, 0, elementArray);
        this.writeUnlock();
        return blockElement;
    }

    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
        return new RunElement(element, attributeSet, n, n2);
    }

    private Element findFrame(String string) {
        ElementIterator elementIterator = new ElementIterator(this);
        Element element = null;
        while ((element = elementIterator.next()) != null) {
            String string2;
            AttributeSet attributeSet = element.getAttributes();
            if (this.matchNameAttribute(attributeSet, HTML.Tag.FRAME) && (string2 = (String)attributeSet.getAttribute(HTML.Attribute.NAME)).equals(string)) break;
        }
        return element;
    }

    private boolean formMatchesSubmissionRequest(AttributeSet attributeSet, AttributeSet attributeSet2) {
        AttributeSet attributeSet3 = this.getFormAttributes(attributeSet);
        if (attributeSet3 != null) {
            return attributeSet2.isEqual(attributeSet3);
        }
        return false;
    }

    public URL getBase() {
        return this.base;
    }

    AttributeSet getFormAttributes(AttributeSet attributeSet) {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            HTML.Tag tag;
            Object object2 = enumeration.nextElement();
            if (!(object2 instanceof HTML.Tag) || (tag = (HTML.Tag)object2) != HTML.Tag.FORM || (object = attributeSet.getAttribute(tag)) == null || !(object instanceof AttributeSet)) continue;
            return (AttributeSet)object;
        }
        return null;
    }

    void getFormData(StringBuffer stringBuffer, Element element) {
        Element element2;
        AttributeSet attributeSet = element.getAttributes();
        AttributeSet attributeSet2 = this.getFormAttributes(attributeSet);
        ElementIterator elementIterator = new ElementIterator(this.getDefaultRootElement());
        if (attributeSet2 == null) {
            return;
        }
        boolean bl = false;
        while ((element2 = elementIterator.next()) != null) {
            AttributeSet attributeSet3 = element2.getAttributes();
            if (this.formMatchesSubmissionRequest(attributeSet3, attributeSet2)) {
                bl = true;
                String string = (String)attributeSet3.getAttribute(HTML.Attribute.TYPE);
                if (string != null && string.equals("submit") && element2 != element || string != null && string.equals("image")) continue;
                this.loadElementDataIntoBuffer(element2, stringBuffer);
                continue;
            }
            if (bl && element2.isLeaf()) break;
        }
    }

    private String getInputElementData(AttributeSet attributeSet) {
        ButtonModel buttonModel;
        Object object = attributeSet.getAttribute(StyleConstants.ModelAttribute);
        String string = (String)attributeSet.getAttribute(HTML.Attribute.TYPE);
        String string2 = null;
        if (string.equals("text") || string.equals("password")) {
            Document document = (Document)object;
            try {
                string2 = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                string2 = null;
            }
        } else if (string.equals("submit") || string.equals("hidden")) {
            string2 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE);
            if (string2 == null) {
                string2 = "";
            }
        } else if ((string.equals("radio") || string.equals("checkbox")) && (buttonModel = (ButtonModel)object).isSelected() && (string2 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE)) == null) {
            string2 = "on";
        }
        return string2;
    }

    public Iterator getIterator(HTML.Tag tag) {
        if (tag.isBlock()) {
            return null;
        }
        return new LeafIterator(tag, this);
    }

    public boolean getPreservesUnknownTags() {
        return this.preservesUnknownTags;
    }

    public HTMLEditorKit.ParserCallback getReader(int n) {
        Object object = this.getProperty("stream");
        if (object instanceof URL) {
            this.base = (URL)object;
        }
        HTMLReader hTMLReader = new HTMLReader(n);
        return hTMLReader;
    }

    public HTMLEditorKit.ParserCallback getReader(int n, int n2, int n3, HTML.Tag tag) {
        Object object = this.getProperty("stream");
        if (object instanceof URL) {
            this.base = (URL)object;
        }
        HTMLReader hTMLReader = new HTMLReader(n, n2, n3, tag);
        return hTMLReader;
    }

    public StyleSheet getStyleSheet() {
        return (StyleSheet)this.getAttributeContext();
    }

    private String getTextAreaData(AttributeSet attributeSet) {
        Document document = (Document)attributeSet.getAttribute(StyleConstants.ModelAttribute);
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public int getTokenThreshold() {
        Integer n = (Integer)this.getProperty(TokenThreshold);
        if (n != null) {
            return n;
        }
        return Integer.MAX_VALUE;
    }

    protected void insert(int n, DefaultStyledDocument.ElementSpec[] elementSpecArray) throws BadLocationException {
        super.insert(n, elementSpecArray);
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        if (attributeSet == null) {
            attributeSet = contentAttributeSet;
        } else if (attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
            ((MutableAttributeSet)attributeSet).addAttributes(contentAttributeSet);
        }
        super.insertUpdate(defaultDocumentEvent, attributeSet);
    }

    boolean isFrameDocument() {
        return this.frameDocument;
    }

    boolean isLastTextOrPasswordField(Element element) {
        Element element2;
        ElementIterator elementIterator = new ElementIterator(this.getDefaultRootElement());
        boolean bl = false;
        AttributeSet attributeSet = this.getFormAttributes(element.getAttributes());
        while ((element2 = elementIterator.next()) != null) {
            AttributeSet attributeSet2 = element2.getAttributes();
            if (this.formMatchesSubmissionRequest(attributeSet2, attributeSet)) {
                String string;
                if (bl && this.matchNameAttribute(attributeSet2, HTML.Tag.INPUT) && ((string = (String)attributeSet2.getAttribute(HTML.Attribute.TYPE)).equals("text") || string.equals("password"))) {
                    return false;
                }
                if (element2 != element) continue;
                bl = true;
                continue;
            }
            if (bl && element2.isLeaf()) break;
        }
        return true;
    }

    private void loadElementDataIntoBuffer(Element element, StringBuffer stringBuffer) {
        AttributeSet attributeSet = element.getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
        if (string == null) {
            return;
        }
        String string2 = null;
        HTML.Tag tag = (HTML.Tag)element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (tag == HTML.Tag.INPUT) {
            string2 = this.getInputElementData(attributeSet);
        } else if (tag == HTML.Tag.TEXTAREA) {
            string2 = this.getTextAreaData(attributeSet);
        } else if (tag == HTML.Tag.SELECT) {
            this.loadSelectData(attributeSet, stringBuffer);
        }
        if (string != null && string2 != null) {
            this.appendBuffer(stringBuffer, string, string2);
        }
    }

    private void loadSelectData(AttributeSet attributeSet, StringBuffer stringBuffer) {
        ComboBoxModel comboBoxModel;
        Option option;
        String string = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
        if (string == null) {
            return;
        }
        Object object = attributeSet.getAttribute(StyleConstants.ModelAttribute);
        if (object instanceof OptionListModel) {
            OptionListModel optionListModel = (OptionListModel)object;
            int n = 0;
            while (n < optionListModel.getSize()) {
                if (optionListModel.isSelectedIndex(n)) {
                    Option option2 = (Option)optionListModel.getElementAt(n);
                    this.appendBuffer(stringBuffer, string, option2.getValue());
                }
                ++n;
            }
        } else if (object instanceof ComboBoxModel && (option = (Option)(comboBoxModel = (ComboBoxModel)object).getSelectedItem()) != null) {
            this.appendBuffer(stringBuffer, string, option.getValue());
        }
    }

    boolean matchNameAttribute(AttributeSet attributeSet, HTML.Tag tag) {
        HTML.Tag tag2;
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        return object instanceof HTML.Tag && (tag2 = (HTML.Tag)object) == tag;
    }

    public void processHTMLFrameHyperlinkEvent(HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent) {
        String string = hTMLFrameHyperlinkEvent.getTarget();
        Element element = hTMLFrameHyperlinkEvent.getSourceElement();
        String string2 = hTMLFrameHyperlinkEvent.getURL().toString();
        if (string.equals("_self")) {
            this.updateFrame(element, string2);
        } else if (string.equals("_parent")) {
            this.updateFrameSet(element.getParentElement(), string2);
        } else {
            Element element2 = this.findFrame(string);
            if (element2 != null) {
                this.updateFrame(element2, string2);
            }
        }
    }

    void resetForm(Element element) {
        Element element2;
        ElementIterator elementIterator = new ElementIterator(this.getDefaultRootElement());
        boolean bl = false;
        AttributeSet attributeSet = this.getFormAttributes(element.getAttributes());
        while ((element2 = elementIterator.next()) != null) {
            AttributeSet attributeSet2 = element2.getAttributes();
            if (this.formMatchesSubmissionRequest(attributeSet2, attributeSet)) {
                Object object;
                Object object2 = attributeSet2.getAttribute(StyleConstants.ModelAttribute);
                if (object2 instanceof TextAreaDocument) {
                    TextAreaDocument textAreaDocument = (TextAreaDocument)object2;
                    textAreaDocument.reset();
                } else if (object2 instanceof PlainDocument) {
                    try {
                        PlainDocument plainDocument = (PlainDocument)object2;
                        plainDocument.remove(0, plainDocument.getLength());
                        if (this.matchNameAttribute(attributeSet2, HTML.Tag.INPUT) && (object = (String)attributeSet2.getAttribute(HTML.Attribute.VALUE)) != null) {
                            plainDocument.insertString(0, (String)object, null);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                } else if (object2 instanceof OptionListModel) {
                    OptionListModel optionListModel = (OptionListModel)object2;
                    int n = optionListModel.getSize();
                    int n2 = 0;
                    while (n2 < n) {
                        optionListModel.removeIndexInterval(n2, n2);
                        ++n2;
                    }
                    BitSet bitSet = optionListModel.getInitialSelection();
                    int n3 = 0;
                    while (n3 < bitSet.size()) {
                        if (bitSet.get(n3)) {
                            optionListModel.addSelectionInterval(n3, n3);
                        }
                        ++n3;
                    }
                } else if (object2 instanceof OptionComboBoxModel) {
                    OptionComboBoxModel optionComboBoxModel = (OptionComboBoxModel)object2;
                    object = optionComboBoxModel.getInitialSelection();
                    if (object != null) {
                        optionComboBoxModel.setSelectedItem(object);
                    }
                } else if (object2 instanceof JToggleButton.ToggleButtonModel) {
                    boolean bl2 = (String)attributeSet2.getAttribute(HTML.Attribute.CHECKED) != null;
                    object = (JToggleButton.ToggleButtonModel)object2;
                    ((JToggleButton.ToggleButtonModel)object).setSelected(bl2);
                }
                bl = true;
                continue;
            }
            if (bl && element2.isLeaf()) break;
        }
    }

    public void setBase(URL uRL) {
        this.base = uRL;
    }

    void setFrameDocumentState(boolean bl) {
        this.frameDocument = bl;
    }

    public void setPreservesUnknownTags(boolean bl) {
        this.preservesUnknownTags = bl;
    }

    public void setTokenThreshold(int n) {
        this.putProperty(TokenThreshold, new Integer(n));
    }

    private void updateFrame(Element element, String string) {
        try {
            this.writeLock();
            HTMLDocument hTMLDocument = this;
            hTMLDocument.getClass();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(hTMLDocument, element.getStartOffset(), 1, DocumentEvent.EventType.CHANGE);
            AttributeSet attributeSet = element.getAttributes().copyAttributes();
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
            defaultDocumentEvent.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(element, attributeSet, false));
            mutableAttributeSet.removeAttribute(HTML.Attribute.SRC);
            mutableAttributeSet.addAttribute(HTML.Attribute.SRC, string);
            defaultDocumentEvent.end();
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        finally {
            Object var4_6 = null;
            this.writeUnlock();
        }
    }

    private void updateFrameSet(Element element, String string) {
        try {
            int n = element.getStartOffset();
            int n2 = element.getEndOffset();
            this.remove(n, n2 - n);
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(HTML.Attribute.SRC, string);
            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.FRAME);
            this.insertString(n, " ", simpleAttributeSet);
        }
        catch (BadLocationException badLocationException) {}
    }

    public static abstract class Iterator {
        public abstract AttributeSet getAttributes();

        public abstract int getEndOffset();

        public abstract int getStartOffset();

        public abstract HTML.Tag getTag();

        public abstract boolean isValid();

        public abstract void next();
    }

    static class LeafIterator
    extends Iterator {
        private int endOffset;
        private HTML.Tag tag;
        private ElementIterator pos;

        LeafIterator(HTML.Tag tag, Document document) {
            this.tag = tag;
            this.pos = new ElementIterator(document);
            this.endOffset = 0;
            this.next();
        }

        public AttributeSet getAttributes() {
            Element element = this.pos.current();
            if (element != null) {
                AttributeSet attributeSet = (AttributeSet)element.getAttributes().getAttribute(this.tag);
                return attributeSet;
            }
            return null;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getStartOffset() {
            Element element = this.pos.current();
            if (element != null) {
                return element.getStartOffset();
            }
            return -1;
        }

        public HTML.Tag getTag() {
            return this.tag;
        }

        public boolean isValid() {
            return this.pos.current() != null;
        }

        public void next() {
            this.nextLeaf(this.pos);
            while (this.isValid()) {
                AttributeSet attributeSet;
                Element element = this.pos.current();
                if (element.getStartOffset() >= this.endOffset && (attributeSet = this.pos.current().getAttributes()).isDefined(this.tag)) {
                    this.setEndOffset();
                    break;
                }
                this.nextLeaf(this.pos);
            }
        }

        void nextLeaf(ElementIterator elementIterator) {
            elementIterator.next();
            while (elementIterator.current() != null) {
                Element element = elementIterator.current();
                if (element.isLeaf()) break;
                elementIterator.next();
            }
        }

        void setEndOffset() {
            AttributeSet attributeSet = this.getAttributes();
            this.endOffset = this.pos.current().getEndOffset();
            ElementIterator elementIterator = (ElementIterator)this.pos.clone();
            this.nextLeaf(elementIterator);
            while (elementIterator.current() != null) {
                Element element = elementIterator.current();
                AttributeSet attributeSet2 = (AttributeSet)element.getAttributes().getAttribute(this.tag);
                if (attributeSet2 == null || !attributeSet2.equals(attributeSet)) break;
                this.endOffset = element.getEndOffset();
                this.nextLeaf(elementIterator);
            }
        }
    }

    public class HTMLReader
    extends HTMLEditorKit.ParserCallback {
        int threshold;
        int offset;
        int tableCount;
        boolean inParagraph = false;
        boolean impliedP = false;
        boolean inPre = false;
        boolean inTextArea = false;
        TextAreaDocument textAreaDocument = null;
        boolean inTitle = false;
        boolean lastWasNewline = true;
        boolean emptyAnchor;
        HTML.Tag insertTag;
        boolean foundInsertTag;
        int popDepth;
        int pushDepth;
        Option option;
        protected Vector parseBuffer = new Vector();
        protected MutableAttributeSet charAttr = new SimpleAttributeSet();
        Stack charAttrStack = new Stack();
        Hashtable tagMap;
        int inBlock = 0;

        public HTMLReader(int n) {
            this(n, 0, 0, null);
        }

        public HTMLReader(int n, int n2, int n3, HTML.Tag tag) {
            this.offset = n;
            this.tableCount = 0;
            this.threshold = HTMLDocument.this.getTokenThreshold();
            this.tagMap = new Hashtable(57);
            TagAction tagAction = new TagAction();
            BlockAction blockAction = new BlockAction();
            ParagraphAction paragraphAction = new ParagraphAction();
            CharacterAction characterAction = new CharacterAction();
            SpecialAction specialAction = new SpecialAction();
            FormAction formAction = new FormAction();
            HiddenAction hiddenAction = new HiddenAction();
            this.tagMap.put(HTML.Tag.A, new AnchorAction());
            this.tagMap.put(HTML.Tag.ADDRESS, characterAction);
            this.tagMap.put(HTML.Tag.APPLET, hiddenAction);
            this.tagMap.put(HTML.Tag.AREA, hiddenAction);
            this.tagMap.put(HTML.Tag.B, characterAction);
            this.tagMap.put(HTML.Tag.BASE, new BaseAction());
            this.tagMap.put(HTML.Tag.BASEFONT, characterAction);
            this.tagMap.put(HTML.Tag.BIG, characterAction);
            this.tagMap.put(HTML.Tag.BLOCKQUOTE, blockAction);
            this.tagMap.put(HTML.Tag.BODY, blockAction);
            this.tagMap.put(HTML.Tag.BR, specialAction);
            this.tagMap.put(HTML.Tag.CAPTION, blockAction);
            this.tagMap.put(HTML.Tag.CENTER, blockAction);
            this.tagMap.put(HTML.Tag.CITE, characterAction);
            this.tagMap.put(HTML.Tag.CODE, characterAction);
            this.tagMap.put(HTML.Tag.DD, blockAction);
            this.tagMap.put(HTML.Tag.DFN, characterAction);
            this.tagMap.put(HTML.Tag.DIR, blockAction);
            this.tagMap.put(HTML.Tag.DIV, blockAction);
            this.tagMap.put(HTML.Tag.DL, blockAction);
            this.tagMap.put(HTML.Tag.DT, paragraphAction);
            this.tagMap.put(HTML.Tag.EM, characterAction);
            this.tagMap.put(HTML.Tag.FONT, characterAction);
            this.tagMap.put(HTML.Tag.FORM, characterAction);
            this.tagMap.put(HTML.Tag.FRAME, specialAction);
            this.tagMap.put(HTML.Tag.FRAMESET, blockAction);
            this.tagMap.put(HTML.Tag.H1, paragraphAction);
            this.tagMap.put(HTML.Tag.H2, paragraphAction);
            this.tagMap.put(HTML.Tag.H3, paragraphAction);
            this.tagMap.put(HTML.Tag.H4, paragraphAction);
            this.tagMap.put(HTML.Tag.H5, paragraphAction);
            this.tagMap.put(HTML.Tag.H6, paragraphAction);
            this.tagMap.put(HTML.Tag.HEAD, hiddenAction);
            this.tagMap.put(HTML.Tag.HR, specialAction);
            this.tagMap.put(HTML.Tag.HTML, blockAction);
            this.tagMap.put(HTML.Tag.I, characterAction);
            this.tagMap.put(HTML.Tag.IMG, specialAction);
            this.tagMap.put(HTML.Tag.INPUT, formAction);
            this.tagMap.put(HTML.Tag.ISINDEX, new IsindexAction());
            this.tagMap.put(HTML.Tag.KBD, characterAction);
            this.tagMap.put(HTML.Tag.LI, blockAction);
            this.tagMap.put(HTML.Tag.LINK, hiddenAction);
            this.tagMap.put(HTML.Tag.MAP, hiddenAction);
            this.tagMap.put(HTML.Tag.MENU, blockAction);
            this.tagMap.put(HTML.Tag.META, hiddenAction);
            this.tagMap.put(HTML.Tag.NOFRAMES, blockAction);
            this.tagMap.put(HTML.Tag.OBJECT, specialAction);
            this.tagMap.put(HTML.Tag.OL, blockAction);
            this.tagMap.put(HTML.Tag.OPTION, formAction);
            this.tagMap.put(HTML.Tag.P, paragraphAction);
            this.tagMap.put(HTML.Tag.PARAM, new ObjectAction());
            this.tagMap.put(HTML.Tag.PRE, new PreAction());
            this.tagMap.put(HTML.Tag.SAMP, characterAction);
            this.tagMap.put(HTML.Tag.SCRIPT, hiddenAction);
            this.tagMap.put(HTML.Tag.SELECT, formAction);
            this.tagMap.put(HTML.Tag.SMALL, characterAction);
            this.tagMap.put(HTML.Tag.STRIKE, characterAction);
            this.tagMap.put(HTML.Tag.S, characterAction);
            this.tagMap.put(HTML.Tag.STRONG, characterAction);
            this.tagMap.put(HTML.Tag.STYLE, hiddenAction);
            this.tagMap.put(HTML.Tag.SUB, characterAction);
            this.tagMap.put(HTML.Tag.SUP, characterAction);
            this.tagMap.put(HTML.Tag.TABLE, blockAction);
            this.tagMap.put(HTML.Tag.TD, blockAction);
            this.tagMap.put(HTML.Tag.TEXTAREA, formAction);
            this.tagMap.put(HTML.Tag.TH, blockAction);
            this.tagMap.put(HTML.Tag.TITLE, new TitleAction());
            this.tagMap.put(HTML.Tag.TR, blockAction);
            this.tagMap.put(HTML.Tag.TT, characterAction);
            this.tagMap.put(HTML.Tag.U, characterAction);
            this.tagMap.put(HTML.Tag.UL, blockAction);
            this.tagMap.put(HTML.Tag.VAR, characterAction);
            HTMLDocument.this.putProperty(HTMLDocument.AdditionalComments, null);
            if (tag != null) {
                this.insertTag = tag;
                this.popDepth = n2;
                this.pushDepth = n3;
                this.foundInsertTag = false;
            } else {
                this.foundInsertTag = true;
            }
        }

        protected void addContent(char[] cArray, int n, int n2) {
            this.addContent(cArray, n, n2, true);
        }

        protected void addContent(char[] cArray, int n, int n2, boolean bl) {
            if (!this.foundInsertTag) {
                return;
            }
            if (bl && !this.inParagraph && !this.inPre) {
                this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                this.inParagraph = true;
                this.impliedP = true;
            }
            this.emptyAnchor = false;
            this.charAttr.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            AttributeSet attributeSet = this.charAttr.copyAttributes();
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 3, cArray, n, n2);
            this.parseBuffer.addElement(elementSpec);
            if (this.tableCount == 0 && this.parseBuffer.size() > this.threshold) {
                try {
                    this.flushBuffer();
                }
                catch (BadLocationException badLocationException) {}
            }
            if (n2 > 0) {
                this.lastWasNewline = cArray[n + n2 - 1] == '\n';
            }
        }

        protected void addSpecialElement(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            if (!this.foundInsertTag) {
                if (!this.isInsertTag(tag)) {
                    return;
                }
                this.foundInsertTag();
            }
            if (tag != HTML.Tag.FRAME && tag != HTML.Tag.HR && !this.inParagraph && !this.inPre) {
                this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                this.inParagraph = true;
                this.impliedP = true;
            }
            this.emptyAnchor = false;
            mutableAttributeSet.addAttributes(this.charAttr);
            mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, tag);
            char[] cArray = new char[]{' '};
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(mutableAttributeSet.copyAttributes(), 3, cArray, 0, 1);
            this.parseBuffer.addElement(elementSpec);
            if (tag == HTML.Tag.FRAME) {
                this.lastWasNewline = true;
            }
        }

        protected void blockClose(HTML.Tag tag) {
            Object object;
            DefaultStyledDocument.ElementSpec elementSpec;
            if (!this.foundInsertTag) {
                return;
            }
            if (!this.lastWasNewline) {
                this.addContent(NEWLINE, 0, 1, this.insertTag != null);
                this.lastWasNewline = true;
            }
            if (this.impliedP) {
                this.impliedP = false;
                this.inParagraph = false;
                this.blockClose(HTML.Tag.IMPLIED);
            }
            --this.inBlock;
            DefaultStyledDocument.ElementSpec elementSpec2 = elementSpec = this.parseBuffer.size() > 0 ? (DefaultStyledDocument.ElementSpec)this.parseBuffer.lastElement() : null;
            if (elementSpec != null && elementSpec.getType() == 1) {
                object = new char[1];
                object[0] = 32;
                this.addContent((char[])object, 0, 1);
            }
            object = new DefaultStyledDocument.ElementSpec(null, 2);
            this.parseBuffer.addElement(object);
            if (tag == HTML.Tag.TABLE) {
                --this.tableCount;
            }
        }

        protected void blockOpen(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            if (tag == HTML.Tag.TABLE) {
                ++this.tableCount;
            }
            if (this.impliedP) {
                this.impliedP = false;
                this.inParagraph = false;
                this.blockClose(HTML.Tag.IMPLIED);
            }
            ++this.inBlock;
            if (!this.foundInsertTag) {
                if (!this.isInsertTag(tag)) {
                    return;
                }
                this.foundInsertTag();
            }
            this.lastWasNewline = false;
            mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, tag);
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(mutableAttributeSet.copyAttributes(), 1);
            this.parseBuffer.addElement(elementSpec);
        }

        public void flush() throws BadLocationException {
            this.flushBuffer();
        }

        void flushBuffer() throws BadLocationException {
            int n = HTMLDocument.this.getLength();
            Object[] objectArray = new DefaultStyledDocument.ElementSpec[this.parseBuffer.size()];
            this.parseBuffer.copyInto(objectArray);
            if (n == 0 && this.insertTag == null) {
                HTMLDocument.this.create((DefaultStyledDocument.ElementSpec[])objectArray);
            } else {
                HTMLDocument.this.insert(this.offset, (DefaultStyledDocument.ElementSpec[])objectArray);
            }
            this.parseBuffer.removeAllElements();
            this.offset += HTMLDocument.this.getLength() - n;
        }

        private void foundInsertTag() {
            this.foundInsertTag = true;
            if (this.popDepth > 0 || this.pushDepth > 0) {
                try {
                    if (this.offset > 0 && !HTMLDocument.this.getText(this.offset - 1, 1).equals("\n")) {
                        DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(null, 3, NEWLINE, 0, NEWLINE.length);
                        elementSpec.setDirection((short)4);
                        this.parseBuffer.addElement(elementSpec);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            int n = 0;
            while (n < this.popDepth) {
                this.parseBuffer.addElement(new DefaultStyledDocument.ElementSpec(null, 2));
                ++n;
            }
            int n2 = 0;
            while (n2 < this.pushDepth) {
                DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(null, 1);
                elementSpec.setDirection((short)5);
                this.parseBuffer.addElement(elementSpec);
                ++n2;
            }
        }

        public void handleComment(char[] cArray, int n) {
            if (HTMLDocument.this.getPreservesUnknownTags()) {
                if (this.inBlock == 0) {
                    Object object = HTMLDocument.this.getProperty(HTMLDocument.AdditionalComments);
                    if (object != null && !(object instanceof Vector)) {
                        return;
                    }
                    if (object == null) {
                        object = new Vector();
                        HTMLDocument.this.putProperty(HTMLDocument.AdditionalComments, object);
                    }
                    ((Vector)object).addElement(new String(cArray));
                    return;
                }
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute(HTML.Attribute.COMMENT, new String(cArray));
                this.addSpecialElement(HTML.Tag.COMMENT, simpleAttributeSet);
            }
        }

        public void handleEndTag(HTML.Tag tag, int n) {
            TagAction tagAction = (TagAction)this.tagMap.get(tag);
            if (tagAction != null) {
                tagAction.end(tag);
            }
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            TagAction tagAction = (TagAction)this.tagMap.get(tag);
            if (tagAction != null) {
                tagAction.start(tag, mutableAttributeSet);
                tagAction.end(tag);
            } else if (HTMLDocument.this.getPreservesUnknownTags()) {
                this.addSpecialElement(tag, mutableAttributeSet);
            }
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            TagAction tagAction = (TagAction)this.tagMap.get(tag);
            if (tagAction != null) {
                tagAction.start(tag, mutableAttributeSet);
            }
        }

        public void handleText(char[] cArray, int n) {
            if (this.inTextArea) {
                this.textAreaContent(cArray);
            } else if (this.inPre) {
                this.preContent(cArray);
            } else if (this.inTitle) {
                HTMLDocument.this.putProperty("title", new String(cArray));
            } else if (this.option != null) {
                this.option.setLabel(new String(cArray));
            } else if (this.inBlock > 0 && cArray.length >= 1) {
                this.addContent(cArray, 0, cArray.length);
            }
        }

        private boolean isInsertTag(HTML.Tag tag) {
            return this.insertTag == tag || tag == HTML.Tag.IMPLIED && tag == HTML.Tag.P;
        }

        protected void popCharacterStyle() {
            if (!this.charAttrStack.empty()) {
                this.charAttr = (MutableAttributeSet)this.charAttrStack.peek();
                this.charAttrStack.pop();
            }
        }

        protected void preContent(char[] cArray) {
            int n = 0;
            int n2 = 0;
            while (n2 < cArray.length) {
                if (cArray[n2] == '\n') {
                    this.addContent(cArray, n, n2 - n + 1);
                    this.blockClose(HTML.Tag.IMPLIED);
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                    simpleAttributeSet.addAttribute(CSS.Attribute.WHITE_SPACE, "pre");
                    this.blockOpen(HTML.Tag.IMPLIED, simpleAttributeSet);
                    n = n2 + 1;
                }
                ++n2;
            }
            if (n < cArray.length) {
                this.addContent(cArray, n, cArray.length - n);
            }
        }

        protected void pushCharacterStyle() {
            this.charAttrStack.push(this.charAttr.copyAttributes());
        }

        protected void registerTag(HTML.Tag tag, TagAction tagAction) {
            this.tagMap.put(tag, tagAction);
        }

        protected void textAreaContent(char[] cArray) {
            try {
                this.textAreaDocument.insertString(this.textAreaDocument.getLength(), new String(cArray), null);
            }
            catch (BadLocationException badLocationException) {}
        }

        public class TagAction {
            public void end(HTML.Tag tag) {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            }
        }

        public class BlockAction
        extends TagAction {
            public void end(HTML.Tag tag) {
                HTMLReader.this.blockClose(tag);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.blockOpen(tag, mutableAttributeSet);
            }
        }

        public class ParagraphAction
        extends BlockAction {
            public void end(HTML.Tag tag) {
                super.end(tag);
                HTMLReader.this.inParagraph = false;
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                super.start(tag, mutableAttributeSet);
                HTMLReader.this.inParagraph = true;
            }
        }

        public class SpecialAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.addSpecialElement(tag, mutableAttributeSet);
            }
        }

        public class IsindexAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                HTMLReader.this.addSpecialElement(tag, mutableAttributeSet);
                HTMLReader.this.blockClose(HTML.Tag.IMPLIED);
            }
        }

        public class HiddenAction
        extends TagAction {
            public void end(HTML.Tag tag) {
                if (!this.isEmpty(tag)) {
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                    simpleAttributeSet.addAttribute(HTML.Attribute.ENDTAG, "true");
                    HTMLReader.this.addSpecialElement(tag, simpleAttributeSet);
                }
            }

            private boolean isEmpty(HTML.Tag tag) {
                return tag != HTML.Tag.APPLET && tag != HTML.Tag.HEAD && tag != HTML.Tag.TITLE && tag != HTML.Tag.SCRIPT && tag != HTML.Tag.STYLE && tag != HTML.Tag.AREA;
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.addSpecialElement(tag, mutableAttributeSet);
            }
        }

        public class PreAction
        extends BlockAction {
            public void end(HTML.Tag tag) {
                HTMLReader.this.inPre = false;
                HTMLReader.this.blockClose(HTML.Tag.IMPLIED);
                HTMLReader.this.blockClose(tag);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.inPre = true;
                HTMLReader.this.blockOpen(tag, mutableAttributeSet);
                mutableAttributeSet.addAttribute(CSS.Attribute.WHITE_SPACE, "pre");
                HTMLReader.this.blockOpen(HTML.Tag.IMPLIED, mutableAttributeSet);
            }
        }

        public class CharacterAction
        extends TagAction {
            public void end(HTML.Tag tag) {
                HTMLReader.this.popCharacterStyle();
                if (tag == HTML.Tag.FORM) {
                    HTMLDocument.this.radioButtonGroup = null;
                }
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.pushCharacterStyle();
                HTMLReader.this.charAttr.addAttribute(tag, mutableAttributeSet.copyAttributes());
                if (tag == HTML.Tag.FORM) {
                    HTMLDocument.this.radioButtonGroup = new ButtonGroup();
                }
            }
        }

        class AnchorAction
        extends CharacterAction {
            AnchorAction() {
            }

            public void end(HTML.Tag tag) {
                if (HTMLReader.this.emptyAnchor) {
                    char[] cArray = new char[]{' '};
                    HTMLReader.this.addContent(cArray, 0, 1);
                }
                super.end(tag);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.emptyAnchor = true;
                super.start(tag, mutableAttributeSet);
            }
        }

        class TitleAction
        extends HiddenAction {
            TitleAction() {
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.inTitle = false;
                super.end(tag);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.inTitle = true;
                super.start(tag, mutableAttributeSet);
            }
        }

        class BaseAction
        extends TagAction {
            BaseAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                block2: {
                    String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.HREF);
                    if (string == null) break block2;
                    try {
                        ((HTMLReader)HTMLReader.this).HTMLDocument.this.base = new URL(((HTMLReader)HTMLReader.this).HTMLDocument.this.base, string);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
        }

        class ObjectAction
        extends SpecialAction {
            ObjectAction() {
            }

            void addParameter(AttributeSet attributeSet) {
                String string = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
                String string2 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE);
                if (string != null && string2 != null) {
                    DefaultStyledDocument.ElementSpec elementSpec = (DefaultStyledDocument.ElementSpec)HTMLReader.this.parseBuffer.lastElement();
                    MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)elementSpec.getAttributes();
                    mutableAttributeSet.addAttribute(string, string2);
                }
            }

            public void end(HTML.Tag tag) {
                if (tag != HTML.Tag.PARAM) {
                    super.end(tag);
                }
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (tag == HTML.Tag.PARAM) {
                    this.addParameter(mutableAttributeSet);
                } else {
                    super.start(tag, mutableAttributeSet);
                }
            }
        }

        public class FormAction
        extends SpecialAction {
            Object selectModel;
            int optionCount;

            public void end(HTML.Tag tag) {
                if (tag == HTML.Tag.OPTION) {
                    HTMLReader.this.option = null;
                } else {
                    if (tag == HTML.Tag.SELECT) {
                        this.selectModel = null;
                        this.optionCount = 0;
                    } else if (tag == HTML.Tag.TEXTAREA) {
                        HTMLReader.this.inTextArea = false;
                        HTMLReader.this.textAreaDocument.storeInitialText();
                    }
                    super.end(tag);
                }
            }

            void setModel(String string, MutableAttributeSet mutableAttributeSet) {
                if (string.equals("submit") || string.equals("reset") || string.equals("image")) {
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, new DefaultButtonModel());
                } else if (string.equals("text") || string.equals("password")) {
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, new PlainDocument());
                } else if (string.equals("checkbox") || string.equals("radio")) {
                    JToggleButton.ToggleButtonModel toggleButtonModel = new JToggleButton.ToggleButtonModel();
                    if (string.equals("radio")) {
                        toggleButtonModel.setGroup(HTMLDocument.this.radioButtonGroup);
                    }
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, toggleButtonModel);
                }
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (tag == HTML.Tag.INPUT) {
                    String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.TYPE);
                    if (string == null) {
                        string = "text";
                        mutableAttributeSet.addAttribute(HTML.Attribute.TYPE, "text");
                    }
                    this.setModel(string, mutableAttributeSet);
                } else if (tag == HTML.Tag.TEXTAREA) {
                    HTMLReader.this.inTextArea = true;
                    HTMLReader.this.textAreaDocument = new TextAreaDocument();
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, HTMLReader.this.textAreaDocument);
                } else if (tag == HTML.Tag.SELECT) {
                    boolean bl;
                    int n = HTML.getIntegerAttributeValue(mutableAttributeSet, HTML.Attribute.SIZE, 1);
                    boolean bl2 = bl = (String)mutableAttributeSet.getAttribute(HTML.Attribute.MULTIPLE) != null;
                    if (n > 1 || bl) {
                        OptionListModel optionListModel = new OptionListModel();
                        if (bl) {
                            optionListModel.setSelectionMode(2);
                        }
                        this.selectModel = optionListModel;
                    } else {
                        this.selectModel = new OptionComboBoxModel();
                    }
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, this.selectModel);
                }
                if (tag == HTML.Tag.OPTION) {
                    HTMLReader.this.option = new Option(mutableAttributeSet);
                    if (this.selectModel instanceof OptionListModel) {
                        OptionListModel optionListModel = (OptionListModel)this.selectModel;
                        optionListModel.addElement(HTMLReader.this.option);
                        if (HTMLReader.this.option.isSelected()) {
                            optionListModel.addSelectionInterval(this.optionCount, this.optionCount);
                            optionListModel.setInitialSelection(this.optionCount);
                        }
                    } else if (this.selectModel instanceof OptionComboBoxModel) {
                        OptionComboBoxModel optionComboBoxModel = (OptionComboBoxModel)this.selectModel;
                        optionComboBoxModel.addElement(HTMLReader.this.option);
                        if (HTMLReader.this.option.isSelected()) {
                            optionComboBoxModel.setSelectedItem(HTMLReader.this.option);
                            optionComboBoxModel.setInitialSelection(HTMLReader.this.option);
                        }
                    }
                    ++this.optionCount;
                } else {
                    super.start(tag, mutableAttributeSet);
                }
            }
        }
    }

    public class RunElement
    extends AbstractDocument.LeafElement {
        public RunElement(Element element, AttributeSet attributeSet, int n, int n2) {
            super(HTMLDocument.this, element, attributeSet, n, n2);
        }

        public String getName() {
            Object object = this.getAttribute(StyleConstants.NameAttribute);
            if (object != null) {
                return object.toString();
            }
            return super.getName();
        }

        public AttributeSet getResolveParent() {
            return null;
        }
    }

    public class BlockElement
    extends AbstractDocument.BranchElement {
        public BlockElement(Element element, AttributeSet attributeSet) {
            super(HTMLDocument.this, element, attributeSet);
        }

        public String getName() {
            Object object = this.getAttribute(StyleConstants.NameAttribute);
            if (object != null) {
                return object.toString();
            }
            return super.getName();
        }

        public AttributeSet getResolveParent() {
            return null;
        }
    }
}

