/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class TableView
extends BoxView {
    int[] columnSpans;
    int[] columnOffsets;
    SizeRequirements[] columnRequirements;

    public TableView(Element element) {
        super(element, 1);
    }

    void addProxy(int n, int n2, TableCell tableCell) {
        TableRow tableRow = (TableRow)this.getView(n);
        if (tableRow != null) {
            int n3 = tableRow.getViewCount();
            int n4 = tableRow.getViewCount();
            while (n4 < n2) {
                tableRow.insert(n4, new ProxyCell(this.getElement()));
                ++n4;
            }
            tableRow.insert(n2, new ProxyCell(tableCell));
        }
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        int n2 = 0;
        int n3 = this.getViewCount();
        int n4 = 0;
        while (n4 < n3) {
            View view = this.getView(n4);
            n2 = Math.max(n2, view.getViewCount());
            ++n4;
        }
        this.columnSpans = new int[n2];
        this.columnOffsets = new int[n2];
        this.columnRequirements = new SizeRequirements[n2];
        int n5 = 0;
        while (n5 < n2) {
            this.columnRequirements[n5] = new SizeRequirements();
            ++n5;
        }
        int n6 = 0;
        while (n6 < n3) {
            View view = this.getView(n6);
            n2 = view.getViewCount();
            int n7 = 0;
            while (n7 < n2) {
                View view2 = view.getView(n7);
                SizeRequirements sizeRequirements2 = this.columnRequirements[n7];
                sizeRequirements2.minimum = Math.max((int)view2.getMinimumSpan(n), sizeRequirements2.minimum);
                sizeRequirements2.preferred = Math.max((int)view2.getPreferredSpan(n), sizeRequirements2.preferred);
                sizeRequirements2.maximum = Math.max((int)view2.getMaximumSpan(n), sizeRequirements2.maximum);
                if (view2 instanceof GridCell) {
                    GridCell gridCell = (GridCell)((Object)view2);
                    gridCell.setGridLocation(n6, n7);
                }
                ++n7;
            }
            ++n6;
        }
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n8 = 0;
        while (n8 < n2) {
            SizeRequirements sizeRequirements3 = this.columnRequirements[n8];
            l += (long)sizeRequirements3.minimum;
            l2 += (long)sizeRequirements3.preferred;
            l3 += (long)sizeRequirements3.maximum;
            ++n8;
        }
        sizeRequirements.minimum = (int)l;
        sizeRequirements.preferred = (int)l2;
        sizeRequirements.maximum = (int)l3;
        sizeRequirements.alignment = 0.0f;
        return sizeRequirements;
    }

    protected TableCell createTableCell(Element element) {
        return new TableCell(element);
    }

    protected TableRow createTableRow(Element element) {
        return new TableRow(element);
    }

    int getColumnCount() {
        return this.columnSpans.length;
    }

    int getColumnSpan(int n) {
        return this.columnSpans[n];
    }

    int getRowCount() {
        return this.getViewCount();
    }

    int getRowSpan(int n) {
        if (n < this.getViewCount()) {
            return this.getSpan(1, n);
        }
        return 0;
    }

    protected View getViewAtPosition(int n, Rectangle rectangle) {
        View view;
        int n2 = this.getViewCount();
        int n3 = 0;
        while (n3 < n2) {
            view = this.getView(n3);
            int n4 = view.getStartOffset();
            int n5 = view.getEndOffset();
            if (n >= n4 && n < n5) {
                if (rectangle != null) {
                    this.childAllocation(n3, rectangle);
                }
                return view;
            }
            ++n3;
        }
        if (n == this.getEndOffset()) {
            view = this.getView(n2 - 1);
            if (rectangle != null) {
                this.childAllocation(n2 - 1, rectangle);
            }
            return view;
        }
        return null;
    }

    protected void layoutColumns(int n, int[] nArray, int[] nArray2, SizeRequirements[] sizeRequirementsArray) {
        SizeRequirements.calculateTiledPositions(n, null, sizeRequirementsArray, nArray, nArray2);
    }

    protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        this.layoutColumns(n, this.columnOffsets, this.columnSpans, this.columnRequirements);
        super.layoutMinorAxis(n, n2, nArray, nArray2);
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        int n2 = 0;
        while (n2 < n) {
            TableRow tableRow = this.createTableRow(element.getElement(n2));
            if (tableRow != null) {
                this.append(tableRow);
            }
            ++n2;
        }
        this.loadProxyCells();
    }

    void loadProxyCells() {
        int n = this.getViewCount();
        int n2 = 0;
        while (n2 < n) {
            View view = this.getView(n2);
            int n3 = 0;
            while (n3 < view.getViewCount()) {
                TableCell tableCell;
                View view2 = view.getView(n3);
                if (view2 instanceof TableCell && ((tableCell = (TableCell)view2).getColumnCount() > 1 || tableCell.getRowCount() > 1)) {
                    int n4 = n2 + tableCell.getRowCount();
                    int n5 = n3 + tableCell.getColumnCount();
                    int n6 = n2;
                    while (n6 < n4) {
                        int n7 = n3;
                        while (n7 < n5) {
                            if (n6 != n2 || n7 != n3) {
                                this.addProxy(n6, n7, tableCell);
                            }
                            ++n7;
                        }
                        ++n6;
                    }
                }
                ++n3;
            }
            ++n2;
        }
    }

    public class TableRow
    extends BoxView {
        public TableRow(Element element) {
            super(element, 0);
        }

        public int getResizeWeight(int n) {
            return 1;
        }

        protected View getViewAtPosition(int n, Rectangle rectangle) {
            View view;
            int n2 = this.getViewCount();
            int n3 = 0;
            while (n3 < n2) {
                view = this.getView(n3);
                int n4 = view.getStartOffset();
                int n5 = view.getEndOffset();
                if (n >= n4 && n < n5) {
                    if (rectangle != null) {
                        this.childAllocation(n3, rectangle);
                    }
                    return view;
                }
                ++n3;
            }
            if (n == this.getEndOffset()) {
                view = this.getView(n2 - 1);
                if (rectangle != null) {
                    this.childAllocation(n2 - 1, rectangle);
                }
                return view;
            }
            return null;
        }

        protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            System.arraycopy(TableView.this.columnOffsets, 0, nArray, 0, nArray.length);
            System.arraycopy(TableView.this.columnSpans, 0, nArray2, 0, nArray2.length);
            int n3 = this.getViewCount();
            int n4 = 0;
            while (n4 < n3) {
                TableCell tableCell;
                int n5;
                View view = this.getView(n4);
                if (view instanceof TableCell && (n5 = (tableCell = (TableCell)view).getColumnCount()) > 1) {
                    int n6 = 1;
                    while (n6 < n5) {
                        int n7 = n4;
                        nArray2[n7] = nArray2[n7] + nArray2[n4 + n6];
                        ++n6;
                    }
                }
                ++n4;
            }
        }

        protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            super.layoutMinorAxis(n, n2, nArray, nArray2);
            int n3 = this.getViewCount();
            int n4 = 0;
            while (n4 < n3) {
                TableCell tableCell;
                int n5;
                View view = this.getView(n4);
                if (view instanceof TableCell && (n5 = (tableCell = (TableCell)view).getRowCount()) > 1) {
                    int n6 = 1;
                    while (n6 < n5) {
                        int n7 = n4;
                        nArray2[n7] = nArray2[n7] + TableView.this.getRowSpan(tableCell.getGridRow() + n6);
                        ++n6;
                    }
                }
                ++n4;
            }
        }

        protected void loadChildren(ViewFactory viewFactory) {
            Element element = this.getElement();
            int n = element.getElementCount();
            if (n > 0) {
                View[] viewArray = new View[n];
                int n2 = 0;
                while (n2 < n) {
                    viewArray[n2] = TableView.this.createTableCell(element.getElement(n2));
                    ++n2;
                }
                this.replace(0, 0, viewArray);
            }
        }
    }

    static interface GridCell {
        public int getColumnCount();

        public int getGridColumn();

        public int getGridRow();

        public int getRowCount();

        public void setGridLocation(int var1, int var2);
    }

    public class TableCell
    extends BoxView
    implements GridCell {
        int row;
        int col;

        public TableCell(Element element) {
            super(element, 1);
        }

        public int getColumnCount() {
            return 1;
        }

        public int getGridColumn() {
            return this.col;
        }

        public int getGridRow() {
            return this.row;
        }

        public float getPreferredSpan(int n) {
            if (n == 0) {
                return super.getPreferredSpan(n) / (float)this.getColumnCount();
            }
            return super.getPreferredSpan(n) / (float)this.getRowCount();
        }

        public int getRowCount() {
            return 1;
        }

        public void setGridLocation(int n, int n2) {
            this.row = n;
            this.col = n2;
        }
    }

    class ProxyCell
    extends View
    implements GridCell {
        TableCell host;
        int row;
        int col;

        ProxyCell(Element element) {
            super(element);
            this.host = null;
        }

        ProxyCell(TableCell tableCell) {
            super(tableCell.getElement());
            this.host = tableCell;
        }

        public int getColumnCount() {
            return 1;
        }

        public int getGridColumn() {
            return this.col;
        }

        public int getGridRow() {
            return this.row;
        }

        public float getPreferredSpan(int n) {
            if (this.host != null) {
                return this.host.getPreferredSpan(n);
            }
            return 0.0f;
        }

        public int getResizeWeight(int n) {
            return 1;
        }

        public int getRowCount() {
            return 1;
        }

        protected void loadChildren(ViewFactory viewFactory) {
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            if (this.host != null) {
                return this.host.modelToView(n, shape, bias);
            }
            return null;
        }

        public void paint(Graphics graphics, Shape shape) {
        }

        public void setGridLocation(int n, int n2) {
            this.row = n;
            this.col = n2;
            this.preferenceChanged(null, true, true);
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            if (this.host != null) {
                return this.host.viewToModel(f, f2, shape, biasArray);
            }
            return -1;
        }
    }
}

