/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;

class MetalInternalFrameTitlePane
extends JComponent
implements LayoutManager,
ActionListener,
PropertyChangeListener {
    protected JMenuBar menuBar;
    protected boolean isPalette = false;
    JInternalFrame frame;
    protected JButton iconButton;
    protected JButton maxButton;
    protected JButton closeButton;
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    Icon maxIcon;
    Icon altMaxIcon;
    Icon iconIcon;
    Icon closeIcon;
    int riseWidth = 0;
    int interButtonSpacing = 2;
    MetalBumps activeBumps = new MetalBumps(0, 0, MetalLookAndFeel.getPrimaryControlHighlight(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControl());
    MetalBumps inactiveBumps = new MetalBumps(0, 0, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getControl());
    MetalBumps paletteBumps;

    public MetalInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        this.frame = jInternalFrame;
        this.setFont(UIManager.getFont("InternalFrame.font"));
        this.maxIcon = (Icon)UIManager.get("InternalFrame.maximizeIcon");
        this.altMaxIcon = (Icon)UIManager.get("InternalFrame.minimizeIcon");
        this.iconIcon = (Icon)UIManager.get("InternalFrame.iconizeIcon");
        this.closeIcon = (Icon)UIManager.get("InternalFrame.closeIcon");
        this.iconButton = new NoFocusButton(this.iconIcon);
        this.iconButton.putClientProperty("paintActive", Boolean.TRUE);
        this.iconButton.setFocusPainted(false);
        this.iconButton.setBorder(handyEmptyBorder);
        this.iconButton.setOpaque(false);
        this.iconButton.addActionListener(this);
        this.iconButton.setActionCommand("Iconify");
        this.iconButton.getAccessibleContext().setAccessibleName("Iconify");
        this.maxButton = new NoFocusButton(this.maxIcon);
        this.maxButton.putClientProperty("paintActive", Boolean.TRUE);
        this.maxButton.setBorder(handyEmptyBorder);
        this.maxButton.setOpaque(false);
        this.maxButton.setFocusPainted(false);
        this.maxButton.addActionListener(this);
        this.maxButton.setActionCommand("Maximize");
        this.maxButton.getAccessibleContext().setAccessibleName("Maximize");
        this.closeButton = new NoFocusButton(this.closeIcon);
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.setBorder(handyEmptyBorder);
        this.closeButton.setOpaque(false);
        this.closeButton.setFocusPainted(false);
        this.closeButton.addActionListener(this);
        this.closeButton.setActionCommand("Close");
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.setLayout(this);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
        this.frame.addPropertyChangeListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block21: {
            block25: {
                block24: {
                    block23: {
                        block22: {
                            block20: {
                                if (!"Close".equals(actionEvent.getActionCommand()) || !this.frame.isClosable()) break block20;
                                try {
                                    this.frame.setClosed(true);
                                }
                                catch (PropertyVetoException propertyVetoException) {}
                                break block21;
                            }
                            if (!"Iconify".equals(actionEvent.getActionCommand()) || !this.frame.isIconifiable()) break block22;
                            if (!this.frame.isIcon()) {
                                try {
                                    this.frame.setIcon(true);
                                }
                                catch (PropertyVetoException propertyVetoException) {}
                            } else {
                                try {
                                    this.frame.setIcon(false);
                                }
                                catch (PropertyVetoException propertyVetoException) {}
                            }
                            ButtonModel buttonModel = this.iconButton.getModel();
                            if (buttonModel == null) break block21;
                            buttonModel.setRollover(false);
                            break block21;
                        }
                        if (!"Minimize".equals(actionEvent.getActionCommand()) || !this.frame.isMaximizable()) break block23;
                        try {
                            this.frame.setIcon(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                        break block21;
                    }
                    if (!"Maximize".equals(actionEvent.getActionCommand()) || !this.frame.isMaximizable()) break block24;
                    if (!this.frame.isMaximum()) {
                        try {
                            this.frame.setMaximum(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    } else {
                        try {
                            this.frame.setMaximum(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    }
                    break block21;
                }
                if (!"Restore".equals(actionEvent.getActionCommand()) || !this.frame.isMaximizable() || !this.frame.isMaximum()) break block25;
                try {
                    this.frame.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
                break block21;
            }
            if (!"Restore".equals(actionEvent.getActionCommand()) || !this.frame.isIconifiable() || !this.frame.isIcon()) break block21;
            try {
                this.frame.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    protected int computeHeight() {
        if (this.isPalette) {
            return UIManager.getInt("InternalFrame.paletteTitleHeight");
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        int n = fontMetrics.getHeight();
        int n2 = this.frame.getFrameIcon().getIconHeight();
        int n3 = Math.max(n += 7, n2 += 5);
        return n3;
    }

    public Dimension getPreferredSize(Container container) {
        return new Dimension(container.getSize().width, this.computeHeight());
    }

    public void layoutContainer(Container container) {
        int n = this.getWidth() - 2;
        int n2 = 2;
        int n3 = 7;
        int n4 = this.closeButton.getIcon().getIconHeight();
        int n5 = this.closeButton.getIcon().getIconWidth();
        int n6 = n;
        if (this.frame.isClosable()) {
            if (this.isPalette) {
                this.closeButton.setBounds(n6 -= n5 + 4, 2, n5 + 2, this.getHeight() - 4);
                n6 -= 3;
            } else {
                this.closeButton.setBounds(n6 -= n5 + this.interButtonSpacing, n2, n5, n4);
                n6 -= n3;
            }
        } else if (this.closeButton.getParent() != null) {
            this.closeButton.getParent().remove(this.closeButton);
        }
        if (this.frame.isMaximizable() && !this.isPalette) {
            this.maxButton.setBounds(n6 -= n5 + this.interButtonSpacing, n2, n5, n4);
        } else if (this.maxButton.getParent() != null) {
            this.maxButton.getParent().remove(this.maxButton);
        }
        if (this.frame.isIconifiable() && !this.isPalette) {
            this.iconButton.setBounds(n6 -= n5 + this.interButtonSpacing, n2, n5, n4);
        } else if (this.iconButton.getParent() != null) {
            this.iconButton.getParent().remove(this.iconButton);
        }
        this.riseWidth = n - n6;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        MetalBumps metalBumps;
        ColorUIResource colorUIResource;
        ColorUIResource colorUIResource2;
        ColorUIResource colorUIResource3;
        if (this.isPalette) {
            this.paintPalette(graphics);
            return;
        }
        boolean bl = this.frame.isSelected();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (bl) {
            colorUIResource3 = MetalLookAndFeel.getWindowTitleBackground();
            colorUIResource2 = MetalLookAndFeel.getWindowTitleForeground();
            ColorUIResource colorUIResource4 = MetalLookAndFeel.getPrimaryControlShadow();
            colorUIResource = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource colorUIResource5 = MetalLookAndFeel.getPrimaryControlHighlight();
            ColorUIResource colorUIResource6 = MetalLookAndFeel.getPrimaryControlInfo();
            metalBumps = this.activeBumps;
        } else {
            colorUIResource3 = MetalLookAndFeel.getWindowTitleInactiveBackground();
            colorUIResource2 = MetalLookAndFeel.getWindowTitleInactiveForeground();
            ColorUIResource colorUIResource7 = MetalLookAndFeel.getControlShadow();
            colorUIResource = MetalLookAndFeel.getControlDarkShadow();
            ColorUIResource colorUIResource8 = MetalLookAndFeel.getControlHighlight();
            ColorUIResource colorUIResource9 = MetalLookAndFeel.getControlInfo();
            metalBumps = this.inactiveBumps;
        }
        ColorUIResource colorUIResource10 = colorUIResource;
        graphics.setColor(colorUIResource3);
        graphics.fillRect(0, 0, n3, n4);
        graphics.setColor(colorUIResource);
        graphics.drawLine(0, n4 - 1, n3, n4 - 1);
        graphics.drawLine(0, 0, 0, 0);
        graphics.drawLine(n3 - 1, 0, n3 - 1, 0);
        int n5 = 0;
        int n6 = 5;
        String string = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            n2 = n4 / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, graphics, n6, n2);
            n6 += icon.getIconWidth() + 2;
        }
        if (string != null) {
            Font font = this.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n = fontMetrics.getHeight();
            n5 = fontMetrics.stringWidth(this.frame.getTitle());
            graphics.setColor(colorUIResource2);
            int n7 = (n4 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            graphics.drawString(this.frame.getTitle(), n6, n7);
        }
        n2 = 3;
        int n8 = this.getWidth() - ((n6 += n5 + this.interButtonSpacing) + this.riseWidth + this.interButtonSpacing + 5);
        n = this.getHeight() - 2 * n2;
        metalBumps.setBumpArea(n8, n);
        metalBumps.paintIcon(this, graphics, n6, n2);
        this.paintChildren(graphics);
    }

    public void paintPalette(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.paletteBumps == null) {
            this.paletteBumps = new MetalBumps(0, 0, MetalLookAndFeel.getPrimaryControlHighlight(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControlShadow());
        }
        ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControlShadow();
        ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControlDarkShadow();
        graphics.setColor(colorUIResource);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(colorUIResource2);
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
        int n3 = 5;
        int n4 = this.getWidth() - (n3 + this.riseWidth + 2);
        int n5 = this.getHeight() - 4;
        this.paletteBumps.setBumpArea(n4, n5);
        this.paletteBumps.paintIcon(this, graphics, n3, 2);
        this.paintChildren(graphics);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getPreferredSize(container);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        JInternalFrame jInternalFrame = (JInternalFrame)propertyChangeEvent.getSource();
        boolean bl = false;
        if (this.frame.isSelected()) {
            this.iconButton.putClientProperty("paintActive", Boolean.TRUE);
            this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
            this.maxButton.putClientProperty("paintActive", Boolean.TRUE);
            this.repaint();
        } else {
            this.iconButton.putClientProperty("paintActive", Boolean.FALSE);
            this.closeButton.putClientProperty("paintActive", Boolean.FALSE);
            this.maxButton.putClientProperty("paintActive", Boolean.FALSE);
            this.repaint();
        }
        if ("selected".equals(string)) {
            this.repaint();
        } else if ("maximum".equals(string)) {
            bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                this.maxButton.setIcon(this.altMaxIcon);
            } else {
                this.maxButton.setIcon(this.maxIcon);
            }
        } else if ("icon".equals(string)) {
            bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                this.iconButton.setIcon(this.iconIcon);
            } else {
                this.iconButton.setIcon(this.iconIcon);
            }
        }
    }

    public void removeLayoutComponent(Component component) {
    }

    public void setPalette(boolean bl) {
        this.isPalette = bl;
        if (this.isPalette) {
            this.closeButton.setIcon(UIManager.getIcon("InternalFrame.paletteCloseIcon"));
        } else {
            this.closeButton.setIcon(this.closeIcon);
        }
        this.repaint();
        this.revalidate();
    }

    private static class NoFocusButton
    extends JButton {
        public NoFocusButton() {
            this.setFocusPainted(false);
        }

        public NoFocusButton(Icon icon) {
            super(icon);
            this.setFocusPainted(false);
        }

        public boolean isContentAreaFilled() {
            return false;
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public boolean isOpaque() {
            return false;
        }

        public void requestFocus() {
        }
    }
}

