/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;

public class BasicProgressBarUI
extends ProgressBarUI {
    private static final Dimension PREFERRED_INNER_HORIZONTAL = new Dimension(146, 12);
    private static final Dimension PREFERRED_INNER_VERTICAL = new Dimension(12, 146);
    private int cachedPercent;
    private int cellLength;
    private int cellSpacing;
    private Color selectionForeground;
    private Color selectionBackground;
    protected JProgressBar progressBar;
    protected ChangeListener changeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicProgressBarUI();
    }

    protected int getAmountFull(Insets insets, int n, int n2) {
        int n3 = 0;
        BoundedRangeModel boundedRangeModel = this.progressBar.getModel();
        if (boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum() != 0) {
            n3 = this.progressBar.getOrientation() == 0 ? (int)Math.round((double)n * this.progressBar.getPercentComplete()) : (int)Math.round((double)n2 * this.progressBar.getPercentComplete());
        }
        return n3;
    }

    private int getCachedPercent() {
        return this.cachedPercent;
    }

    protected int getCellLength() {
        if (this.progressBar.isStringPainted()) {
            return 1;
        }
        return this.cellLength;
    }

    protected int getCellSpacing() {
        if (this.progressBar.isStringPainted()) {
            return 0;
        }
        return this.cellSpacing;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            dimension.width = Short.MAX_VALUE;
        } else {
            dimension.height = Short.MAX_VALUE;
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            dimension.width = 10;
        } else {
            dimension.height = 10;
        }
        return dimension;
    }

    protected Dimension getPreferredInnerHorizontal() {
        return PREFERRED_INNER_HORIZONTAL;
    }

    protected Dimension getPreferredInnerVertical() {
        return PREFERRED_INNER_VERTICAL;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        Insets insets = this.progressBar.getInsets();
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        if (this.progressBar.getOrientation() == 0) {
            dimension = new Dimension(this.getPreferredInnerHorizontal());
            if (this.progressBar.isStringPainted()) {
                int n;
                String string = this.progressBar.getString();
                int n2 = fontMetrics.stringWidth(string);
                if (n2 > dimension.width) {
                    dimension.width = n2;
                }
                if ((n = fontMetrics.getHeight() + fontMetrics.getDescent()) > dimension.height) {
                    dimension.height = n;
                }
            }
        } else {
            dimension = new Dimension(this.getPreferredInnerVertical());
            if (this.progressBar.isStringPainted()) {
                int n;
                String string = new String("100%");
                int n3 = fontMetrics.stringWidth(string);
                if (n3 > dimension.width) {
                    dimension.width = n3;
                }
                if ((n3 = fontMetrics.stringWidth(string = this.progressBar.getString())) > dimension.width) {
                    dimension.width = n3;
                }
                if ((n = fontMetrics.getHeight() + fontMetrics.getDescent()) > dimension.height) {
                    dimension.height = n;
                }
            }
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    protected Color getSelectionBackground() {
        return this.selectionBackground;
    }

    protected Color getSelectionForeground() {
        return this.selectionForeground;
    }

    protected Point getStringPlacement(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        int n5 = fontMetrics.stringWidth(string);
        int n6 = fontMetrics.getAscent() + fontMetrics.getDescent();
        if (this.progressBar.getOrientation() == 0) {
            return new Point(n + Math.round(n3 / 2 - n5 / 2), n2 + fontMetrics.getHeight() - Math.round(fontMetrics.getDescent() / 2));
        }
        return new Point(n + Math.round(n3 / 2 - n5 / 2), n2 + Math.round(n4 / 2 + n6 / 2));
    }

    protected void installDefaults() {
        this.progressBar.setOpaque(true);
        LookAndFeel.installBorder(this.progressBar, "ProgressBar.border");
        LookAndFeel.installColorsAndFont(this.progressBar, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
        this.cellLength = UIManager.getInt("ProgressBar.cellLength");
        this.cellSpacing = UIManager.getInt("ProgressBar.cellSpacing");
        this.selectionForeground = UIManager.getColor("ProgressBar.selectionForeground");
        this.selectionBackground = UIManager.getColor("ProgressBar.selectionBackground");
    }

    protected void installListeners() {
        this.changeListener = new ChangeHandler();
        this.progressBar.addChangeListener(this.changeListener);
    }

    public void installUI(JComponent jComponent) {
        this.progressBar = (JProgressBar)jComponent;
        this.installDefaults();
        this.installListeners();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        BoundedRangeModel boundedRangeModel = this.progressBar.getModel();
        int n = 0;
        int n2 = 0;
        int n3 = this.progressBar.getWidth();
        int n4 = this.progressBar.getHeight();
        Insets insets = this.progressBar.getInsets();
        int n5 = this.getCellLength() + this.getCellSpacing();
        int n6 = this.getAmountFull(insets, n3 -= insets.right + (n += insets.left), n4 -= insets.bottom + (n2 += insets.top));
        graphics.setColor(this.progressBar.getForeground());
        if (this.progressBar.getOrientation() == 0) {
            if (this.getCellSpacing() == 0 && n6 > 0) {
                graphics.fillRect(n, n2, n - insets.left + n6, n4);
            } else {
                int n7 = n + n6;
                int n8 = n;
                while (n8 < n7) {
                    graphics.fillRect(n8, n2, this.getCellLength(), n4);
                    n8 += n5;
                }
            }
        } else if (this.getCellSpacing() == 0 && n6 > 0) {
            graphics.fillRect(n, n4 - n6 + insets.top, n3, n6);
        } else {
            int n9 = n4 - n6;
            int n10 = n4 - this.getCellLength() + this.getCellSpacing();
            while (n10 >= n9) {
                graphics.fillRect(n, n10, n3, this.getCellLength());
                n10 -= n5;
            }
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(graphics, n, n2, n3, n4, n6, insets);
        }
    }

    protected void paintString(Graphics graphics, int n, int n2, int n3, int n4, int n5, Insets insets) {
        String string = this.progressBar.getString();
        graphics.setFont(this.progressBar.getFont());
        Point point = this.getStringPlacement(graphics, string, n, n2, n3, n4);
        Rectangle rectangle = graphics.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            graphics.setColor(this.getSelectionForeground());
            graphics.drawString(string, point.x, point.y);
            graphics.setColor(this.getSelectionBackground());
            graphics.setClip(n5 + insets.left, n2, n3, n4);
            graphics.drawString(string, point.x, point.y);
        } else {
            graphics.setColor(this.getSelectionBackground());
            graphics.drawString(string, point.x, point.y);
            graphics.setColor(this.getSelectionForeground());
            graphics.setClip(n, n4 - n5 + insets.top, n3, n4);
            graphics.drawString(string, point.x, point.y);
        }
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void setCachedPercent(int n) {
        this.cachedPercent = n;
    }

    protected void setCellLength(int n) {
        this.cellLength = n;
    }

    protected void setCellSpacing(int n) {
        this.cellSpacing = n;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.progressBar);
    }

    protected void uninstallListeners() {
        this.progressBar.removeChangeListener(this.changeListener);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.progressBar = null;
    }

    public class ChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            int n;
            BoundedRangeModel boundedRangeModel = BasicProgressBarUI.this.progressBar.getModel();
            int n2 = boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum();
            int n3 = n2 > 0 ? 100 * boundedRangeModel.getValue() / n2 : 0;
            if (n3 != (n = BasicProgressBarUI.this.getCachedPercent())) {
                BasicProgressBarUI.this.setCachedPercent(n3);
                BasicProgressBarUI.this.progressBar.repaint();
            }
        }
    }
}

