/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.TimerQueue;

public class JApplet
extends Applet
implements Accessible,
RootPaneContainer {
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected AccessibleContext accessibleContext = null;

    public JApplet() {
        TimerQueue timerQueue = TimerQueue.sharedInstance();
        if (timerQueue != null) {
            TimerQueue timerQueue2 = timerQueue;
            synchronized (timerQueue2) {
                if (!timerQueue.running) {
                    timerQueue.start();
                }
            }
        }
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.setRootPane(this.createRootPane());
        this.setRootPaneCheckingEnabled(true);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("add");
        }
        super.addImpl(component, object, n);
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    private Error createRootPaneException(String string) {
        String string2 = this.getClass().getName();
        return new Error("Do not use " + string2 + "." + string + "() use " + string2 + ".getContentPane()." + string + "() instead");
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJApplet();
        }
        return this.accessibleContext;
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getMenuBar();
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected String paramString() {
        String string = this.rootPane != null ? this.rootPane.toString() : "";
        String string2 = this.rootPaneCheckingEnabled ? "true" : "false";
        return String.valueOf(super.paramString()) + ",rootPane=" + string + ",rootPaneCheckingEnabled=" + string2;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            JComponent.processKeyBindingsForAllComponents(keyEvent, this, keyEvent.getID() == 401);
        }
    }

    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        this.getRootPane().setMenuBar(jMenuBar);
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("setLayout");
        }
        super.setLayout(layoutManager);
    }

    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                Object var4_3 = null;
                this.setRootPaneCheckingEnabled(bl);
            }
        }
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected class AccessibleJApplet
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        protected AccessibleJApplet() {
        }

        public void addFocusListener(FocusListener focusListener) {
            JApplet.this.addFocusListener(focusListener);
        }

        public boolean contains(Point point) {
            return JApplet.this.contains(point);
        }

        public Accessible getAccessibleAt(Point point) {
            return SwingUtilities.getAccessibleAt(JApplet.this, point);
        }

        public Accessible getAccessibleChild(int n) {
            return SwingUtilities.getAccessibleChild(JApplet.this, n);
        }

        public int getAccessibleChildrenCount() {
            return SwingUtilities.getAccessibleChildrenCount(JApplet.this);
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public int getAccessibleIndexInParent() {
            return SwingUtilities.getAccessibleIndexInParent(JApplet.this);
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent != null) {
                return this.accessibleParent;
            }
            Container container = JApplet.this.getParent();
            if (container instanceof Accessible) {
                return (Accessible)((Object)container);
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FRAME;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = SwingUtilities.getAccessibleStateSet(JApplet.this);
            accessibleStateSet.add(AccessibleState.ACTIVE);
            return accessibleStateSet;
        }

        public Color getBackground() {
            return JApplet.this.getBackground();
        }

        public Rectangle getBounds() {
            return JApplet.this.getBounds();
        }

        public Cursor getCursor() {
            return JApplet.this.getCursor();
        }

        public Font getFont() {
            return JApplet.this.getFont();
        }

        public FontMetrics getFontMetrics(Font font) {
            return JApplet.this.getFontMetrics(font);
        }

        public Color getForeground() {
            return JApplet.this.getForeground();
        }

        public Locale getLocale() {
            return JApplet.this.getLocale();
        }

        public Point getLocation() {
            return JApplet.this.getLocation();
        }

        public Point getLocationOnScreen() {
            return JApplet.this.getLocationOnScreen();
        }

        public Dimension getSize() {
            return JApplet.this.getSize();
        }

        public boolean isEnabled() {
            return JApplet.this.isEnabled();
        }

        public boolean isFocusTraversable() {
            return JApplet.this.isFocusTraversable();
        }

        public boolean isShowing() {
            return JApplet.this.isShowing();
        }

        public boolean isVisible() {
            return JApplet.this.isVisible();
        }

        public void removeFocusListener(FocusListener focusListener) {
            JApplet.this.removeFocusListener(focusListener);
        }

        public void requestFocus() {
            JApplet.this.requestFocus();
        }

        public void setBackground(Color color) {
            JApplet.this.setBackground(color);
        }

        public void setBounds(Rectangle rectangle) {
            JApplet.this.setBounds(rectangle);
        }

        public void setCursor(Cursor cursor) {
            JApplet.this.setCursor(cursor);
        }

        public void setEnabled(boolean bl) {
            JApplet.this.setEnabled(bl);
        }

        public void setFont(Font font) {
            JApplet.this.setFont(font);
        }

        public void setForeground(Color color) {
            JApplet.this.setForeground(color);
        }

        public void setLocation(Point point) {
            JApplet.this.setLocation(point);
        }

        public void setSize(Dimension dimension) {
            JApplet.this.setSize(dimension);
        }

        public void setVisible(boolean bl) {
            JApplet.this.setVisible(bl);
        }
    }
}

