/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    private ZipEntry entry;
    private CRC32 crc = new CRC32();
    private long remaining;
    private byte[] tmpbuf = new byte[512];
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private boolean closed = false;
    private boolean entryEOF = false;

    public ZipInputStream(InputStream inputStream) {
        super(new PushbackInputStream(inputStream, 512), new Inflater(true), 512);
    }

    public int available() throws IOException {
        this.ensureOpen();
        if (this.entryEOF) {
            return 0;
        }
        return 1;
    }

    public void close() throws IOException {
        this.in.close();
        this.closed = true;
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        while (this.read(this.tmpbuf, 0, this.tmpbuf.length) != -1) {
        }
        this.entryEOF = true;
    }

    protected ZipEntry createZipEntry(String string) {
        return new ZipEntry(string);
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    private static final int get16(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private static final long get32(byte[] byArray, int n) {
        return (long)ZipInputStream.get16(byArray, n) | (long)ZipInputStream.get16(byArray, n + 2) << 16;
    }

    public ZipEntry getNextEntry() throws IOException {
        this.ensureOpen();
        if (this.entry != null) {
            this.closeEntry();
        }
        this.crc.reset();
        this.inf.reset();
        this.entry = this.readLOC();
        if (this.entry == null) {
            return null;
        }
        if (this.entry.method == 0) {
            this.remaining = this.entry.size;
        }
        this.entryEOF = false;
        return this.entry;
    }

    private static String getUTF8String(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n + n2;
        int n5 = n;
        while (n5 < n4) {
            int n6 = byArray[n5++] & 0xFF;
            switch (n6 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n3;
                    break;
                }
                case 12: 
                case 13: {
                    if ((byArray[n5++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++n3;
                    break;
                }
                case 14: {
                    if ((byArray[n5++] & 0xC0) != 128 || (byArray[n5++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++n3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        if (n5 != n4) {
            throw new IllegalArgumentException();
        }
        char[] cArray = new char[n3];
        n5 = 0;
        while (n < n4) {
            int n7 = byArray[n++] & 0xFF;
            switch (n7 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n5++] = (char)n7;
                    break;
                }
                case 12: 
                case 13: {
                    cArray[n5++] = (char)((n7 & 0x1F) << 6 | byArray[n++] & 0x3F);
                    break;
                }
                case 14: {
                    int n8 = (byArray[n++] & 0x3F) << 6;
                    cArray[n5++] = (char)((n7 & 0xF) << 12 | n8 | byArray[n++] & 0x3F);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return new String(cArray, 0, n3);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (this.entry == null) {
            return -1;
        }
        switch (this.entry.method) {
            case 8: {
                n2 = super.read(byArray, n, n2);
                if (n2 == -1) {
                    this.readEnd(this.entry);
                    this.entryEOF = true;
                    this.entry = null;
                } else {
                    this.crc.update(byArray, n, n2);
                }
                return n2;
            }
            case 0: {
                if (this.remaining <= 0L) {
                    this.entryEOF = true;
                    this.entry = null;
                    return -1;
                }
                if ((long)n2 > this.remaining) {
                    n2 = (int)this.remaining;
                }
                if ((n2 = this.in.read(byArray, n, n2)) == -1) {
                    throw new ZipException("unexpected EOF");
                }
                this.crc.update(byArray, n, n2);
                this.remaining -= (long)n2;
                return n2;
            }
        }
        throw new InternalError("invalid compression method");
    }

    private void readEnd(ZipEntry zipEntry) throws IOException {
        int n = this.inf.getRemaining();
        if (n > 0) {
            ((PushbackInputStream)this.in).unread(this.buf, this.len - n, n);
        }
        if ((zipEntry.flag & 8) == 8) {
            this.readFully(this.tmpbuf, 0, 16);
            long l = ZipInputStream.get32(this.tmpbuf, 0);
            if (l != 134695760L) {
                throw new ZipException("invalid EXT descriptor signature");
            }
            zipEntry.crc = ZipInputStream.get32(this.tmpbuf, 4);
            zipEntry.csize = ZipInputStream.get32(this.tmpbuf, 8);
            zipEntry.size = ZipInputStream.get32(this.tmpbuf, 12);
        }
        if (zipEntry.size != (long)this.inf.getTotalOut()) {
            throw new ZipException("invalid entry size (expected " + zipEntry.size + " but got " + this.inf.getTotalOut() + " bytes)");
        }
        if (zipEntry.csize != (long)this.inf.getTotalIn()) {
            throw new ZipException("invalid entry compressed size (expected " + zipEntry.csize + " but got " + this.inf.getTotalIn() + " bytes)");
        }
        if (zipEntry.crc != this.crc.getValue()) {
            throw new ZipException("invalid entry CRC (expected 0x" + Long.toHexString(zipEntry.crc) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
        }
    }

    private void readFully(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 == -1) {
                throw new EOFException();
            }
            n += n3;
            n2 -= n3;
        }
    }

    private ZipEntry readLOC() throws IOException {
        try {
            this.readFully(this.tmpbuf, 0, 30);
        }
        catch (EOFException eOFException) {
            return null;
        }
        if (ZipInputStream.get32(this.tmpbuf, 0) != 67324752L) {
            return null;
        }
        int n = ZipInputStream.get16(this.tmpbuf, 26);
        if (n == 0) {
            throw new ZipException("missing entry name");
        }
        byte[] byArray = new byte[n];
        this.readFully(byArray, 0, n);
        ZipEntry zipEntry = this.createZipEntry(ZipInputStream.getUTF8String(byArray, 0, n));
        zipEntry.version = ZipInputStream.get16(this.tmpbuf, 4);
        zipEntry.flag = ZipInputStream.get16(this.tmpbuf, 6);
        if ((zipEntry.flag & 1) == 1) {
            throw new ZipException("encrypted ZIP entry not supported");
        }
        zipEntry.method = ZipInputStream.get16(this.tmpbuf, 8);
        zipEntry.time = ZipInputStream.get32(this.tmpbuf, 10);
        if ((zipEntry.flag & 8) == 8) {
            if (zipEntry.method != 8) {
                throw new ZipException("only DEFLATED entries can have EXT descriptor");
            }
        } else {
            zipEntry.crc = ZipInputStream.get32(this.tmpbuf, 14);
            zipEntry.csize = ZipInputStream.get32(this.tmpbuf, 18);
            zipEntry.size = ZipInputStream.get32(this.tmpbuf, 22);
        }
        if ((n = ZipInputStream.get16(this.tmpbuf, 28)) > 0) {
            byArray = new byte[n];
            this.readFully(byArray, 0, n);
            zipEntry.extra = byArray;
        }
        return zipEntry;
    }

    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        this.ensureOpen();
        int n = (int)Math.min(l, Integer.MAX_VALUE);
        int n2 = 0;
        while (n2 < n) {
            int n3 = n - n2;
            if (n3 > this.tmpbuf.length) {
                n3 = this.tmpbuf.length;
            }
            if ((n3 = this.read(this.tmpbuf, 0, n3)) == -1) {
                this.entryEOF = true;
                break;
            }
            n2 += n3;
        }
        return n2;
    }
}

