/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import sun.security.action.LoadLibraryAction;

public class ZipFile
implements ZipConstants {
    private long jzfile;
    private String name;
    private int total;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private Vector inflaters = new Vector();

    static {
        AccessController.doPrivileged(new LoadLibraryAction("zip"));
        ZipFile.initIDs();
    }

    public ZipFile(File file) throws ZipException, IOException {
        this(file.getPath());
    }

    public ZipFile(String string) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        this.jzfile = ZipFile.open(string);
        this.name = string;
        this.total = ZipFile.getTotal(this.jzfile);
    }

    public void close() throws IOException {
        if (this.jzfile != 0L) {
            long l = this.jzfile;
            this.jzfile = 0L;
            ZipFile.close(l);
            Vector vector = this.inflaters;
            synchronized (vector) {
                int n = this.inflaters.size();
                int n2 = 0;
                while (n2 < n) {
                    Inflater inflater = (Inflater)this.inflaters.get(n2);
                    inflater.end();
                    ++n2;
                }
            }
        }
    }

    private static native void close(long var0);

    public Enumeration entries() {
        if (this.jzfile == 0L) {
            throw new IllegalStateException("zip file closed");
        }
        return new Enumeration(){
            private int i = 0;

            public boolean hasMoreElements() {
                return this.i < ZipFile.this.total;
            }

            public Object nextElement() throws NoSuchElementException {
                if (this.i >= ZipFile.this.total) {
                    throw new NoSuchElementException();
                }
                long l = ZipFile.getNextEntry(ZipFile.this.jzfile, this.i++);
                if (l == 0L) {
                    throw new InternalError("jzentry == 0");
                }
                return new ZipEntry(l);
            }
        };
    }

    private static native int getCSize(long var0);

    private static native long getEntry(long var0, String var2);

    public ZipEntry getEntry(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (this.jzfile == 0L) {
            throw new IllegalStateException("zip file closed");
        }
        long l = ZipFile.getEntry(this.jzfile, string);
        if (l != 0L) {
            return new ZipEntry(string, l);
        }
        return null;
    }

    private Inflater getInflater() {
        Vector vector = this.inflaters;
        synchronized (vector) {
            int n = this.inflaters.size();
            if (n > 0) {
                Inflater inflater = (Inflater)this.inflaters.remove(n - 1);
                inflater.reset();
                Inflater inflater2 = inflater;
                Object var3_6 = null;
                return inflater2;
            }
            Inflater inflater = new Inflater(true);
            Object var3_7 = null;
            return inflater;
        }
    }

    private InputStream getInputStream(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (this.jzfile == 0L) {
            throw new IllegalStateException("zip file closed");
        }
        long l = ZipFile.getEntry(this.jzfile, string);
        if (l == 0L) {
            return null;
        }
        ZipFileInputStream zipFileInputStream = new ZipFileInputStream(this.jzfile, l);
        switch (ZipFile.getMethod(l)) {
            case 0: {
                return zipFileInputStream;
            }
            case 8: {
                return new InflaterInputStream(zipFileInputStream, this.getInflater()){
                    private boolean eof;

                    public void close() {
                        ZipFile.this.releaseInflater(this.inf);
                    }

                    protected void fill() throws IOException {
                        if (this.eof) {
                            throw new EOFException("Unexpected end of ZLIB input stream");
                        }
                        this.len = this.in.read(this.buf, 0, this.buf.length);
                        if (this.len == -1) {
                            this.buf[0] = 0;
                            this.len = 1;
                            this.eof = true;
                        }
                        this.inf.setInput(this.buf, 0, this.len);
                    }
                };
            }
        }
        throw new ZipException("invalid compression method");
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return this.getInputStream(zipEntry.name);
    }

    private static native int getMethod(long var0);

    public String getName() {
        return this.name;
    }

    private static native long getNextEntry(long var0, int var2);

    private static native int getTotal(long var0);

    private static native void initIDs();

    private static native long open(String var0);

    private static native int read(long var0, long var2, int var4, byte[] var5, int var6, int var7);

    private void releaseInflater(Inflater inflater) {
        Vector vector = this.inflaters;
        synchronized (vector) {
            this.inflaters.add(inflater);
        }
    }

    public int size() {
        if (this.jzfile == 0L) {
            throw new IllegalStateException("zip file closed");
        }
        return this.total;
    }

    private static class ZipFileInputStream
    extends InputStream {
        private long jzfile;
        private long jzentry;
        private int pos;
        private int rem;

        ZipFileInputStream(long l, long l2) {
            this.jzfile = l;
            this.jzentry = l2;
            this.pos = 0;
            this.rem = ZipFile.getCSize(l2);
        }

        public int available() {
            return this.rem;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) == 1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.rem == 0) {
                return -1;
            }
            if (n2 <= 0) {
                return 0;
            }
            if (n2 > this.rem) {
                n2 = this.rem;
            }
            if ((n2 = ZipFile.read(this.jzfile, this.jzentry, this.pos, byArray, n, n2)) > 0) {
                this.pos += n2;
                this.rem -= n2;
            }
            return n2;
        }

        public long skip(long l) {
            int n = l > (long)this.rem ? this.rem : (int)l;
            this.pos += n;
            this.rem -= n;
            return n;
        }
    }
}

