/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.security.AccessController;
import java.util.zip.DataFormatException;
import sun.security.action.LoadLibraryAction;

public class Inflater {
    private long strm;
    private byte[] buf = new byte[0];
    private int off;
    private int len;
    private boolean finished;
    private boolean needDict;

    static {
        AccessController.doPrivileged(new LoadLibraryAction("zip"));
        Inflater.initIDs();
    }

    public Inflater() {
        this(false);
    }

    public Inflater(boolean bl) {
        this.strm = Inflater.init(bl);
    }

    public synchronized void end() {
        if (this.strm != 0L) {
            Inflater.end(this.strm);
            this.strm = 0L;
        }
    }

    private static native void end(long var0);

    protected void finalize() {
        this.end();
    }

    public synchronized boolean finished() {
        return this.finished;
    }

    public synchronized int getAdler() {
        if (this.strm == 0L) {
            throw new NullPointerException();
        }
        return Inflater.getAdler(this.strm);
    }

    private static native int getAdler(long var0);

    public synchronized int getRemaining() {
        return this.len;
    }

    public synchronized int getTotalIn() {
        if (this.strm == 0L) {
            throw new NullPointerException();
        }
        return Inflater.getTotalIn(this.strm);
    }

    private static native int getTotalIn(long var0);

    public synchronized int getTotalOut() {
        if (this.strm == 0L) {
            throw new NullPointerException();
        }
        return Inflater.getTotalOut(this.strm);
    }

    private static native int getTotalOut(long var0);

    public int inflate(byte[] byArray) throws DataFormatException {
        return this.inflate(byArray, 0, byArray.length);
    }

    public synchronized int inflate(byte[] byArray, int n, int n2) throws DataFormatException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.inflateBytes(byArray, n, n2);
    }

    private native int inflateBytes(byte[] var1, int var2, int var3) throws DataFormatException;

    private static native long init(boolean var0);

    private static native void initIDs();

    public synchronized boolean needsDictionary() {
        return this.needDict;
    }

    public synchronized boolean needsInput() {
        return this.len <= 0;
    }

    public synchronized void reset() {
        if (this.strm == 0L) {
            throw new NullPointerException();
        }
        Inflater.reset(this.strm);
        this.finished = false;
        this.needDict = false;
        this.len = 0;
        this.off = 0;
    }

    private static native void reset(long var0);

    private static native void setDictionary(long var0, byte[] var2, int var3, int var4);

    public void setDictionary(byte[] byArray) {
        this.setDictionary(byArray, 0, byArray.length);
    }

    public synchronized void setDictionary(byte[] byArray, int n, int n2) {
        if (this.strm == 0L || byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Inflater.setDictionary(this.strm, byArray, n, n2);
        this.needDict = false;
    }

    public void setInput(byte[] byArray) {
        this.setInput(byArray, 0, byArray.length);
    }

    public synchronized void setInput(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.buf = byArray;
        this.off = n;
        this.len = n2;
    }
}

