/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CollationKey;
import java.text.CollationRules;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.text.resources.LocaleData;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class Collator
implements Comparator,
Cloneable {
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int IDENTICAL = 3;
    public static final int NO_DECOMPOSITION = 0;
    public static final int CANONICAL_DECOMPOSITION = 1;
    public static final int FULL_DECOMPOSITION = 2;
    private int strength = 2;
    private int decmp = 1;
    private static Hashtable cache = new Hashtable();
    static final int LESS = -1;
    static final int EQUAL = 0;
    static final int GREATER = 1;
    static final long serialVersionUID = -7718728969026499504L;

    protected Collator() {
    }

    public Object clone() {
        try {
            return (Collator)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int compare(Object object, Object object2) {
        return this.compare((String)object, (String)object2);
    }

    public abstract int compare(String var1, String var2);

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Collator collator = (Collator)object;
        return this.strength == collator.strength && this.decmp == collator.decmp;
    }

    public boolean equals(String string, String string2) {
        return this.compare(string, string2) == 0;
    }

    public static synchronized Locale[] getAvailableLocales() {
        return LocaleData.getAvailableLocales("CollationElements");
    }

    public abstract CollationKey getCollationKey(String var1);

    public synchronized int getDecomposition() {
        return this.decmp;
    }

    public static synchronized Collator getInstance() {
        return Collator.getInstance(Locale.getDefault());
    }

    public static synchronized Collator getInstance(Locale locale) {
        RuleBasedCollator ruleBasedCollator = null;
        ruleBasedCollator = (RuleBasedCollator)cache.get(locale);
        if (ruleBasedCollator != null) {
            return (Collator)ruleBasedCollator.clone();
        }
        String string = "";
        int n = 1;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
            string = resourceBundle.getString("CollationElements");
            n = (Integer)resourceBundle.getObject("CollationDecomp");
        }
        catch (MissingResourceException missingResourceException) {}
        try {
            ruleBasedCollator = new RuleBasedCollator(String.valueOf(CollationRules.DEFAULTRULES) + string, n);
        }
        catch (ParseException parseException) {
            try {
                ruleBasedCollator = new RuleBasedCollator(CollationRules.DEFAULTRULES);
            }
            catch (ParseException parseException2) {}
        }
        ruleBasedCollator.setDecomposition(0);
        cache.put(locale, ruleBasedCollator);
        return (Collator)ruleBasedCollator.clone();
    }

    public synchronized int getStrength() {
        return this.strength;
    }

    public abstract int hashCode();

    public synchronized void setDecomposition(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Wrong decomposition mode.");
        }
        this.decmp = n;
    }

    public synchronized void setStrength(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Incorrect comparison level.");
        }
        this.strength = n;
    }
}

