/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InputStream;
import java.security.Security;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class Provider
extends Properties {
    private String name;
    private String info;
    private double version;
    static final long serialVersionUID = -4298000515446427739L;

    Provider(String string) {
        this(string, 1.0, "no information available");
    }

    protected Provider(String string, double d, String string2) {
        this.name = string;
        this.version = d;
        this.info = string2;
    }

    private static void check(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(string);
        }
    }

    public synchronized void clear() {
        Provider.check("clearProviderProperties." + this.name);
        super.clear();
    }

    private static void debug(String string) {
        Security.debug(string);
    }

    private static void debug(String string, Throwable throwable) {
        Security.debug(string, throwable);
    }

    public Set entrySet() {
        return Collections.unmodifiableMap(this).entrySet();
    }

    public String getInfo() {
        return this.info;
    }

    public String getName() {
        return this.name;
    }

    public double getVersion() {
        return this.version;
    }

    public Set keySet() {
        return Collections.unmodifiableMap(this).keySet();
    }

    public synchronized void load(InputStream inputStream) throws IOException {
        Provider.check("loadProviderProperties." + this.name);
        super.load(inputStream);
    }

    static Provider loadProvider(String string) {
        try {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            Class clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            Object object = clazz.newInstance();
            if (object instanceof Provider) {
                return (Provider)object;
            }
            Provider.debug(String.valueOf(string) + " not a provider");
        }
        catch (Exception exception) {
            Provider.debug("error loading provider " + string, exception);
        }
        return null;
    }

    public synchronized Object put(Object object, Object object2) {
        Provider.check("putProviderProperty." + this.name);
        return super.put(object, object2);
    }

    public synchronized void putAll(Map map) {
        Provider.check("putAllProviderProperties." + this.name);
        super.putAll(map);
    }

    public synchronized Object remove(Object object) {
        Provider.check("removeProviderProperty." + this.name);
        return super.remove(object);
    }

    public String toString() {
        return String.valueOf(this.name) + " version " + this.version;
    }

    public Collection values() {
        return Collections.unmodifiableMap(this).values();
    }
}

