/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.Arrays;
import java.util.Properties;

public final class ActivationGroupDesc
implements Serializable {
    private String className;
    private String location;
    private MarshalledObject data;
    private CommandEnvironment env;
    private Properties props;
    private static final long serialVersionUID = -4936225423168276595L;

    public ActivationGroupDesc(String string, String string2, MarshalledObject marshalledObject, Properties properties, CommandEnvironment commandEnvironment) {
        this.props = properties;
        this.env = commandEnvironment;
        this.data = marshalledObject;
        this.location = string2;
        this.className = string;
    }

    public ActivationGroupDesc(Properties properties, CommandEnvironment commandEnvironment) {
        this("sun.rmi.server.ActivationGroupImpl", null, null, properties, commandEnvironment);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof ActivationGroupDesc)) return false;
        ActivationGroupDesc activationGroupDesc = (ActivationGroupDesc)object;
        if (this.className == null) {
            if (activationGroupDesc.className != null) {
                return false;
            }
        } else {
            boolean bl = this.className.equals(activationGroupDesc.className);
            if (!bl) return false;
        }
        if (this.location == null) {
            if (activationGroupDesc.location != null) {
                return false;
            }
        } else {
            boolean bl = this.location.equals(activationGroupDesc.location);
            if (!bl) return false;
        }
        if (this.data == null) {
            if (activationGroupDesc.data != null) {
                return false;
            }
        } else {
            boolean bl = this.data.equals(activationGroupDesc.data);
            if (!bl) return false;
        }
        if (this.env == null) {
            if (activationGroupDesc.env != null) {
                return false;
            }
        } else {
            boolean bl = this.env.equals(activationGroupDesc.env);
            if (!bl) return false;
        }
        if (this.props == null) {
            if (activationGroupDesc.props == null) return true;
            return false;
        }
        boolean bl = this.props.equals(activationGroupDesc.props);
        if (bl) return true;
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    public CommandEnvironment getCommandEnvironment() {
        return this.env;
    }

    public MarshalledObject getData() {
        return this.data;
    }

    public String getLocation() {
        return this.location;
    }

    public Properties getPropertyOverrides() {
        return this.props != null ? (Properties)this.props.clone() : null;
    }

    public int hashCode() {
        return (this.location == null ? 0 : this.location.hashCode() << 24) ^ (this.env == null ? 0 : this.env.hashCode() << 16) ^ (this.className == null ? 0 : this.className.hashCode() << 8) ^ (this.data == null ? 0 : this.data.hashCode());
    }

    public static class CommandEnvironment
    implements Serializable {
        private String command;
        private String[] options;

        public CommandEnvironment(String string, String[] stringArray) {
            this.command = string;
            if (stringArray == null) {
                this.options = null;
            } else {
                this.options = new String[stringArray.length];
                System.arraycopy(stringArray, 0, this.options, 0, stringArray.length);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof CommandEnvironment)) return false;
            CommandEnvironment commandEnvironment = (CommandEnvironment)object;
            if (this.command == null) {
                if (commandEnvironment.command != null) {
                    return false;
                }
            } else {
                boolean bl = this.command.equals(commandEnvironment.command);
                if (!bl) return false;
            }
            if (Arrays.equals(this.options, commandEnvironment.options)) return true;
            return false;
        }

        public String[] getCommandOptions() {
            return this.options != null ? (String[])this.options.clone() : new String[]{};
        }

        public String getCommandPath() {
            return this.command;
        }

        public int hashCode() {
            return this.command == null ? 0 : this.command.hashCode();
        }
    }
}

