/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public final class Naming {
    private Naming() {
    }

    public static void bind(String string, Remote remote) throws AlreadyBoundException, MalformedURLException, RemoteException {
        URL uRL = Naming.cleanURL(string);
        Registry registry = Naming.getRegistry(uRL);
        if (remote == null) {
            throw new NullPointerException("cannot bind to null");
        }
        registry.bind(Naming.getName(uRL), remote);
    }

    private static URL cleanURL(String string) throws MalformedURLException {
        int n;
        URL uRL = new URL("http:");
        if (string.indexOf(35) >= 0) {
            throw new MalformedURLException("Invalid character, '#', in URL: " + string);
        }
        if (string.startsWith("rmi:")) {
            string = string.substring(4);
        }
        if ((n = string.indexOf(58)) >= 0 && n < string.indexOf(47)) {
            throw new MalformedURLException("No protocol needed");
        }
        uRL = new URL(uRL, string);
        return uRL;
    }

    private static String getName(URL uRL) {
        String string = uRL.getFile();
        if (string == null || string.equals("/")) {
            return null;
        }
        return string.substring(1);
    }

    private static Registry getRegistry(URL uRL) throws RemoteException {
        String string = uRL.getHost();
        int n = uRL.getPort();
        return LocateRegistry.getRegistry(string, n);
    }

    public static String[] list(String string) throws RemoteException, MalformedURLException {
        URL uRL = Naming.cleanURL(string);
        Registry registry = Naming.getRegistry(uRL);
        String string2 = uRL.getHost();
        int n = uRL.getPort();
        String string3 = "rmi:";
        if (n > 0 || !string2.equals("")) {
            string3 = String.valueOf(string3) + "//" + string2;
        }
        if (n > 0) {
            string3 = String.valueOf(string3) + ":" + n;
        }
        string3 = String.valueOf(string3) + "/";
        String[] stringArray = registry.list();
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = String.valueOf(string3) + stringArray[n2];
            ++n2;
        }
        return stringArray;
    }

    public static Remote lookup(String string) throws NotBoundException, MalformedURLException, RemoteException {
        URL uRL = Naming.cleanURL(string);
        Registry registry = Naming.getRegistry(uRL);
        String string2 = Naming.getName(uRL);
        if (string2 == null) {
            return registry;
        }
        return registry.lookup(string2);
    }

    public static void rebind(String string, Remote remote) throws RemoteException, MalformedURLException {
        URL uRL = Naming.cleanURL(string);
        Registry registry = Naming.getRegistry(uRL);
        if (remote == null) {
            throw new NullPointerException("cannot bind to null");
        }
        registry.rebind(Naming.getName(uRL), remote);
    }

    public static void unbind(String string) throws RemoteException, NotBoundException, MalformedURLException {
        URL uRL = Naming.cleanURL(string);
        Registry registry = Naming.getRegistry(uRL);
        registry.unbind(Naming.getName(uRL));
    }
}

