/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.FileNameMap;
import java.net.URL;
import java.net.UnknownContentHandler;
import java.net.UnknownServiceException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import sun.security.action.GetPropertyAction;

public abstract class URLConnection {
    protected URL url;
    protected boolean doInput = true;
    protected boolean doOutput = false;
    private static boolean defaultAllowUserInteraction = false;
    protected boolean allowUserInteraction = defaultAllowUserInteraction;
    private static boolean defaultUseCaches = true;
    protected boolean useCaches = defaultUseCaches;
    protected long ifModifiedSince = 0L;
    protected boolean connected = false;
    private static FileNameMap fileNameMap;
    static ContentHandlerFactory factory;
    private static Hashtable handlers;
    private static final ContentHandler UnknownContentHandlerP;
    private static final String contentClassPrefix = "sun.net.www.content";
    private static final String contentPathProp = "java.content.handler.pkgs";

    static {
        handlers = new Hashtable();
        UnknownContentHandlerP = new UnknownContentHandler();
    }

    protected URLConnection(URL uRL) {
        this.url = uRL;
    }

    private static boolean checkfpx(InputStream inputStream) throws IOException {
        int n;
        int n2;
        inputStream.mark(256);
        long l = 28L;
        long l2 = 0L;
        while (l2 != l) {
            l2 += inputStream.skip(l - l2);
        }
        long l3 = l2;
        int n3 = inputStream.read();
        inputStream.read();
        l3 += 2L;
        if (n3 == 254) {
            n2 = inputStream.read();
            n2 += inputStream.read() << 8;
        } else {
            n2 = inputStream.read() << 8;
            n2 += inputStream.read();
        }
        l = 48L - (l3 += 2L);
        l2 = 0L;
        while (l2 != l) {
            l2 += inputStream.skip(l - l2);
        }
        l3 += l2;
        if (n3 == 254) {
            n = inputStream.read();
            n += inputStream.read() << 8;
            n += inputStream.read() << 16;
            n += inputStream.read() << 24;
        } else {
            n = inputStream.read() << 24;
            n += inputStream.read() << 16;
            n += inputStream.read() << 8;
            n += inputStream.read();
        }
        l3 += 4L;
        inputStream.reset();
        l = 512L + (long)(1 << n2) * (long)n + 80L;
        inputStream.mark((int)l + 48);
        l2 = 0L;
        while (l2 != l) {
            l2 += inputStream.skip(l - l2);
        }
        int[] nArray = new int[16];
        int n4 = 0;
        while (n4 < 16) {
            nArray[n4] = inputStream.read();
            ++n4;
        }
        if (n3 == 254 && nArray[0] == 0 && nArray[2] == 97 && nArray[3] == 86 && nArray[4] == 84 && nArray[5] == 193 && nArray[6] == 206 && nArray[7] == 17 && nArray[8] == 133 && nArray[9] == 83 && nArray[10] == 0 && nArray[11] == 170 && nArray[12] == 0 && nArray[13] == 161 && nArray[14] == 249 && nArray[15] == 91) {
            inputStream.reset();
            return true;
        }
        if (nArray[3] == 0 && nArray[1] == 97 && nArray[0] == 86 && nArray[5] == 84 && nArray[4] == 193 && nArray[7] == 206 && nArray[6] == 17 && nArray[8] == 133 && nArray[9] == 83 && nArray[10] == 0 && nArray[11] == 170 && nArray[12] == 0 && nArray[13] == 161 && nArray[14] == 249 && nArray[15] == 91) {
            inputStream.reset();
            return true;
        }
        inputStream.reset();
        return false;
    }

    public abstract void connect() throws IOException;

    public boolean getAllowUserInteraction() {
        return this.allowUserInteraction;
    }

    public Object getContent() throws IOException {
        this.getInputStream();
        return this.getContentHandler().getContent(this);
    }

    public String getContentEncoding() {
        return this.getHeaderField("content-encoding");
    }

    synchronized ContentHandler getContentHandler() throws UnknownServiceException {
        String string = this.getContentType();
        ContentHandler contentHandler = null;
        if (string == null) {
            throw new UnknownServiceException("no content-type");
        }
        try {
            contentHandler = (ContentHandler)handlers.get(string);
            if (contentHandler != null) {
                return contentHandler;
            }
        }
        catch (Exception exception) {}
        if (factory != null) {
            contentHandler = factory.createContentHandler(string);
        }
        if (contentHandler == null) {
            try {
                contentHandler = this.lookupContentHandlerClassFor(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                contentHandler = UnknownContentHandlerP;
            }
            handlers.put(string, contentHandler);
        }
        return contentHandler;
    }

    private String getContentHandlerPkgPrefixes() {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction(contentPathProp, ""));
        if (string != "") {
            string = String.valueOf(string) + "|";
        }
        return String.valueOf(string) + contentClassPrefix;
    }

    public int getContentLength() {
        return this.getHeaderFieldInt("content-length", -1);
    }

    public String getContentType() {
        return this.getHeaderField("content-type");
    }

    public long getDate() {
        return this.getHeaderFieldDate("date", 0L);
    }

    public static boolean getDefaultAllowUserInteraction() {
        return defaultAllowUserInteraction;
    }

    public static String getDefaultRequestProperty(String string) {
        return null;
    }

    public boolean getDefaultUseCaches() {
        return defaultUseCaches;
    }

    public boolean getDoInput() {
        return this.doInput;
    }

    public boolean getDoOutput() {
        return this.doOutput;
    }

    public long getExpiration() {
        return this.getHeaderFieldDate("expires", 0L);
    }

    public static FileNameMap getFileNameMap() {
        return new FileNameMap(){

            public String getContentTypeFor(String string) {
                return fileNameMap.getContentTypeFor(string);
            }
        };
    }

    public String getHeaderField(int n) {
        return null;
    }

    public String getHeaderField(String string) {
        return null;
    }

    public long getHeaderFieldDate(String string, long l) {
        try {
            return Date.parse(this.getHeaderField(string));
        }
        catch (Throwable throwable) {
            return l;
        }
    }

    public int getHeaderFieldInt(String string, int n) {
        try {
            return Integer.parseInt(this.getHeaderField(string));
        }
        catch (Throwable throwable) {
            return n;
        }
    }

    public String getHeaderFieldKey(int n) {
        return null;
    }

    public long getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public InputStream getInputStream() throws IOException {
        throw new UnknownServiceException("protocol doesn't support input");
    }

    public long getLastModified() {
        return this.getHeaderFieldDate("last-modified", 0L);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException("protocol doesn't support output");
    }

    public Permission getPermission() throws IOException {
        return new AllPermission();
    }

    public String getRequestProperty(String string) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        return null;
    }

    public URL getURL() {
        return this.url;
    }

    public boolean getUseCaches() {
        return this.useCaches;
    }

    protected static String guessContentTypeFromName(String string) {
        String string2 = null;
        if (fileNameMap != null) {
            string2 = fileNameMap.getContentTypeFor(string);
        }
        return string2;
    }

    public static String guessContentTypeFromStream(InputStream inputStream) throws IOException {
        inputStream.mark(10);
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        int n5 = inputStream.read();
        int n6 = inputStream.read();
        int n7 = inputStream.read();
        int n8 = inputStream.read();
        inputStream.reset();
        if (n == 202 && n2 == 254 && n3 == 186 && n4 == 190) {
            return "application/java-vm";
        }
        if (n == 172 && n2 == 237) {
            return "application/x-java-serialized-object";
        }
        if (n == 71 && n2 == 73 && n3 == 70 && n4 == 56) {
            return "image/gif";
        }
        if (n == 35 && n2 == 100 && n3 == 101 && n4 == 102) {
            return "image/x-bitmap";
        }
        if (n == 33 && n2 == 32 && n3 == 88 && n4 == 80 && n5 == 77 && n6 == 50) {
            return "image/x-pixmap";
        }
        if (n == 46 && n2 == 115 && n3 == 110 && n4 == 100) {
            return "audio/basic";
        }
        if (n == 100 && n2 == 110 && n3 == 115 && n4 == 46) {
            return "audio/basic";
        }
        if (n == 60 && (n2 == 33 || n2 == 104 && (n3 == 116 && n4 == 109 && n5 == 108 || n3 == 101 && n4 == 97 && n5 == 100) || n2 == 98 && n3 == 111 && n4 == 100 && n5 == 121 || n2 == 72 && (n3 == 84 && n4 == 77 && n5 == 76 || n3 == 69 && n4 == 65 && n5 == 68) || n2 == 66 && n3 == 79 && n4 == 68 && n5 == 89)) {
            return "text/html";
        }
        if (n == 255 && n2 == 216 && n3 == 255 && n4 == 224) {
            return "image/jpeg";
        }
        if (n == 255 && n2 == 216 && n3 == 255 && n4 == 238) {
            return "image/jpg";
        }
        if (n == 82 && n2 == 73 && n3 == 70 && n4 == 70) {
            return "audio/x-wav";
        }
        if (n == 208 && n2 == 207 && n3 == 17 && n4 == 224 && n5 == 161 && n6 == 177 && n7 == 26 && n8 == 225 && URLConnection.checkfpx(inputStream)) {
            return "image/vnd.fpx";
        }
        return null;
    }

    private ContentHandler lookupContentHandlerClassFor(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String string2 = this.typeToPackageName(string);
        String string3 = this.getContentHandlerPkgPrefixes();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            try {
                String string5 = String.valueOf(string4) + "." + string2;
                ContentHandler contentHandler = (ContentHandler)Class.forName(string5).newInstance();
                return contentHandler;
            }
            catch (Exception exception) {}
        }
        return UnknownContentHandlerP;
    }

    public void setAllowUserInteraction(boolean bl) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        this.allowUserInteraction = bl;
    }

    public static synchronized void setContentHandlerFactory(ContentHandlerFactory contentHandlerFactory) {
        if (factory != null) {
            throw new Error("factory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = contentHandlerFactory;
    }

    public static void setDefaultAllowUserInteraction(boolean bl) {
        defaultAllowUserInteraction = bl;
    }

    public static void setDefaultRequestProperty(String string, String string2) {
    }

    public void setDefaultUseCaches(boolean bl) {
        defaultUseCaches = bl;
    }

    public void setDoInput(boolean bl) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        this.doInput = bl;
    }

    public void setDoOutput(boolean bl) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        this.doOutput = bl;
    }

    public static void setFileNameMap(FileNameMap fileNameMap) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        URLConnection.fileNameMap = fileNameMap;
    }

    public void setIfModifiedSince(long l) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        this.ifModifiedSince = l;
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
    }

    public void setUseCaches(boolean bl) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        this.useCaches = bl;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ":" + this.url;
    }

    private String typeToPackageName(String string) {
        string = string.toLowerCase();
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '/') {
                cArray[n2] = 46;
            } else if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9')) {
                cArray[n2] = 95;
            }
            ++n2;
        }
        return new String(cArray);
    }
}

