/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.SocketException;

public class MulticastSocket
extends DatagramSocket {
    private Object ttlLock = new Object();

    public MulticastSocket() throws IOException {
    }

    public MulticastSocket(int n) throws IOException {
        super(n);
    }

    void create(int n, InetAddress inetAddress) throws SocketException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkListen(n);
        }
        try {
            this.impl = (DatagramSocketImpl)DatagramSocket.implClass.newInstance();
        }
        catch (Exception exception) {
            throw new SocketException("can't instantiate DatagramSocketImpl" + exception.toString());
        }
        this.impl.create();
        this.impl.setOption(4, new Integer(-1));
        this.impl.bind(n, InetAddress.anyLocalAddress);
    }

    public InetAddress getInterface() throws SocketException {
        return (InetAddress)this.impl.getOption(16);
    }

    public byte getTTL() throws IOException {
        int n = this.getTimeToLive();
        if (n > 127) {
            return 127;
        }
        return (byte)n;
    }

    public int getTimeToLive() throws IOException {
        return this.impl.getTimeToLive();
    }

    public void joinGroup(InetAddress inetAddress) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMulticast(inetAddress);
        }
        this.impl.join(inetAddress);
    }

    public void leaveGroup(InetAddress inetAddress) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMulticast(inetAddress);
        }
        this.impl.leave(inetAddress);
    }

    public void send(DatagramPacket datagramPacket, byte by) throws IOException {
        Object object = this.ttlLock;
        synchronized (object) {
            DatagramPacket datagramPacket2 = datagramPacket;
            synchronized (datagramPacket2) {
                Object object2;
                if (!this.connected) {
                    object2 = System.getSecurityManager();
                    if (object2 != null) {
                        if (datagramPacket.getAddress().isMulticastAddress()) {
                            ((SecurityManager)object2).checkMulticast(datagramPacket.getAddress(), by);
                        } else {
                            ((SecurityManager)object2).checkConnect(datagramPacket.getAddress().getHostAddress(), datagramPacket.getPort());
                        }
                    }
                } else {
                    object2 = null;
                    object2 = datagramPacket.getAddress();
                    if (object2 == null) {
                        datagramPacket.setAddress(this.connectedAddress);
                        datagramPacket.setPort(this.connectedPort);
                    } else if (!((InetAddress)object2).equals(this.connectedAddress) || datagramPacket.getPort() != this.connectedPort) {
                        throw new SecurityException("connected address and packet address differ");
                    }
                }
                byte by2 = this.getTTL();
                try {
                    if (by != by2) {
                        this.impl.setTTL(by);
                    }
                    this.impl.send(datagramPacket);
                }
                finally {
                    Object var9_7 = null;
                    if (by != by2) {
                        this.impl.setTTL(by2);
                    }
                }
            }
        }
    }

    public void setInterface(InetAddress inetAddress) throws SocketException {
        this.impl.setOption(16, inetAddress);
    }

    public void setTTL(byte by) throws IOException {
        int n = -1;
        n = by < 0 ? by & 0xFF : (int)by;
        this.setTimeToLive(n);
    }

    public void setTimeToLive(int n) throws IOException {
        if (n < 1 || n > 255) {
            throw new IllegalArgumentException("ttl out of range");
        }
        this.impl.setTimeToLive(n);
    }
}

