/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class Constructor
extends AccessibleObject
implements Member {
    private Class clazz;
    private int slot;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;
    private int modifiers;

    private Constructor() {
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Constructor) {
            Class[] classArray;
            Class[] classArray2;
            Constructor constructor = (Constructor)object;
            if (this.getDeclaringClass() == constructor.getDeclaringClass() && (classArray2 = this.parameterTypes).length == (classArray = constructor.parameterTypes).length) {
                int n = 0;
                while (n < classArray2.length) {
                    if (classArray2[n] != classArray[n]) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    public Class getDeclaringClass() {
        return this.clazz;
    }

    public Class[] getExceptionTypes() {
        return Method.copy(this.exceptionTypes);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.getDeclaringClass().getName();
    }

    public Class[] getParameterTypes() {
        return Method.copy(this.parameterTypes);
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode();
    }

    public native Object newInstance(Object[] var1) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.getModifiers();
            if (n != 0) {
                stringBuffer.append(String.valueOf(Modifier.toString(n)) + " ");
            }
            stringBuffer.append(Field.getTypeName(this.getDeclaringClass()));
            stringBuffer.append("(");
            Class[] classArray = this.parameterTypes;
            int n2 = 0;
            while (n2 < classArray.length) {
                stringBuffer.append(Field.getTypeName(classArray[n2]));
                if (n2 < classArray.length - 1) {
                    stringBuffer.append(",");
                }
                ++n2;
            }
            stringBuffer.append(")");
            Class[] classArray2 = this.exceptionTypes;
            if (classArray2.length > 0) {
                stringBuffer.append(" throws ");
                int n3 = 0;
                while (n3 < classArray2.length) {
                    stringBuffer.append(classArray2[n3].getName());
                    if (n3 < classArray2.length - 1) {
                        stringBuffer.append(",");
                    }
                    ++n3;
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }
}

