/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Byte
extends Number
implements Comparable {
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class TYPE = Class.getPrimitiveClass("byte");
    private byte value;
    private static final long serialVersionUID = -7183698231559129828L;

    public Byte(byte by) {
        this.value = by;
    }

    public Byte(String string) throws NumberFormatException {
        this.value = Byte.parseByte(string);
    }

    public byte byteValue() {
        return this.value;
    }

    public int compareTo(Byte by) {
        return this.value - by.value;
    }

    public int compareTo(Object object) {
        return this.compareTo((Byte)object);
    }

    public static Byte decode(String string) throws NumberFormatException {
        if (string.startsWith("0x")) {
            return Byte.valueOf(string.substring(2), 16);
        }
        if (string.startsWith("#")) {
            return Byte.valueOf(string.substring(1), 16);
        }
        if (string.startsWith("0") && string.length() > 1) {
            return Byte.valueOf(string.substring(1), 8);
        }
        return Byte.valueOf(string);
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Byte) {
            return this.value == (Byte)object;
        }
        return false;
    }

    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public static byte parseByte(String string) throws NumberFormatException {
        return Byte.parseByte(string, 10);
    }

    public static byte parseByte(String string, int n) throws NumberFormatException {
        int n2 = Integer.parseInt(string, n);
        if (n2 < -128 || n2 > 127) {
            throw new NumberFormatException();
        }
        return (byte)n2;
    }

    public short shortValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static String toString(byte by) {
        return Integer.toString(by, 10);
    }

    public static Byte valueOf(String string) throws NumberFormatException {
        return Byte.valueOf(string, 10);
    }

    public static Byte valueOf(String string, int n) throws NumberFormatException {
        return new Byte(Byte.parseByte(string, n));
    }
}

