/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;

public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private boolean blockDataMode;
    private byte[] buf;
    private int count;
    private OutputStream out;
    private DataOutputStream dos;
    private IOException abortIOException = null;
    private ArrayList wireHandle2Object;
    private int nextWireOffset;
    private int[] wireHash2Handle;
    private int[] wireNextHandle;
    private int wireHashSizePower = 2;
    private int wireHashLoadFactor = 7;
    private int wireHashCapacity = (1 << this.wireHashSizePower) * this.wireHashLoadFactor;
    private Object currentObject;
    private ObjectStreamClass currentClassDesc;
    private Stack classDescStack;
    private PutField currentPutFields;
    private Object[] writeObjectArglist = new Object[]{this};
    boolean enableReplace;
    private Object[] replaceObjects;
    private int nextReplaceOffset;
    private static final boolean REPLACEABLE = true;
    private static final boolean NOT_REPLACEABLE = false;
    private int recursionDepth = 0;
    boolean useDeprecatedExternalizableFormat = false;
    private boolean enableSubclassImplementation;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    protected ObjectOutputStream() throws IOException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ObjectStreamConstants.SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.enableSubclassImplementation = true;
    }

    public ObjectOutputStream(OutputStream outputStream) throws IOException {
        this.enableSubclassImplementation = false;
        this.out = outputStream;
        this.dos = new DataOutputStream(this);
        this.buf = new byte[1024];
        this.writeStreamHeader();
        this.resetStream();
    }

    private void addReplacement(Object object, Object object2) {
        if (this.replaceObjects == null) {
            this.replaceObjects = new Object[10];
        }
        if (this.nextReplaceOffset == this.replaceObjects.length) {
            Object[] objectArray = this.replaceObjects;
            this.replaceObjects = new Object[2 + this.nextReplaceOffset * 2];
            System.arraycopy(objectArray, 0, this.replaceObjects, 0, this.nextReplaceOffset);
        }
        this.replaceObjects[this.nextReplaceOffset++] = object;
        this.replaceObjects[this.nextReplaceOffset++] = object2;
    }

    protected void annotateClass(Class clazz) throws IOException {
    }

    private void assignWireOffset(Object object) throws IOException {
        if (this.nextWireOffset == this.wireNextHandle.length) {
            int[] nArray = this.wireNextHandle;
            this.wireNextHandle = new int[this.nextWireOffset * 2];
            System.arraycopy(nArray, 0, this.wireNextHandle, 0, this.nextWireOffset);
        }
        if (this.nextWireOffset >= this.wireHashCapacity) {
            this.growWireHash2Handle();
        }
        this.wireHandle2Object.add(object);
        this.hashInsert(object, this.nextWireOffset);
        ++this.nextWireOffset;
    }

    private void bufferedWrite(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        int n4 = this.buf.length - this.count;
        if (n3 > n4) {
            System.arraycopy(byArray, n, this.buf, this.count, n4);
            n += n4;
            n3 -= n4;
            this.out.write(this.buf, 0, this.buf.length);
            this.count = 0;
            while (n3 >= this.buf.length) {
                System.arraycopy(byArray, n, this.buf, 0, this.buf.length);
                this.out.write(this.buf, 0, this.buf.length);
                n += this.buf.length;
                n3 -= this.buf.length;
            }
        }
        if (n3 != 0) {
            System.arraycopy(byArray, n, this.buf, this.count, n3);
            this.count += n3;
        }
    }

    private boolean checkSpecialClasses(Object object) throws IOException {
        if (object instanceof Class) {
            this.outputClass((Class)object);
            return true;
        }
        if (object instanceof ObjectStreamClass) {
            this.outputClassDescriptor((ObjectStreamClass)object);
            return true;
        }
        return false;
    }

    private boolean checkSubstitutableSpecialClasses(Object object, Class clazz) throws IOException {
        if (clazz == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ObjectOutputStream.class$("java.lang.String")))) {
            this.outputString((String)object);
            return true;
        }
        if (clazz.isArray()) {
            this.outputArray(object);
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public void defaultWriteObject() throws IOException {
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("defaultWriteObject");
        }
        ObjectStreamField[] objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
        if (objectStreamFieldArray.length > 0) {
            boolean bl = this.setBlockData(false);
            this.outputClassFields(this.currentObject, this.currentClassDesc.forClass(), objectStreamFieldArray);
            this.setBlockData(bl);
        }
    }

    protected void drain() throws IOException {
        if (this.count == 0) {
            return;
        }
        if (this.blockDataMode) {
            this.writeBlockDataHeader(this.count);
        }
        this.out.write(this.buf, 0, this.count);
        this.count = 0;
    }

    protected boolean enableReplaceObject(boolean bl) throws SecurityException {
        boolean bl2 = this.enableReplace;
        if (bl) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(ObjectStreamConstants.SUBSTITUTION_PERMISSION);
            }
            this.enableReplace = true;
        } else {
            this.enableReplace = false;
        }
        return bl2;
    }

    private int findWireOffset(Object object) {
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % this.wireHash2Handle.length;
        int n3 = this.wireHash2Handle[n2];
        while (n3 >= 0) {
            if (this.wireHandle2Object.get(n3) == object) {
                return n3;
            }
            n3 = this.wireNextHandle[n3];
        }
        return -1;
    }

    public void flush() throws IOException {
        this.drain();
        this.out.flush();
    }

    private void growWireHash2Handle() {
        ++this.wireHashSizePower;
        this.wireHash2Handle = new int[(1 << this.wireHashSizePower) - 1];
        Arrays.fill(this.wireHash2Handle, -1);
        int n = 0;
        while (n < this.nextWireOffset) {
            this.wireNextHandle[n] = 0;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.wireHandle2Object.size()) {
            this.hashInsert(this.wireHandle2Object.get(n2), n2);
            ++n2;
        }
        this.wireHashCapacity = (1 << this.wireHashSizePower) * this.wireHashLoadFactor;
    }

    private void hashInsert(Object object, int n) {
        int n2 = System.identityHashCode(object);
        int n3 = (n2 & Integer.MAX_VALUE) % this.wireHash2Handle.length;
        this.wireNextHandle[n] = this.wireHash2Handle[n3];
        this.wireHash2Handle[n3] = n;
    }

    private void invokeObjectWriter(Object object) throws IOException {
        try {
            this.currentClassDesc.writeObjectMethod.invoke(object, this.writeObjectArglist);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error("interal error");
        }
        catch (IllegalAccessException illegalAccessException) {}
    }

    private Object lookupReplace(Object object) {
        int n = 0;
        while (n < this.nextReplaceOffset) {
            if (this.replaceObjects[n] == object) {
                return this.replaceObjects[n + 1];
            }
            n += 2;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void outputArray(Object object) throws IOException {
        Class clazz = this.currentClassDesc.forClass();
        this.writeCode(117);
        this.outputClassDescriptor(this.currentClassDesc);
        this.assignWireOffset(object);
        Class clazz2 = clazz.getComponentType();
        if (clazz2.isPrimitive()) {
            if (clazz2 == Integer.TYPE) {
                int[] nArray = (int[])object;
                int n = nArray.length;
                this.writeInt(n);
                int n2 = 0;
                while (n2 < n) {
                    this.writeInt(nArray[n2]);
                    ++n2;
                }
                return;
            } else if (clazz2 == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                int n = byArray.length;
                this.writeInt(n);
                this.writeInternal(byArray, 0, n, true);
                return;
            } else if (clazz2 == Long.TYPE) {
                long[] lArray = (long[])object;
                int n = lArray.length;
                this.writeInt(n);
                int n3 = 0;
                while (n3 < n) {
                    this.writeLong(lArray[n3]);
                    ++n3;
                }
                return;
            } else if (clazz2 == Float.TYPE) {
                float[] fArray = (float[])object;
                int n = fArray.length;
                this.writeInt(n);
                int n4 = 0;
                while (n4 < n) {
                    this.writeFloat(fArray[n4]);
                    ++n4;
                }
                return;
            } else if (clazz2 == Double.TYPE) {
                double[] dArray = (double[])object;
                int n = dArray.length;
                this.writeInt(n);
                int n5 = 0;
                while (n5 < n) {
                    this.writeDouble(dArray[n5]);
                    ++n5;
                }
                return;
            } else if (clazz2 == Short.TYPE) {
                short[] sArray = (short[])object;
                int n = sArray.length;
                this.writeInt(n);
                int n6 = 0;
                while (n6 < n) {
                    this.writeShort(sArray[n6]);
                    ++n6;
                }
                return;
            } else if (clazz2 == Character.TYPE) {
                char[] cArray = (char[])object;
                int n = cArray.length;
                this.writeInt(n);
                int n7 = 0;
                while (n7 < n) {
                    this.writeChar(cArray[n7]);
                    ++n7;
                }
                return;
            } else {
                if (clazz2 != Boolean.TYPE) throw new InvalidClassException(clazz.getName());
                boolean[] blArray = (boolean[])object;
                int n = blArray.length;
                this.writeInt(n);
                int n8 = 0;
                while (n8 < n) {
                    this.writeBoolean(blArray[n8]);
                    ++n8;
                }
            }
            return;
        } else {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            this.writeInt(n);
            int n9 = 0;
            while (n9 < n) {
                this.writeObject(objectArray[n9]);
                ++n9;
            }
        }
    }

    private void outputClass(Class clazz) throws IOException {
        this.writeCode(118);
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookupInternal(clazz);
        if (objectStreamClass == null) {
            throw new NotSerializableException(clazz.getName());
        }
        this.outputClassDescriptor(objectStreamClass);
        this.assignWireOffset(clazz);
    }

    private void outputClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
        if (this.serializeNullAndRepeat(objectStreamClass, false)) {
            return;
        }
        this.writeCode(114);
        String string = objectStreamClass.getName();
        this.writeUTF(string);
        this.writeLong(objectStreamClass.getSerialVersionUID());
        this.assignWireOffset(objectStreamClass);
        objectStreamClass.write(this);
        boolean bl = this.setBlockData(true);
        this.annotateClass(objectStreamClass.forClass());
        this.setBlockData(bl);
        this.writeCode(120);
        ObjectStreamClass objectStreamClass2 = objectStreamClass.getSuperclass();
        this.outputClassDescriptor(objectStreamClass2);
    }

    private void outputClassFields(Object object, Class clazz, ObjectStreamField[] objectStreamFieldArray) throws IOException, InvalidClassException {
        int n = 0;
        while (n < objectStreamFieldArray.length) {
            if (objectStreamFieldArray[n].getField() == null) {
                throw new InvalidClassException(clazz.getName(), "Nonexistent field " + objectStreamFieldArray[n].getName());
            }
            try {
                switch (objectStreamFieldArray[n].getTypeCode()) {
                    case 'B': {
                        byte by = objectStreamFieldArray[n].getField().getByte(object);
                        this.writeByte(by);
                        break;
                    }
                    case 'C': {
                        char c = objectStreamFieldArray[n].getField().getChar(object);
                        this.writeChar(c);
                        break;
                    }
                    case 'F': {
                        float f = objectStreamFieldArray[n].getField().getFloat(object);
                        this.writeFloat(f);
                        break;
                    }
                    case 'D': {
                        double d = objectStreamFieldArray[n].getField().getDouble(object);
                        this.writeDouble(d);
                        break;
                    }
                    case 'I': {
                        int n2 = objectStreamFieldArray[n].getField().getInt(object);
                        this.writeInt(n2);
                        break;
                    }
                    case 'J': {
                        long l = objectStreamFieldArray[n].getField().getLong(object);
                        this.writeLong(l);
                        break;
                    }
                    case 'S': {
                        short s = objectStreamFieldArray[n].getField().getShort(object);
                        this.writeShort(s);
                        break;
                    }
                    case 'Z': {
                        boolean bl = objectStreamFieldArray[n].getField().getBoolean(object);
                        this.writeBoolean(bl);
                        break;
                    }
                    case 'L': 
                    case '[': {
                        Object object2 = objectStreamFieldArray[n].getField().get(object);
                        this.writeObject(object2);
                        break;
                    }
                    default: {
                        throw new InvalidClassException(clazz.getName());
                    }
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InvalidClassException(clazz.getName(), illegalAccessException.getMessage());
            }
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void outputObject(Object object) throws IOException {
        this.currentObject = object;
        if (this.currentClassDesc.isNonSerializable()) {
            throw new NotSerializableException(this.currentClassDesc.getName());
        }
        this.writeCode(115);
        this.outputClassDescriptor(this.currentClassDesc);
        this.assignWireOffset(object);
        if (this.currentClassDesc.isExternalizable()) {
            Externalizable externalizable = (Externalizable)object;
            if (this.useDeprecatedExternalizableFormat) {
                externalizable.writeExternal(this);
                return;
            } else {
                this.setBlockData(true);
                try {
                    externalizable.writeExternal(this);
                    return;
                }
                finally {
                    Object var4_4 = null;
                    this.setBlockData(false);
                    this.writeCode(120);
                }
            }
        }
        int n = this.classDescStack.size();
        try {
            ObjectStreamClass objectStreamClass;
            while ((objectStreamClass = this.currentClassDesc.getSuperclass()) != null) {
                this.classDescStack.push(this.currentClassDesc);
                this.currentClassDesc = objectStreamClass;
            }
            do {
                if (this.currentClassDesc.hasWriteObject()) {
                    this.setBlockData(true);
                    this.invokeObjectWriter(object);
                    this.setBlockData(false);
                    this.writeCode(120);
                } else {
                    this.defaultWriteObject();
                }
                if (this.classDescStack.size() <= n) break;
            } while ((this.currentClassDesc = (ObjectStreamClass)this.classDescStack.pop()) != null);
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.classDescStack.setSize(n);
            throw throwable;
        }
        Object var4_6 = null;
        this.classDescStack.setSize(n);
    }

    private void outputString(String string) throws IOException {
        this.assignWireOffset(string);
        this.writeCode(116);
        this.writeUTF(string);
    }

    public PutField putFields() throws IOException {
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("putFields");
        }
        this.currentPutFields = new PutFieldImpl(this.currentClassDesc);
        return this.currentPutFields;
    }

    protected Object replaceObject(Object object) throws IOException {
        return object;
    }

    public void reset() throws IOException {
        if (this.currentObject != null || this.currentClassDesc != null) {
            throw new IOException("Illegal call to reset");
        }
        this.setBlockData(false);
        this.writeCode(121);
        this.resetStream();
        this.abortIOException = null;
    }

    private void resetStream() throws IOException {
        int n;
        if (this.wireHandle2Object == null) {
            this.wireHandle2Object = new ArrayList();
            this.wireNextHandle = new int[4];
            this.wireHash2Handle = new int[(1 << this.wireHashSizePower) - 1];
        } else {
            this.wireHandle2Object.clear();
            n = 0;
            while (n < this.nextWireOffset) {
                this.wireNextHandle[n] = 0;
                ++n;
            }
        }
        this.nextWireOffset = 0;
        Arrays.fill(this.wireHash2Handle, -1);
        if (this.classDescStack == null) {
            this.classDescStack = new Stack();
        } else {
            this.classDescStack.setSize(0);
        }
        n = 0;
        while (n < this.nextReplaceOffset) {
            this.replaceObjects[n] = null;
            ++n;
        }
        this.nextReplaceOffset = 0;
        this.setBlockData(true);
    }

    private boolean serializeNullAndRepeat(Object object, boolean bl) throws IOException {
        int n;
        if (object == null) {
            this.writeCode(112);
            return true;
        }
        if (bl && this.replaceObjects != null) {
            object = this.lookupReplace(object);
        }
        if ((n = this.findWireOffset(object)) >= 0) {
            this.writeCode(113);
            this.writeInt(n + 0x7E0000);
            return true;
        }
        return false;
    }

    private boolean setBlockData(boolean bl) throws IOException {
        if (this.blockDataMode == bl) {
            return bl;
        }
        this.drain();
        this.blockDataMode = bl;
        return bl ^ true;
    }

    public void useProtocolVersion(int n) throws IOException {
        if (this.nextWireOffset != 0) {
            throw new IllegalStateException("Must call useProtocolVersion before writing any objects to the stream");
        }
        switch (n) {
            case 1: {
                this.useDeprecatedExternalizableFormat = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown version:" + n);
            }
            case 2: 
        }
    }

    public void write(int n) throws IOException {
        if (this.count >= this.buf.length) {
            this.drain();
        }
        this.buf[this.count++] = (byte)n;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeInternal(byArray, n, n2, false);
    }

    private void writeBlockDataHeader(int n) throws IOException {
        if (n <= 255) {
            this.out.write(119);
            this.out.write((byte)n);
        } else {
            this.out.write(122);
            this.out.write((byte)(n >> 24 & 0xFF));
            this.out.write((byte)(n >> 16 & 0xFF));
            this.out.write((byte)(n >> 8 & 0xFF));
            this.out.write((byte)(n & 0xFF));
        }
    }

    public void writeBoolean(boolean bl) throws IOException {
        if (this.count >= this.buf.length) {
            this.drain();
        }
        this.buf[this.count++] = (byte)(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        if (this.count >= this.buf.length) {
            this.drain();
        }
        this.buf[this.count++] = (byte)n;
    }

    public void writeBytes(String string) throws IOException {
        this.dos.writeBytes(string);
    }

    private void writeCanonical(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        int n4 = this.buf.length - this.count;
        if (n3 > n4) {
            this.writeBlockDataHeader(this.buf.length);
            this.out.write(this.buf, 0, this.count);
            this.out.write(byArray, n, n4);
            this.count = 0;
            n += n4;
            n3 -= n4;
            while (n3 >= this.buf.length) {
                if (this.blockDataMode) {
                    this.writeBlockDataHeader(this.buf.length);
                }
                this.out.write(byArray, n, this.buf.length);
                n += this.buf.length;
                n3 -= this.buf.length;
            }
        }
        if (n3 != 0) {
            System.arraycopy(byArray, n, this.buf, this.count, n3);
            this.count += n3;
        }
    }

    public void writeChar(int n) throws IOException {
        if (this.count + 2 > this.buf.length) {
            if (this.blockDataMode) {
                this.dos.writeChar(n);
                return;
            }
            this.drain();
        }
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)n;
    }

    public void writeChars(String string) throws IOException {
        this.dos.writeChars(string);
    }

    private void writeCode(int n) throws IOException {
        this.writeByte(n);
    }

    public void writeDouble(double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        if (this.count + 8 > this.buf.length) {
            if (this.blockDataMode) {
                this.dos.writeDouble(d);
                return;
            }
            this.drain();
        }
        this.buf[this.count++] = (byte)(l >>> 56);
        this.buf[this.count++] = (byte)(l >>> 48);
        this.buf[this.count++] = (byte)(l >>> 40);
        this.buf[this.count++] = (byte)(l >>> 32);
        this.buf[this.count++] = (byte)(l >>> 24);
        this.buf[this.count++] = (byte)(l >>> 16);
        this.buf[this.count++] = (byte)(l >>> 8);
        this.buf[this.count++] = (byte)l;
    }

    public void writeFields() throws IOException {
        if (this.currentObject == null || this.currentClassDesc == null || this.currentPutFields == null) {
            throw new NotActiveException("writeFields");
        }
        boolean bl = this.setBlockData(false);
        this.currentPutFields.write(this);
        this.setBlockData(bl);
    }

    public void writeFloat(float f) throws IOException {
        int n = Float.floatToIntBits(f);
        if (this.count + 4 > this.buf.length) {
            if (this.blockDataMode) {
                this.dos.writeFloat(f);
                return;
            }
            this.drain();
        }
        this.buf[this.count++] = (byte)(n >>> 24);
        this.buf[this.count++] = (byte)(n >>> 16);
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)n;
    }

    public void writeInt(int n) throws IOException {
        if (this.count + 4 > this.buf.length) {
            if (this.blockDataMode) {
                this.dos.writeInt(n);
                return;
            }
            this.drain();
        }
        this.buf[this.count++] = (byte)(n >>> 24);
        this.buf[this.count++] = (byte)(n >>> 16);
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)n;
    }

    private void writeInternal(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        if (n2 < 0) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        if (this.blockDataMode) {
            this.writeCanonical(byArray, n, n2);
        } else {
            int n3 = this.buf.length - this.count;
            if (n2 <= n3) {
                System.arraycopy(byArray, n, this.buf, this.count, n2);
                this.count += n2;
            } else if (bl) {
                this.bufferedWrite(byArray, n, n2);
            } else {
                this.drain();
                this.out.write(byArray, n, n2);
            }
        }
    }

    public void writeLong(long l) throws IOException {
        if (this.count + 8 > this.buf.length) {
            if (this.blockDataMode) {
                this.dos.writeLong(l);
                return;
            }
            this.drain();
        }
        this.buf[this.count++] = (byte)(l >>> 56);
        this.buf[this.count++] = (byte)(l >>> 48);
        this.buf[this.count++] = (byte)(l >>> 40);
        this.buf[this.count++] = (byte)(l >>> 32);
        this.buf[this.count++] = (byte)(l >>> 24);
        this.buf[this.count++] = (byte)(l >>> 16);
        this.buf[this.count++] = (byte)(l >>> 8);
        this.buf[this.count++] = (byte)l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void writeObject(Object object) throws IOException {
        boolean bl;
        ObjectStreamClass objectStreamClass;
        Object object2;
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                if (this.enableSubclassImplementation) {
                                    this.writeObjectOverride(object);
                                    return;
                                }
                                object2 = this.currentObject;
                                objectStreamClass = this.currentClassDesc;
                                bl = this.setBlockData(false);
                                ++this.recursionDepth;
                                try {
                                    try {
                                        if (this.serializeNullAndRepeat(object, true)) {
                                            Object var6_5 = null;
                                            --this.recursionDepth;
                                            this.currentObject = object2;
                                            this.currentClassDesc = objectStreamClass;
                                            break block18;
                                        }
                                        if (this.checkSpecialClasses(object)) {
                                            break block19;
                                        }
                                        this.currentClassDesc = ObjectStreamClass.lookupInternal(object.getClass());
                                        Object object3 = object;
                                        if (this.currentClassDesc.isReplaceable()) {
                                            object3 = ObjectStreamClass.invokeMethod(this.currentClassDesc.writeReplaceMethod, object, null);
                                        }
                                        if (this.enableReplace) {
                                            object3 = this.replaceObject(object3);
                                        }
                                        if (object != object3) {
                                            ObjectStreamClass objectStreamClass2 = this.currentClassDesc = object3 == null ? null : ObjectStreamClass.lookupInternal(object3.getClass());
                                            if (object3 != null && !(object3 instanceof Serializable)) {
                                                String string = object3.getClass().getName();
                                                throw new NotSerializableException(string);
                                            }
                                            if (this.serializeNullAndRepeat(object3, true)) {
                                                this.addReplacement(object, object3);
                                                break block20;
                                            }
                                            this.addReplacement(object, object3);
                                            if (this.checkSpecialClasses(object3)) {
                                                break block21;
                                            }
                                            object = object3;
                                        }
                                        if (this.checkSubstitutableSpecialClasses(object, this.currentClassDesc.forClass())) {
                                            break block22;
                                        }
                                        this.outputObject(object);
                                    }
                                    catch (IOException iOException) {
                                        if (this.abortIOException != null) break block23;
                                        try {
                                            this.setBlockData(false);
                                            this.writeCode(123);
                                            this.resetStream();
                                            this.setBlockData(false);
                                            this.currentClassDesc = ObjectStreamClass.lookupInternal(iOException.getClass());
                                            this.outputObject(iOException);
                                            this.resetStream();
                                            this.abortIOException = iOException;
                                            break block23;
                                        }
                                        catch (IOException iOException2) {
                                            this.abortIOException = new StreamCorruptedException(iOException2.getMessage());
                                        }
                                    }
                                    break block23;
                                }
                                catch (Throwable throwable) {
                                    Object var6_11 = null;
                                    --this.recursionDepth;
                                    this.currentObject = object2;
                                    this.currentClassDesc = objectStreamClass;
                                    this.setBlockData(bl);
                                    throw throwable;
                                }
                            }
                            this.setBlockData(bl);
                            return;
                        }
                        Object var6_6 = null;
                        --this.recursionDepth;
                        this.currentObject = object2;
                        this.currentClassDesc = objectStreamClass;
                        this.setBlockData(bl);
                        return;
                    }
                    Object var6_7 = null;
                    --this.recursionDepth;
                    this.currentObject = object2;
                    this.currentClassDesc = objectStreamClass;
                    this.setBlockData(bl);
                    return;
                }
                Object var6_8 = null;
                --this.recursionDepth;
                this.currentObject = object2;
                this.currentClassDesc = objectStreamClass;
                this.setBlockData(bl);
                return;
            }
            Object var6_9 = null;
            --this.recursionDepth;
            this.currentObject = object2;
            this.currentClassDesc = objectStreamClass;
            this.setBlockData(bl);
            return;
        }
        Object var6_10 = null;
        --this.recursionDepth;
        this.currentObject = object2;
        this.currentClassDesc = objectStreamClass;
        this.setBlockData(bl);
        IOException iOException = this.abortIOException;
        if (this.recursionDepth == 0) {
            this.abortIOException = null;
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    protected void writeObjectOverride(Object object) throws IOException {
    }

    public void writeShort(int n) throws IOException {
        if (this.count + 2 > this.buf.length) {
            if (this.blockDataMode) {
                this.dos.writeShort(n);
                return;
            }
            this.drain();
        }
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)n;
    }

    protected void writeStreamHeader() throws IOException {
        this.writeShort(-21267);
        this.writeShort(5);
    }

    void writeTypeString(String string) throws IOException {
        int n = this.findWireOffset(string);
        if (n >= 0) {
            this.writeCode(113);
            this.writeInt(n + 0x7E0000);
        } else {
            this.assignWireOffset(string);
            this.writeCode(116);
            this.writeUTF(string);
        }
    }

    public void writeUTF(String string) throws IOException {
        this.dos.writeUTF(string);
    }

    public static abstract class PutField {
        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, Object var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, boolean var2);

        public abstract void write(ObjectOutput var1) throws IOException;
    }

    static final class PutFieldImpl
    extends PutField {
        private byte[] data;
        private Object[] objects;
        private ObjectStreamClass desc;

        PutFieldImpl(ObjectStreamClass objectStreamClass) {
            this.desc = objectStreamClass;
            if (this.desc.primBytes > 0) {
                this.data = new byte[this.desc.primBytes];
            }
            if (this.desc.objFields > 0) {
                this.objects = new Object[this.desc.objFields];
            }
        }

        public void put(String string, byte by) {
            ObjectStreamField objectStreamField = this.desc.getField(string, Byte.TYPE);
            if (objectStreamField == null || objectStreamField.getType() != Byte.TYPE) {
                throw new IllegalArgumentException("No such byte field");
            }
            this.data[objectStreamField.getOffset()] = by;
        }

        public void put(String string, char c) {
            ObjectStreamField objectStreamField = this.desc.getField(string, Character.TYPE);
            if (objectStreamField == null || objectStreamField.getType() != Character.TYPE) {
                throw new IllegalArgumentException("No such char field");
            }
            this.data[objectStreamField.getOffset()] = (byte)(c >> 8);
            this.data[objectStreamField.getOffset() + 1] = (byte)c;
        }

        public void put(String string, double d) {
            long l = Double.doubleToLongBits(d);
            ObjectStreamField objectStreamField = this.desc.getField(string, Double.TYPE);
            if (objectStreamField == null || objectStreamField.getType() != Double.TYPE) {
                throw new IllegalArgumentException("No such double field");
            }
            int n = objectStreamField.getOffset();
            this.data[n] = (byte)(l >> 56);
            this.data[n + 1] = (byte)(l >> 48);
            this.data[n + 2] = (byte)(l >> 40);
            this.data[n + 3] = (byte)(l >> 32);
            this.data[n + 4] = (byte)(l >> 24);
            this.data[n + 5] = (byte)(l >> 16);
            this.data[n + 6] = (byte)(l >> 8);
            this.data[n + 7] = (byte)l;
        }

        public void put(String string, float f) {
            int n = Float.floatToIntBits(f);
            ObjectStreamField objectStreamField = this.desc.getField(string, Float.TYPE);
            if (objectStreamField == null || objectStreamField.getType() != Float.TYPE) {
                throw new IllegalArgumentException("No such float field");
            }
            int n2 = objectStreamField.getOffset();
            this.data[n2] = (byte)(n >> 24);
            this.data[n2 + 1] = (byte)(n >> 16);
            this.data[n2 + 2] = (byte)(n >> 8);
            this.data[n2 + 3] = (byte)n;
        }

        public void put(String string, int n) {
            ObjectStreamField objectStreamField = this.desc.getField(string, Integer.TYPE);
            if (objectStreamField == null || objectStreamField.getType() != Integer.TYPE) {
                throw new IllegalArgumentException("No such int field");
            }
            int n2 = objectStreamField.getOffset();
            this.data[n2] = (byte)(n >> 24);
            this.data[n2 + 1] = (byte)(n >> 16);
            this.data[n2 + 2] = (byte)(n >> 8);
            this.data[n2 + 3] = (byte)n;
        }

        public void put(String string, long l) {
            ObjectStreamField objectStreamField = this.desc.getField(string, Long.TYPE);
            if (objectStreamField == null || objectStreamField.getType() != Long.TYPE) {
                throw new IllegalArgumentException("No such long field");
            }
            int n = objectStreamField.getOffset();
            this.data[n] = (byte)(l >> 56);
            this.data[n + 1] = (byte)(l >> 48);
            this.data[n + 2] = (byte)(l >> 40);
            this.data[n + 3] = (byte)(l >> 32);
            this.data[n + 4] = (byte)(l >> 24);
            this.data[n + 5] = (byte)(l >> 16);
            this.data[n + 6] = (byte)(l >> 8);
            this.data[n + 7] = (byte)l;
        }

        public void put(String string, Object object) {
            ObjectStreamField objectStreamField = this.desc.getField(string, class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ObjectOutputStream.class$("java.lang.Object")));
            if (objectStreamField == null || objectStreamField.isPrimitive()) {
                throw new IllegalArgumentException("No such object field");
            }
            this.objects[objectStreamField.getOffset()] = object;
        }

        public void put(String string, short s) {
            ObjectStreamField objectStreamField = this.desc.getField(string, Short.TYPE);
            if (objectStreamField == null || objectStreamField.getType() != Short.TYPE) {
                throw new IllegalArgumentException("No such short field");
            }
            int n = objectStreamField.getOffset();
            this.data[n] = (byte)(s >> 8);
            this.data[n + 1] = (byte)s;
        }

        public void put(String string, boolean bl) throws IllegalArgumentException {
            ObjectStreamField objectStreamField = this.desc.getField(string, Boolean.TYPE);
            if (objectStreamField == null || objectStreamField.getType() != Boolean.TYPE) {
                throw new IllegalArgumentException("No such boolean field");
            }
            this.data[objectStreamField.getOffset()] = (byte)(bl ? 1 : 0);
        }

        public void write(ObjectOutput objectOutput) throws IOException {
            if (this.data != null) {
                objectOutput.write(this.data, 0, this.data.length);
            }
            if (this.objects != null) {
                int n = 0;
                while (n < this.objects.length) {
                    objectOutput.writeObject(this.objects[n]);
                    ++n;
                }
            }
        }
    }

    static final class Stack
    extends ArrayList {
        Stack() {
        }

        Object peek() {
            int n = this.size();
            if (n == 0) {
                throw new EmptyStackException();
            }
            return this.get(n - 1);
        }

        Object pop() {
            int n = this.size();
            Object object = this.peek();
            this.remove(n - 1);
            return object;
        }

        Object push(Object object) {
            this.add(object);
            return object;
        }

        void setSize(int n) {
            if (n == 0) {
                this.clear();
            } else {
                int n2 = this.size();
                int n3 = n2 - 1;
                while (n3 >= n) {
                    this.remove(n3);
                    --n3;
                }
            }
        }
    }
}

