/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.ValidationCallback;
import java.io.WriteAbortedException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private InputStream in;
    private int count;
    private boolean blockDataMode;
    private byte[] buffer;
    private DataInputStream dis;
    private IOException abortIOException = null;
    private ClassNotFoundException abortClassNotFoundException = null;
    private Object currentObject;
    private ObjectStreamClass currentClassDesc;
    private Class currentClass;
    private Object currentGetFields;
    private static final int INITIAL_BUFFER_SIZE = 64;
    private byte[] data;
    ObjectStreamClass[] classdesc;
    Class[] classes;
    int spClass;
    private ArrayList wireHandle2Object;
    private int nextWireOffset;
    private ArrayList callbacks;
    private int recursionDepth;
    private byte currCode;
    boolean enableResolve;
    private boolean enableSubclassImplementation;
    private Object[] readObjectArglist = new Object[]{this};
    static /* synthetic */ Class class$java$lang$Object;

    protected ObjectInputStream() throws IOException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ObjectStreamConstants.SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.enableSubclassImplementation = true;
    }

    public ObjectInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
        this.enableSubclassImplementation = false;
        this.in = inputStream;
        this.dis = new DataInputStream(this);
        this.readStreamHeader();
        this.resetStream();
    }

    private void SkipToEndOfBlockData() throws IOException, ClassNotFoundException {
        while (this.peekCode() != 120) {
            try {
                Object object = this.readObject(false);
            }
            catch (OptionalDataException optionalDataException) {
                if (optionalDataException.length <= 0) continue;
                this.skip(optionalDataException.length);
            }
        }
        this.readCode();
    }

    private static native Object allocateNewArray(Class var0, int var1);

    private static native Object allocateNewObject(Class var0, Class var1) throws InstantiationException, IllegalAccessException;

    private int assignWireOffset(Object object) throws IOException {
        this.wireHandle2Object.add(object);
        if (++this.nextWireOffset != this.wireHandle2Object.size()) {
            throw new StreamCorruptedException("Elements not assigned in order");
        }
        return this.nextWireOffset - 1;
    }

    public int available() throws IOException {
        if (this.blockDataMode) {
            if (this.count == 0 && this.in.available() > 0) {
                this.refill();
            }
            if (this.count >= 0) {
                return this.count;
            }
            return 0;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("defaultReadObject");
        }
        ObjectStreamField[] objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
        if (objectStreamFieldArray.length > 0) {
            boolean bl = this.setBlockData(false);
            this.inputClassFields(this.currentObject, this.currentClass, objectStreamFieldArray);
            this.setBlockData(bl);
        }
    }

    private void doValidations() throws InvalidObjectException {
        if (this.callbacks == null) {
            return;
        }
        int n = this.callbacks.size();
        int n2 = 0;
        while (n2 < n) {
            ValidationCallback validationCallback = (ValidationCallback)this.callbacks.get(n2);
            validationCallback.callback.validateObject();
            ++n2;
        }
        this.callbacks.clear();
    }

    protected boolean enableResolveObject(boolean bl) throws SecurityException {
        boolean bl2 = this.enableResolve;
        if (bl) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(ObjectStreamConstants.SUBSTITUTION_PERMISSION);
            }
            this.enableResolve = true;
        } else {
            this.enableResolve = false;
        }
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int inputArray(boolean bl) throws IOException, ClassNotFoundException {
        ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
        Class clazz = objectStreamClass.forClass();
        if (clazz == null && bl) {
            throw new ClassNotFoundException(objectStreamClass.getName());
        }
        int n = this.readInt();
        this.currentObject = clazz == null ? null : ObjectInputStream.allocateNewArray(clazz, n);
        int n2 = this.assignWireOffset(this.currentObject);
        if (clazz != null && clazz.getComponentType().isPrimitive()) {
            Class clazz2 = clazz.getComponentType();
            if (this.buffer == null) {
                this.buffer = new byte[1024];
            }
            int n3 = this.buffer.length;
            int n4 = this.buffer.length;
            if (clazz2 == Boolean.TYPE) {
                boolean[] blArray = (boolean[])this.currentObject;
                int n5 = 0;
                while (n5 < n) {
                    if (n3 >= n4) {
                        int n6 = Math.min(n - n5, n4);
                        this.readFully(this.buffer, 0, n6);
                        n3 = 0;
                    }
                    blArray[n5] = this.buffer[n3] != 0;
                    ++n3;
                    ++n5;
                }
                return n2;
            } else if (clazz2 == Byte.TYPE) {
                byte[] byArray = (byte[])this.currentObject;
                int n7 = 0;
                while (n7 < n) {
                    int n8 = Math.min(n - n7, n4);
                    this.readFully(this.buffer, 0, n8);
                    System.arraycopy(this.buffer, 0, byArray, n7, n8);
                    n7 += n8;
                }
                return n2;
            } else if (clazz2 == Short.TYPE) {
                short[] sArray = (short[])this.currentObject;
                int n9 = 0;
                while (n9 < n) {
                    if (n3 > n4 - 2) {
                        int n10 = Math.min((n - n9) * 2, n4);
                        this.readFully(this.buffer, 0, n10);
                        n3 = 0;
                    }
                    sArray[n9] = (short)(((this.buffer[n3] & 0xFF) << 8) + (this.buffer[n3 + 1] & 0xFF));
                    n3 += 2;
                    ++n9;
                }
                return n2;
            } else if (clazz2 == Integer.TYPE) {
                int[] nArray = (int[])this.currentObject;
                int n11 = 0;
                while (n11 < n) {
                    if (n3 > n4 - 4) {
                        int n12 = Math.min((n - n11) * 4, n4);
                        this.readFully(this.buffer, 0, n12);
                        n3 = 0;
                    }
                    nArray[n11] = ((this.buffer[n3] & 0xFF) << 24) + ((this.buffer[n3 + 1] & 0xFF) << 16) + ((this.buffer[n3 + 2] & 0xFF) << 8) + (this.buffer[n3 + 3] & 0xFF);
                    n3 += 4;
                    ++n11;
                }
                return n2;
            } else if (clazz2 == Long.TYPE) {
                long[] lArray = (long[])this.currentObject;
                int n13 = 0;
                while (n13 < n) {
                    int n14;
                    if (n3 > n4 - 8) {
                        n14 = Math.min((n - n13) * 8, n4);
                        this.readFully(this.buffer, 0, n14);
                        n3 = 0;
                    }
                    n14 = ((this.buffer[n3] & 0xFF) << 24) + ((this.buffer[n3 + 1] & 0xFF) << 16) + ((this.buffer[n3 + 2] & 0xFF) << 8) + (this.buffer[n3 + 3] & 0xFF);
                    int n15 = ((this.buffer[n3 + 4] & 0xFF) << 24) + ((this.buffer[n3 + 5] & 0xFF) << 16) + ((this.buffer[n3 + 6] & 0xFF) << 8) + (this.buffer[n3 + 7] & 0xFF);
                    lArray[n13] = ((long)n14 << 32) + ((long)n15 & 0xFFFFFFFFL);
                    n3 += 8;
                    ++n13;
                }
                return n2;
            } else if (clazz2 == Float.TYPE) {
                float[] fArray = (float[])this.currentObject;
                int n16 = 0;
                while (n16 < n) {
                    int n17;
                    if (n3 > n4 - 4) {
                        n17 = Math.min((n - n16) * 4, n4);
                        this.readFully(this.buffer, 0, n17);
                        n3 = 0;
                    }
                    n17 = ((this.buffer[n3] & 0xFF) << 24) + ((this.buffer[n3 + 1] & 0xFF) << 16) + ((this.buffer[n3 + 2] & 0xFF) << 8) + (this.buffer[n3 + 3] & 0xFF);
                    n3 += 4;
                    fArray[n16] = Float.intBitsToFloat(n17);
                    ++n16;
                }
                return n2;
            } else if (clazz2 == Double.TYPE) {
                double[] dArray = (double[])this.currentObject;
                int n18 = 0;
                while (n18 < n) {
                    int n19;
                    if (n3 > n4 - 8) {
                        n19 = Math.min((n - n18) * 8, n4);
                        this.readFully(this.buffer, 0, n19);
                        n3 = 0;
                    }
                    n19 = ((this.buffer[n3] & 0xFF) << 24) + ((this.buffer[n3 + 1] & 0xFF) << 16) + ((this.buffer[n3 + 2] & 0xFF) << 8) + (this.buffer[n3 + 3] & 0xFF);
                    int n20 = ((this.buffer[n3 + 4] & 0xFF) << 24) + ((this.buffer[n3 + 5] & 0xFF) << 16) + ((this.buffer[n3 + 6] & 0xFF) << 8) + (this.buffer[n3 + 7] & 0xFF);
                    n3 += 8;
                    dArray[n18] = Double.longBitsToDouble(((long)n19 << 32) + ((long)n20 & 0xFFFFFFFFL));
                    ++n18;
                }
                return n2;
            } else {
                if (clazz2 != Character.TYPE) throw new InvalidClassException(clazz.getName());
                char[] cArray = (char[])this.currentObject;
                int n21 = 0;
                while (n21 < n) {
                    if (n3 > n4 - 2) {
                        int n22 = Math.min((n - n21) * 2, n4);
                        this.readFully(this.buffer, 0, n22);
                        n3 = 0;
                    }
                    cArray[n21] = (char)(((this.buffer[n3] & 0xFF) << 8) + (this.buffer[n3 + 1] & 0xFF));
                    n3 += 2;
                    ++n21;
                }
            }
            return n2;
        } else {
            Object[] objectArray = (Object[])this.currentObject;
            boolean bl2 = clazz != null;
            int n23 = 0;
            while (n23 < n) {
                Object object = this.readObject(bl2);
                if (objectArray != null) {
                    objectArray[n23] = object;
                }
                ++n23;
            }
        }
        return n2;
    }

    private ObjectStreamClass inputClassDescriptor() throws IOException, InvalidClassException, ClassNotFoundException {
        Class clazz;
        String string = this.readUTF();
        long l = this.readLong();
        ObjectStreamClass objectStreamClass = new ObjectStreamClass(string, l);
        int n = this.assignWireOffset(objectStreamClass);
        objectStreamClass.read(this);
        boolean bl = this.setBlockData(true);
        try {
            clazz = this.resolveClass(objectStreamClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            clazz = null;
        }
        this.SkipToEndOfBlockData();
        bl = this.setBlockData(bl);
        objectStreamClass.setClass(clazz);
        ObjectStreamClass objectStreamClass2 = (ObjectStreamClass)this.readObject();
        objectStreamClass.setSuperclass(objectStreamClass2);
        return objectStreamClass;
    }

    private void inputClassFields(Object object, Class clazz, ObjectStreamField[] objectStreamFieldArray) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        int n;
        int n2;
        int n3 = objectStreamFieldArray.length - this.currentClassDesc.objFields;
        if (this.currentClassDesc.primBytes > 0) {
            if (this.data == null) {
                this.data = new byte[Math.max(this.currentClassDesc.primBytes, 64)];
            } else if (this.data.length < this.currentClassDesc.primBytes) {
                this.data = new byte[this.currentClassDesc.primBytes];
            }
            this.readFully(this.data, 0, this.currentClassDesc.primBytes);
        }
        if (object != null) {
            n2 = 0;
            while (n2 < n3) {
                if (objectStreamFieldArray[n2].getField() != null) {
                    try {
                        int n4 = objectStreamFieldArray[n2].getOffset();
                        switch (objectStreamFieldArray[n2].getTypeCode()) {
                            case 'B': {
                                byte by = this.data[n4];
                                objectStreamFieldArray[n2].getField().setByte(object, by);
                                break;
                            }
                            case 'Z': {
                                boolean bl = this.data[n4] != 0;
                                objectStreamFieldArray[n2].getField().setBoolean(object, bl);
                                break;
                            }
                            case 'C': {
                                char c = (char)(((this.data[n4] & 0xFF) << 8) + (this.data[n4 + 1] & 0xFF));
                                objectStreamFieldArray[n2].getField().setChar(object, c);
                                break;
                            }
                            case 'S': {
                                short s = (short)(((this.data[n4] & 0xFF) << 8) + (this.data[n4 + 1] & 0xFF));
                                objectStreamFieldArray[n2].getField().setShort(object, s);
                                break;
                            }
                            case 'I': {
                                int n5 = ((this.data[n4] & 0xFF) << 24) + ((this.data[n4 + 1] & 0xFF) << 16) + ((this.data[n4 + 2] & 0xFF) << 8) + (this.data[n4 + 3] & 0xFF);
                                objectStreamFieldArray[n2].getField().setInt(object, n5);
                                break;
                            }
                            case 'J': {
                                int n6 = ((this.data[n4] & 0xFF) << 24) + ((this.data[n4 + 1] & 0xFF) << 16) + ((this.data[n4 + 2] & 0xFF) << 8) + (this.data[n4 + 3] & 0xFF);
                                n = ((this.data[n4 + 4] & 0xFF) << 24) + ((this.data[n4 + 5] & 0xFF) << 16) + ((this.data[n4 + 6] & 0xFF) << 8) + (this.data[n4 + 7] & 0xFF);
                                long l = ((long)n6 << 32) + ((long)n & 0xFFFFFFFFL);
                                objectStreamFieldArray[n2].getField().setLong(object, l);
                                break;
                            }
                            case 'F': {
                                int n7 = ((this.data[n4] & 0xFF) << 24) + ((this.data[n4 + 1] & 0xFF) << 16) + ((this.data[n4 + 2] & 0xFF) << 8) + (this.data[n4 + 3] & 0xFF);
                                float f = Float.intBitsToFloat(n7);
                                objectStreamFieldArray[n2].getField().setFloat(object, f);
                                break;
                            }
                            case 'D': {
                                int n6 = ((this.data[n4] & 0xFF) << 24) + ((this.data[n4 + 1] & 0xFF) << 16) + ((this.data[n4 + 2] & 0xFF) << 8) + (this.data[n4 + 3] & 0xFF);
                                n = ((this.data[n4 + 4] & 0xFF) << 24) + ((this.data[n4 + 5] & 0xFF) << 16) + ((this.data[n4 + 6] & 0xFF) << 8) + (this.data[n4 + 7] & 0xFF);
                                long l = ((long)n6 << 32) + ((long)n & 0xFFFFFFFFL);
                                double d = Double.longBitsToDouble(l);
                                objectStreamFieldArray[n2].getField().setDouble(object, d);
                                break;
                            }
                            default: {
                                throw new InvalidClassException(clazz.getName());
                            }
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new InvalidClassException(clazz.getName(), "IllegalAccessException");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ClassCastException("Assigning instance of class " + objectStreamFieldArray[n2].getType().getName() + " to field " + this.currentClassDesc.getName() + '#' + objectStreamFieldArray[n2].getField().getName());
                    }
                }
                ++n2;
            }
        }
        if (this.currentClassDesc.objFields > 0) {
            n2 = n3;
            while (n2 < objectStreamFieldArray.length) {
                n = objectStreamFieldArray[n2].getField() == null ? 0 : 1;
                Object object2 = this.readObject(n != 0);
                if (object != null && objectStreamFieldArray[n2].getField() != null) {
                    try {
                        objectStreamFieldArray[n2].getField().set(object, object2);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new InvalidClassException(clazz.getName(), "IllegalAccessException");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ClassCastException("Assigning instance of class " + object2.getClass().getName() + " to field " + this.currentClassDesc.getName() + '#' + objectStreamFieldArray[n2].getField().getName());
                    }
                }
                ++n2;
            }
        }
    }

    private int inputObject(boolean bl) throws IOException, ClassNotFoundException {
        int n;
        block31: {
            Class clazz;
            n = -1;
            this.currentClassDesc = (ObjectStreamClass)this.readObject();
            this.currentClass = this.currentClassDesc.forClass();
            if (this.currentClass == null && bl) {
                throw new ClassNotFoundException(this.currentClassDesc.getName());
            }
            if (bl) {
                this.currentClassDesc.verifyInstanceDeserialization();
            }
            if (this.currentClassDesc.isExternalizable()) {
                try {
                    boolean bl2;
                    block30: {
                        this.currentObject = this.currentClass == null ? null : ObjectInputStream.allocateNewObject(this.currentClass, this.currentClass);
                        n = this.assignWireOffset(this.currentObject);
                        bl2 = this.blockDataMode;
                        try {
                            if (this.currentClassDesc.hasExternalizableBlockDataMode()) {
                                bl2 = this.setBlockData(true);
                            }
                            if (this.currentObject == null) break block30;
                            Externalizable externalizable = (Externalizable)this.currentObject;
                            externalizable.readExternal(this);
                        }
                        catch (Throwable throwable) {
                            Object var5_11 = null;
                            if (this.currentClassDesc.hasExternalizableBlockDataMode()) {
                                this.SkipToEndOfBlockData();
                                this.setBlockData(bl2);
                            }
                            throw throwable;
                        }
                    }
                    Object var5_10 = null;
                    if (this.currentClassDesc.hasExternalizableBlockDataMode()) {
                        this.SkipToEndOfBlockData();
                        this.setBlockData(bl2);
                    }
                    break block31;
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    throw new InvalidClassException(this.currentClass.getName(), noSuchMethodError.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new InvalidClassException(this.currentClass.getName(), "IllegalAccessException");
                }
                catch (InstantiationException instantiationException) {
                    throw new InvalidClassException(this.currentClass.getName(), "InstantiationException");
                }
            }
            ObjectStreamClass objectStreamClass = this.currentClassDesc;
            Class clazz2 = this.currentClass;
            int n2 = this.spClass;
            objectStreamClass = this.currentClassDesc;
            clazz2 = this.currentClass;
            while (objectStreamClass != null) {
                Class clazz3 = objectStreamClass.forClass();
                clazz = clazz2;
                while (clazz != null) {
                    if (clazz3 == clazz) break;
                    clazz = clazz.getSuperclass();
                }
                ++this.spClass;
                if (this.spClass >= this.classes.length) {
                    int n3 = this.classes.length * 2;
                    Class[] classArray = new Class[n3];
                    ObjectStreamClass[] objectStreamClassArray = new ObjectStreamClass[n3];
                    System.arraycopy(this.classes, 0, classArray, 0, this.classes.length);
                    System.arraycopy(this.classdesc, 0, objectStreamClassArray, 0, this.classes.length);
                    this.classes = classArray;
                    this.classdesc = objectStreamClassArray;
                }
                if (clazz == null) {
                    this.classdesc[this.spClass] = objectStreamClass;
                    this.classes[this.spClass] = null;
                } else {
                    this.classdesc[this.spClass] = objectStreamClass;
                    this.classes[this.spClass] = clazz;
                    clazz2 = clazz.getSuperclass();
                }
                objectStreamClass = objectStreamClass.getSuperclass();
            }
            try {
                this.currentObject = this.currentClass == null ? null : ObjectInputStream.allocateNewObject(this.currentClass, clazz2);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new InvalidClassException(clazz2.getName(), noSuchMethodError.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InvalidClassException(clazz2.getName(), "IllegalAccessException");
            }
            catch (InstantiationException instantiationException) {
                throw new InvalidClassException(clazz2.getName(), "InstantiationException");
            }
            n = this.assignWireOffset(this.currentObject);
            try {
                this.spClass = this.spClass;
                while (this.spClass > n2) {
                    ObjectStreamField[] objectStreamFieldArray;
                    this.currentClassDesc = this.classdesc[this.spClass];
                    this.currentClass = this.classes[this.spClass];
                    if (this.classes[this.spClass] != null) {
                        this.setBlockData(true);
                        objectStreamFieldArray = this.currentClassDesc.localClassDescriptor();
                        if (!this.invokeObjectReader(this.currentObject)) {
                            this.defaultReadObject();
                        }
                    } else {
                        objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
                        if (objectStreamFieldArray.length > 0) {
                            boolean bl3 = this.setBlockData(false);
                            this.inputClassFields(null, this.currentClass, objectStreamFieldArray);
                            this.setBlockData(bl3);
                        }
                    }
                    if (this.currentClassDesc.hasWriteObject()) {
                        this.SkipToEndOfBlockData();
                    }
                    this.setBlockData(false);
                    --this.spClass;
                }
            }
            finally {
                clazz = null;
                this.spClass = n2;
            }
        }
        return n;
    }

    private boolean invokeObjectReader(Object object) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        if (this.currentClassDesc.readObjectMethod == null) {
            return false;
        }
        try {
            this.currentClassDesc.readObjectMethod.invoke(object, this.readObjectArglist);
            return true;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error("interal error");
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
    }

    private native Class loadClass0(Class var1, String var2) throws ClassNotFoundException;

    private byte peekCode() throws IOException, StreamCorruptedException {
        while (this.currCode == 0) {
            int n = this.in.read();
            if (n < 0) {
                throw new EOFException("Expecting code");
            }
            this.currCode = (byte)n;
            if (this.currCode < 112 || this.currCode > 123) {
                throw new StreamCorruptedException("Type code out of range, is " + this.currCode);
            }
            if (this.currCode != 121) continue;
            if (this.recursionDepth != 0 || this.currentObject != null || this.currentClassDesc != null) {
                throw new StreamCorruptedException("Illegal stream state for reset");
            }
            this.resetStream();
            this.currCode = 0;
        }
        return this.currCode;
    }

    private void pushbackCode(byte by) {
        this.currCode = by;
    }

    public int read() throws IOException {
        int n;
        if (this.blockDataMode) {
            while (this.count == 0) {
                this.refill();
            }
            if (this.count < 0) {
                return -1;
            }
            n = this.in.read();
            if (n >= 0) {
                --this.count;
            }
        } else {
            n = this.in.read();
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.blockDataMode) {
            while (this.count == 0) {
                this.refill();
            }
            if (this.count < 0) {
                return -1;
            }
            int n3 = Math.min(n2, this.count);
            int n4 = this.in.read(byArray, n, n3);
            if (n4 > 0) {
                this.count -= n4;
            }
            return n4;
        }
        return this.in.read(byArray, n, n2);
    }

    public boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public char readChar() throws IOException {
        return this.dis.readChar();
    }

    private byte readCode() throws IOException, StreamCorruptedException {
        byte by = this.peekCode();
        this.currCode = 0;
        return by;
    }

    public double readDouble() throws IOException {
        return this.dis.readDouble();
    }

    public GetField readFields() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("defaultReadObject");
        }
        GetFieldImpl getFieldImpl = new GetFieldImpl(this.currentClassDesc);
        this.currentGetFields = getFieldImpl;
        boolean bl = this.setBlockData(false);
        getFieldImpl.read(this);
        this.setBlockData(bl);
        return getFieldImpl;
    }

    public float readFloat() throws IOException {
        return this.dis.readFloat();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.dis.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.dis.readFully(byArray, n, n2);
    }

    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    public String readLine() throws IOException {
        return this.dis.readLine();
    }

    public long readLong() throws IOException {
        return this.dis.readLong();
    }

    public final Object readObject() throws OptionalDataException, ClassNotFoundException, IOException {
        if (this.enableSubclassImplementation) {
            return this.readObjectOverride();
        }
        return this.readObject(true);
    }

    private final Object readObject(boolean bl) throws OptionalDataException, ClassNotFoundException, IOException {
        ClassNotFoundException classNotFoundException;
        if (this.blockDataMode) {
            if (this.count == 0) {
                this.refill();
            }
            if (this.count > 0) {
                throw new OptionalDataException(this.count);
            }
        }
        this.peekCode();
        Object object = this.currentObject;
        ObjectStreamClass objectStreamClass = this.currentClassDesc;
        boolean bl2 = this.setBlockData(false);
        ++this.recursionDepth;
        Object object2 = null;
        byte by = this.readCode();
        try {
            block45: {
                try {
                    int n = -1;
                    switch (by) {
                        case 112: {
                            object2 = null;
                            break;
                        }
                        case 113: {
                            n = this.readInt() - 0x7E0000;
                            try {
                                object2 = this.wireHandle2Object.get(n);
                                break;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                throw new StreamCorruptedException("Reference to object never serialized.");
                            }
                        }
                        case 116: {
                            Object object3 = object2 = this.readUTF();
                            n = this.assignWireOffset(object2);
                            if (this.enableResolve) {
                                object2 = this.resolveObject(object2);
                            }
                            if (object2 != object3) {
                                this.wireHandle2Object.set(n, object2);
                            }
                            break;
                        }
                        case 118: {
                            ObjectStreamClass objectStreamClass2 = (ObjectStreamClass)this.readObject(bl);
                            if (objectStreamClass2 == null) {
                                throw new StreamCorruptedException("Class not in stream");
                            }
                            object2 = objectStreamClass2.forClass();
                            if (object2 == null && bl) {
                                throw new ClassNotFoundException(objectStreamClass2.getName());
                            }
                            this.assignWireOffset(object2);
                            break;
                        }
                        case 114: {
                            object2 = this.inputClassDescriptor();
                            break;
                        }
                        case 117: {
                            n = this.inputArray(bl);
                            object2 = this.currentObject;
                            if (this.enableResolve) {
                                object2 = this.resolveObject(object2);
                            }
                            if (object2 != this.currentObject) {
                                this.wireHandle2Object.set(n, object2);
                            }
                            break;
                        }
                        case 115: {
                            n = this.inputObject(bl);
                            object2 = this.currentObject;
                            if (this.currentObject != null && this.currentClassDesc != null && this.currentClassDesc.isResolvable()) {
                                object2 = ObjectStreamClass.invokeMethod(this.currentClassDesc.readResolveMethod, object2, null);
                            }
                            if (this.enableResolve) {
                                object2 = this.resolveObject(object2);
                            }
                            if (object2 != this.currentObject) {
                                this.wireHandle2Object.set(n, object2);
                            }
                            break;
                        }
                        case 120: {
                            if (!bl2) {
                                throw new StreamCorruptedException("Unexpected end of block data");
                            }
                            this.pushbackCode((byte)120);
                            this.count = -1;
                            throw new OptionalDataException(true);
                        }
                        case 119: 
                        case 122: {
                            if (by == 122) {
                                int n2;
                                int n3;
                                int n4;
                                int n5 = this.in.read();
                                if ((n5 | (n4 = this.in.read()) | (n3 = this.in.read()) | (n2 = this.in.read())) < 0) {
                                    throw new StreamCorruptedException("EOF expecting count");
                                }
                                this.count = n5 << 24 | n4 << 16 | n3 << 8 | n2;
                                if (this.count < 0) {
                                    throw new StreamCorruptedException("Negative block data size");
                                }
                            } else {
                                this.count = this.in.read();
                                if (this.count < 0) {
                                    throw new StreamCorruptedException("EOF expecting count");
                                }
                            }
                            if (!bl2) {
                                throw new StreamCorruptedException("Unexpected blockdata");
                            }
                            throw new OptionalDataException(this.count);
                        }
                        case 123: {
                            this.resetStream();
                            IOException iOException = (IOException)this.readObject();
                            this.resetStream();
                            throw new WriteAbortedException("Writing aborted by exception", iOException);
                        }
                        default: {
                            throw new StreamCorruptedException("Unknown code in readObject " + by);
                        }
                    }
                }
                catch (OptionalDataException optionalDataException) {
                    throw optionalDataException;
                }
                catch (IOException iOException) {
                    if (this.abortIOException == null && this.abortClassNotFoundException == null) {
                        this.abortIOException = iOException;
                    }
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    if (this.abortIOException != null || this.abortClassNotFoundException != null) break block45;
                    this.abortClassNotFoundException = classNotFoundException2;
                }
            }
            classNotFoundException = null;
            --this.recursionDepth;
            this.currentObject = object;
            this.currentClassDesc = objectStreamClass;
            this.currentClass = this.currentClassDesc != null ? this.currentClassDesc.forClass() : null;
        }
        catch (Throwable throwable) {
            Object var8_19 = null;
            --this.recursionDepth;
            this.currentObject = object;
            this.currentClassDesc = objectStreamClass;
            this.currentClass = this.currentClassDesc != null ? this.currentClassDesc.forClass() : null;
            this.setBlockData(bl2);
            throw throwable;
        }
        this.setBlockData(bl2);
        IOException iOException = this.abortIOException;
        if (this.recursionDepth == 0) {
            this.abortIOException = null;
        }
        if (iOException != null) {
            throw iOException;
        }
        classNotFoundException = this.abortClassNotFoundException;
        if (this.recursionDepth == 0) {
            this.abortClassNotFoundException = null;
        }
        if (classNotFoundException != null) {
            throw classNotFoundException;
        }
        if (this.recursionDepth == 0) {
            this.doValidations();
        }
        return object2;
    }

    protected Object readObjectOverride() throws OptionalDataException, ClassNotFoundException, IOException {
        return null;
    }

    public short readShort() throws IOException {
        return this.dis.readShort();
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        short s = 0;
        short s2 = 0;
        try {
            s = this.readShort();
            s2 = this.readShort();
        }
        catch (EOFException eOFException) {
            throw new StreamCorruptedException("Caught EOFException while reading the stream header");
        }
        if (s != -21267) {
            throw new StreamCorruptedException("InputStream does not contain a serialized object");
        }
        if (s2 != 5) {
            throw new StreamCorruptedException("Version Mismatch, Expected 5 and got " + s2);
        }
    }

    public String readUTF() throws IOException {
        return this.dis.readUTF();
    }

    public int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.dis.readUnsignedShort();
    }

    private void refill() throws IOException {
        byte by;
        this.count = -1;
        try {
            by = this.peekCode();
        }
        catch (EOFException eOFException) {
            return;
        }
        if (by == 119) {
            by = this.readCode();
            int n = this.in.read();
            if (n < 0) {
                throw new StreamCorruptedException("EOF expecting count");
            }
            this.count = n & 0xFF;
        } else if (by == 122) {
            int n;
            int n2;
            int n3;
            by = this.readCode();
            int n4 = this.in.read();
            if ((n4 | (n3 = this.in.read()) | (n2 = this.in.read()) | (n = this.in.read())) < 0) {
                throw new StreamCorruptedException("EOF expecting count");
            }
            int n5 = n4 << 24 | n3 << 16 | n2 << 8 | n;
            if (n5 < 0) {
                throw new StreamCorruptedException("Negative block data size");
            }
            this.count = n5;
        }
    }

    public synchronized void registerValidation(ObjectInputValidation objectInputValidation, int n) throws NotActiveException, InvalidObjectException {
        if (this.recursionDepth == 0) {
            throw new NotActiveException("readObject not Active");
        }
        if (objectInputValidation == null) {
            throw new InvalidObjectException("Null is not a valid callback object");
        }
        ValidationCallback validationCallback = new ValidationCallback(objectInputValidation, n);
        if (this.callbacks == null) {
            this.callbacks = new ArrayList();
        }
        if (this.callbacks.isEmpty() || ((ValidationCallback)this.callbacks.get((int)(this.callbacks.size() - 1))).priority >= n) {
            this.callbacks.add(validationCallback);
            return;
        }
        int n2 = this.callbacks.size();
        int n3 = 0;
        while (n3 < n2) {
            ValidationCallback validationCallback2 = (ValidationCallback)this.callbacks.get(n3);
            if (validationCallback2.priority <= n) {
                this.callbacks.add(n3, validationCallback);
                break;
            }
            ++n3;
        }
    }

    private void resetStream() throws IOException {
        int n;
        if (this.wireHandle2Object == null) {
            this.wireHandle2Object = new ArrayList();
        } else {
            this.wireHandle2Object.clear();
        }
        this.nextWireOffset = 0;
        if (this.classes == null) {
            this.classes = new Class[20];
        } else {
            n = 0;
            while (n < this.classes.length) {
                this.classes[n] = null;
                ++n;
            }
        }
        if (this.classdesc == null) {
            this.classdesc = new ObjectStreamClass[20];
        } else {
            n = 0;
            while (n < this.classdesc.length) {
                this.classdesc[n] = null;
                ++n;
            }
        }
        this.spClass = 0;
        this.setBlockData(true);
        if (this.callbacks != null) {
            this.callbacks.clear();
        }
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        return this.loadClass0(null, objectStreamClass.getName());
    }

    protected Object resolveObject(Object object) throws IOException {
        return object;
    }

    private boolean setBlockData(boolean bl) throws IOException {
        if (this.blockDataMode == bl) {
            return bl;
        }
        if (this.blockDataMode && this.count > 0) {
            throw new StreamCorruptedException("Unread data");
        }
        this.count = bl ? 0 : -1;
        this.blockDataMode = bl;
        return bl ^ true;
    }

    public int skipBytes(int n) throws IOException {
        return this.dis.skipBytes(n);
    }

    public static abstract class GetField {
        public abstract boolean defaulted(String var1) throws IOException, IllegalArgumentException;

        public abstract byte get(String var1, byte var2) throws IOException, IllegalArgumentException;

        public abstract char get(String var1, char var2) throws IOException, IllegalArgumentException;

        public abstract double get(String var1, double var2) throws IOException, IllegalArgumentException;

        public abstract float get(String var1, float var2) throws IOException, IllegalArgumentException;

        public abstract int get(String var1, int var2) throws IOException, IllegalArgumentException;

        public abstract long get(String var1, long var2) throws IOException, IllegalArgumentException;

        public abstract Object get(String var1, Object var2) throws IOException, IllegalArgumentException;

        public abstract short get(String var1, short var2) throws IOException, IllegalArgumentException;

        public abstract boolean get(String var1, boolean var2) throws IOException, IllegalArgumentException;

        public abstract ObjectStreamClass getObjectStreamClass();
    }

    static final class GetFieldImpl
    extends GetField {
        private byte[] data;
        private Object[] objects;
        private ObjectStreamClass desc;

        GetFieldImpl(ObjectStreamClass objectStreamClass) {
            this.desc = objectStreamClass;
            if (this.desc.primBytes > 0) {
                this.data = new byte[this.desc.primBytes];
            }
            if (this.desc.objFields > 0) {
                this.objects = new Object[this.desc.objFields];
            }
        }

        private ObjectStreamField checkField(String string, Class clazz) throws IllegalArgumentException {
            ObjectStreamField objectStreamField;
            ObjectStreamField objectStreamField2;
            ObjectStreamField objectStreamField3 = objectStreamField2 = clazz == null ? this.desc.getField(string) : this.desc.getField(string, clazz);
            if (objectStreamField2 != null) {
                if (clazz != null && clazz != objectStreamField2.getType()) {
                    throw new IllegalArgumentException("field type incorrect");
                }
                return objectStreamField2;
            }
            ObjectStreamClass objectStreamClass = this.desc.localClassDescriptor();
            if (objectStreamClass == null) {
                throw new IllegalArgumentException("No local class descriptor");
            }
            ObjectStreamField objectStreamField4 = objectStreamField = clazz == null ? objectStreamClass.getField(string) : objectStreamClass.getField(string, clazz);
            if (objectStreamField == null) {
                throw new IllegalArgumentException("no such field");
            }
            if (clazz != null && clazz != objectStreamField.getType() && (clazz.isPrimitive() || objectStreamField.getType().isPrimitive())) {
                throw new IllegalArgumentException("field type incorrect");
            }
            return null;
        }

        public boolean defaulted(String string) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, null);
            return objectStreamField == null;
        }

        public byte get(String string, byte by) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, Byte.TYPE);
            if (objectStreamField == null) {
                return by;
            }
            return this.data[objectStreamField.getOffset()];
        }

        public char get(String string, char c) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, Character.TYPE);
            if (objectStreamField == null) {
                return c;
            }
            int n = objectStreamField.getOffset();
            return (char)(((this.data[n] & 0xFF) << 8) + (this.data[n + 1] & 0xFF));
        }

        public double get(String string, double d) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, Double.TYPE);
            if (objectStreamField == null) {
                return d;
            }
            int n = objectStreamField.getOffset();
            int n2 = ((this.data[n] & 0xFF) << 24) + ((this.data[n + 1] & 0xFF) << 16) + ((this.data[n + 2] & 0xFF) << 8) + (this.data[n + 3] & 0xFF);
            int n3 = ((this.data[n + 4] & 0xFF) << 24) + ((this.data[n + 5] & 0xFF) << 16) + ((this.data[n + 6] & 0xFF) << 8) + (this.data[n + 7] & 0xFF);
            long l = ((long)n2 << 32) + ((long)n3 & 0xFFFFFFFFL);
            return Double.longBitsToDouble(l);
        }

        public float get(String string, float f) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, Float.TYPE);
            if (objectStreamField == null) {
                return f;
            }
            int n = objectStreamField.getOffset();
            int n2 = ((this.data[n] & 0xFF) << 24) + ((this.data[n + 1] & 0xFF) << 16) + ((this.data[n + 2] & 0xFF) << 8) + (this.data[n + 3] & 0xFF);
            return Float.intBitsToFloat(n2);
        }

        public int get(String string, int n) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, Integer.TYPE);
            if (objectStreamField == null) {
                return n;
            }
            int n2 = objectStreamField.getOffset();
            return ((this.data[n2] & 0xFF) << 24) + ((this.data[n2 + 1] & 0xFF) << 16) + ((this.data[n2 + 2] & 0xFF) << 8) + (this.data[n2 + 3] & 0xFF);
        }

        public long get(String string, long l) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, Long.TYPE);
            if (objectStreamField == null) {
                return l;
            }
            int n = objectStreamField.getOffset();
            int n2 = ((this.data[n] & 0xFF) << 24) + ((this.data[n + 1] & 0xFF) << 16) + ((this.data[n + 2] & 0xFF) << 8) + (this.data[n + 3] & 0xFF);
            int n3 = ((this.data[n + 4] & 0xFF) << 24) + ((this.data[n + 5] & 0xFF) << 16) + ((this.data[n + 6] & 0xFF) << 8) + (this.data[n + 7] & 0xFF);
            long l2 = ((long)n2 << 32) + ((long)n3 & 0xFFFFFFFFL);
            return l2;
        }

        public Object get(String string, Object object) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ObjectInputStream.class$("java.lang.Object")));
            if (objectStreamField == null) {
                return object;
            }
            return this.objects[objectStreamField.getOffset()];
        }

        public short get(String string, short s) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, Short.TYPE);
            if (objectStreamField == null) {
                return s;
            }
            int n = objectStreamField.getOffset();
            return (short)(((this.data[n] & 0xFF) << 8) + (this.data[n + 1] & 0xFF));
        }

        public boolean get(String string, boolean bl) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, Boolean.TYPE);
            if (objectStreamField == null) {
                return bl;
            }
            return this.data[objectStreamField.getOffset()] != 0;
        }

        public ObjectStreamClass getObjectStreamClass() {
            return this.desc;
        }

        void read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            if (this.data != null) {
                objectInputStream.readFully(this.data, 0, this.data.length);
            }
            if (this.objects != null) {
                int n = 0;
                while (n < this.objects.length) {
                    this.objects[n] = objectInputStream.readObject(false);
                    ++n;
                }
            }
        }
    }
}

