/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPathIterator;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public final class GeneralPath
implements Shape,
Cloneable {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private static final byte SEG_MOVETO = 0;
    private static final byte SEG_LINETO = 1;
    private static final byte SEG_QUADTO = 2;
    private static final byte SEG_CUBICTO = 3;
    private static final byte SEG_CLOSE = 4;
    byte[] pointTypes;
    float[] pointCoords;
    int numTypes;
    int numCoords;
    int windingRule;
    static final int INIT_SIZE = 20;
    static final int EXPAND_MAX = 500;

    public GeneralPath() {
        this(1, 20, 20);
    }

    public GeneralPath(int n) {
        this(n, 20, 20);
    }

    public GeneralPath(int n, int n2) {
        this(n, n2, n2);
    }

    GeneralPath(int n, int n2, int n3) {
        this.setWindingRule(n);
        this.pointTypes = new byte[n2];
        this.pointCoords = new float[n3 * 2];
    }

    public GeneralPath(Shape shape) {
        this(1, 20, 20);
        PathIterator pathIterator = shape.getPathIterator(null);
        this.setWindingRule(pathIterator.getWindingRule());
        this.append(pathIterator, false);
    }

    public void append(Shape shape, boolean bl) {
        PathIterator pathIterator = shape.getPathIterator(null);
        this.append(pathIterator, bl);
    }

    public void append(PathIterator pathIterator, boolean bl) {
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    if (!bl || this.numTypes < 1 || this.numCoords < 2) {
                        this.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    if (this.pointTypes[this.numTypes - 1] != 4 && this.pointCoords[this.numCoords - 2] == fArray[0] && this.pointCoords[this.numCoords - 1] == fArray[1]) break;
                }
                case 1: {
                    this.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    this.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    this.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    this.closePath();
                    break;
                }
            }
            pathIterator.next();
            bl = false;
        }
    }

    public Object clone() {
        try {
            GeneralPath generalPath = (GeneralPath)super.clone();
            generalPath.pointTypes = (byte[])this.pointTypes.clone();
            generalPath.pointCoords = (float[])this.pointCoords.clone();
            return generalPath;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized void closePath() {
        if (this.numTypes == 0 || this.pointTypes[this.numTypes - 1] != 4) {
            this.needRoom(1, 0, true);
            this.pointTypes[this.numTypes++] = 4;
        }
    }

    public boolean contains(double d, double d2) {
        return new Area(this).contains(d, d2);
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return new Area(this).contains(d, d2, d3, d4);
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public synchronized Shape createTransformedShape(AffineTransform affineTransform) {
        GeneralPath generalPath = (GeneralPath)this.clone();
        if (affineTransform != null) {
            generalPath.transform(affineTransform);
        }
        return generalPath;
    }

    public synchronized void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.needRoom(1, 6, true);
        this.pointTypes[this.numTypes++] = 3;
        this.pointCoords[this.numCoords++] = f;
        this.pointCoords[this.numCoords++] = f2;
        this.pointCoords[this.numCoords++] = f3;
        this.pointCoords[this.numCoords++] = f4;
        this.pointCoords[this.numCoords++] = f5;
        this.pointCoords[this.numCoords++] = f6;
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public synchronized Rectangle2D getBounds2D() {
        float f;
        float f2;
        float f3;
        float f4;
        int n = this.numCoords;
        if (n > 0) {
            f3 = f4 = this.pointCoords[--n];
            f = f2 = this.pointCoords[--n];
            while (n > 0) {
                float f5;
                float f6 = this.pointCoords[--n];
                if ((f5 = this.pointCoords[--n]) < f) {
                    f = f5;
                }
                if (f6 < f3) {
                    f3 = f6;
                }
                if (f5 > f2) {
                    f2 = f5;
                }
                if (!(f6 > f4)) continue;
                f4 = f6;
            }
        } else {
            f4 = 0.0f;
            f2 = 0.0f;
            f3 = 0.0f;
            f = 0.0f;
        }
        return new Rectangle2D.Float(f, f3, f2 - f, f4 - f3);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized Point2D getCurrentPoint() {
        block8: {
            if (this.numTypes < 1 || this.numCoords < 2) {
                return null;
            }
            var1_1 = this.numCoords;
            if (this.pointTypes[this.numTypes - 1] != 4) break block8;
            var2_2 = this.numTypes - 2;
            block6: while (var2_2 > 0) {
                switch (this.pointTypes[var2_2]) {
                    case 1: {
                        var1_1 -= 2;
                        ** GOTO lbl16
                    }
                    case 2: {
                        var1_1 -= 4;
                        ** GOTO lbl16
                    }
                    case 3: {
                        var1_1 -= 6;
                    }
lbl16:
                    // 4 sources

                    default: {
                        --var2_2;
                        continue block6;
                    }
                    case 0: {
                        break block6;
                    }
                }
            }
        }
        return new Point2D.Float(this.pointCoords[var1_1 - 2], this.pointCoords[var1_1 - 1]);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new GeneralPathIterator(this, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }

    public synchronized int getWindingRule() {
        return this.windingRule;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return new Area(this).intersects(d, d2, d3, d4);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public synchronized void lineTo(float f, float f2) {
        this.needRoom(1, 2, true);
        this.pointTypes[this.numTypes++] = 1;
        this.pointCoords[this.numCoords++] = f;
        this.pointCoords[this.numCoords++] = f2;
    }

    public synchronized void moveTo(float f, float f2) {
        if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
            this.pointCoords[this.numCoords - 2] = f;
            this.pointCoords[this.numCoords - 1] = f2;
        } else {
            this.needRoom(1, 2, false);
            this.pointTypes[this.numTypes++] = 0;
            this.pointCoords[this.numCoords++] = f;
            this.pointCoords[this.numCoords++] = f2;
        }
    }

    private void needRoom(int n, int n2, boolean bl) {
        Object[] objectArray;
        int n3;
        if (bl && this.numTypes == 0) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        int n4 = this.pointCoords.length;
        if (this.numCoords + n2 > n4) {
            n3 = n4;
            if (n3 > 1000) {
                n3 = 1000;
            }
            if (n3 < n2) {
                n3 = n2;
            }
            objectArray = new float[n4 + n3];
            System.arraycopy(this.pointCoords, 0, objectArray, 0, this.numCoords);
            this.pointCoords = objectArray;
        }
        if (this.numTypes + n > (n4 = this.pointTypes.length)) {
            n3 = n4;
            if (n3 > 500) {
                n3 = 500;
            }
            if (n3 < n) {
                n3 = n;
            }
            objectArray = new byte[n4 + n3];
            System.arraycopy(this.pointTypes, 0, objectArray, 0, this.numTypes);
            this.pointTypes = (byte[])objectArray;
        }
    }

    public synchronized void quadTo(float f, float f2, float f3, float f4) {
        this.needRoom(1, 4, true);
        this.pointTypes[this.numTypes++] = 2;
        this.pointCoords[this.numCoords++] = f;
        this.pointCoords[this.numCoords++] = f2;
        this.pointCoords[this.numCoords++] = f3;
        this.pointCoords[this.numCoords++] = f4;
    }

    public synchronized void reset() {
        this.numCoords = 0;
        this.numTypes = 0;
    }

    public void setWindingRule(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("winding rule must be WIND_EVEN_ODD or WIND_NON_ZERO");
        }
        this.windingRule = n;
    }

    public void transform(AffineTransform affineTransform) {
        affineTransform.transform(this.pointCoords, 0, this.pointCoords, 0, this.numCoords / 2);
    }
}

