/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.FocusManager;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.im.InputContext;
import java.awt.peer.WindowPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import sun.security.action.GetPropertyAction;

public class Window
extends Container {
    String warningString;
    static final int OPENED = 1;
    int state;
    transient Vector ownedWindowList;
    private transient WeakReference weakThis;
    transient WindowListener windowListener;
    private transient boolean active = false;
    transient InputContext inputContext;
    private FocusManager focusMgr;
    private static final String base = "win";
    private static int nameCounter = 0;
    private static final long serialVersionUID = 4497834738069338734L;
    private int windowSerializedDataVersion = 1;

    static {
        Toolkit.loadLibraries();
        Window.initIDs();
    }

    Window() {
        this.setWarningString();
        this.focusMgr = new FocusManager(this);
        this.visible = false;
        this.inputContext = InputContext.getInstance();
    }

    public Window(Frame frame) {
        this();
        this.ownedInit(frame);
    }

    public Window(Window window) {
        this();
        this.ownedInit(window);
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createWindow(this);
            }
            super.addNotify();
        }
    }

    void addOwnedWindow(WeakReference weakReference) {
        if (weakReference != null) {
            if (this.ownedWindowList == null) {
                this.ownedWindowList = new Vector();
            }
            if (!this.ownedWindowList.contains(weakReference)) {
                this.ownedWindowList.addElement(weakReference);
            }
        }
    }

    public synchronized void addWindowListener(WindowListener windowListener) {
        if (windowListener == null) {
            return;
        }
        this.windowListener = AWTEventMulticaster.add(this.windowListener, windowListener);
        this.newEventsOnly = true;
    }

    public void applyResourceBundle(String string) {
        this.applyResourceBundle(ResourceBundle.getBundle(string));
    }

    public void applyResourceBundle(ResourceBundle resourceBundle) {
        this.applyOrientation(ComponentOrientation.getOrientation(resourceBundle));
    }

    void connectOwnedWindow(Window window) {
        WeakReference weakReference;
        window.weakThis = weakReference = new WeakReference(window);
        window.parent = this;
        this.addOwnedWindow(weakReference);
    }

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            Object var3_3 = null;
            return string;
        }
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 1004: {
                this.setFocusOwner(this);
                break;
            }
            case 101: {
                this.invalidate();
                this.validate();
                this.repaint();
                break;
            }
            case 205: {
                this.active = true;
                break;
            }
            case 206: {
                this.active = false;
                break;
            }
        }
        super.dispatchEventImpl(aWTEvent);
    }

    public void dispose() {
        class DisposeAction
        implements Runnable {
            private final /* synthetic */ Window this$0;

            DisposeAction(Window window) {
                this.this$0 = window;
            }

            public void run() {
                if (this.this$0.ownedWindowList != null) {
                    Vector vector = this.this$0.ownedWindowList;
                    synchronized (vector) {
                        int n = 0;
                        while (n < this.this$0.ownedWindowList.size()) {
                            Window window = (Window)((WeakReference)this.this$0.ownedWindowList.elementAt(n)).get();
                            if (window != null) {
                                window.dispose();
                            }
                            ++n;
                        }
                    }
                }
                this.this$0.hide();
                this.this$0.removeNotify();
            }
        }
        DisposeAction disposeAction = new DisposeAction(this);
        if (EventQueue.isDispatchThread()) {
            disposeAction.run();
        } else {
            try {
                EventQueue.invokeAndWait(disposeAction);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Disposal was interrupted:");
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("Exception during disposal:");
                invocationTargetException.printStackTrace();
            }
        }
        this.postWindowEvent(202);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        switch (aWTEvent.id) {
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                return (this.eventMask & 0x40L) != 0L || this.windowListener != null;
            }
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void finalize() throws Throwable {
        this.inputContext.dispose();
        if (this.parent != null) {
            ((Window)this.parent).removeOwnedWindow(this.weakThis);
        }
        super.finalize();
    }

    public Component getFocusOwner() {
        if (this.active) {
            return this.focusMgr.getFocusOwner();
        }
        return null;
    }

    public InputContext getInputContext() {
        return this.inputContext;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public Window[] getOwnedWindows() {
        Window[] windowArray;
        if (this.ownedWindowList != null) {
            Vector vector = this.ownedWindowList;
            synchronized (vector) {
                int n = this.ownedWindowList.size();
                int n2 = 0;
                Window[] windowArray2 = new Window[n];
                int n3 = 0;
                while (n3 < n) {
                    windowArray2[n2] = (Window)((WeakReference)this.ownedWindowList.elementAt(n3)).get();
                    if (windowArray2[n2] != null) {
                        ++n2;
                    }
                    ++n3;
                }
                if (n != n2) {
                    windowArray = new Frame[n2];
                    System.arraycopy(windowArray2, 0, windowArray, 0, n2);
                } else {
                    windowArray = windowArray2;
                }
            }
        } else {
            windowArray = new Window[]{};
        }
        return windowArray;
    }

    public Window getOwner() {
        return (Window)this.parent;
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public final String getWarningString() {
        return this.warningString;
    }

    private static native void initIDs();

    boolean isActive() {
        return this.active;
    }

    public boolean isShowing() {
        return this.visible;
    }

    void nextFocus(Component component) {
        this.focusMgr.focusNext(component);
    }

    private void ownedInit(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("null owner window");
        }
        this.parent = window;
        this.weakThis = new WeakReference(this);
        window.addOwnedWindow(this.weakThis);
        this.setLayout(new BorderLayout());
    }

    public void pack() {
        Container container = this.parent;
        if (container != null && container.getPeer() == null) {
            container.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        this.setSize(this.getPreferredSize());
        this.isPacked = true;
        this.validate();
    }

    public boolean postEvent(Event event) {
        if (this.handleEvent(event)) {
            event.consume();
            return true;
        }
        return false;
    }

    void postProcessKeyEvent(KeyEvent keyEvent) {
        WindowPeer windowPeer = (WindowPeer)this.peer;
        if (windowPeer == null) {
            return;
        }
        switch (windowPeer.handleFocusTraversalEvent(keyEvent)) {
            case 1: {
                keyEvent.consume();
                break;
            }
            case 2: {
                if (!this.focusMgr.focusNext()) break;
                keyEvent.consume();
                break;
            }
            case 3: {
                if (!this.focusMgr.focusPrevious()) break;
                keyEvent.consume();
            }
        }
    }

    synchronized void postWindowEvent(int n) {
        if (this.windowListener != null || (this.eventMask & 0x40L) != 0L) {
            WindowEvent windowEvent = new WindowEvent(this, n);
            Toolkit.getEventQueue().postEvent(windowEvent);
        }
    }

    void preProcessKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isActionKey() && keyEvent.getKeyCode() == 112 && keyEvent.isControlDown() && keyEvent.isShiftDown() && keyEvent.getID() == 401) {
            this.list(System.out, 0);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof WindowEvent) {
            this.processWindowEvent((WindowEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (this.windowListener != null) {
            switch (windowEvent.getID()) {
                case 200: {
                    this.windowListener.windowOpened(windowEvent);
                    break;
                }
                case 201: {
                    this.windowListener.windowClosing(windowEvent);
                    break;
                }
                case 202: {
                    this.windowListener.windowClosed(windowEvent);
                    break;
                }
                case 203: {
                    this.windowListener.windowIconified(windowEvent);
                    break;
                }
                case 204: {
                    this.windowListener.windowDeiconified(windowEvent);
                    break;
                }
                case 205: {
                    this.windowListener.windowActivated(windowEvent);
                    break;
                }
                case 206: {
                    this.windowListener.windowDeactivated(windowEvent);
                    break;
                }
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        String string;
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            string = ((String)object).intern();
            if (string == "windowL") {
                this.addWindowListener((WindowListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
        try {
            while ((object = objectInputStream.readObject()) != null) {
                string = ((String)object).intern();
                if (string == "ownedL") {
                    this.connectOwnedWindow((Window)objectInputStream.readObject());
                    continue;
                }
                objectInputStream.readObject();
            }
        }
        catch (OptionalDataException optionalDataException) {}
        this.setWarningString();
        this.inputContext = InputContext.getInstance();
    }

    void removeOwnedWindow(WeakReference weakReference) {
        if (weakReference != null && this.ownedWindowList != null) {
            this.ownedWindowList.removeElement(weakReference);
        }
    }

    public synchronized void removeWindowListener(WindowListener windowListener) {
        if (windowListener == null) {
            return;
        }
        this.windowListener = AWTEventMulticaster.remove(this.windowListener, windowListener);
    }

    void setFocusOwner(Component component) {
        this.focusMgr.setFocusOwner(component);
    }

    private void setWarningString() {
        this.warningString = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && !securityManager.checkTopLevelWindow(this)) {
            this.warningString = (String)AccessController.doPrivileged(new GetPropertyAction("awt.appletWarning", "Warning: Applet Window"));
        }
    }

    public void show() {
        Container container = this.parent;
        if (container != null && container.getPeer() == null) {
            container.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        this.validate();
        if (this.visible) {
            this.toFront();
        } else {
            super.show();
        }
        if ((this.state & 1) == 0) {
            this.postWindowEvent(200);
            this.state |= 1;
        }
    }

    public void toBack() {
        WindowPeer windowPeer = (WindowPeer)this.peer;
        if (windowPeer != null) {
            windowPeer.toBack();
        }
    }

    public void toFront() {
        WindowPeer windowPeer = (WindowPeer)this.peer;
        if (windowPeer != null) {
            windowPeer.toFront();
        }
    }

    void transferFocus(Component component) {
        this.nextFocus(component);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "windowL", this.windowListener);
        objectOutputStream.writeObject(null);
        if (this.ownedWindowList != null) {
            Vector vector = this.ownedWindowList;
            synchronized (vector) {
                int n = 0;
                while (n < this.ownedWindowList.size()) {
                    Window window = (Window)((WeakReference)this.ownedWindowList.elementAt(n)).get();
                    if (window != null) {
                        objectOutputStream.writeObject("ownedL");
                        objectOutputStream.writeObject(window);
                    }
                    ++n;
                }
            }
        }
        objectOutputStream.writeObject(null);
    }
}

