/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.IntegerInterleavedRaster;

abstract class TexturePaintContext
implements PaintContext {
    ColorModel colorModel;
    int bWidth;
    int bHeight;
    int maxWidth;
    WritableRaster outRas;
    double xOrg;
    double yOrg;
    double incXAcross;
    double incYAcross;
    double incXDown;
    double incYDown;
    int colincx;
    int colincy;
    int colincxerr;
    int colincyerr;
    int rowincx;
    int rowincy;
    int rowincxerr;
    int rowincyerr;

    TexturePaintContext(ColorModel colorModel, AffineTransform affineTransform, int n, int n2, int n3) {
        this.colorModel = colorModel;
        this.bWidth = n;
        this.bHeight = n2;
        this.maxWidth = n3;
        try {
            affineTransform = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            affineTransform.setToScale(0.0, 0.0);
        }
        this.incXAcross = TexturePaintContext.mod(affineTransform.getScaleX(), n);
        this.incYAcross = TexturePaintContext.mod(affineTransform.getShearY(), n2);
        this.incXDown = TexturePaintContext.mod(affineTransform.getShearX(), n);
        this.incYDown = TexturePaintContext.mod(affineTransform.getScaleY(), n2);
        this.xOrg = affineTransform.getTranslateX();
        this.yOrg = affineTransform.getTranslateY();
        this.colincx = (int)this.incXAcross;
        this.colincy = (int)this.incYAcross;
        this.colincxerr = TexturePaintContext.fractAsInt(this.incXAcross);
        this.colincyerr = TexturePaintContext.fractAsInt(this.incYAcross);
        this.rowincx = (int)this.incXDown;
        this.rowincy = (int)this.incYDown;
        this.rowincxerr = TexturePaintContext.fractAsInt(this.incXDown);
        this.rowincyerr = TexturePaintContext.fractAsInt(this.incYDown);
    }

    public void dispose() {
    }

    static int fractAsInt(double d) {
        return (int)(d % 1.0 * 2.147483647E9);
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public static PaintContext getContext(BufferedImage bufferedImage, AffineTransform affineTransform, RenderingHints renderingHints, Rectangle rectangle) {
        ByteInterleavedRaster byteInterleavedRaster;
        WritableRaster writableRaster = bufferedImage.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        int n = rectangle.width;
        if (writableRaster instanceof IntegerInterleavedRaster) {
            IntegerInterleavedRaster integerInterleavedRaster = (IntegerInterleavedRaster)writableRaster;
            if (integerInterleavedRaster.getNumDataElements() == 1 && integerInterleavedRaster.getPixelStride() == 1) {
                return new Int(integerInterleavedRaster, colorModel, affineTransform, n);
            }
        } else if (writableRaster instanceof ByteInterleavedRaster && (byteInterleavedRaster = (ByteInterleavedRaster)writableRaster).getNumDataElements() == 1 && byteInterleavedRaster.getPixelStride() == 1) {
            return new Byte(byteInterleavedRaster, colorModel, affineTransform, n);
        }
        return new Any(writableRaster, colorModel, affineTransform, n);
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        if (this.outRas == null || this.outRas.getWidth() < n3 || this.outRas.getHeight() < n4) {
            this.outRas = this.makeRaster(n4 == 1 ? Math.max(n3, this.maxWidth) : n3, n4);
        }
        double d = TexturePaintContext.mod(this.xOrg + (double)n * this.incXAcross + (double)n2 * this.incXDown, this.bWidth);
        double d2 = TexturePaintContext.mod(this.yOrg + (double)n * this.incYAcross + (double)n2 * this.incYDown, this.bHeight);
        this.setRaster((int)d, (int)d2, (int)(d % 1.0 * 2.147483647E9), (int)(d2 % 1.0 * 2.147483647E9), n3, n4, this.bWidth, this.bHeight, this.colincx, this.colincxerr, this.colincy, this.colincyerr, this.rowincx, this.rowincxerr, this.rowincy, this.rowincyerr);
        return this.outRas;
    }

    public abstract WritableRaster makeRaster(int var1, int var2);

    static double mod(double d, double d2) {
        if ((d %= d2) < 0.0 && (d += d2) >= d2) {
            d = 0.0;
        }
        return d;
    }

    public abstract void setRaster(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16);

    static class Int
    extends TexturePaintContext {
        IntegerInterleavedRaster srcRas;
        int[] inData;
        int inOff;
        int inSpan;
        int[] outData;
        int outOff;
        int outSpan;

        public Int(IntegerInterleavedRaster integerInterleavedRaster, ColorModel colorModel, AffineTransform affineTransform, int n) {
            super(colorModel, affineTransform, integerInterleavedRaster.getWidth(), integerInterleavedRaster.getHeight(), n);
            this.srcRas = integerInterleavedRaster;
            this.inData = integerInterleavedRaster.getDataStorage();
            this.inSpan = integerInterleavedRaster.getScanlineStride();
            this.inOff = integerInterleavedRaster.getDataOffset(0);
        }

        public WritableRaster makeRaster(int n, int n2) {
            WritableRaster writableRaster = this.srcRas.createCompatibleWritableRaster(n, n2);
            IntegerInterleavedRaster integerInterleavedRaster = (IntegerInterleavedRaster)writableRaster;
            this.outData = integerInterleavedRaster.getDataStorage();
            this.outSpan = integerInterleavedRaster.getScanlineStride();
            this.outOff = integerInterleavedRaster.getDataOffset(0);
            return writableRaster;
        }

        public void setRaster(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
            int[] nArray = this.inData;
            int[] nArray2 = this.outData;
            int n17 = this.outOff;
            int n18 = this.inSpan;
            int n19 = this.inOff;
            int n20 = this.outSpan;
            boolean bl = n9 == 1 && n10 == 0 && n11 == 0 && n12 == 0;
            int n21 = n;
            int n22 = n2;
            int n23 = n3;
            int n24 = n4;
            if (bl) {
                n20 -= n5;
            }
            int n25 = 0;
            while (n25 < n6) {
                int n26;
                if (bl) {
                    int n27;
                    n26 = n19 + n22 * n18 + n7;
                    n = n7 - n21;
                    n17 += n5;
                    if (n7 >= 32) {
                        n27 = n5;
                        while (n27 > 0) {
                            int n28 = n27 < n ? n27 : n;
                            System.arraycopy(nArray, n26 - n, nArray2, n17 - n27, n28);
                            n27 -= n28;
                            if ((n -= n28) != 0) continue;
                            n = n7;
                        }
                    } else {
                        n27 = n5;
                        while (n27 > 0) {
                            nArray2[n17 - n27] = nArray[n26 - n];
                            if (--n == 0) {
                                n = n7;
                            }
                            --n27;
                        }
                    }
                } else {
                    n = n21;
                    n2 = n22;
                    n3 = n23;
                    n4 = n24;
                    n26 = 0;
                    while (n26 < n5) {
                        nArray2[n17 + n26] = nArray[n19 + n2 * n18 + n];
                        if ((n3 += n10) < 0) {
                            n3 &= Integer.MAX_VALUE;
                            ++n;
                        }
                        if ((n += n9) >= n7) {
                            n -= n7;
                        }
                        if ((n4 += n12) < 0) {
                            n4 &= Integer.MAX_VALUE;
                            ++n2;
                        }
                        if ((n2 += n11) >= n8) {
                            n2 -= n8;
                        }
                        ++n26;
                    }
                }
                if ((n23 += n14) < 0) {
                    n23 &= Integer.MAX_VALUE;
                    ++n21;
                }
                if ((n21 += n13) >= n7) {
                    n21 -= n7;
                }
                if ((n24 += n16) < 0) {
                    n24 &= Integer.MAX_VALUE;
                    ++n22;
                }
                if ((n22 += n15) >= n8) {
                    n22 -= n8;
                }
                n17 += n20;
                ++n25;
            }
        }
    }

    static class Byte
    extends TexturePaintContext {
        ByteInterleavedRaster srcRas;
        byte[] inData;
        int inOff;
        int inSpan;
        byte[] outData;
        int outOff;
        int outSpan;

        public Byte(ByteInterleavedRaster byteInterleavedRaster, ColorModel colorModel, AffineTransform affineTransform, int n) {
            super(colorModel, affineTransform, byteInterleavedRaster.getWidth(), byteInterleavedRaster.getHeight(), n);
            this.srcRas = byteInterleavedRaster;
            this.inData = byteInterleavedRaster.getDataStorage();
            this.inSpan = byteInterleavedRaster.getScanlineStride();
            this.inOff = byteInterleavedRaster.getDataOffset(0);
        }

        public WritableRaster makeRaster(int n, int n2) {
            WritableRaster writableRaster = this.srcRas.createCompatibleWritableRaster(n, n2);
            ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)writableRaster;
            this.outData = byteInterleavedRaster.getDataStorage();
            this.outSpan = byteInterleavedRaster.getScanlineStride();
            this.outOff = byteInterleavedRaster.getDataOffset(0);
            return writableRaster;
        }

        public void setRaster(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
            byte[] byArray = this.inData;
            byte[] byArray2 = this.outData;
            int n17 = this.outOff;
            int n18 = this.inSpan;
            int n19 = this.inOff;
            int n20 = this.outSpan;
            boolean bl = n9 == 1 && n10 == 0 && n11 == 0 && n12 == 0;
            int n21 = n;
            int n22 = n2;
            int n23 = n3;
            int n24 = n4;
            if (bl) {
                n20 -= n5;
            }
            int n25 = 0;
            while (n25 < n6) {
                int n26;
                if (bl) {
                    int n27;
                    n26 = n19 + n22 * n18 + n7;
                    n = n7 - n21;
                    n17 += n5;
                    if (n7 >= 32) {
                        n27 = n5;
                        while (n27 > 0) {
                            int n28 = n27 < n ? n27 : n;
                            System.arraycopy(byArray, n26 - n, byArray2, n17 - n27, n28);
                            n27 -= n28;
                            if ((n -= n28) != 0) continue;
                            n = n7;
                        }
                    } else {
                        n27 = n5;
                        while (n27 > 0) {
                            byArray2[n17 - n27] = byArray[n26 - n];
                            if (--n == 0) {
                                n = n7;
                            }
                            --n27;
                        }
                    }
                } else {
                    n = n21;
                    n2 = n22;
                    n3 = n23;
                    n4 = n24;
                    n26 = 0;
                    while (n26 < n5) {
                        byArray2[n17 + n26] = byArray[n19 + n2 * n18 + n];
                        if ((n3 += n10) < 0) {
                            n3 &= Integer.MAX_VALUE;
                            ++n;
                        }
                        if ((n += n9) >= n7) {
                            n -= n7;
                        }
                        if ((n4 += n12) < 0) {
                            n4 &= Integer.MAX_VALUE;
                            ++n2;
                        }
                        if ((n2 += n11) >= n8) {
                            n2 -= n8;
                        }
                        ++n26;
                    }
                }
                if ((n23 += n14) < 0) {
                    n23 &= Integer.MAX_VALUE;
                    ++n21;
                }
                if ((n21 += n13) >= n7) {
                    n21 -= n7;
                }
                if ((n24 += n16) < 0) {
                    n24 &= Integer.MAX_VALUE;
                    ++n22;
                }
                if ((n22 += n15) >= n8) {
                    n22 -= n8;
                }
                n17 += n20;
                ++n25;
            }
        }
    }

    static class Any
    extends TexturePaintContext {
        WritableRaster srcRas;

        public Any(WritableRaster writableRaster, ColorModel colorModel, AffineTransform affineTransform, int n) {
            super(colorModel, affineTransform, writableRaster.getWidth(), writableRaster.getHeight(), n);
            this.srcRas = writableRaster;
        }

        public WritableRaster makeRaster(int n, int n2) {
            return this.srcRas.createCompatibleWritableRaster(n, n2);
        }

        public void setRaster(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
            Object object = null;
            int n17 = n;
            int n18 = n2;
            int n19 = n3;
            int n20 = n4;
            WritableRaster writableRaster = this.srcRas;
            WritableRaster writableRaster2 = this.outRas;
            int n21 = 0;
            while (n21 < n6) {
                n = n17;
                n2 = n18;
                n3 = n19;
                n4 = n20;
                int n22 = 0;
                while (n22 < n5) {
                    object = writableRaster.getDataElements(n, n2, object);
                    writableRaster2.setDataElements(n22, n21, object);
                    if ((n3 += n10) < 0) {
                        n3 &= Integer.MAX_VALUE;
                        ++n;
                    }
                    if ((n += n9) >= n7) {
                        n -= n7;
                    }
                    if ((n4 += n12) < 0) {
                        n4 &= Integer.MAX_VALUE;
                        ++n2;
                    }
                    if ((n2 += n11) >= n8) {
                        n2 -= n8;
                    }
                    ++n22;
                }
                if ((n19 += n14) < 0) {
                    n19 &= Integer.MAX_VALUE;
                    ++n17;
                }
                if ((n17 += n13) >= n7) {
                    n17 -= n7;
                }
                if ((n20 += n16) < 0) {
                    n20 &= Integer.MAX_VALUE;
                    ++n18;
                }
                if ((n18 += n15) >= n8) {
                    n18 -= n8;
                }
                ++n21;
            }
        }
    }
}

