/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ChoicePeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class Choice
extends Component
implements ItemSelectable {
    Vector pItems = new Vector();
    int selectedIndex = -1;
    transient ItemListener itemListener;
    private static final String base = "choice";
    private static int nameCounter = 0;
    private static final long serialVersionUID = -4075310674757313071L;
    private int choiceSerializedDataVersion = 1;

    public void add(String string) {
        this.addItem(string);
    }

    public void addItem(String string) {
        Choice choice = this;
        synchronized (choice) {
            this.addItemNoInvalidate(string);
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
        this.newEventsOnly = true;
    }

    private void addItemNoInvalidate(String string) {
        if (string == null) {
            throw new NullPointerException("cannot add null item to Choice");
        }
        this.pItems.addElement(string);
        ChoicePeer choicePeer = (ChoicePeer)this.peer;
        if (choicePeer != null) {
            choicePeer.addItem(string, this.pItems.size() - 1);
        }
        if (this.selectedIndex < 0) {
            this.select(0);
        }
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createChoice(this);
            }
            super.addNotify();
        }
    }

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            Object var3_3 = null;
            return string;
        }
    }

    public int countItems() {
        return this.pItems.size();
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 701) {
            return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    public String getItem(int n) {
        return this.getItemImpl(n);
    }

    public int getItemCount() {
        return this.countItems();
    }

    final String getItemImpl(int n) {
        return (String)this.pItems.elementAt(n);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized String getSelectedItem() {
        return this.selectedIndex >= 0 ? this.getItem(this.selectedIndex) : null;
    }

    public synchronized Object[] getSelectedObjects() {
        if (this.selectedIndex >= 0) {
            Object[] objectArray = new Object[]{this.getItem(this.selectedIndex)};
            return objectArray;
        }
        return null;
    }

    public void insert(String string, int n) {
        Choice choice = this;
        synchronized (choice) {
            if (n < 0) {
                throw new IllegalArgumentException("index less than zero.");
            }
            int n2 = this.getItemCount();
            Vector vector = new Vector();
            int n3 = n;
            while (n3 < n2) {
                vector.addElement(this.getItem(n));
                this.removeNoInvalidate(n);
                ++n3;
            }
            this.addItemNoInvalidate(string);
            int n4 = 0;
            while (n4 < vector.size()) {
                this.addItemNoInvalidate((String)vector.elementAt(n4));
                ++n4;
            }
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",current=" + this.getSelectedItem();
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(itemEvent);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            String string = ((String)object).intern();
            if (string == "itemL") {
                this.addItemListener((ItemListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    public void remove(int n) {
        Choice choice = this;
        synchronized (choice) {
            this.removeNoInvalidate(n);
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    public void remove(String string) {
        Choice choice = this;
        synchronized (choice) {
            int n = this.pItems.indexOf(string);
            if (n < 0) {
                throw new IllegalArgumentException("item " + string + " not found in choice");
            }
            this.removeNoInvalidate(n);
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    public void removeAll() {
        Choice choice = this;
        synchronized (choice) {
            int n = this.getItemCount();
            int n2 = 0;
            while (n2 < n) {
                this.removeNoInvalidate(0);
                ++n2;
            }
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    private void removeNoInvalidate(int n) {
        this.pItems.removeElementAt(n);
        ChoicePeer choicePeer = (ChoicePeer)this.peer;
        if (choicePeer != null) {
            choicePeer.remove(n);
        }
        if (this.pItems.size() == 0) {
            this.selectedIndex = -1;
        } else if (this.selectedIndex == n) {
            this.select(0);
        } else if (this.selectedIndex > n) {
            this.select(this.selectedIndex - 1);
        }
    }

    public synchronized void select(int n) {
        if (n >= this.pItems.size() || n < 0) {
            throw new IllegalArgumentException("illegal Choice item position: " + n);
        }
        if (this.pItems.size() > 0) {
            this.selectedIndex = n;
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            if (choicePeer != null) {
                choicePeer.select(n);
            }
        }
    }

    public synchronized void select(String string) {
        int n = this.pItems.indexOf(string);
        if (n >= 0) {
            this.select(n);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "itemL", this.itemListener);
        objectOutputStream.writeObject(null);
    }
}

