/*
 * Decompiled with CFR 0.152.
 */
package com.sun.CORBA.iiop;

import com.sun.CORBA.IOR;
import com.sun.CORBA.ServiceContext;
import com.sun.CORBA.iiop.CDRInputStream;
import com.sun.CORBA.iiop.IIOPInputStream;
import com.sun.CORBA.iiop.Message;
import com.sun.CORBA.util.Utility;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public final class ReplyMessage
extends Message {
    private ServiceContext[] ctx;
    private int status;
    private String exceptionId;
    private String exClassName;
    private int minorCode;
    private CompletionStatus completionStatus;
    private IOR ior;
    public static final int NO_EXCEPTION = 0;
    public static final int USER_EXCEPTION = 1;
    public static final int SYSTEM_EXCEPTION = 2;
    public static final int LOCATION_FORWARD = 3;

    public ReplyMessage() {
    }

    public ReplyMessage(ServiceContext[] serviceContextArray, int n, int n2) {
        this.setType(1);
        this.ctx = serviceContextArray;
        this.requestId = n;
        this.status = n2;
    }

    public String getExceptionId() {
        return this.exceptionId;
    }

    public IOR getIOR() {
        return this.ior;
    }

    public int getMinorCode() {
        return this.minorCode;
    }

    public int getReplyStatus() {
        return this.status;
    }

    public ServiceContext[] getServiceContextList() {
        return this.ctx;
    }

    public SystemException getSystemException() {
        SystemException systemException;
        try {
            systemException = (SystemException)Class.forName(this.exClassName).newInstance();
        }
        catch (Exception exception) {
            throw new INTERNAL("BAD SystemException: " + this.exClassName, 0, CompletionStatus.COMPLETED_MAYBE);
        }
        systemException.minor = this.minorCode;
        systemException.completed = this.completionStatus;
        return systemException;
    }

    public void read(InputStream inputStream) throws SystemException {
        block10: {
            block9: {
                this.ctx = new ServiceContext[inputStream.read_long()];
                int n = 0;
                while (n < this.ctx.length) {
                    this.ctx[n] = new ServiceContext();
                    this.ctx[n].read(inputStream);
                    ++n;
                }
                this.requestId = inputStream.read_long();
                this.status = inputStream.read_long();
                if (this.status != 2) break block9;
                String string = inputStream.read_string();
                this.exClassName = Utility.classNameOf(string);
                this.minorCode = inputStream.read_long();
                int n2 = inputStream.read_long();
                switch (n2) {
                    case 0: {
                        this.completionStatus = CompletionStatus.COMPLETED_YES;
                        break block10;
                    }
                    case 1: {
                        this.completionStatus = CompletionStatus.COMPLETED_NO;
                        break block10;
                    }
                    case 2: {
                        this.completionStatus = CompletionStatus.COMPLETED_MAYBE;
                        break block10;
                    }
                    default: {
                        throw new INTERNAL("BAD completion status: " + n2, 0, CompletionStatus.COMPLETED_MAYBE);
                    }
                }
            }
            if (this.status == 1) {
                IIOPInputStream iIOPInputStream = (IIOPInputStream)inputStream;
                this.exceptionId = iIOPInputStream.peek_string();
            } else if (this.status == 3) {
                CDRInputStream cDRInputStream = (CDRInputStream)inputStream;
                this.ior = new IOR(cDRInputStream.orb);
                this.ior.read(inputStream);
            }
        }
    }

    public void write(OutputStream outputStream) throws SystemException {
        super.write(outputStream);
        if (this.ctx != null) {
            outputStream.write_long(this.ctx.length);
            int n = 0;
            while (n < this.ctx.length) {
                this.ctx[n].write(outputStream);
                ++n;
            }
        } else {
            outputStream.write_long(0);
        }
        outputStream.write_long(this.requestId);
        outputStream.write_long(this.status);
    }
}

