/*
 * Decompiled with CFR 0.152.
 */
package com.sun.CORBA.iiop;

import com.sun.CORBA.ClientSubcontract;
import com.sun.CORBA.IOR;
import com.sun.CORBA.MarshalOutputStream;
import com.sun.CORBA.ORB;
import com.sun.CORBA.idl.TypeCodeImpl;
import com.sun.CORBA.iiop.CDRInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;

public class CDROutputStream
extends org.omg.CORBA.portable.OutputStream
implements MarshalOutputStream {
    static final int DEFAULT_BUFFER_SIZE = 1024;
    protected boolean littleEndian;
    protected int size;
    protected byte[] buf;
    protected ORB orb;

    public CDROutputStream(org.omg.CORBA.ORB oRB) {
        this(oRB, false);
    }

    public CDROutputStream(org.omg.CORBA.ORB oRB, boolean bl) {
        this(oRB, bl, 1024);
    }

    public CDROutputStream(org.omg.CORBA.ORB oRB, boolean bl, int n) {
        this.orb = (ORB)oRB;
        this.littleEndian = bl;
        this.buf = new byte[n];
        this.size = 0;
    }

    private final void alignAndReserve(int n, int n2) {
        int n3;
        this.size = n3 = this.size - 1 + n & ~(n - 1);
        if (n3 + n2 < this.buf.length) {
            return;
        }
        this.grow(n, n2);
    }

    public InputStream create_input_stream() {
        return new CDRInputStream(this.orb, this.buf, this.size, this.littleEndian);
    }

    public final int getSize() {
        return this.size;
    }

    protected void grow(int n, int n2) {
        if (this.buf == null) {
            this.buf = new byte[1024];
            return;
        }
        byte[] byArray = this.buf;
        this.buf = new byte[byArray.length * 2];
        System.arraycopy(byArray, 0, this.buf, 0, byArray.length);
    }

    public final void putEndian() throws SystemException {
        this.write_boolean(this.littleEndian);
    }

    public final void reset() {
        this.size = 0;
    }

    public final byte[] toByteArray() {
        byte[] byArray = new byte[this.size];
        System.arraycopy(this.buf, 0, byArray, 0, this.size);
        return byArray;
    }

    public void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream outputStream) {
        outputStream.write_long(this.size);
        outputStream.write_octet_array(this.buf, 0, this.size);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.size);
    }

    public final void write_Object(Object object) {
        if (object == null) {
            new IOR(this.orb, "", null).write(this);
            return;
        }
        ObjectImpl objectImpl = (ObjectImpl)object;
        ClientSubcontract clientSubcontract = null;
        try {
            clientSubcontract = (ClientSubcontract)((java.lang.Object)objectImpl._get_delegate());
        }
        catch (Exception exception) {}
        if (clientSubcontract == null) {
            this.orb.connect(object);
            clientSubcontract = (ClientSubcontract)((java.lang.Object)objectImpl._get_delegate());
        }
        IOR iOR = clientSubcontract.marshal();
        iOR.write(this);
    }

    public final void write_Principal(Principal principal) {
        this.write_long(principal.name().length);
        this.write_octet_array(principal.name(), 0, principal.name().length);
    }

    public final void write_TypeCode(TypeCode typeCode) {
        if (typeCode == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        TypeCodeImpl typeCodeImpl = typeCode instanceof TypeCodeImpl ? (TypeCodeImpl)typeCode : new TypeCodeImpl(this.orb, typeCode);
        typeCodeImpl.write_value(this);
    }

    public final void write_any(Any any) {
        if (any == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_TypeCode(any.type());
        any.write_value(this);
    }

    public final void write_boolean(boolean bl) {
        this.write_octet(bl ? (byte)1 : 0);
    }

    public final void write_boolean_array(boolean[] blArray, int n, int n2) {
        if (blArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.write_boolean(blArray[n3 + n]);
            ++n3;
        }
    }

    public final void write_char(char c) {
        this.alignAndReserve(1, 1);
        if (c > '\u00ff') {
            throw new MARSHAL(6, CompletionStatus.COMPLETED_NO);
        }
        this.buf[this.size++] = (byte)(c & 0xFF);
    }

    public final void write_char_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.write_char(cArray[n3 + n]);
            ++n3;
        }
    }

    public final void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    public final void write_double_array(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.write_double(dArray[n3 + n]);
            ++n3;
        }
    }

    public final void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    public final void write_float_array(float[] fArray, int n, int n2) {
        if (fArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.write_float(fArray[n3 + n]);
            ++n3;
        }
    }

    public final void write_long(int n) {
        this.alignAndReserve(4, 4);
        if (this.littleEndian) {
            this.buf[this.size++] = (byte)(n & 0xFF);
            this.buf[this.size++] = (byte)(n >>> 8 & 0xFF);
            this.buf[this.size++] = (byte)(n >>> 16 & 0xFF);
            this.buf[this.size++] = (byte)(n >>> 24 & 0xFF);
        } else {
            this.buf[this.size++] = (byte)(n >>> 24 & 0xFF);
            this.buf[this.size++] = (byte)(n >>> 16 & 0xFF);
            this.buf[this.size++] = (byte)(n >>> 8 & 0xFF);
            this.buf[this.size++] = (byte)(n & 0xFF);
        }
    }

    public final void write_long_array(int[] nArray, int n, int n2) {
        if (nArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.write_long(nArray[n3 + n]);
            ++n3;
        }
    }

    public final void write_longlong(long l) {
        this.alignAndReserve(8, 8);
        if (this.littleEndian) {
            this.buf[this.size++] = (byte)(l & 0xFFL);
            this.buf[this.size++] = (byte)(l >>> 8 & 0xFFL);
            this.buf[this.size++] = (byte)(l >>> 16 & 0xFFL);
            this.buf[this.size++] = (byte)(l >>> 24 & 0xFFL);
            this.buf[this.size++] = (byte)(l >>> 32 & 0xFFL);
            this.buf[this.size++] = (byte)(l >>> 40 & 0xFFL);
            this.buf[this.size++] = (byte)(l >>> 48 & 0xFFL);
            this.buf[this.size++] = (byte)(l >>> 56 & 0xFFL);
        } else {
            this.buf[this.size++] = (byte)(l >>> 56 & 0xFFL);
            this.buf[this.size++] = (byte)(l >>> 48 & 0xFFL);
            this.buf[this.size++] = (byte)(l >>> 40 & 0xFFL);
            this.buf[this.size++] = (byte)(l >>> 32 & 0xFFL);
            this.buf[this.size++] = (byte)(l >>> 24 & 0xFFL);
            this.buf[this.size++] = (byte)(l >>> 16 & 0xFFL);
            this.buf[this.size++] = (byte)(l >>> 8 & 0xFFL);
            this.buf[this.size++] = (byte)(l & 0xFFL);
        }
    }

    public final void write_longlong_array(long[] lArray, int n, int n2) {
        if (lArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.write_longlong(lArray[n3 + n]);
            ++n3;
        }
    }

    public final void write_octet(byte by) {
        this.alignAndReserve(1, 1);
        this.buf[this.size++] = by;
    }

    public final void write_octet_array(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        int n3 = n;
        while (n3 < n2 + n) {
            this.alignAndReserve(1, 1);
            int n4 = this.buf.length - this.size;
            int n5 = n2 + n - n3;
            int n6 = n5 < n4 ? n5 : n4;
            System.arraycopy(byArray, n3, this.buf, this.size, n6);
            this.size += n6;
            n3 += n6;
        }
    }

    public final void write_short(short s) {
        this.alignAndReserve(2, 2);
        if (this.littleEndian) {
            this.buf[this.size++] = (byte)(s & 0xFF);
            this.buf[this.size++] = (byte)(s >>> 8 & 0xFF);
        } else {
            this.buf[this.size++] = (byte)(s >>> 8 & 0xFF);
            this.buf[this.size++] = (byte)(s & 0xFF);
        }
    }

    public final void write_short_array(short[] sArray, int n, int n2) {
        if (sArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.write_short(sArray[n3 + n]);
            ++n3;
        }
    }

    public final void write_string(String string) {
        if (string == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        int n = string.length();
        this.write_long(n + 1);
        int n2 = 0;
        while (n2 < n) {
            this.write_char(string.charAt(n2));
            ++n2;
        }
        this.write_octet((byte)0);
    }

    public final void write_ulong(int n) {
        this.write_long(n);
    }

    public final void write_ulong_array(int[] nArray, int n, int n2) {
        if (nArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_long_array(nArray, n, n2);
    }

    public final void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    public final void write_ulonglong_array(long[] lArray, int n, int n2) {
        if (lArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_longlong_array(lArray, n, n2);
    }

    public final void write_ushort(short s) {
        this.write_short(s);
    }

    public final void write_ushort_array(short[] sArray, int n, int n2) {
        if (sArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_short_array(sArray, n, n2);
    }

    public final void write_wchar(char c) {
        throw new MARSHAL(5, CompletionStatus.COMPLETED_NO);
    }

    public final void write_wchar_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.write_wchar(cArray[n3 + n]);
            ++n3;
        }
    }

    public final void write_wstring(String string) {
        throw new MARSHAL(5, CompletionStatus.COMPLETED_NO);
    }
}

