/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.debug;

import sun.tools.agent.AgentConstants;
import sun.tools.debug.RemoteAgent;
import sun.tools.debug.RemoteClass;
import sun.tools.debug.RemoteValue;
import sun.tools.java.Type;

public class RemoteField
implements AgentConstants {
    RemoteAgent agent;
    int slot;
    String name;
    String signature;
    short access;
    Object clazz;

    RemoteField(RemoteAgent remoteAgent, int n, String string, String string2, short s, RemoteClass remoteClass) {
        this.agent = remoteAgent;
        this.slot = n;
        this.name = string;
        this.signature = string2;
        this.access = s;
        this.clazz = remoteClass;
    }

    public String getModifiers() {
        String string = new String();
        if ((this.access & 1) == 1) {
            string = string.concat("public ");
        }
        if ((this.access & 2) == 2) {
            string = string.concat("private ");
        }
        if ((this.access & 4) == 4) {
            string = string.concat("protected ");
        }
        if ((this.access & 8) == 8) {
            string = string.concat("static ");
        }
        if ((this.access & 0x80) == 128) {
            string = string.concat("transient ");
        }
        if ((this.access & 0x10) == 16) {
            string = string.concat("final ");
        }
        if ((this.access & 0x40) == 64) {
            string = string.concat("volatile ");
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return Type.tType(this.signature);
    }

    public String getTypedName() {
        return Type.tType(this.signature).typeString(this.name, false, true);
    }

    RemoteValue getValue(int n) throws Exception {
        return this.agent.getSlotValue(n, this.slot);
    }

    public boolean isStatic() {
        return (this.access & 8) == 8;
    }

    void setValue(int n, char c) throws IllegalAccessException, Exception {
        if (this.getType().getTypeCode() != 2) {
            throw new IllegalAccessException();
        }
        this.agent.setSlotValue(n, this.slot, c);
    }

    void setValue(int n, double d) throws IllegalAccessException, Exception {
        if (this.getType().getTypeCode() != 7) {
            throw new IllegalAccessException();
        }
        this.agent.setSlotValue(n, this.slot, d);
    }

    void setValue(int n, float f) throws IllegalAccessException, Exception {
        if (this.getType().getTypeCode() != 6) {
            throw new IllegalAccessException();
        }
        this.agent.setSlotValue(n, this.slot, f);
    }

    void setValue(int n, int n2) throws IllegalAccessException, Exception {
        int n3 = this.getType().getTypeCode();
        if (n3 == 5) {
            this.setValue(n, (long)n2);
            return;
        }
        if (n3 != 4 && n3 != 1 && n3 != 3) {
            throw new IllegalAccessException();
        }
        this.agent.setSlotValue(n, this.slot, n2);
    }

    void setValue(int n, long l) throws IllegalAccessException, Exception {
        if (this.getType().getTypeCode() != 5) {
            throw new IllegalAccessException();
        }
        this.agent.setSlotValue(n, this.slot, l);
    }

    void setValue(int n, boolean bl) throws IllegalAccessException, Exception {
        if (this.getType().getTypeCode() != 0) {
            throw new IllegalAccessException();
        }
        this.agent.setSlotValue(n, this.slot, bl);
    }

    public String toString() {
        return new String(String.valueOf(this.signature) + " " + this.name);
    }
}

