/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.debug;

import java.io.InputStream;
import sun.tools.debug.NoSuchLineNumberException;
import sun.tools.debug.RemoteAgent;
import sun.tools.debug.RemoteField;
import sun.tools.debug.RemoteObject;
import sun.tools.debug.RemoteValue;

public class RemoteClass
extends RemoteObject {
    String name;
    String sourceName;
    boolean intf;
    RemoteClass superclass;
    RemoteObject loader;
    RemoteClass[] interfaces = null;
    private RemoteField[] methods = null;
    private RemoteField[] instanceFields = null;
    private RemoteField[] staticFields = null;

    RemoteClass(RemoteAgent remoteAgent, int n) {
        super(remoteAgent, 16, n, remoteAgent.classClass);
    }

    public void catchExceptions() throws Exception {
        if (!this.isExceptionClass()) {
            throw new ClassCastException();
        }
        this.agent.catchExceptionClass(this);
    }

    public String clearBreakpoint(int n) throws Exception {
        return this.agent.clearBreakpoint(this, n);
    }

    public String clearBreakpointLine(int n) throws Exception {
        return this.agent.clearBreakpointLine(this, n);
    }

    public String clearBreakpointMethod(RemoteField remoteField) throws Exception {
        return this.agent.clearBreakpointMethod(this, remoteField);
    }

    public String description() {
        return this.toString();
    }

    private void getClassInfo() throws Exception {
        if (this.interfaces == null) {
            this.agent.getClassInfo(this);
        }
    }

    public RemoteObject getClassLoader() throws Exception {
        this.getClassInfo();
        return this.loader;
    }

    public RemoteField getField(int n) throws Exception {
        this.loadFields();
        if (n < 0 || n >= this.staticFields.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.staticFields[n];
    }

    public RemoteField getField(String string) throws NoSuchFieldException, Exception {
        this.loadFields();
        int n = this.staticFields.length - 1;
        while (n >= 0) {
            if (string.equals(this.staticFields[n].getName())) {
                return this.staticFields[n];
            }
            --n;
        }
        throw new NoSuchFieldException();
    }

    public RemoteValue getFieldValue(int n) throws Exception {
        return this.getField(n).getValue(this.id);
    }

    public RemoteValue getFieldValue(String string) throws NoSuchFieldException, Exception {
        return this.getField(string).getValue(this.id);
    }

    public RemoteField[] getFields() throws Exception {
        return this.getStaticFields();
    }

    public RemoteField getInstanceField(int n) throws Exception {
        this.loadFields();
        if (n < 0 || n >= this.instanceFields.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.instanceFields[n];
    }

    public RemoteField[] getInstanceFields() throws Exception {
        this.loadFields();
        return this.instanceFields;
    }

    public RemoteClass[] getInterfaces() throws Exception {
        this.getClassInfo();
        return this.interfaces;
    }

    public int[] getLineNumbers() throws Exception {
        this.getClassInfo();
        return this.agent.getLineNumbers(this);
    }

    public RemoteField getMethod(String string) throws NoSuchMethodException, Exception {
        if (this.methods == null) {
            this.methods = this.agent.getMethods(this.id);
        }
        int n = 0;
        while (n < this.methods.length) {
            if (string.equals(this.methods[n].getName())) {
                return this.methods[n];
            }
            ++n;
        }
        throw new NoSuchMethodException();
    }

    public int getMethodLineNumber(int n) throws IndexOutOfBoundsException, NoSuchLineNumberException, Exception {
        if (this.methods == null) {
            this.methods = this.agent.getMethods(this.id);
        }
        if (n < 0 || n >= this.methods.length) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.agent.getMethodLineNumber(this.id, n);
        if (n2 == -1) {
            throw new NoSuchLineNumberException();
        }
        return n2;
    }

    public int getMethodLineNumber(String string) throws NoSuchMethodException, NoSuchLineNumberException, Exception {
        if (this.methods == null) {
            this.methods = this.agent.getMethods(this.id);
        }
        int n = 0;
        while (n < this.methods.length) {
            if (string.equals(this.methods[n].getName())) {
                int n2 = this.agent.getMethodLineNumber(this.id, n);
                if (n2 == -1) {
                    throw new NoSuchLineNumberException();
                }
                return n2;
            }
            ++n;
        }
        throw new NoSuchMethodException();
    }

    public String[] getMethodNames() throws Exception {
        if (this.methods == null) {
            this.methods = this.agent.getMethods(this.id);
        }
        String[] stringArray = new String[this.methods.length];
        int n = 0;
        while (n < this.methods.length) {
            stringArray[n] = this.methods[n].getName();
            ++n;
        }
        return stringArray;
    }

    public RemoteField[] getMethods() throws Exception {
        if (this.methods == null) {
            this.methods = this.agent.getMethods(this.id);
        }
        return this.methods;
    }

    public String getName() throws Exception {
        this.getClassInfo();
        return this.name;
    }

    public InputStream getSourceFile() throws Exception {
        this.getClassInfo();
        return this.agent.getSourceFile(this.name, this.sourceName);
    }

    public String getSourceFileName() throws Exception {
        this.getClassInfo();
        return this.sourceName;
    }

    public RemoteField[] getStaticFields() throws Exception {
        this.loadFields();
        return this.staticFields;
    }

    public RemoteClass getSuperclass() throws Exception {
        this.getClassInfo();
        return this.superclass;
    }

    public void ignoreExceptions() throws Exception {
        if (!this.isExceptionClass()) {
            throw new ClassCastException();
        }
        this.agent.ignoreExceptionClass(this);
    }

    private boolean isExceptionClass() throws Exception {
        if (this.getName().equals("java.lang.Exception") || this.getName().equals("java.lang.Error")) {
            return true;
        }
        RemoteClass remoteClass = this.superclass;
        do {
            this.agent.message("isExceptionClass: superClass=" + remoteClass.getName());
            if (!remoteClass.getName().equals("java.lang.Exception") && !remoteClass.getName().equals("java.lang.Error")) continue;
            return true;
        } while (!(remoteClass = remoteClass.getSuperclass()).getName().equals("java.lang.Object"));
        return false;
    }

    public boolean isInterface() throws Exception {
        this.getClassInfo();
        return this.intf;
    }

    private void loadFields() throws Exception {
        if (this.staticFields == null || this.instanceFields == null) {
            RemoteField[] remoteFieldArray = this.agent.getFields(this.id);
            int n = 0;
            int n2 = 0;
            while (n2 < remoteFieldArray.length) {
                if (remoteFieldArray[n2].isStatic()) {
                    ++n;
                }
                ++n2;
            }
            this.staticFields = new RemoteField[n];
            this.instanceFields = new RemoteField[remoteFieldArray.length - n];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < remoteFieldArray.length) {
                if (remoteFieldArray[n5].isStatic()) {
                    this.staticFields[n4++] = remoteFieldArray[n5];
                } else {
                    this.instanceFields[n3++] = remoteFieldArray[n5];
                }
                ++n5;
            }
        }
    }

    public String setBreakpointLine(int n) throws Exception {
        return this.agent.setBreakpointLine(this, n);
    }

    public String setBreakpointMethod(RemoteField remoteField) throws Exception {
        return this.agent.setBreakpointMethod(this, remoteField);
    }

    public String toString() {
        try {
            this.getClassInfo();
            return String.valueOf(RemoteValue.toHex(this.id)) + ":" + (this.intf ? "interface" : "class") + "(" + this.getName() + ")";
        }
        catch (Exception exception) {
            return "<communications errors>";
        }
    }

    public String typeName() throws Exception {
        this.getClassInfo();
        return this.getName();
    }
}

