/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.security.InvalidParameterException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.Vector;
import sun.security.provider.PolicyParser;
import sun.security.tools.AddEntryDoneButtonListener;
import sun.security.tools.AddPermButtonListener;
import sun.security.tools.CancelButtonListener;
import sun.security.tools.ChangeKeyStoreOKButtonListener;
import sun.security.tools.ConfirmRemovePolicyEntryOKButtonListener;
import sun.security.tools.EditPermButtonListener;
import sun.security.tools.EditPolicyEditPermOKButtonListener;
import sun.security.tools.NewPolicyEntryAddPermOKButtonListener;
import sun.security.tools.OverWriteFileOKButtonListener;
import sun.security.tools.PermissionActionsMenuListener;
import sun.security.tools.PermissionMenuListener;
import sun.security.tools.PermissionNameMenuListener;
import sun.security.tools.PolicyEntry;
import sun.security.tools.PolicyListListener;
import sun.security.tools.PolicyTool;
import sun.security.tools.RemovePermButtonListener;
import sun.security.tools.ToolWindow;
import sun.security.tools.UserSaveCancelButtonListener;
import sun.security.tools.UserSaveNoButtonListener;
import sun.security.tools.UserSaveYesButtonListener;

class ToolDialog
extends Dialog {
    public final int NOACTION = 0;
    public final int QUIT = 1;
    public final int NEW = 2;
    public final int OPEN = 3;
    public final String ALL_PERM_CLASS = "java.security.AllPermission";
    public final String AWT_PERM_CLASS = "java.awt.AWTPermission";
    public final String FILE_PERM_CLASS = "java.io.FilePermission";
    public final String NET_PERM_CLASS = "java.net.NetPermission";
    public final String PROP_PERM_CLASS = "java.util.PropertyPermission";
    public final String REF_PERM_CLASS = "java.lang.reflect.ReflectPermission";
    public final String RUN_PERM_CLASS = "java.lang.RuntimePermission";
    public final String SEC_PERM_CLASS = "java.security.SecurityPermission";
    public final String SER_PERM_CLASS = "java.io.SerializablePermission";
    public final String SOCK_PERM_CLASS = "java.net.SocketPermission";
    public final String PERM = "Permission:                                                       ";
    public final String ALL_PERM = "AllPermission";
    public final String AWT_PERM = "AWTPermission";
    public final String FILE_PERM = "FilePermission";
    public final String NET_PERM = "NetPermission";
    public final String PROPERTY_PERM = "PropertyPermission";
    public final String REFLECT_PERM = "ReflectPermission";
    public final String RUNTIME_PERM = "RuntimePermission";
    public final String SECURITY_PERM = "SecurityPermission";
    public final String SERIAL_PERM = "SerializablePermission";
    public final String SOCKET_PERM = "SocketPermission";
    public final String PERM_NAME = "Target Name:                                                    ";
    public final String AWT_BANNER = "showWindowWithoutWarningBanner";
    public final String AWT_CLIPBOARD = "accessClipboard";
    public final String AWT_EVENT_QUEUE = "accessEventQueue";
    public final String FILE_ALL_FILES = "<<ALL FILES>>";
    public final String NET_PASSWD_AUTH = "requestPasswordAuthentication";
    public final String NET_SET_AUTH = "setDefaultAuthenticator";
    public final String REFLECT_CHECK = "suppressAccessChecks";
    public final String R_ACCESS_CLASS = "accessClassInPackage.<package name>";
    public final String R_DEFINE_CLASS = "defineClassInPackage.<package name>";
    public final String R_CREATE_LOADER = "createClassLoader";
    public final String R_GET_LOADER = "getClassLoader";
    public final String R_EXIT_VM = "exitVM";
    public final String R_GET_DOMAIN = "getProtectionDomain";
    public final String R_SET_DOMAIN = "setProtectionDomain";
    public final String R_SET_FACTORY = "setFactory";
    public final String R_READ_FD = "readFileDescriptor";
    public final String R_WRITE_FD = "writeFileDescriptor";
    public final String R_SET_IO = "setIO";
    public final String R_LOAD_LIB = "loadLibrary.<library name>";
    public final String R_ACCESS_MEMBER = "accessDeclaredMembers.<class name>";
    public final String R_PRINT = "queuePrintJob";
    public final String R_THREAD = "modifyThread";
    public final String R_THREAD_GROUP = "modifyThreadGroup";
    public final String SEC_GET_POLICY = "getPolicy";
    public final String SEC_SET_POLICY = "setPolicy";
    public final String SEC_GET_PROP = "getProperty.<property name>";
    public final String SEC_SET_PROP = "setProperty.<property name>";
    public final String SEC_INSERT_PROV = "insertProvider.<provider name>";
    public final String SEC_REM_PROV = "removeProvider.<provider name>";
    public final String SEC_SET_SCOPE = "setSystemScope";
    public final String SEC_SET_PUBKEY = "setIdentityPublicKey";
    public final String SEC_SET_ID = "setIdentityInfo";
    public final String SEC_ADD_CERT = "addIdentityCertificate";
    public final String SEC_REMOVE_CERT = "removeIdentityCertificate";
    public final String SEC_CLEAR_PROP = "clearProviderProperties.<provider name>";
    public final String SEC_PUT_PROP = "putProviderProperty.<provider name>";
    public final String SEC_REMOVE_PROP = "removeProviderProperty.<provider name>";
    public final String SEC_GET_PRIVKEY = "getSignerPrivateKey";
    public final String SEC_SET_KEYPAIR = "setSignerKeyPair";
    public final String SER_SUBCLASS = "enableSubclassImplementation";
    public final String SER_SUBSTITUTE = "enableSubstitution";
    public final String PERM_ACTIONS = "Actions:                                                             ";
    public final String FILE_PERM_READ = "read";
    public final String FILE_PERM_WRITE = "write";
    public final String FILE_PERM_DELETE = "delete";
    public final String FILE_PERM_EXECUTE = "execute";
    public final String FILE_PERM_ALL = "read, write, delete, execute";
    public final String PROP_PERM_READ = "read";
    public final String PROP_PERM_WRITE = "write";
    public final String PROP_PERM_ALL = "read, write";
    public final String SOCKET_PERM_ACCEPT = "accept";
    public final String SOCKET_PERM_CONNECT = "connect";
    public final String SOCKET_PERM_LISTEN = "listen";
    public final String SOCKET_PERM_RESOLVE = "resolve";
    public final String SOCKET_PERM_ALL = "accept, connect, listen, resolve";
    public final int OW_LABEL = 0;
    public final int OW_EMPTY_LABEL1 = 1;
    public final int OW_OK_BUTTON = 2;
    public final int OW_CANCEL_BUTTON = 3;
    public final int PE_CODEBASE_LABEL = 0;
    public final int PE_CODEBASE_TEXTFIELD = 1;
    public final int PE_SIGNEDBY_LABEL = 2;
    public final int PE_SIGNEDBY_TEXTFIELD = 3;
    public final int PE_EMPTY_LABEL1 = 4;
    public final int PE_PANEL1 = 5;
    public final int PE_ADD_PERM_BUTTON = 0;
    public final int PE_EMPTY_LABEL2 = 1;
    public final int PE_EDIT_PERM_BUTTON = 2;
    public final int PE_EMPTY_LABEL3 = 3;
    public final int PE_REMOVE_PERM_BUTTON = 4;
    public final int PE_EMPTY_LABEL4 = 6;
    public final int PE_PERM_LIST = 7;
    public final int PE_EMPTY_LABEL5 = 8;
    public final int PE_PANEL2 = 9;
    public final int PE_CANCEL_BUTTON = 0;
    public final int PE_EMPTY_LABEL6 = 1;
    public final int PE_DONE_BUTTON = 2;
    public final int PD_DESC_LABEL = 0;
    public final int PD_EMPTY_LABEL1 = 1;
    public final int PD_PERM_CHOICE = 2;
    public final int PD_EMPTY_LABEL2 = 3;
    public final int PD_PERM_TEXTFIELD = 4;
    public final int PD_NAME_CHOICE = 5;
    public final int PD_EMPTY_LABEL3 = 6;
    public final int PD_NAME_TEXTFIELD = 7;
    public final int PD_ACTIONS_CHOICE = 8;
    public final int PD_EMPTY_LABEL4 = 9;
    public final int PD_ACTIONS_TEXTFIELD = 10;
    public final int PD_SIGNEDBY_LABEL = 11;
    public final int PD_EMPTY_LABEL5 = 12;
    public final int PD_SIGNEDBY_TEXTFIELD = 13;
    public final int PD_EMPTY_LABEL6 = 14;
    public final int PD_CANCEL_BUTTON = 15;
    public final int PD_OK_BUTTON = 16;
    public final int CHANGE_KEYSTORE = 0;
    public final int KSD_NAME_LABEL = 0;
    public final int KSD_NAME_TEXTFIELD = 1;
    public final int KSD_EMPTY_LABEL1 = 2;
    public final int KSD_TYPE_LABEL = 3;
    public final int KSD_TYPE_TEXTFIELD = 4;
    public final int KSD_EMPTY_LABEL2 = 5;
    public final int KSD_CANCEL_BUTTON = 6;
    public final int KSD_OK_BUTTON = 7;
    public final int USC_LABEL = 0;
    public final int USC_EMPTY_LABEL = 1;
    public final int USC_PANEL = 2;
    public final int USC_YES_BUTTON = 0;
    public final int USC_EMPTY_LABEL2 = 1;
    public final int USC_NO_BUTTON = 2;
    public final int USC_EMPTY_LABEL3 = 3;
    public final int USC_CANCEL_BUTTON = 4;
    public final int CRPE_EMPTY_LABEL1 = 0;
    public final int CRPE_LABEL1 = 1;
    public final int CRPE_EMPTY_LABEL2 = 2;
    public final int CRPE_LABEL2 = 3;
    private final int PERMISSION = 0;
    private final int PERMISSION_NAME = 1;
    private final int PERMISSION_ACTIONS = 2;
    private final int PERMISSION_SIGNEDBY = 3;
    PolicyTool tool;
    ToolWindow tw;

    ToolDialog(String string, PolicyTool policyTool, ToolWindow toolWindow, boolean bl) {
        super((Frame)toolWindow, bl);
        this.setTitle(string);
        this.tool = policyTool;
        this.tw = toolWindow;
    }

    String addSingleBackSlash(String string) {
        String string2 = new String();
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[1];
        while (n2 < n) {
            cArray[0] = string.charAt(n2);
            string2 = string2.concat(new String(cArray));
            if (cArray[0] == '\\') {
                string2 = string2.concat(new String(cArray));
                if (string.charAt(n2 + 1) == '\\') {
                    ++n2;
                }
            }
            ++n2;
        }
        return string2;
    }

    void displayConfirmRemovePolicyEntry() {
        Object object;
        Object object2;
        List list = (List)this.tw.getComponent(8);
        int n = list.getSelectedIndex();
        PolicyEntry[] policyEntryArray = this.tool.getEntry();
        Point point = this.tw.getLocationOnScreen();
        ((Component)this).setBounds(point.x + 25, point.y + 100, 600, 400);
        this.setLayout(new GridBagLayout());
        Label label = new Label("");
        this.tw.addNewComponent(this, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        label = new Label("Remove this Policy Entry?");
        this.tw.addNewComponent(this, label, 1, 1, 0, 2, 1, 0.0, 0.0, 1);
        label = new Label("");
        this.tw.addNewComponent(this, label, 2, 1, 1, 2, 1, 0.0, 0.0, 1);
        label = new Label("Grant " + policyEntryArray[n].codebaseToString());
        this.tw.addNewComponent(this, label, 3, 1, 2, 2, 1, 0.0, 0.0, 1);
        Vector<PolicyParser.PermissionEntry> vector = policyEntryArray[n].getGrantEntry().permissionEntries;
        int n2 = 0;
        while (n2 < vector.size()) {
            object2 = vector.elementAt(n2);
            object = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)object);
            ((PolicyParser.PermissionEntry)object2).write(printWriter);
            String string = ((StringWriter)object).toString();
            label = new Label("    " + string.substring(0, string.indexOf(";") + 1));
            this.tw.addNewComponent(this, label, 4 + n2, 1, 3 + n2, 2, 1, 0.0, 0.0, 1);
            ++n2;
        }
        label = new Label("");
        this.tw.addNewComponent(this, label, 4 + vector.size(), 1, 3 + vector.size(), 2, 1, 0.0, 0.0, 1);
        object2 = new Button("Cancel");
        ((Button)object2).addActionListener(new CancelButtonListener(this));
        this.tw.addNewComponent(this, (Component)object2, 5 + vector.size(), 2, 4 + vector.size(), 1, 1, 0.0, 0.0, 3);
        object = new Button("OK");
        ((Button)object).addActionListener(new ConfirmRemovePolicyEntryOKButtonListener(this.tool, this.tw, this));
        this.tw.addNewComponent(this, (Component)object, 6 + vector.size(), 1, 4 + vector.size(), 1, 1, 0.0, 0.0, 3);
        label = new Label("");
        this.tw.addNewComponent(this, label, 7 + vector.size(), 1, 5 + vector.size(), 2, 1, 0.0, 0.0, 1);
        this.pack();
        ((Component)this).setVisible(true);
    }

    void displayOverWriteFileDialog(String string, int n) {
        Point point = this.tw.getLocationOnScreen();
        ((Component)this).setBounds(point.x + 75, point.y + 100, 400, 150);
        this.setLayout(new GridBagLayout());
        Label label = new Label("OK to overwrite existing file " + string + "?");
        this.tw.addNewComponent(this, label, 0, 0, 0, 2, 1, 0.0, 0.0, 1);
        label = new Label("");
        this.tw.addNewComponent(this, label, 1, 0, 1, 1, 1, 0.0, 0.0, 1);
        Button button = new Button("OK");
        button.addActionListener(new OverWriteFileOKButtonListener(this.tool, this.tw, this, string, n));
        this.tw.addNewComponent(this, button, 2, 0, 2, 1, 1, 0.0, 0.0, 3);
        button = new Button("Cancel");
        button.addActionListener(new CancelButtonListener(this));
        this.tw.addNewComponent(this, button, 3, 1, 2, 1, 1, 0.0, 0.0, 3);
        ((Component)this).setVisible(true);
    }

    void displayPermissionDialog(boolean bl, boolean bl2) {
        TextField textField;
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        PolicyParser.PermissionEntry permissionEntry = null;
        List list = (List)this.getComponent(7);
        int n = list.getSelectedIndex();
        if (!bl && bl2) {
            object3 = this.parsePermissionString(list.getItem(n), 0);
            object2 = this.parsePermissionString(list.getItem(n), 1);
            object = this.parsePermissionString(list.getItem(n), 2);
            permissionEntry = new PolicyParser.PermissionEntry((String)object3, (String)object2, (String)object);
            permissionEntry.signedBy = this.parsePermissionString(list.getItem(n), 3);
        } else if (bl && bl2) {
            object3 = (List)this.tw.getComponent(8);
            int n2 = ((List)object3).getSelectedIndex();
            object = this.tool.getEntry();
            serializable = object[n2].getGrantEntry().permissionEntries;
            permissionEntry = ((Vector)serializable).elementAt(n);
        }
        object3 = new ToolDialog("Permissions", this.tool, this.tw, true);
        object2 = this.getLocationOnScreen();
        ((Component)object3).setBounds(((Point)object2).x + 50, ((Point)object2).y + 100, 700, 250);
        ((Container)object3).setLayout(new GridBagLayout());
        ((Dialog)object3).setResizable(false);
        object = bl2 ? new Label("Edit Permission:") : new Label("Add New Permission:");
        this.tw.addNewComponent((Container)object3, (Component)object, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        object = new Label("");
        this.tw.addNewComponent((Container)object3, (Component)object, 1, 0, 1, 1, 1, 0.0, 0.0, 1);
        serializable = new Choice();
        ((Choice)serializable).add("Permission:                                                       ");
        ((Choice)serializable).add("AllPermission");
        ((Choice)serializable).add("AWTPermission");
        ((Choice)serializable).add("FilePermission");
        ((Choice)serializable).add("NetPermission");
        ((Choice)serializable).add("PropertyPermission");
        ((Choice)serializable).add("ReflectPermission");
        ((Choice)serializable).add("RuntimePermission");
        ((Choice)serializable).add("SecurityPermission");
        ((Choice)serializable).add("SerializablePermission");
        ((Choice)serializable).add("SocketPermission");
        ((Choice)serializable).addItemListener(new PermissionMenuListener((ToolDialog)object3));
        this.tw.addNewComponent((Container)object3, (Component)serializable, 2, 0, 2, 1, 1, 0.0, 0.0, 1);
        this.tw.addNewComponent((Container)object3, new Label(""), 3, 1, 2, 1, 1, 0.0, 0.0, 1);
        TextField textField2 = textField = bl2 ? new TextField(permissionEntry.permission, 30) : new TextField(30);
        if (bl2) {
            this.setPermissions(permissionEntry.permission, (Choice)serializable);
        }
        this.tw.addNewComponent((Container)object3, textField, 4, 2, 2, 1, 1, 0.0, 0.0, 1);
        serializable = new Choice();
        ((Choice)serializable).add("Target Name:                                                    ");
        ((Choice)serializable).addItemListener(new PermissionNameMenuListener((ToolDialog)object3));
        TextField textField3 = textField = bl2 ? new TextField(permissionEntry.name, 40) : new TextField(40);
        if (bl2) {
            this.setPermissionNames(permissionEntry.permission, (Choice)serializable, textField);
        }
        this.tw.addNewComponent((Container)object3, (Component)serializable, 5, 0, 3, 1, 1, 0.0, 0.0, 1);
        this.tw.addNewComponent((Container)object3, new Label(""), 6, 1, 3, 1, 1, 0.0, 0.0, 1);
        this.tw.addNewComponent((Container)object3, textField, 7, 2, 3, 1, 1, 0.0, 0.0, 1);
        serializable = new Choice();
        ((Choice)serializable).add("Actions:                                                             ");
        ((Choice)serializable).addItemListener(new PermissionActionsMenuListener((ToolDialog)object3));
        TextField textField4 = textField = bl2 ? new TextField(permissionEntry.action, 40) : new TextField(40);
        if (bl2) {
            this.setPermissionActions(permissionEntry.permission, (Choice)serializable, textField);
        }
        this.tw.addNewComponent((Container)object3, (Component)serializable, 8, 0, 4, 1, 1, 0.0, 0.0, 1);
        this.tw.addNewComponent((Container)object3, new Label(""), 9, 1, 4, 1, 1, 0.0, 0.0, 1);
        this.tw.addNewComponent((Container)object3, textField, 10, 2, 4, 1, 1, 0.0, 0.0, 1);
        object = new Label("Signed By:");
        this.tw.addNewComponent((Container)object3, (Component)object, 11, 0, 5, 1, 1, 0.0, 0.0, 1);
        this.tw.addNewComponent((Container)object3, new Label(""), 12, 1, 5, 1, 1, 0.0, 0.0, 1);
        textField = bl2 ? new TextField(permissionEntry.signedBy, 40) : new TextField(40);
        this.tw.addNewComponent((Container)object3, textField, 13, 2, 5, 1, 1, 0.0, 0.0, 1);
        object = new Label("");
        this.tw.addNewComponent((Container)object3, (Component)object, 14, 0, 6, 1, 1, 0.0, 0.0, 1);
        Button button = new Button("Cancel");
        button.addActionListener(new CancelButtonListener((ToolDialog)object3));
        this.tw.addNewComponent((Container)object3, button, 15, 2, 7, 1, 1, 0.0, 0.0, 3);
        Button button2 = new Button("OK");
        if (bl) {
            button2.addActionListener(new EditPolicyEditPermOKButtonListener(this.tool, this.tw, this, (ToolDialog)object3, bl2));
        } else {
            button2.addActionListener(new NewPolicyEntryAddPermOKButtonListener(this.tool, this.tw, this, (ToolDialog)object3, bl2));
        }
        this.tw.addNewComponent((Container)object3, button2, 16, 0, 7, 1, 1, 0.0, 0.0, 3);
        ((Component)object3).setVisible(true);
    }

    void displayPolicyEntryDialog(boolean bl) {
        Object object;
        Serializable serializable;
        Component component;
        int n = 0;
        PolicyEntry[] policyEntryArray = null;
        List list = new List(15, false);
        list.addActionListener(new EditPermButtonListener(this.tool, this.tw, this, bl));
        Point point = this.tw.getLocationOnScreen();
        ((Component)this).setBounds(point.x + 75, point.y + 100, 600, 500);
        this.setLayout(new GridBagLayout());
        this.setResizable(false);
        if (bl) {
            policyEntryArray = this.tool.getEntry();
            component = (List)this.tw.getComponent(8);
            n = ((List)component).getSelectedIndex();
            serializable = policyEntryArray[n].getGrantEntry().permissionEntries;
            int n2 = 0;
            while (n2 < ((Vector)serializable).size()) {
                object = null;
                PolicyParser.PermissionEntry permissionEntry = (PolicyParser.PermissionEntry)((Vector)serializable).elementAt(n2);
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                permissionEntry.write(printWriter);
                if (File.separatorChar == '\\' && permissionEntry.permission.equals("java.io.FilePermission")) {
                    permissionEntry.name = this.addSingleBackSlash(permissionEntry.name);
                    object = this.addSingleBackSlash(stringWriter.toString());
                } else {
                    object = stringWriter.toString();
                }
                object = ((String)object).substring(0, ((String)object).indexOf(";") + 1);
                list.add((String)object);
                ++n2;
            }
        }
        component = new Label("CodeBase:");
        this.tw.addNewComponent(this, component, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        serializable = bl ? new TextField(policyEntryArray[n].getGrantEntry().codeBase, 60) : new TextField(60);
        this.tw.addNewComponent(this, (Component)serializable, 1, 1, 0, 1, 1, 0.0, 0.0, 1);
        component = new Label("SignedBy:");
        this.tw.addNewComponent(this, component, 2, 0, 1, 1, 1, 0.0, 0.0, 1);
        serializable = bl ? new TextField(policyEntryArray[n].getGrantEntry().signedBy, 60) : new TextField(60);
        this.tw.addNewComponent(this, (Component)serializable, 3, 1, 1, 1, 1, 0.0, 0.0, 1);
        component = new Label("");
        this.tw.addNewComponent(this, component, 4, 0, 2, 1, 1, 0.0, 0.0, 1);
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        object = new Button("Add Permission");
        ((Button)object).addActionListener(new AddPermButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent(panel, (Component)object, 0, 0, 0, 1, 1, 0.0, 0.0, 3);
        component = new Label("");
        this.tw.addNewComponent(panel, component, 1, 1, 0, 1, 1, 0.0, 0.0, 1);
        object = new Button("Edit Permission");
        ((Button)object).addActionListener(new EditPermButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent(panel, (Component)object, 2, 2, 0, 1, 1, 0.0, 0.0, 3);
        component = new Label("");
        this.tw.addNewComponent(panel, component, 3, 3, 0, 1, 1, 0.0, 0.0, 1);
        object = new Button("Remove Permission");
        ((Button)object).addActionListener(new RemovePermButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent(panel, (Component)object, 4, 4, 0, 1, 1, 0.0, 0.0, 3);
        this.tw.addNewComponent(this, panel, 5, 0, 3, 2, 1, 0.0, 0.0, 3);
        component = new Label("");
        this.tw.addNewComponent(this, component, 6, 0, 4, 1, 1, 0.0, 0.0, 1);
        this.tw.addNewComponent(this, list, 7, 0, 5, 3, 1, 0.0, 0.0, 1);
        component = new Label("");
        this.tw.addNewComponent(this, component, 8, 0, 6, 1, 1, 0.0, 0.0, 1);
        panel = new Panel();
        panel.setLayout(new GridBagLayout());
        object = new Button("Cancel");
        ((Button)object).addActionListener(new CancelButtonListener(this));
        this.tw.addNewComponent(panel, (Component)object, 0, 2, 0, 1, 1, 0.0, 0.0, 3);
        component = new Label("");
        this.tw.addNewComponent(panel, component, 1, 1, 0, 1, 1, 0.0, 0.0, 1);
        object = new Button("Done");
        ((Button)object).addActionListener(new AddEntryDoneButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent(panel, (Component)object, 2, 0, 0, 1, 1, 0.0, 0.0, 3);
        this.tw.addNewComponent(this, panel, 9, 0, 7, 2, 1, 0.0, 0.0, 3);
        ((Component)this).setVisible(true);
    }

    void displaySaveAsDialog(int n) {
        block7: {
            FileDialog fileDialog = new FileDialog((Frame)this.tw, "Save As", 1);
            ((Component)fileDialog).setVisible(true);
            if (fileDialog.getFile() == null || fileDialog.getFile().equals("")) {
                return;
            }
            String string = new String(String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile());
            fileDialog.dispose();
            File file = new File(string);
            if (file.exists()) {
                ToolDialog toolDialog = new ToolDialog("Overwrite File", this.tool, this.tw, true);
                toolDialog.displayOverWriteFileDialog(string, n);
            } else {
                try {
                    this.tool.savePolicy(string);
                    this.tw.displayStatusDialog(null, "Policy successfully written to " + string);
                    TextField textField = (TextField)this.tw.getComponent(2);
                    textField.setText(string);
                    ((Component)this.tw).setVisible(true);
                    this.userSaveContinue(this.tool, this.tw, this, n);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (string == null || string.equals("")) {
                        this.tw.displayErrorDialog(null, new FileNotFoundException("null filename"));
                        break block7;
                    }
                    this.tw.displayErrorDialog(null, new FileNotFoundException(String.valueOf(string) + " not found"));
                }
                catch (Exception exception) {
                    this.tw.displayErrorDialog(null, exception);
                }
            }
        }
    }

    void displayUserSave(int n) {
        if (this.tool.modified) {
            Point point = this.tw.getLocationOnScreen();
            ((Component)this).setBounds(point.x + 75, point.y + 100, 400, 150);
            this.setLayout(new GridBagLayout());
            Label label = new Label("     Save changes?");
            this.tw.addNewComponent(this, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
            Label label2 = new Label("");
            this.tw.addNewComponent(this, label2, 1, 0, 1, 1, 1, 0.0, 0.0, 1);
            Panel panel = new Panel();
            panel.setLayout(new GridBagLayout());
            Button button = new Button("Yes");
            button.addActionListener(new UserSaveYesButtonListener(this, this.tool, this.tw, n));
            this.tw.addNewComponent(panel, button, 0, 0, 0, 1, 1, 0.0, 0.0, 3);
            label2 = new Label("");
            this.tw.addNewComponent(panel, label2, 1, 1, 0, 1, 1, 0.0, 0.0, 1);
            Button button2 = new Button("No");
            button2.addActionListener(new UserSaveNoButtonListener(this, this.tool, this.tw, n));
            this.tw.addNewComponent(panel, button2, 2, 2, 0, 1, 1, 0.0, 0.0, 3);
            label2 = new Label("");
            this.tw.addNewComponent(panel, label2, 3, 3, 0, 1, 1, 0.0, 0.0, 1);
            Button button3 = new Button("Cancel");
            button3.addActionListener(new UserSaveCancelButtonListener(this));
            this.tw.addNewComponent(panel, button3, 4, 4, 0, 1, 1, 0.0, 0.0, 3);
            this.tw.addNewComponent(this, panel, 2, 0, 2, 1, 1, 0.0, 0.0, 1);
            this.pack();
            ((Component)this).setVisible(true);
        } else {
            this.userSaveContinue(this.tool, this.tw, this, n);
        }
    }

    PolicyParser.PermissionEntry getPermFromDialog() {
        TextField textField = (TextField)this.getComponent(4);
        String string = new String(textField.getText().trim());
        textField = (TextField)this.getComponent(7);
        String string2 = null;
        if (!textField.getText().trim().equals("")) {
            string2 = new String(textField.getText().trim());
        }
        if (string.equals("") || !string.equals("java.security.AllPermission") && string2 == null) {
            throw new InvalidParameterException("Permission and Target Name must have a value");
        }
        textField = (TextField)this.getComponent(10);
        String string3 = null;
        if (!textField.getText().trim().equals("")) {
            string3 = new String(textField.getText().trim());
        }
        textField = (TextField)this.getComponent(13);
        String string4 = null;
        if (!textField.getText().trim().equals("")) {
            string4 = new String(textField.getText().trim());
        }
        PolicyParser.PermissionEntry permissionEntry = new PolicyParser.PermissionEntry(string, string2, string3);
        permissionEntry.signedBy = string4;
        if (string4 != null) {
            String[] stringArray = this.tool.parseSigners(permissionEntry.signedBy);
            int n = 0;
            while (n < stringArray.length) {
                try {
                    PublicKey publicKey = this.tool.getPublicKeyAlias(stringArray[n]);
                    if (publicKey == null) {
                        this.tool.warnings.addElement("Warning: A public key for alias '" + stringArray[n] + "' does not exist.");
                        this.tw.displayStatusDialog(this, "Warning: A public key for alias '" + stringArray[n] + "' does not exist.");
                    }
                }
                catch (Exception exception) {
                    this.tw.displayErrorDialog((Window)this, exception);
                }
                ++n;
            }
        }
        return permissionEntry;
    }

    PolicyEntry getPolicyEntryFromDialog() throws InvalidParameterException, MalformedURLException, NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, CertificateException, IOException, Exception {
        Object object;
        TextField textField = (TextField)this.getComponent(1);
        String string = null;
        if (!textField.getText().trim().equals("")) {
            string = new String(textField.getText().trim());
        }
        textField = (TextField)this.getComponent(3);
        String string2 = null;
        if (!textField.getText().trim().equals("")) {
            string2 = new String(textField.getText().trim());
        }
        PolicyParser.GrantEntry grantEntry = new PolicyParser.GrantEntry(string2, string);
        Vector<Object> vector = new Vector<Object>();
        List list = (List)this.getComponent(7);
        String[] stringArray = list.getItems();
        int n = 0;
        while (n < stringArray.length) {
            object = new PolicyParser.PermissionEntry(this.parsePermissionString(stringArray[n], 0), this.parsePermissionString(stringArray[n], 1), this.parsePermissionString(stringArray[n], 2));
            ((PolicyParser.PermissionEntry)object).signedBy = this.parsePermissionString(stringArray[n], 3);
            vector.addElement(object);
            ++n;
        }
        grantEntry.permissionEntries = vector;
        object = new PolicyEntry(this.tool, grantEntry);
        return object;
    }

    void keyStoreDialog(int n) {
        Point point = this.tw.getLocationOnScreen();
        ((Component)this).setBounds(point.x + 25, point.y + 100, 500, 200);
        this.setLayout(new GridBagLayout());
        if (n == 0) {
            Label label = new Label("New KeyStore URL:");
            this.tw.addNewComponent(this, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
            TextField textField = new TextField(this.tool.getKeyStoreName(), 30);
            this.tw.addNewComponent(this, textField, 1, 1, 0, 1, 1, 0.0, 0.0, 1);
            label = new Label("");
            this.tw.addNewComponent(this, label, 2, 0, 2, 1, 1, 0.0, 0.0, 1);
            label = new Label("New KeyStore Type:");
            this.tw.addNewComponent(this, label, 3, 0, 3, 1, 1, 0.0, 0.0, 1);
            textField = new TextField(this.tool.getKeyStoreType(), 30);
            this.tw.addNewComponent(this, textField, 4, 1, 3, 1, 1, 0.0, 0.0, 1);
            label = new Label("");
            this.tw.addNewComponent(this, label, 5, 0, 4, 1, 1, 0.0, 0.0, 1);
            Button button = new Button("Cancel");
            button.addActionListener(new CancelButtonListener(this));
            this.tw.addNewComponent(this, button, 6, 1, 5, 1, 1, 0.0, 0.0, 3);
            Button button2 = new Button("OK");
            button2.addActionListener(new ChangeKeyStoreOKButtonListener(this.tool, this.tw, this));
            this.tw.addNewComponent(this, button2, 7, 0, 5, 1, 1, 0.0, 0.0, 3);
        }
        ((Component)this).setVisible(true);
    }

    private String parsePermissionString(String string, int n) {
        string = string.substring(string.indexOf(" ") + 1);
        switch (n) {
            case 0: {
                if (string.indexOf("java.security.AllPermission") != -1) {
                    return new String("java.security.AllPermission");
                }
                if (string.indexOf("\"") == -1) {
                    return string.substring(0, string.indexOf(";"));
                }
                return string.substring(0, string.indexOf("\"") - 1);
            }
            case 1: {
                if (string.indexOf("java.security.AllPermission") != -1) {
                    return null;
                }
                if (string.indexOf("\"") == -1) {
                    return null;
                }
                return string.substring(string.indexOf("\"") + 1, string.indexOf("\"", string.indexOf("\"") + 1));
            }
            case 2: {
                if (string.indexOf("java.security.AllPermission") != -1) {
                    return null;
                }
                if (string.indexOf("\"") == -1 || string.indexOf("\", \"") == -1) {
                    return null;
                }
                String string2 = string.substring(string.indexOf("\", \"") + 4, string.indexOf(";") - 1);
                if (string2.indexOf("signedBy") != -1) {
                    return string2.substring(0, string2.indexOf("signedBy") - 3);
                }
                return string2;
            }
            case 3: {
                if (string.indexOf("signedBy") == -1) {
                    return null;
                }
                return string.substring(string.indexOf("signedBy") + 10, string.indexOf(";") - 1);
            }
        }
        return null;
    }

    void setPermissionActions(String string, Choice choice, TextField textField) {
        choice.removeAll();
        choice.add("Actions:                                                             ");
        textField.setEditable(true);
        if (string.equals("java.security.AllPermission")) {
            textField.setEditable(false);
        } else if (string.equals("java.awt.AWTPermission")) {
            textField.setEditable(false);
        } else if (string.equals("java.io.FilePermission")) {
            choice.add("read");
            choice.add("write");
            choice.add("delete");
            choice.add("execute");
            choice.add("read, write, delete, execute");
        } else if (string.equals("java.net.NetPermission")) {
            textField.setEditable(false);
        } else if (string.equals("java.util.PropertyPermission")) {
            choice.add("read");
            choice.add("write");
            choice.add("read, write");
        } else if (string.equals("java.lang.reflect.ReflectPermission")) {
            textField.setEditable(false);
        } else if (string.equals("java.lang.RuntimePermission")) {
            textField.setEditable(false);
        } else if (string.equals("java.security.SecurityPermission")) {
            textField.setEditable(false);
        } else if (string.equals("java.io.SerializablePermission")) {
            textField.setEditable(false);
        } else if (string.equals("java.net.SocketPermission")) {
            choice.add("listen");
            choice.add("connect");
            choice.add("accept");
            choice.add("resolve");
            choice.add("accept, connect, listen, resolve");
        }
    }

    void setPermissionNames(String string, Choice choice, TextField textField) {
        choice.removeAll();
        choice.add("Target Name:                                                    ");
        textField.setEditable(true);
        if (string.equals("java.security.AllPermission")) {
            textField.setEditable(false);
        } else if (string.equals("java.awt.AWTPermission")) {
            choice.add("accessClipboard");
            choice.add("accessEventQueue");
            choice.add("showWindowWithoutWarningBanner");
        } else if (string.equals("java.io.FilePermission")) {
            choice.add("<<ALL FILES>>");
        } else if (string.equals("java.net.NetPermission")) {
            choice.add("setDefaultAuthenticator");
            choice.add("requestPasswordAuthentication");
        } else if (!string.equals("java.util.PropertyPermission")) {
            if (string.equals("java.lang.reflect.ReflectPermission")) {
                choice.add("suppressAccessChecks");
            } else if (string.equals("java.lang.RuntimePermission")) {
                choice.add("createClassLoader");
                choice.add("getClassLoader");
                choice.add("exitVM");
                choice.add("setFactory");
                choice.add("setIO");
                choice.add("modifyThread");
                choice.add("modifyThreadGroup");
                choice.add("getProtectionDomain");
                choice.add("setProtectionDomain");
                choice.add("readFileDescriptor");
                choice.add("writeFileDescriptor");
                choice.add("loadLibrary.<library name>");
                choice.add("accessClassInPackage.<package name>");
                choice.add("defineClassInPackage.<package name>");
                choice.add("accessDeclaredMembers.<class name>");
                choice.add("queuePrintJob");
            } else if (string.equals("java.security.SecurityPermission")) {
                choice.add("getPolicy");
                choice.add("setPolicy");
                choice.add("getProperty.<property name>");
                choice.add("setProperty.<property name>");
                choice.add("insertProvider.<provider name>");
                choice.add("removeProvider.<provider name>");
                choice.add("setSystemScope");
                choice.add("setIdentityPublicKey");
                choice.add("setIdentityInfo");
                choice.add("addIdentityCertificate");
                choice.add("removeIdentityCertificate");
                choice.add("clearProviderProperties.<provider name>");
                choice.add("putProviderProperty.<provider name>");
                choice.add("removeProviderProperty.<provider name>");
                choice.add("getSignerPrivateKey");
                choice.add("setSignerKeyPair");
            } else if (string.equals("java.io.SerializablePermission")) {
                choice.add("enableSubclassImplementation");
                choice.add("enableSubstitution");
            } else {
                string.equals("java.net.SocketPermission");
            }
        }
    }

    void setPermissions(String string, Choice choice) {
        if (string.equals("java.security.AllPermission")) {
            choice.select("AllPermission");
        } else if (string.equals("java.awt.AWTPermission")) {
            choice.select("AWTPermission");
        } else if (string.equals("java.io.FilePermission")) {
            choice.select("FilePermission");
        } else if (string.equals("java.net.NetPermission")) {
            choice.select("NetPermission");
        } else if (string.equals("java.util.PropertyPermission")) {
            choice.select("PropertyPermission");
        } else if (string.equals("java.lang.reflect.ReflectPermission")) {
            choice.select("ReflectPermission");
        } else if (string.equals("java.lang.RuntimePermission")) {
            choice.select("RuntimePermission");
        } else if (string.equals("java.security.SecurityPermission")) {
            choice.select("SecurityPermission");
        } else if (string.equals("java.io.SerializablePermission")) {
            choice.select("SerializablePermission");
        } else if (string.equals("java.net.SocketPermission")) {
            choice.select("SocketPermission");
        }
    }

    void userSaveContinue(PolicyTool policyTool, ToolWindow toolWindow, ToolDialog toolDialog, int n) {
        switch (n) {
            case 1: {
                ((Component)toolWindow).setVisible(false);
                toolWindow.dispose();
                System.exit(0);
            }
            case 2: {
                try {
                    policyTool.openPolicy(null);
                }
                catch (Exception exception) {
                    policyTool.modified = false;
                    toolWindow.displayErrorDialog(null, exception);
                }
                List list = new List(40, false);
                list.addActionListener(new PolicyListListener(policyTool, toolWindow));
                toolWindow.replacePolicyList(list);
                TextField textField = (TextField)toolWindow.getComponent(2);
                textField.setText("");
                TextField textField2 = (TextField)toolWindow.getComponent(4);
                textField2.setText("");
                ((Component)toolWindow).setVisible(true);
                break;
            }
            case 3: {
                FileDialog fileDialog = new FileDialog((Frame)toolWindow, "Open", 0);
                ((Component)fileDialog).setVisible(true);
                if (fileDialog.getFile() == null || fileDialog.getFile().equals("")) {
                    return;
                }
                String string = new String(String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile());
                try {
                    try {
                        policyTool.openPolicy(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (string == null || string.equals("")) {
                            toolWindow.displayErrorDialog(null, new FileNotFoundException("null filename"));
                        } else {
                            toolWindow.displayErrorDialog(null, new FileNotFoundException(String.valueOf(string) + " not found"));
                        }
                    }
                    catch (PolicyParser.ParsingException parsingException) {
                        toolWindow.displayErrorDialog(null, "Error parsing policy file " + string + ": " + parsingException.getMessage());
                        policyTool.warnings.addElement("Error: Could not open policy file, " + string + ", because of parsing error: " + parsingException.getMessage());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        toolWindow.displayErrorDialog(null, new Exception("Permission could not be mapped to an appropriate class"));
                    }
                    catch (Exception exception) {
                        toolWindow.displayErrorDialog(null, exception);
                    }
                    Object var11_17 = null;
                    policyTool.modified = false;
                }
                catch (Throwable throwable) {
                    Object var11_18 = null;
                    policyTool.modified = false;
                    throw throwable;
                }
                List list = new List(40, false);
                list.addActionListener(new PolicyListListener(policyTool, toolWindow));
                PolicyEntry[] policyEntryArray = policyTool.getEntry();
                if (policyEntryArray != null) {
                    int n2 = 0;
                    while (n2 < policyEntryArray.length) {
                        list.add(policyEntryArray[n2].codebaseToString());
                        ++n2;
                    }
                }
                toolWindow.replacePolicyList(list);
                TextField textField = (TextField)toolWindow.getComponent(2);
                textField.setText(string);
                TextField textField3 = (TextField)toolWindow.getComponent(4);
                if (policyTool.getKeyStoreType() != null && policyTool.getKeyStoreType().length() > 0) {
                    textField3.setText(String.valueOf(policyTool.getKeyStoreName()) + ", " + policyTool.getKeyStoreType());
                } else {
                    textField3.setText(policyTool.getKeyStoreName());
                }
                ((Component)toolWindow).setVisible(true);
                if (!policyTool.newWarning) break;
                toolWindow.displayStatusDialog(null, "Errors have occurred while opening the policy configuration.  View the Warning Log for more information.");
                break;
            }
        }
    }
}

