/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Vector;
import sun.rmi.rmic.BatchEnvironment;
import sun.rmi.rmic.Constants;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.Main;
import sun.rmi.rmic.Names;
import sun.rmi.rmic.RemoteClass;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;

public class Generator
implements Constants {
    private BatchEnvironment env;
    private RemoteClass remoteClass;
    private int version;
    private RemoteClass.Method[] remoteMethods;
    private Identifier remoteClassName;
    private Identifier stubClassName;
    private Identifier skeletonClassName;
    private String[] methodFieldNames;
    private ClassDefinition defException;
    private ClassDefinition defRemoteException;
    private ClassDefinition defRuntimeException;

    private Generator(BatchEnvironment batchEnvironment, RemoteClass remoteClass, int n) throws ClassNotFound {
        this.env = batchEnvironment;
        this.remoteClass = remoteClass;
        this.version = n;
        this.remoteMethods = remoteClass.getRemoteMethods();
        this.remoteClassName = remoteClass.getName();
        this.stubClassName = Names.stubFor(this.remoteClassName);
        this.skeletonClassName = Names.skeletonFor(this.remoteClassName);
        this.methodFieldNames = Generator.nameMethodFields(this.remoteMethods);
        this.defException = batchEnvironment.getClassDeclaration(sun.tools.java.Constants.idJavaLangException).getClassDefinition(batchEnvironment);
        this.defRemoteException = batchEnvironment.getClassDeclaration(Constants.idRemoteException).getClassDefinition(batchEnvironment);
        this.defRuntimeException = batchEnvironment.getClassDeclaration(sun.tools.java.Constants.idJavaLangRuntimeException).getClassDefinition(batchEnvironment);
    }

    private Vector computeUniqueCatchList(ClassDeclaration[] classDeclarationArray) {
        Vector<ClassDefinition> vector = new Vector<ClassDefinition>();
        vector.addElement(this.defRuntimeException);
        vector.addElement(this.defRemoteException);
        int n = 0;
        while (n < classDeclarationArray.length) {
            block7: {
                ClassDeclaration classDeclaration = classDeclarationArray[n];
                try {
                    if (this.defException.subClassOf(this.env, classDeclaration)) {
                        vector.clear();
                        break;
                    }
                    if (!this.defException.superClassOf(this.env, classDeclaration)) break block7;
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        ClassDefinition classDefinition = (ClassDefinition)vector.elementAt(n2);
                        if (!classDefinition.superClassOf(this.env, classDeclaration)) {
                            if (classDefinition.subClassOf(this.env, classDeclaration)) {
                                vector.removeElementAt(n2);
                                continue;
                            }
                            ++n2;
                            continue;
                        }
                        break block7;
                    }
                    vector.addElement(classDeclaration.getClassDefinition(this.env));
                }
                catch (ClassNotFound classNotFound) {
                    this.env.error(0L, "class.not.found", classNotFound.name, classDeclaration.getName());
                }
            }
            ++n;
        }
        return vector;
    }

    public static void generate(BatchEnvironment batchEnvironment, ClassDefinition classDefinition, File file, int n) {
        Object object;
        Generator generator;
        RemoteClass remoteClass = RemoteClass.forClass(batchEnvironment, classDefinition);
        if (remoteClass == null) {
            return;
        }
        try {
            generator = new Generator(batchEnvironment, remoteClass, n);
        }
        catch (ClassNotFound classNotFound) {
            batchEnvironment.error(0L, "rmic.class.not.found", classNotFound.name);
            return;
        }
        Identifier identifier = Names.stubFor(classDefinition.getName());
        File file2 = Generator.getFileForClass(identifier, file, ".java");
        batchEnvironment.addGeneratedFile(file2);
        try {
            object = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file2)));
            generator.writeStub((IndentingWriter)object);
            ((BufferedWriter)object).close();
            if (batchEnvironment.verbose()) {
                batchEnvironment.output(Main.getText("rmic.wrote", file2.getPath()));
            }
            batchEnvironment.parseFile(new ClassFile(file2));
        }
        catch (IOException iOException) {
            batchEnvironment.error(0L, "cant.write", file2.toString());
            return;
        }
        object = Names.skeletonFor(classDefinition.getName());
        File file3 = Generator.getFileForClass((Identifier)object, file, ".java");
        if (n == 1 || n == 2) {
            batchEnvironment.addGeneratedFile(file3);
            try {
                IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file3)));
                generator.writeSkeleton(indentingWriter);
                indentingWriter.close();
                if (batchEnvironment.verbose()) {
                    batchEnvironment.output(Main.getText("rmic.wrote", file3.getPath()));
                }
                batchEnvironment.parseFile(new ClassFile(file3));
            }
            catch (IOException iOException) {
                batchEnvironment.error(0L, "cant.write", file2.toString());
                return;
            }
        } else {
            File file4 = Generator.getFileForClass((Identifier)object, file, ".class");
            file3.delete();
            file4.delete();
        }
    }

    private static String generateNameFromType(Type type) {
        int n = type.getTypeCode();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return type.toString();
            }
            case 9: {
                return "arrayOf_" + Generator.generateNameFromType(type.getElementType());
            }
            case 10: {
                return Names.mangleClass(type.getClassName().getName()).toString();
            }
        }
        throw new Error("unexpected type code: " + n);
    }

    private static File getFileForClass(Identifier identifier, File file, String string) {
        Identifier identifier2 = Names.mangleClass(identifier);
        String string2 = identifier2.getQualifier().toString().replace('.', File.separatorChar);
        String string3 = String.valueOf(String.valueOf(identifier2.getName())) + string;
        if (file != null) {
            File file2 = new File(file, string2);
            if (!file2.exists()) {
                file2.mkdirs();
            }
            return new File(file2, string3);
        }
        return new File(System.getProperty("user.dir"), string3);
    }

    private static String[] nameMethodFields(RemoteClass.Method[] methodArray) {
        String[] stringArray = new String[methodArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = "$method_" + methodArray[n].getName() + "_" + n;
            ++n;
        }
        return stringArray;
    }

    private static String[] nameParameters(Type[] typeArray) {
        String[] stringArray = new String[typeArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = "$param_" + Generator.generateNameFromType(typeArray[n]) + "_" + (n + 1);
            ++n;
        }
        return stringArray;
    }

    private static String unwrapArgumentCode(Type type, String string) {
        int n = type.getTypeCode();
        switch (n) {
            case 0: {
                return "((java.lang.Boolean) " + string + ").booleanValue()";
            }
            case 1: {
                return "((java.lang.Byte) " + string + ").byteValue()";
            }
            case 2: {
                return "((java.lang.Character) " + string + ").charValue()";
            }
            case 3: {
                return "((java.lang.Short) " + string + ").shortValue()";
            }
            case 4: {
                return "((java.lang.Integer) " + string + ").intValue()";
            }
            case 5: {
                return "((java.lang.Long) " + string + ").longValue()";
            }
            case 6: {
                return "((java.lang.Float) " + string + ").floatValue()";
            }
            case 7: {
                return "((java.lang.Double) " + string + ").doubleValue()";
            }
            case 9: 
            case 10: {
                return "((" + type + ") " + string + ")";
            }
        }
        throw new Error("unexpected type code: " + n);
    }

    private static String wrapArgumentCode(Type type, String string) {
        int n = type.getTypeCode();
        switch (n) {
            case 0: {
                return "new java.lang.Boolean(" + string + ")";
            }
            case 1: {
                return "new java.lang.Byte(" + string + ")";
            }
            case 2: {
                return "new java.lang.Character(" + string + ")";
            }
            case 3: {
                return "new java.lang.Short(" + string + ")";
            }
            case 4: {
                return "new java.lang.Integer(" + string + ")";
            }
            case 5: {
                return "new java.lang.Long(" + string + ")";
            }
            case 6: {
                return "new java.lang.Float(" + string + ")";
            }
            case 7: {
                return "new java.lang.Double(" + string + ")";
            }
            case 9: 
            case 10: {
                return string;
            }
        }
        throw new Error("unexpected type code: " + n);
    }

    private void writeInterfaceHash(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("private static final long interfaceHash = " + this.remoteClass.getInterfaceHash() + "L;");
    }

    private static void writeMarshalArgument(IndentingWriter indentingWriter, String string, Type type, String string2) throws IOException {
        int n = type.getTypeCode();
        switch (n) {
            case 0: {
                indentingWriter.p(String.valueOf(string) + ".writeBoolean(" + string2 + ")");
                break;
            }
            case 1: {
                indentingWriter.p(String.valueOf(string) + ".writeByte(" + string2 + ")");
                break;
            }
            case 2: {
                indentingWriter.p(String.valueOf(string) + ".writeChar(" + string2 + ")");
                break;
            }
            case 3: {
                indentingWriter.p(String.valueOf(string) + ".writeShort(" + string2 + ")");
                break;
            }
            case 4: {
                indentingWriter.p(String.valueOf(string) + ".writeInt(" + string2 + ")");
                break;
            }
            case 5: {
                indentingWriter.p(String.valueOf(string) + ".writeLong(" + string2 + ")");
                break;
            }
            case 6: {
                indentingWriter.p(String.valueOf(string) + ".writeFloat(" + string2 + ")");
                break;
            }
            case 7: {
                indentingWriter.p(String.valueOf(string) + ".writeDouble(" + string2 + ")");
                break;
            }
            case 9: 
            case 10: {
                indentingWriter.p(String.valueOf(string) + ".writeObject(" + string2 + ")");
                break;
            }
            default: {
                throw new Error("unexpected type code: " + n);
            }
        }
    }

    private static void writeMarshalArguments(IndentingWriter indentingWriter, String string, Type[] typeArray, String[] stringArray) throws IOException {
        if (typeArray.length != stringArray.length) {
            throw new Error("paramter type and name arrays different sizes");
        }
        int n = 0;
        while (n < typeArray.length) {
            Generator.writeMarshalArgument(indentingWriter, string, typeArray[n], stringArray[n]);
            indentingWriter.pln(";");
            ++n;
        }
    }

    private void writeMethodFieldDeclarations(IndentingWriter indentingWriter) throws IOException {
        int n = 0;
        while (n < this.methodFieldNames.length) {
            indentingWriter.pln("private static java.lang.reflect.Method " + this.methodFieldNames[n] + ";");
            ++n;
        }
    }

    private void writeMethodFieldInitializers(IndentingWriter indentingWriter) throws IOException {
        int n = 0;
        while (n < this.methodFieldNames.length) {
            indentingWriter.p(String.valueOf(this.methodFieldNames[n]) + " = ");
            RemoteClass.Method method = this.remoteMethods[n];
            MemberDefinition memberDefinition = method.getMemberDefinition();
            Identifier identifier = method.getName();
            Type type = method.getType();
            Type[] typeArray = type.getArgumentTypes();
            indentingWriter.p(String.valueOf(String.valueOf(memberDefinition.getClassDefinition().getName())) + ".class.getMethod(\"" + identifier + "\", new java.lang.Class[] {");
            int n2 = 0;
            while (n2 < typeArray.length) {
                if (n2 > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(String.valueOf(String.valueOf(typeArray[n2])) + ".class");
                ++n2;
            }
            indentingWriter.pln("});");
            ++n;
        }
    }

    private void writeOperationsArray(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.plnI("private static final " + Constants.idOperation + "[] operations = {");
        int n = 0;
        while (n < this.remoteMethods.length) {
            if (n > 0) {
                indentingWriter.pln(",");
            }
            indentingWriter.p("new " + Constants.idOperation + "(\"" + this.remoteMethods[n].getOperationString() + "\")");
            ++n;
        }
        indentingWriter.pln();
        indentingWriter.pOln("};");
    }

    private void writeSkeleton(IndentingWriter indentingWriter) throws IOException {
        int n;
        if (this.version == 3) {
            throw new Error("should not generate skeleton for version");
        }
        indentingWriter.pln("// Skeleton class generated by rmic, do not edit.");
        indentingWriter.pln("// Contents subject to change without notice.");
        indentingWriter.pln();
        if (this.remoteClassName.isQualified()) {
            indentingWriter.pln("package " + this.remoteClassName.getQualifier() + ";");
            indentingWriter.pln();
        }
        indentingWriter.plnI("public final class " + Names.mangleClass(this.skeletonClassName.getName()));
        indentingWriter.pln("implements " + Constants.idSkeleton);
        indentingWriter.pOlnI("{");
        this.writeOperationsArray(indentingWriter);
        indentingWriter.pln();
        this.writeInterfaceHash(indentingWriter);
        indentingWriter.pln();
        indentingWriter.plnI("public " + Constants.idOperation + "[] getOperations() {");
        indentingWriter.pln("return (" + Constants.idOperation + "[]) operations.clone();");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public void dispatch(" + Constants.idRemote + " obj, " + Constants.idRemoteCall + " call, int opnum, long hash)");
        indentingWriter.pln("throws java.lang.Exception");
        indentingWriter.pOlnI("{");
        if (this.version == 2) {
            indentingWriter.plnI("if (opnum < 0) {");
            if (this.remoteMethods.length > 0) {
                n = 0;
                while (n < this.remoteMethods.length) {
                    if (n > 0) {
                        indentingWriter.pO("} else ");
                    }
                    indentingWriter.plnI("if (hash == " + this.remoteMethods[n].getMethodHash() + "L) {");
                    indentingWriter.pln("opnum = " + n + ";");
                    ++n;
                }
                indentingWriter.pOlnI("} else {");
            }
            indentingWriter.pln("throw new " + Constants.idUnmarshalException + "(\"invalid method hash\");");
            if (this.remoteMethods.length > 0) {
                indentingWriter.pOln("}");
            }
            indentingWriter.pOlnI("} else {");
        }
        indentingWriter.plnI("if (hash != interfaceHash)");
        indentingWriter.pln("throw new " + Constants.idSkeletonMismatchException + "(\"interface hash mismatch\");");
        indentingWriter.pO();
        if (this.version == 2) {
            indentingWriter.pOln("}");
        }
        indentingWriter.pln();
        indentingWriter.pln(String.valueOf(String.valueOf(this.remoteClassName)) + " server = (" + this.remoteClassName + ") obj;");
        indentingWriter.plnI("switch (opnum) {");
        n = 0;
        while (n < this.remoteMethods.length) {
            this.writeSkeletonDispatchCase(indentingWriter, n);
            ++n;
        }
        indentingWriter.pOlnI("default:");
        indentingWriter.pln("throw new " + Constants.idUnmarshalException + "(\"invalid method number\");");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    private void writeSkeletonDispatchCase(IndentingWriter indentingWriter, int n) throws IOException {
        int n2;
        RemoteClass.Method method = this.remoteMethods[n];
        Identifier identifier = method.getName();
        Type type = method.getType();
        Type[] typeArray = type.getArgumentTypes();
        String[] stringArray = Generator.nameParameters(typeArray);
        Type type2 = type.getReturnType();
        indentingWriter.pOlnI("case " + n + ": // " + type.typeString(identifier.toString(), true, false));
        indentingWriter.pOlnI("{");
        if (typeArray.length > 0) {
            n2 = 0;
            while (n2 < typeArray.length) {
                indentingWriter.pln(String.valueOf(String.valueOf(typeArray[n2])) + " " + stringArray[n2] + ";");
                ++n2;
            }
            indentingWriter.plnI("try {");
            indentingWriter.pln("java.io.ObjectInput in = call.getInputStream();");
            boolean bl = Generator.writeUnmarshalArguments(indentingWriter, "in", typeArray, stringArray);
            indentingWriter.pOlnI("} catch (java.io.IOException e) {");
            indentingWriter.pln("throw new " + Constants.idUnmarshalException + "(\"error unmarshalling arguments\", e);");
            if (bl) {
                indentingWriter.pOlnI("} catch (java.lang.ClassNotFoundException e) {");
                indentingWriter.pln("throw new " + Constants.idUnmarshalException + "(\"error unmarshalling arguments\", e);");
            }
            indentingWriter.pOlnI("} finally {");
            indentingWriter.pln("call.releaseInputStream();");
            indentingWriter.pOln("}");
        } else {
            indentingWriter.pln("call.releaseInputStream();");
        }
        if (!type2.isType(11)) {
            indentingWriter.p(String.valueOf(String.valueOf(type2)) + " $result = ");
        }
        indentingWriter.p("server." + identifier + "(");
        n2 = 0;
        while (n2 < stringArray.length) {
            if (n2 > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(stringArray[n2]);
            ++n2;
        }
        indentingWriter.pln(");");
        indentingWriter.plnI("try {");
        if (!type2.isType(11)) {
            indentingWriter.p("java.io.ObjectOutput out = ");
        }
        indentingWriter.pln("call.getResultStream(true);");
        if (!type2.isType(11)) {
            Generator.writeMarshalArgument(indentingWriter, "out", type2, "$result");
            indentingWriter.pln(";");
        }
        indentingWriter.pOlnI("} catch (java.io.IOException e) {");
        indentingWriter.pln("throw new " + Constants.idMarshalException + "(\"error marshalling return\", e);");
        indentingWriter.pOln("}");
        indentingWriter.pln("break;");
        indentingWriter.pOlnI("}");
        indentingWriter.pln();
    }

    private void writeStub(IndentingWriter indentingWriter) throws IOException {
        int n;
        indentingWriter.pln("// Stub class generated by rmic, do not edit.");
        indentingWriter.pln("// Contents subject to change without notice.");
        indentingWriter.pln();
        if (this.remoteClassName.isQualified()) {
            indentingWriter.pln("package " + this.remoteClassName.getQualifier() + ";");
            indentingWriter.pln();
        }
        indentingWriter.plnI("public final class " + Names.mangleClass(this.stubClassName.getName()));
        indentingWriter.pln("extends " + Constants.idRemoteStub);
        ClassDefinition[] classDefinitionArray = this.remoteClass.getRemoteInterfaces();
        if (classDefinitionArray.length > 0) {
            indentingWriter.p("implements ");
            n = 0;
            while (n < classDefinitionArray.length) {
                if (n > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(classDefinitionArray[n].getName().toString());
                ++n;
            }
            indentingWriter.pln();
        }
        indentingWriter.pOlnI("{");
        if (this.version == 1 || this.version == 2) {
            this.writeOperationsArray(indentingWriter);
            indentingWriter.pln();
            this.writeInterfaceHash(indentingWriter);
            indentingWriter.pln();
        }
        if (this.version == 2 || this.version == 3) {
            indentingWriter.pln("private static final long serialVersionUID = 2;");
            indentingWriter.pln();
            if (this.methodFieldNames.length > 0) {
                if (this.version == 2) {
                    indentingWriter.pln("private static boolean useNewInvoke;");
                }
                this.writeMethodFieldDeclarations(indentingWriter);
                indentingWriter.pln();
                indentingWriter.plnI("static {");
                indentingWriter.plnI("try {");
                if (this.version == 2) {
                    indentingWriter.plnI(String.valueOf(String.valueOf(Constants.idRemoteRef)) + ".class.getMethod(\"invoke\",");
                    indentingWriter.plnI("new java.lang.Class[] {");
                    indentingWriter.pln(String.valueOf(String.valueOf(Constants.idRemote)) + ".class,");
                    indentingWriter.pln("java.lang.reflect.Method.class,");
                    indentingWriter.pln("java.lang.Object[].class,");
                    indentingWriter.pln("long.class");
                    indentingWriter.pOln("});");
                    indentingWriter.pO();
                    indentingWriter.pln("useNewInvoke = true;");
                }
                this.writeMethodFieldInitializers(indentingWriter);
                indentingWriter.pOlnI("} catch (java.lang.NoSuchMethodException e) {");
                if (this.version == 2) {
                    indentingWriter.pln("useNewInvoke = false;");
                } else {
                    indentingWriter.plnI("throw new java.lang.NoSuchMethodError(");
                    indentingWriter.pln("\"stub class initialization failed\");");
                    indentingWriter.pO();
                }
                indentingWriter.pOln("}");
                indentingWriter.pOln("}");
                indentingWriter.pln();
            }
        }
        this.writeStubConstructors(indentingWriter);
        indentingWriter.pln();
        if (this.remoteMethods.length > 0) {
            indentingWriter.pln("// methods from remote interfaces");
            n = 0;
            while (n < this.remoteMethods.length) {
                indentingWriter.pln();
                this.writeStubMethod(indentingWriter, n);
                ++n;
            }
        }
        indentingWriter.pOln("}");
    }

    private void writeStubConstructors(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("// constructors");
        if (this.version == 1 || this.version == 2) {
            indentingWriter.plnI("public " + Names.mangleClass(this.stubClassName.getName()) + "() {");
            indentingWriter.pln("super();");
            indentingWriter.pOln("}");
        }
        indentingWriter.plnI("public " + Names.mangleClass(this.stubClassName.getName()) + "(" + Constants.idRemoteRef + " ref) {");
        indentingWriter.pln("super(ref);");
        indentingWriter.pOln("}");
    }

    private void writeStubMethod(IndentingWriter indentingWriter, int n) throws IOException {
        int n2;
        RemoteClass.Method method = this.remoteMethods[n];
        Identifier identifier = method.getName();
        Type type = method.getType();
        Type[] typeArray = type.getArgumentTypes();
        String[] stringArray = Generator.nameParameters(typeArray);
        Type type2 = type.getReturnType();
        ClassDeclaration[] classDeclarationArray = method.getExceptions();
        indentingWriter.pln("// implementation of " + type.typeString(identifier.toString(), true, false));
        indentingWriter.p("public " + type2 + " " + identifier + "(");
        int n3 = 0;
        while (n3 < typeArray.length) {
            if (n3 > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(String.valueOf(String.valueOf(typeArray[n3])) + " " + stringArray[n3]);
            ++n3;
        }
        indentingWriter.plnI(")");
        if (classDeclarationArray.length > 0) {
            indentingWriter.p("throws ");
            int n4 = 0;
            while (n4 < classDeclarationArray.length) {
                if (n4 > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(classDeclarationArray[n4].getName().toString());
                ++n4;
            }
            indentingWriter.pln();
        }
        indentingWriter.pOlnI("{");
        Vector vector = this.computeUniqueCatchList(classDeclarationArray);
        if (vector.size() > 0) {
            indentingWriter.plnI("try {");
        }
        if (this.version == 2) {
            indentingWriter.plnI("if (useNewInvoke) {");
        }
        if (this.version == 2 || this.version == 3) {
            if (!type2.isType(11)) {
                indentingWriter.p("Object $result = ");
            }
            indentingWriter.p("ref.invoke(this, " + this.methodFieldNames[n] + ", ");
            if (typeArray.length > 0) {
                indentingWriter.p("new java.lang.Object[] {");
                n2 = 0;
                while (n2 < typeArray.length) {
                    if (n2 > 0) {
                        indentingWriter.p(", ");
                    }
                    indentingWriter.p(Generator.wrapArgumentCode(typeArray[n2], stringArray[n2]));
                    ++n2;
                }
                indentingWriter.p("}");
            } else {
                indentingWriter.p("null");
            }
            indentingWriter.pln(", " + method.getMethodHash() + "L);");
            if (!type2.isType(11)) {
                indentingWriter.pln("return " + Generator.unwrapArgumentCode(type2, "$result") + ";");
            }
        }
        if (this.version == 2) {
            indentingWriter.pOlnI("} else {");
        }
        if (this.version == 1 || this.version == 2) {
            indentingWriter.pln(String.valueOf(String.valueOf(Constants.idRemoteCall)) + " call = ref.newCall((" + Constants.idRemoteObject + ") this, operations, " + n + ", interfaceHash);");
            if (typeArray.length > 0) {
                indentingWriter.plnI("try {");
                indentingWriter.pln("java.io.ObjectOutput out = call.getOutputStream();");
                Generator.writeMarshalArguments(indentingWriter, "out", typeArray, stringArray);
                indentingWriter.pOlnI("} catch (java.io.IOException e) {");
                indentingWriter.pln("throw new " + Constants.idMarshalException + "(\"error marshalling arguments\", e);");
                indentingWriter.pOln("}");
            }
            indentingWriter.pln("ref.invoke(call);");
            if (type2.isType(11)) {
                indentingWriter.pln("ref.done(call);");
            } else {
                indentingWriter.pln(String.valueOf(String.valueOf(type2)) + " $result;");
                indentingWriter.plnI("try {");
                indentingWriter.pln("java.io.ObjectInput in = call.getInputStream();");
                n2 = Generator.writeUnmarshalArgument(indentingWriter, "in", type2, "$result") ? 1 : 0;
                indentingWriter.pln(";");
                indentingWriter.pOlnI("} catch (java.io.IOException e) {");
                indentingWriter.pln("throw new " + Constants.idUnmarshalException + "(\"error unmarshalling return\", e);");
                if (n2 != 0) {
                    indentingWriter.pOlnI("} catch (java.lang.ClassNotFoundException e) {");
                    indentingWriter.pln("throw new " + Constants.idUnmarshalException + "(\"error unmarshalling return\", e);");
                }
                indentingWriter.pOlnI("} finally {");
                indentingWriter.pln("ref.done(call);");
                indentingWriter.pOln("}");
                indentingWriter.pln("return $result;");
            }
        }
        if (this.version == 2) {
            indentingWriter.pOln("}");
        }
        if (vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ClassDefinition classDefinition = (ClassDefinition)enumeration.nextElement();
                indentingWriter.pOlnI("} catch (" + classDefinition.getName() + " e) {");
                indentingWriter.pln("throw e;");
            }
            indentingWriter.pOlnI("} catch (java.lang.Exception e) {");
            indentingWriter.pln("throw new " + Constants.idUnexpectedException + "(\"undeclared checked exception\", e);");
            indentingWriter.pOln("}");
        }
        indentingWriter.pOln("}");
    }

    private static boolean writeUnmarshalArgument(IndentingWriter indentingWriter, String string, Type type, String string2) throws IOException {
        boolean bl = false;
        if (string2 != null) {
            indentingWriter.p(String.valueOf(string2) + " = ");
        }
        int n = type.getTypeCode();
        switch (type.getTypeCode()) {
            case 0: {
                indentingWriter.p(String.valueOf(string) + ".readBoolean()");
                break;
            }
            case 1: {
                indentingWriter.p(String.valueOf(string) + ".readByte()");
                break;
            }
            case 2: {
                indentingWriter.p(String.valueOf(string) + ".readChar()");
                break;
            }
            case 3: {
                indentingWriter.p(String.valueOf(string) + ".readShort()");
                break;
            }
            case 4: {
                indentingWriter.p(String.valueOf(string) + ".readInt()");
                break;
            }
            case 5: {
                indentingWriter.p(String.valueOf(string) + ".readLong()");
                break;
            }
            case 6: {
                indentingWriter.p(String.valueOf(string) + ".readFloat()");
                break;
            }
            case 7: {
                indentingWriter.p(String.valueOf(string) + ".readDouble()");
                break;
            }
            case 9: 
            case 10: {
                indentingWriter.p("(" + type + ") " + string + ".readObject()");
                bl = true;
                break;
            }
            default: {
                throw new Error("unexpected type code: " + n);
            }
        }
        return bl;
    }

    private static boolean writeUnmarshalArguments(IndentingWriter indentingWriter, String string, Type[] typeArray, String[] stringArray) throws IOException {
        if (typeArray.length != stringArray.length) {
            throw new Error("paramter type and name arrays different sizes");
        }
        boolean bl = false;
        int n = 0;
        while (n < typeArray.length) {
            if (Generator.writeUnmarshalArgument(indentingWriter, string, typeArray[n], stringArray[n])) {
                bl = true;
            }
            indentingWriter.pln(";");
            ++n;
        }
        return bl;
    }
}

