/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.applet.AppletClassLoader;
import sun.applet.AppletPanel;
import sun.awt.AppContext;

public class AppletSecurity
extends SecurityManager {
    private AppContext mainAppContext;
    private static RuntimePermission threadPermission;
    private static RuntimePermission threadGroupPermission;
    private boolean inThreadGroupCheck = false;

    public AppletSecurity() {
        this.reset();
        this.mainAppContext = AppContext.getAppContext();
    }

    public synchronized void checkAccess(Thread thread) {
        if (!this.inThreadGroup(thread)) {
            if (threadPermission == null) {
                threadPermission = new RuntimePermission("modifyThread");
            }
            this.checkPermission(threadPermission);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void checkAccess(ThreadGroup threadGroup) {
        block5: {
            if (this.inThreadGroupCheck) {
                if (threadGroupPermission == null) {
                    threadGroupPermission = new RuntimePermission("modifyThreadGroup");
                }
                this.checkPermission(threadGroupPermission);
                return;
            }
            try {
                this.inThreadGroupCheck = true;
                if (this.inThreadGroup(threadGroup)) break block5;
                if (threadGroupPermission == null) {
                    threadGroupPermission = new RuntimePermission("modifyThreadGroup");
                }
                this.checkPermission(threadGroupPermission);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.inThreadGroupCheck = false;
                throw throwable;
            }
        }
        Object var3_2 = null;
        this.inThreadGroupCheck = false;
    }

    public void checkAwtEventQueueAccess() {
        AppContext appContext = AppContext.getAppContext();
        AppletClassLoader appletClassLoader = this.currentAppletClassLoader();
        if (appContext == this.mainAppContext && appletClassLoader != null) {
            super.checkAwtEventQueueAccess();
        }
    }

    public void checkPackageAccess(final String string) {
        super.checkPackageAccess(string);
        final boolean[] blArray = new boolean[1];
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                int n;
                String string3 = string;
                do {
                    String string2;
                    if (Boolean.getBoolean(string2 = "package.restrict.access." + string3)) {
                        blArray[0] = true;
                        break;
                    }
                    n = string3.lastIndexOf(46);
                    if (n == -1) continue;
                    string3 = string3.substring(0, n);
                } while (n != -1);
                return null;
            }
        });
        if (blArray[0]) {
            this.checkPermission(new RuntimePermission("accessClassInPackage." + string));
        }
    }

    private AppletClassLoader currentAppletClassLoader() {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null || classLoader instanceof AppletClassLoader) {
            return (AppletClassLoader)classLoader;
        }
        Class<?>[] classArray = this.getClassContext();
        int n = 0;
        while (n < classArray.length) {
            classLoader = classArray[n].getClassLoader();
            if (classLoader instanceof AppletClassLoader) {
                return (AppletClassLoader)classLoader;
            }
            ++n;
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof AppletClassLoader) {
            return (AppletClassLoader)classLoader;
        }
        return null;
    }

    public ThreadGroup getThreadGroup() {
        AppletClassLoader appletClassLoader = this.currentAppletClassLoader();
        if (appletClassLoader != null && appletClassLoader instanceof AppletClassLoader) {
            AppletClassLoader appletClassLoader2 = appletClassLoader;
            ThreadGroup threadGroup = appletClassLoader2.getThreadGroup();
            if (threadGroup == null) {
                return super.getThreadGroup();
            }
            ThreadGroup threadGroup2 = Thread.currentThread().getThreadGroup();
            if (!threadGroup.parentOf(threadGroup2) || threadGroup == threadGroup2) {
                throw new SecurityException("Access denied to ThreadGroup not owned by applet");
            }
            AppContext appContext = AppContext.getAppContext();
            ThreadGroup threadGroup3 = AppletPanel.getAppContextThreadGroup(appContext);
            if (threadGroup3 != null) {
                return threadGroup3;
            }
            throw new SecurityException("Access denied to ThreadGroup not owned by applet");
        }
        return super.getThreadGroup();
    }

    protected boolean inThreadGroup(Thread thread) {
        return this.inThreadGroup(thread.getThreadGroup());
    }

    protected boolean inThreadGroup(ThreadGroup threadGroup) {
        if (this.currentAppletClassLoader() == null) {
            return false;
        }
        return this.getThreadGroup().parentOf(threadGroup);
    }

    public void reset() {
    }
}

