/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.tools.javadoc.DocletInvoker;
import com.sun.tools.javadoc.Env;
import com.sun.tools.javadoc.Res;
import com.sun.tools.javadoc.RootDocImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassFile;
import sun.tools.java.Constants;
import sun.tools.java.Identifier;
import sun.tools.java.Package;
import sun.tools.util.CommandLine;
import sun.tools.util.ModifierFilter;

public final class Main
implements Constants {
    static final String program = "javadoc";
    static final String standardDocletClassName = "com.sun.tools.doclets.standard.Standard";
    static final String oneOneDocletClassName = "com.sun.tools.doclets.oneone.OneOne";
    static List options = new ArrayList();
    static int nwarnings = 0;
    static int nerrors = 0;
    static ModifierFilter showAccess = null;
    static long defaultFilter = 5L;
    static DocletInvoker docletInvoker;

    static void exit() {
        int n = 0;
        if (nerrors > 0) {
            Res.notice(nerrors > 1 ? "main.errors" : "main.error", String.valueOf(nerrors));
            n = 1;
        }
        if (nwarnings > 0) {
            Res.notice(nwarnings > 1 ? "main.warnings" : "main.warning", String.valueOf(nwarnings));
        }
        System.exit(n);
    }

    static RootDocImpl init(Env env, List list) {
        RootDocImpl rootDocImpl = null;
        try {
            rootDocImpl = Main.initInner(env, list);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Res.error("main.out.of.memory");
            Main.exit();
        }
        catch (Error error) {
            error.printStackTrace();
            Res.error("main.fatal.error");
            Main.exit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Res.error("main.fatal.exception");
            Main.exit();
        }
        return rootDocImpl;
    }

    static RootDocImpl initInner(Env env, List list) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<ClassDeclaration> arrayList2 = new ArrayList<ClassDeclaration>();
        try {
            Object object;
            Object object2;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                if (Main.parseSourceClass(env, (String)object2)) continue;
                arrayList.add(object2);
            }
            object2 = env.getClasses();
            while (object2.hasMoreElements()) {
                object = (ClassDeclaration)object2.nextElement();
                arrayList2.add((ClassDeclaration)object);
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                Main.parseSourcePackage(env, (String)object);
            }
        }
        finally {
            Object var5_7 = null;
            env.flushErrors();
            nerrors += env.nerrors;
            nwarnings += env.nwarnings;
        }
        if (nerrors > 0) {
            Main.exit();
        }
        Res.notice("main.Building_tree");
        System.gc();
        if (showAccess == null) {
            Main.setFilter(defaultFilter);
        }
        return new RootDocImpl(env, arrayList2, arrayList, showAccess, options);
    }

    public static void main(String[] stringArray) {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        long l = System.currentTimeMillis();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 4;
        String string5 = null;
        try {
            stringArray = CommandLine.parse(stringArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Res.error("main.cant.read", fileNotFoundException.getMessage());
            Main.exit();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Main.exit();
        }
        Main.setDocletInvoker(stringArray);
        int n2 = 0;
        while (n2 < stringArray.length) {
            object = stringArray[n2];
            if (((String)object).equals("-verbose")) {
                Main.setOption((String)object);
                n |= 1;
            } else if (((String)object).equals("-encoding")) {
                Main.oneArg(stringArray, n2++);
                string5 = stringArray[n2];
            } else if (((String)object).equals("-help")) {
                Main.usage();
                Main.exit();
            } else if (((String)object).equals("-private")) {
                Main.setOption((String)object);
                Main.setFilter(-9223372036854775801L);
            } else if (((String)object).equals("-package")) {
                Main.setOption((String)object);
                Main.setFilter(-9223372036854775803L);
            } else if (((String)object).equals("-protected")) {
                Main.setOption((String)object);
                Main.setFilter(5L);
            } else if (((String)object).equals("-public")) {
                Main.setOption((String)object);
                Main.setFilter(1L);
            } else if (((String)object).equals("-sourcepath")) {
                Main.oneArg(stringArray, n2++);
                if (string != null) {
                    Main.usageError("main.option.already.seen", (String)object);
                }
                string = stringArray[n2];
            } else if (((String)object).equals("-classpath")) {
                Main.oneArg(stringArray, n2++);
                if (string3 != null) {
                    Main.usageError("main.option.already.seen", (String)object);
                }
                string3 = stringArray[n2];
            } else if (((String)object).equals("-sysclasspath")) {
                Main.oneArg(stringArray, n2++);
                if (string2 != null) {
                    Main.usageError("main.option.already.seen", (String)object);
                }
                string2 = stringArray[n2];
            } else if (((String)object).equals("-bootclasspath")) {
                Main.oneArg(stringArray, n2++);
                if (string2 != null) {
                    Main.usageError("main.option.already.seen", (String)object);
                }
                string2 = stringArray[n2];
            } else if (((String)object).equals("-extdirs")) {
                Main.oneArg(stringArray, n2++);
                if (string4 != null) {
                    Main.usageError("main.option.already.seen", (String)object);
                }
                string4 = stringArray[n2];
            } else if (stringArray[n2].equals("-Xverbosepath")) {
                bl = true;
            } else if (((String)object).equals("-overview")) {
                Main.oneArg(stringArray, n2++);
            } else if (((String)object).equals("-doclet")) {
                ++n2;
            } else if (((String)object).equals("-docletpath")) {
                ++n2;
            } else if (((String)object).equals("-locale")) {
                Main.oneArg(stringArray, n2++);
                RootDocImpl.setLocale(stringArray[n2]);
            } else if (((String)object).equals("-1.1")) {
                Main.setOption((String)object);
            } else if (((String)object).startsWith("-")) {
                int n3 = docletInvoker.optionLength((String)object);
                if (n3 < 0) {
                    Main.exit();
                } else if (n3 == 0) {
                    Main.usageError("main.invalid_flag", (String)object);
                } else {
                    if (n2 + n3 > stringArray.length) {
                        Main.usageError("main.requires_argument", (String)object);
                    }
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    int n4 = 0;
                    while (n4 < n3 - 1) {
                        arrayList2.add(stringArray[++n2]);
                        ++n4;
                    }
                    Main.setOption((String)object, arrayList2);
                }
            } else {
                arrayList.add(object);
            }
            ++n2;
        }
        if (arrayList.isEmpty()) {
            Main.usageError("main.No_packages_or_classes_specified");
        }
        if (!docletInvoker.validOptions(RootDocImpl.options(options))) {
            Main.exit();
        }
        object = Env.create(string, string3, string2, string4, n, string5);
        if (bl) {
            ((Env)object).printPaths();
        }
        RootDocImpl rootDocImpl = Main.init((Env)object, arrayList);
        object = null;
        System.gc();
        docletInvoker.start(rootDocImpl);
        if ((n & 1) != 0) {
            l = System.currentTimeMillis() - l;
            Res.notice("main.done_in", Long.toString(l));
        }
        Main.exit();
    }

    static void oneArg(String[] stringArray, int n) {
        if (n + 1 < stringArray.length) {
            Main.setOption(stringArray[n], stringArray[n + 1]);
        } else {
            Main.usageError("main.requires_argument", stringArray[n]);
        }
    }

    static boolean parseSourceClass(Env env, String string) throws IOException {
        Object object;
        Identifier identifier = Identifier.lookup(string);
        Package package_ = env.getPackage(identifier.getQualifier());
        if (package_.exists() && (object = package_.getSourceFile(identifier.getName())) != null) {
            env.parseFile((ClassFile)object);
            Res.notice("main.Loading_source_file_for_class", string);
            ClassDeclaration classDeclaration = env.getClassDeclaration(identifier);
            if (classDeclaration.getClassDefinition() == null || classDeclaration.getStatus() == 3) {
                env.error(0L, "wrong.source", ((ClassFile)object).getPath(), classDeclaration, package_);
                classDeclaration.setDefinition(null, 7);
            }
            return true;
        }
        object = new File(string);
        try {
            env.parseFile(new ClassFile((File)object));
            Res.notice("main.Loading_source_file", ((File)object).toString());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static void parseSourcePackage(Env env, String string) throws IOException {
        Identifier identifier = Identifier.lookup(string);
        Package package_ = env.getPackage(identifier);
        boolean bl = false;
        if (package_.exists()) {
            Enumeration enumeration = package_.getSourceFiles();
            while (enumeration.hasMoreElements()) {
                if (!bl) {
                    Res.notice("main.Loading_source_files_for_package", string);
                    bl = true;
                }
                env.parseFile((ClassFile)enumeration.nextElement());
            }
        }
        if (!bl) {
            Res.error("main.source_not_found", string);
        }
    }

    static void setDocletInvoker(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            if (string3.equals("-1.1")) {
                if (string != null) {
                    Main.usageError("main.more_than_one_doclet_specified_0_and_1", string, oneOneDocletClassName);
                }
                string = oneOneDocletClassName;
            } else if (string3.equals("-doclet")) {
                Main.oneArg(stringArray, n++);
                if (string != null) {
                    Main.usageError("main.more_than_one_doclet_specified_0_and_1", string, stringArray[n]);
                }
                string = stringArray[n];
            } else if (string3.equals("-docletpath")) {
                Main.oneArg(stringArray, n++);
                string2 = string2 == null ? stringArray[n] : String.valueOf(string2) + File.pathSeparator + stringArray[n];
            }
            ++n;
        }
        if (string == null) {
            string = standardDocletClassName;
        }
        docletInvoker = new DocletInvoker(string, string2);
    }

    static void setFilter(long l) {
        if (showAccess != null) {
            Res.error("main.incompatible.access.flags");
            Main.usage();
            Main.exit();
        }
        showAccess = new ModifierFilter(l);
    }

    static void setOption(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        options.add(arrayList);
    }

    static void setOption(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string2);
        options.add(arrayList);
    }

    static void setOption(String string, List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.addAll(list);
        options.add(arrayList);
    }

    static void usage() {
        Res.notice("main.usage");
        if (docletInvoker != null) {
            docletInvoker.optionLength("-help");
        }
    }

    static void usageError(String string) {
        Res.error(string);
        Main.usage();
        Main.exit();
    }

    static void usageError(String string, String string2) {
        Res.error(string, string2);
        Main.usage();
        Main.exit();
    }

    static void usageError(String string, String string2, String string3) {
        Res.error(string, string2, string3);
        Main.usage();
        Main.exit();
    }
}

