/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.ArrayList;
import java.util.Iterator;

public class RenderableImageProducer
implements ImageProducer,
Runnable {
    private RenderableImage image;
    private RenderContext context;
    private ArrayList consumers = new ArrayList();

    public RenderableImageProducer(RenderableImage renderableImage, RenderContext renderContext) {
        this.image = renderableImage;
        this.context = renderContext;
    }

    public void setRenderContext(RenderContext renderContext) {
        this.context = renderContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsumer(ImageConsumer imageConsumer) {
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            if (!this.consumers.contains(imageConsumer)) {
                this.consumers.add(imageConsumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConsumer(ImageConsumer imageConsumer) {
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            return this.consumers.contains(imageConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(ImageConsumer imageConsumer) {
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            this.consumers.remove(imageConsumer);
        }
    }

    @Override
    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
        Thread thread = new Thread((Runnable)this, "RenderableImageProducerWorker");
        thread.start();
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            Object object;
            RenderedImage renderedImage = this.context == null ? this.image.createDefaultRendering() : this.image.createRendering(this.context);
            Raster raster = renderedImage.getData();
            ColorModel colorModel = renderedImage.getColorModel();
            if (colorModel == null) {
                colorModel = ColorModel.getRGBdefault();
            }
            SampleModel sampleModel = raster.getSampleModel();
            DataBuffer dataBuffer = raster.getDataBuffer();
            int n = raster.getWidth();
            int n2 = raster.getHeight();
            Iterator iterator = this.consumers.iterator();
            while (iterator.hasNext()) {
                object = (ImageConsumer)iterator.next();
                object.setHints(30);
                object.setDimensions(n, n2);
            }
            object = new int[n];
            int[] nArray = new int[sampleModel.getNumBands()];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    sampleModel.getPixel(j, i, nArray, dataBuffer);
                    object[j] = colorModel.getDataElement(nArray, 0);
                }
                for (ImageConsumer imageConsumer : this.consumers) {
                    imageConsumer.setPixels(0, i, n, 1, colorModel, (int[])object, 0, n);
                }
            }
            for (ImageConsumer imageConsumer : this.consumers) {
                imageConsumer.imageComplete(3);
            }
        }
    }
}

