/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class ColorConvertOp
implements BufferedImageOp,
RasterOp {
    private RenderingHints hints;
    private ICC_Profile[] profiles = null;
    private ColorSpace[] spaces;

    public ColorConvertOp(ColorSpace colorSpace, RenderingHints renderingHints) {
        if (colorSpace == null) {
            throw new NullPointerException();
        }
        this.spaces = new ColorSpace[]{colorSpace};
        this.hints = renderingHints;
    }

    public ColorConvertOp(ColorSpace colorSpace, ColorSpace colorSpace2, RenderingHints renderingHints) {
        if (colorSpace == null || colorSpace2 == null) {
            throw new NullPointerException();
        }
        this.spaces = new ColorSpace[]{colorSpace, colorSpace2};
        this.hints = renderingHints;
    }

    public ColorConvertOp(ICC_Profile[] iCC_ProfileArray, RenderingHints renderingHints) {
        if (iCC_ProfileArray == null) {
            throw new NullPointerException();
        }
        this.hints = renderingHints;
        this.profiles = iCC_ProfileArray;
        this.spaces = new ColorSpace[iCC_ProfileArray.length];
        for (int i = 0; i < iCC_ProfileArray.length; ++i) {
            this.spaces[i] = new ICC_ColorSpace(iCC_ProfileArray[i]);
        }
    }

    public ColorConvertOp(RenderingHints renderingHints) {
        this.hints = renderingHints;
        this.spaces = new ColorSpace[0];
    }

    @Override
    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        BufferedImage bufferedImage3;
        if (bufferedImage2 == null && this.spaces.length == 0) {
            throw new IllegalArgumentException("Not enough color space information to complete conversion.");
        }
        if (bufferedImage2 != null && (bufferedImage.getHeight() != bufferedImage2.getHeight() || bufferedImage.getWidth() != bufferedImage2.getWidth())) {
            throw new IllegalArgumentException("Source and destination images have different dimensions");
        }
        if (bufferedImage.isAlphaPremultiplied()) {
            bufferedImage3 = this.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
            this.copyimage(bufferedImage, bufferedImage3);
            bufferedImage3.coerceData(false);
            bufferedImage = bufferedImage3;
        }
        for (int i = 0; i < this.spaces.length; ++i) {
            if (bufferedImage.getColorModel().getColorSpace().getType() == this.spaces[i].getType()) continue;
            bufferedImage3 = this.createCompatibleDestImage(bufferedImage, this.createCompatibleColorModel(bufferedImage, this.spaces[i]));
            this.copyimage(bufferedImage, bufferedImage3);
            bufferedImage = bufferedImage3;
        }
        if (bufferedImage2 == null) {
            bufferedImage2 = bufferedImage;
        } else {
            this.copyimage(bufferedImage, bufferedImage2);
        }
        return bufferedImage2;
    }

    @Override
    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        if (this.spaces.length < 2) {
            throw new IllegalArgumentException("Not enough information about source and destination colorspaces.");
        }
        if (this.spaces[0].getNumComponents() != raster.getNumBands() || writableRaster != null && this.spaces[this.spaces.length - 1].getNumComponents() != writableRaster.getNumBands()) {
            throw new IllegalArgumentException("Source or destination raster contains the wrong number of bands.");
        }
        if (writableRaster != null && (raster.getHeight() != writableRaster.getHeight() || raster.getWidth() != writableRaster.getWidth())) {
            throw new IllegalArgumentException("Source and destination rasters have different dimensions");
        }
        for (int i = 0; i < this.spaces.length - 2; ++i) {
            WritableRaster writableRaster2 = this.createCompatibleDestRaster(raster, this.spaces[i + 1], false, raster.getTransferType());
            this.copyraster(raster, this.spaces[i], writableRaster2, this.spaces[i + 1]);
            raster = writableRaster2;
        }
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster, this.spaces[this.spaces.length - 1], false, 0);
        }
        this.copyraster(raster, this.spaces[this.spaces.length - 2], writableRaster, this.spaces[this.spaces.length - 1]);
        return writableRaster;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        if (colorModel == null && this.spaces.length == 0) {
            throw new IllegalArgumentException("Don't know the destination colormodel");
        }
        if (colorModel == null) {
            colorModel = this.createCompatibleColorModel(bufferedImage, this.spaces[this.spaces.length - 1]);
        }
        return new BufferedImage(colorModel, this.createCompatibleDestRaster(bufferedImage.getRaster(), colorModel.getColorSpace(), bufferedImage.getColorModel().hasAlpha(), colorModel.getTransferType()), bufferedImage.isAlphaPremultiplied(), null);
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster raster) {
        if (this.spaces.length < 2) {
            throw new IllegalArgumentException("Not enough destination colorspace information");
        }
        return this.createCompatibleDestRaster(raster, this.spaces[this.spaces.length - 1], false, 0);
    }

    public final ICC_Profile[] getICC_Profiles() {
        return this.profiles;
    }

    @Override
    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    @Override
    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            return (Point2D)point2D.clone();
        }
        point2D2.setLocation(point2D);
        return point2D2;
    }

    @Override
    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return bufferedImage.getRaster().getBounds();
    }

    @Override
    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    private void copyimage(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        if (this.hints != null) {
            graphics2D.setRenderingHints(this.hints);
        }
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
    }

    private void copyraster(Raster raster, ColorSpace colorSpace, WritableRaster writableRaster, ColorSpace colorSpace2) {
        float[] fArray = new float[raster.getNumBands()];
        if (this.hints != null && this.hints.get(RenderingHints.KEY_COLOR_RENDERING) == RenderingHints.VALUE_COLOR_RENDER_QUALITY) {
            for (int i = raster.getMinY(); i < raster.getHeight() + raster.getMinY(); ++i) {
                for (int j = raster.getMinX(); j < raster.getWidth() + raster.getMinX(); ++j) {
                    writableRaster.setPixel(j, i, colorSpace2.fromCIEXYZ(colorSpace.toCIEXYZ(raster.getPixel(j, i, fArray))));
                }
            }
        } else {
            for (int i = raster.getMinY(); i < raster.getHeight() + raster.getMinY(); ++i) {
                for (int j = raster.getMinX(); j < raster.getWidth() + raster.getMinX(); ++j) {
                    writableRaster.setPixel(j, i, colorSpace2.fromRGB(colorSpace.toRGB(raster.getPixel(j, i, fArray))));
                }
            }
        }
    }

    private ColorModel createCompatibleColorModel(BufferedImage bufferedImage, ColorSpace colorSpace) {
        return new ComponentColorModel(colorSpace, bufferedImage.getColorModel().hasAlpha(), bufferedImage.isAlphaPremultiplied(), bufferedImage.getColorModel().getTransparency(), 0);
    }

    private WritableRaster createCompatibleDestRaster(Raster raster, ColorSpace colorSpace, boolean bl, int n) {
        int n2 = colorSpace.getNumComponents();
        if (bl) {
            ++n2;
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        DataBuffer dataBuffer = Buffers.createBuffer(n, raster.getWidth() * raster.getHeight() * n2, 1);
        return new WritableRaster(new PixelInterleavedSampleModel(n, raster.getWidth(), raster.getHeight(), n2, n2 * raster.getWidth(), nArray), dataBuffer, new Point(raster.getMinX(), raster.getMinY()));
    }
}

