/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.logging;

import java.io.IOException;
import javax.servlet.ServletContext;
import org.apache.jasper.logging.Logger;

public class DefaultLogger
extends Logger {
    private static char[] newline;
    protected ServletContext servletContext;

    static {
        String separator = System.getProperty("line.separator", "\n");
        newline = separator.toCharArray();
    }

    public DefaultLogger() {
    }

    public DefaultLogger(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private void bad(Throwable t1, String message, Throwable t2) {
        System.err.println("Default sink is unwritable! Reason:");
        if (t1 != null) {
            t1.printStackTrace();
        }
        if (message != null) {
            System.err.println(message);
        }
        if (t2 != null) {
            t2.printStackTrace();
        }
    }

    public void flush() {
        try {
            Logger.defaultSink.flush();
        }
        catch (IOException iOException) {}
    }

    protected void realLog(String message) {
        if (this.servletContext != null) {
            this.servletContext.log(message);
            return;
        }
        try {
            Logger.defaultSink.write(message);
            Logger.defaultSink.write(newline);
            this.flush();
        }
        catch (IOException e) {
            this.bad(e, message, null);
        }
    }

    protected void realLog(String message, Throwable t) {
        if (this.servletContext != null) {
            this.servletContext.log(message, t);
            return;
        }
        try {
            Logger.defaultSink.write(message);
            Logger.defaultSink.write(newline);
            Logger.defaultSink.write(Logger.throwableToString(t));
            Logger.defaultSink.write(newline);
            this.flush();
        }
        catch (IOException e) {
            this.bad(e, message, t);
        }
    }
}

