/*
 * Decompiled with CFR 0.152.
 */
package tyrex.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.util.Properties;
import javax.naming.InitialContext;
import org.omg.CORBA.ORB;
import tyrex.conf.Server;
import tyrex.resource.ResourceLimits;
import tyrex.server.TransactionServer;
import tyrex.util.Messages;

public final class Configure
implements Serializable {
    private int _txTimeout = 60000;
    private boolean _txTerminate;
    private boolean _txNested = true;
    private ResourceLimits _limits;
    private transient PrintWriter _logWriter;
    private boolean _use_log = false;
    private String _log_directory;
    private transient Server _serverConf;
    private ORB _orb;
    private boolean _recovery = false;
    static /* synthetic */ Class class$tyrex$server$TransactionServer;

    public void activateRecovery() {
        this._recovery = true;
    }

    public void activation() throws Exception {
        try {
            ActivationGroupDesc activationGroupDesc = new ActivationGroupDesc(new Properties(), null);
            ActivationGroupID activationGroupID = ActivationGroup.getSystem().registerGroup(activationGroupDesc);
            ActivationGroup.createGroup((ActivationGroupID)activationGroupID, (ActivationGroupDesc)activationGroupDesc, (long)0L);
            ActivationDesc activationDesc = new ActivationDesc(activationGroupID, (class$tyrex$server$TransactionServer != null ? class$tyrex$server$TransactionServer : (class$tyrex$server$TransactionServer = Configure.class$("tyrex.server.TransactionServer"))).getName(), null, new MarshalledObject<Configure>(this));
            ActivationID activationID = ActivationGroup.getSystem().registerObject(activationDesc);
            Remote remote = Activatable.register((ActivationDesc)activationDesc);
            Naming.rebind("/tyrex/TransactionServer", remote);
            InitialContext initialContext = new InitialContext();
            initialContext.rebind("/tyrex/TransactionServer", (Object)remote);
        }
        catch (Exception exception) {
            if (this.getLogWriter() != null) {
                this.getLogWriter().println(Messages.format("tyrex.server.failedActivate", exception));
            }
            throw exception;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void flush() throws IOException {
        if (this._serverConf == null) {
            throw new IOException(Messages.message("tyrex.server.noConfigFile"));
        }
        this._serverConf.save();
    }

    public String getLogDirectory() {
        return this._log_directory;
    }

    public PrintWriter getLogWriter() {
        return this._logWriter;
    }

    public boolean getNestedTransaction() {
        return this._txNested;
    }

    public ORB getORB() {
        return this._orb;
    }

    public synchronized ResourceLimits getResourceLimits() {
        if (this._limits == null) {
            this._limits = new ResourceLimits();
        }
        return this._limits;
    }

    public boolean getThreadTerminate() {
        return this._txTerminate;
    }

    public int getTransactionTimeout() {
        return this._txTimeout / 1000;
    }

    public boolean isLogActivated() {
        return this._use_log;
    }

    public boolean isRecoveryActivated() {
        return this._recovery;
    }

    public int serverStatus() {
        return TransactionServer.status();
    }

    public void setLogProperty(String string) {
        this._log_directory = string;
        if (string != null) {
            this._use_log = true;
        }
    }

    public void setLogWriter(PrintWriter printWriter) {
        if (printWriter == null) {
            throw new NullPointerException("Argument 'writer' is null");
        }
        this._logWriter = printWriter;
    }

    public void setNestedTransaction(boolean bl) {
        this._txNested = bl;
    }

    public void setORB(ORB oRB) {
        this._orb = oRB;
    }

    public synchronized void setResourceLimits(ResourceLimits resourceLimits) {
        this._limits = resourceLimits;
    }

    public void setThreadTerminate(boolean bl) {
        this._txTerminate = bl;
    }

    public void setTransactionTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.message("tyrex.tx.timeNegative"));
        }
        this._txTimeout = n == 0 ? 60000 : n * 1000;
    }

    public void shutdownServer() {
        TransactionServer.shutdown(this);
    }

    public void startServer() {
        TransactionServer.start(this);
    }

    public static class Default {
        public static final int TxTimeout = 60;
        public static final int UpperLimit = 200;
        public static final int Duration = 10;
    }

    public static class Status {
        public static final int Inactive = 0;
        public static final int Active = 1;
        public static final int Starting = 2;
        public static final int Shutdown = 3;
    }

    public static class Names {
        public static final String TransactionServer = "/tyrex/TransactionServer";
        public static final String UserTransaction = "/comp/UserTransaction";
    }
}

