/*
 * Decompiled with CFR 0.152.
 */
package tyrex.resource;

import java.io.Serializable;

public final class ResourceLimits
implements Serializable {
    private int _upperLimit = -1;
    private int _desiredSize = 0;
    private int _activeLimit = -1;
    private int _waitTimeout = 10000;
    private float _pruneFactor = 0.1f;
    private int _checkEvery = 10000;

    public int getActiveLimit() {
        return this._activeLimit;
    }

    public int getCheckEvery() {
        return this._checkEvery;
    }

    public int getDesiredSize() {
        return this._desiredSize;
    }

    public float getPruneFactor() {
        return this._pruneFactor;
    }

    public int getUpperLimit() {
        return this._upperLimit;
    }

    public int getWaitTimeout() {
        return this._waitTimeout / 1000;
    }

    public void setActiveLimit(int n) {
        this._activeLimit = n;
    }

    public void setCheckEvery(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Argument 'checkEvery' is negative");
        }
        this._checkEvery = n * 1000;
    }

    public void setDesiredSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Argument 'desiredSize' is negative");
        }
        this._desiredSize = n;
    }

    public void setPruneFactor(float f) {
        if (f < 0.0f || (double)f > 1.0) {
            throw new IllegalArgumentException("Argument 'pruneFactor' is negative");
        }
        this._pruneFactor = f;
    }

    public void setUpperLimit(int n) {
        this._upperLimit = n;
    }

    public void setWaitTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Argument 'waitTimeout' is negative");
        }
        this._waitTimeout = n * 1000;
    }
}

