/*
 * Decompiled with CFR 0.152.
 */
package tyrex.recovery;

import java.sql.Connection;
import java.util.Vector;
import javax.naming.spi.ObjectFactory;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Vote;
import tyrex.jdbc.ServerDataSource;
import tyrex.jdbc.xa.EnabledDataSource;
import tyrex.jdbc.xa.XADataSourceImpl;
import tyrex.recovery.ConnectionLog;
import tyrex.recovery.LogMonitor;
import tyrex.recovery.LogWriter;
import tyrex.tm.XidImpl;
import tyrex.util.Logger;

public class RecoveryManager {
    private LogMonitor _monitor;
    private boolean _xa_used = false;
    private XAResource[] _xa;
    public static RecoveryManager manager;

    public RecoveryManager(String string, ORB oRB) {
        this._monitor = new LogMonitor(string);
        this._monitor.setORB(oRB);
    }

    private void commit_xa_resources(XidImpl xidImpl) {
        if (this.is_xa_used()) {
            XAResource[] xAResourceArray = this.list_pending_xa_resources(xidImpl);
            int n = 0;
            while (n < xAResourceArray.length) {
                try {
                    xAResourceArray[n].commit(xidImpl, false);
                }
                catch (XAException xAException) {}
                ++n;
            }
        }
    }

    private void continue_ots_commit(XidImpl xidImpl, Resource[] resourceArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Vector<Resource> vector = new Vector<Resource>();
        int n = 0;
        while (n < resourceArray.length) {
            if (bl && !bl2) {
                try {
                    resourceArray[n].rollback();
                    bl3 = true;
                    LogWriter.out.rollback_ots_resource(xidImpl, resourceArray[n]);
                }
                catch (HeuristicCommit heuristicCommit) {
                    if (!bl3) {
                        bl2 = true;
                    }
                    vector.addElement(resourceArray[n]);
                }
                catch (HeuristicHazard heuristicHazard) {
                    vector.addElement(resourceArray[n]);
                }
                catch (HeuristicMixed heuristicMixed) {
                    vector.addElement(resourceArray[n]);
                }
                catch (COMM_FAILURE cOMM_FAILURE) {
                }
                catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {}
            } else {
                try {
                    resourceArray[n].commit();
                    bl2 = true;
                    LogWriter.out.commit_ots_resource(xidImpl, resourceArray[n]);
                }
                catch (NotPrepared notPrepared) {
                    bl = true;
                }
                catch (HeuristicRollback heuristicRollback) {
                    bl = true;
                    vector.addElement(resourceArray[n]);
                }
                catch (HeuristicMixed heuristicMixed) {
                    bl = true;
                    vector.addElement(resourceArray[n]);
                }
                catch (HeuristicHazard heuristicHazard) {
                    bl = true;
                    vector.addElement(resourceArray[n]);
                }
                catch (COMM_FAILURE cOMM_FAILURE) {
                    bl = true;
                }
                catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                    bl = true;
                }
            }
            ++n;
        }
        if (!bl) {
            LogWriter.out.commit_end(xidImpl, 0);
        } else {
            LogWriter.out.rollback_end(xidImpl, 0);
        }
        Resource resource = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            resource = (Resource)vector.elementAt(n2);
            try {
                resource.forget();
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {}
            ++n2;
        }
        LogWriter.out.completed(xidImpl);
    }

    private void continue_ots_commit_one_phase(XidImpl xidImpl, Resource resource) {
        try {
            resource.commit_one_phase();
            LogWriter.out.commit_ots_resource(xidImpl, resource);
        }
        catch (HeuristicHazard heuristicHazard) {
            resource.forget();
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
        }
        catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {}
        LogWriter.out.completed(xidImpl);
    }

    private boolean is_xa_used() {
        if (!this._xa_used && this._xa == null) {
            this.open_xa_resources();
            if (this._xa != null && this._xa.length != 0) {
                this._xa_used = true;
            }
        }
        return this._xa_used;
    }

    private XAResource[] list_pending_xa_resources(XidImpl xidImpl) {
        int n;
        Object[] objectArray;
        Vector<XAResource> vector = new Vector<XAResource>();
        int n2 = 0;
        while (n2 < this._xa.length) {
            try {
                objectArray = this._xa[n2].recover(0);
                n = 0;
                while (n < objectArray.length) {
                    if (xidImpl.equals(objectArray[n])) {
                        vector.addElement(this._xa[n2]);
                        n = objectArray.length;
                    }
                    ++n;
                }
            }
            catch (XAException xAException) {}
            ++n2;
        }
        objectArray = new XAResource[vector.size()];
        n = 0;
        while (n < vector.size()) {
            objectArray[n] = (XAResource)vector.elementAt(n);
            ++n;
        }
        return objectArray;
    }

    public static void newRecoveryManager(String string, ORB oRB) {
        manager = new RecoveryManager(string, oRB);
    }

    private void open_xa_resources() {
        ConnectionLog[] connectionLogArray = this._monitor.open_connections();
        this._xa = new XAResource[connectionLogArray.length];
        int n = 0;
        while (n < connectionLogArray.length) {
            try {
                ObjectFactory objectFactory;
                if (connectionLogArray[n].datasource.startsWith("tyrex-driver:")) {
                    objectFactory = new EnabledDataSource();
                    ((EnabledDataSource)objectFactory).setDriverName(connectionLogArray[n].datasource.substring(13));
                    this._xa[n] = ((XADataSourceImpl)((Object)objectFactory)).getXAConnection(connectionLogArray[n].name, connectionLogArray[n].password).getXAResource();
                } else {
                    objectFactory = new ServerDataSource(connectionLogArray[n].datasource);
                    Connection connection = ((ServerDataSource)objectFactory).getConnection(connectionLogArray[n].name, connectionLogArray[n].password);
                    this._xa[n] = ((XAConnection)((Object)connection)).getXAResource();
                }
            }
            catch (Exception exception) {}
            ++n;
        }
    }

    private void print(String string, String string2) {
        Logger.getSystemLogger().println(String.valueOf(string) + ": " + string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void recover_this_transaction(XidImpl xidImpl) {
        this.print("RecoveryManager", "Recover transaction : " + xidImpl.toString());
        Status status = this._monitor.transaction_status(xidImpl);
        switch (status.value()) {
            case 0: {
                this.print("RecoveryManager", "transaction active");
                Resource[] resourceArray = this._monitor.registered_ots_resources(xidImpl);
                this.rollback_ots_resources(xidImpl, resourceArray);
                this.rollback_xa_resources(xidImpl);
                LogWriter.out.rollback_end(xidImpl, 0);
                LogWriter.out.completed(xidImpl);
                return;
            }
            case 7: {
                this.print("RecoveryManager", "transaction is preparing");
                Resource[] resourceArray = this._monitor.prepared_ots_resources(xidImpl);
                this.rollback_ots_resources(xidImpl, resourceArray);
                Resource[] resourceArray2 = this._monitor.free_ots_resources(xidImpl);
                this.rollback_ots_resources(xidImpl, resourceArray2);
                this.rollback_xa_resources(xidImpl);
                LogWriter.out.rollback_end(xidImpl, 0);
                LogWriter.out.completed(xidImpl);
                return;
            }
            case 2: {
                this.print("RecoveryManager", "transaction is prepared");
                Vote vote = this._monitor.prepare_vote(xidImpl);
                switch (vote.value()) {
                    case 0: {
                        this.print("RecoveryManager", "Commit is voted");
                        if (this._monitor.is_any_rollback(xidImpl)) {
                            this.print("RecoveryManager", "Must be rolledback");
                            Resource[] resourceArray = this._monitor.prepared_ots_resources(xidImpl);
                            this.rollback_ots_resources(xidImpl, resourceArray);
                            this.rollback_xa_resources(xidImpl);
                            LogWriter.out.rollback_end(xidImpl, 0);
                            LogWriter.out.completed(xidImpl);
                            return;
                        }
                        this.print("RecoveryManager", "Continue commit");
                        Resource[] resourceArray = this._monitor.prepared_ots_resources(xidImpl);
                        Resource[] resourceArray3 = this._monitor.registered_ots_resources(xidImpl);
                        if (resourceArray.length == 1 && resourceArray3.length == 1) {
                            this.continue_ots_commit_one_phase(xidImpl, resourceArray[0]);
                        } else {
                            this.continue_ots_commit(xidImpl, resourceArray);
                        }
                        this.commit_xa_resources(xidImpl);
                        return;
                    }
                    case 2: {
                        this.print("RecoveryManager", "ReadOnly is voted");
                        LogWriter.out.commit_end(xidImpl, 0);
                        LogWriter.out.completed(xidImpl);
                        return;
                    }
                    case 1: {
                        this.print("RecoveryManager", "Rollback is voted");
                        Resource[] resourceArray = this._monitor.prepared_ots_resources(xidImpl);
                        this.rollback_ots_resources(xidImpl, resourceArray);
                        this.rollback_xa_resources(xidImpl);
                        LogWriter.out.rollback_end(xidImpl, 0);
                        LogWriter.out.completed(xidImpl);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 8: {
                this.print("RecoveryManager", "transaction is committing");
                if (this._monitor.is_any_rollback(xidImpl)) {
                    this.print("RecoveryManager", "Must be rolledback");
                    Resource[] resourceArray = this._monitor.prepared_ots_resources(xidImpl);
                    this.rollback_ots_resources(xidImpl, resourceArray);
                    this.rollback_xa_resources(xidImpl);
                    LogWriter.out.rollback_end(xidImpl, 0);
                    LogWriter.out.completed(xidImpl);
                    return;
                }
                this.print("RecoveryManager", "Continue commit");
                Resource[] resourceArray = this._monitor.prepared_ots_resources(xidImpl);
                Resource[] resourceArray4 = this._monitor.registered_ots_resources(xidImpl);
                if (resourceArray.length == 1 && resourceArray4.length == 1) {
                    this.continue_ots_commit_one_phase(xidImpl, resourceArray[0]);
                } else {
                    this.continue_ots_commit(xidImpl, resourceArray);
                }
                this.commit_xa_resources(xidImpl);
                return;
            }
            case 9: {
                this.print("RecoveryManager", "transaction is rolling back");
                Resource[] resourceArray = this._monitor.free_ots_resources(xidImpl);
                this.rollback_ots_resources(xidImpl, resourceArray);
                this.rollback_xa_resources(xidImpl);
                LogWriter.out.rollback_end(xidImpl, 0);
                LogWriter.out.completed(xidImpl);
                return;
            }
            default: {
                this.print("RecoveryManager", "transaction state not expected, just to be completed : " + status.value());
                LogWriter.out.completed(xidImpl);
            }
        }
    }

    public void recover_transactions() {
        this.print("RecoveryManager", "Begin transaction recovery");
        XidImpl[] xidImplArray = this._monitor.uncompleted_transactions();
        int n = 0;
        while (n < xidImplArray.length) {
            this.recover_this_transaction(xidImplArray[n]);
            ++n;
        }
        LogWriter.out.recovery();
        this.print("RecoveryManager", "End of recovery : " + xidImplArray.length + " transaction(s) recovered.");
    }

    private void rollback_ots_resources(XidImpl xidImpl, Resource[] resourceArray) {
        int n = 0;
        while (n < resourceArray.length) {
            try {
                resourceArray[n].rollback();
                LogWriter.out.rollback_ots_resource(xidImpl, resourceArray[n]);
            }
            catch (HeuristicCommit heuristicCommit) {
            }
            catch (HeuristicMixed heuristicMixed) {
            }
            catch (HeuristicHazard heuristicHazard) {
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {}
            ++n;
        }
    }

    private void rollback_xa_resources(XidImpl xidImpl) {
        if (this.is_xa_used()) {
            XAResource[] xAResourceArray = this.list_pending_xa_resources(xidImpl);
            int n = 0;
            while (n < xAResourceArray.length) {
                try {
                    xAResourceArray[n].rollback(xidImpl);
                }
                catch (XAException xAException) {}
                ++n;
            }
        }
    }
}

