/*
 * Decompiled with CFR 0.152.
 */
package tyrex.naming;

import java.io.Serializable;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import tyrex.naming.MemoryBinding;
import tyrex.naming.MemoryBindingEnumeration;
import tyrex.naming.MemoryContext;
import tyrex.naming.NamingPermission;
import tyrex.util.FastThreadLocal;

public final class EnvContext
implements Context,
Serializable {
    private static FastThreadLocal _local = new FastThreadLocal();
    private transient MemoryBinding _bindings;
    private Hashtable _env = new Hashtable();
    private String _path;
    static /* synthetic */ Class class$tyrex$naming$MemoryContextFactory;

    public EnvContext(Hashtable hashtable) throws NamingException {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.addToEnvironment(string, hashtable.get(string));
            }
        } else {
            hashtable = new Hashtable();
        }
        this._path = null;
    }

    EnvContext(MemoryBinding memoryBinding, Hashtable hashtable) throws NamingException {
        this._bindings = memoryBinding;
        this._path = this._bindings.getName();
        if (this._path.length() == 0) {
            this._path = null;
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.addToEnvironment(string, hashtable.get(string));
            }
        } else {
            hashtable = new Hashtable();
        }
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this._env.put(string, object);
    }

    public void bind(String string, Object object) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void bind(Name name, Object object) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() {
        this._env.clear();
    }

    public String composeName(String string, String string2) {
        return String.valueOf(string2) + "/" + string;
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        name2 = (Name)name2.clone();
        return name2.addAll(name);
    }

    public Context createSubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void destroySubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    private MemoryBinding getBindings() throws NamingException {
        if (this._bindings != null) {
            return this._bindings;
        }
        ThreadMemoryBinding threadMemoryBinding = (ThreadMemoryBinding)_local.get();
        if (threadMemoryBinding == null) {
            throw new NamingException("Error: Environment naming context (java:comp) not bound to this thread");
        }
        MemoryBinding memoryBinding = threadMemoryBinding.bindings;
        if (this._path != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this._path, "/");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.length() <= 0) continue;
                MemoryBinding memoryBinding2 = (MemoryBinding)memoryBinding.get(string);
                if (memoryBinding2 == null || !(memoryBinding2 instanceof MemoryBinding)) {
                    throw new NamingException("Error: Environment naming context path java:" + this._path + " no longer bound to this thread");
                }
                memoryBinding = memoryBinding2;
            }
        }
        this._bindings = memoryBinding;
        return memoryBinding;
    }

    public Hashtable getEnvironment() {
        return this._env;
    }

    public String getNameInNamespace() throws NamingException {
        return this._path == null ? "" : this._path;
    }

    public NameParser getNameParser(String string) throws NamingException {
        if (string.length() == 0) {
            return MemoryContext.DefaultNameParser;
        }
        return this.getNameParser(new CompositeName(string));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return MemoryContext.DefaultNameParser;
        }
        String string = name.get(0);
        MemoryBinding memoryBinding = this.getBindings();
        while (name.size() > 1) {
            Object object = memoryBinding.get(string);
            if (object instanceof Context) {
                return ((Context)object).getNameParser(name.getSuffix(1));
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(String.valueOf(string) + " is not a subcontext");
            }
            memoryBinding = (MemoryBinding)object;
            name = name.getSuffix(1);
            string = name.get(0);
        }
        return MemoryContext.DefaultNameParser;
    }

    private Object internalLookup(Name name, boolean bl) throws NamingException {
        Object object;
        MemoryBinding memoryBinding;
        block11: {
            String string;
            memoryBinding = this.getBindings();
            while (true) {
                if (!name.isEmpty() && name.get(0).length() == 0) {
                    name = name.getSuffix(1);
                    continue;
                }
                if (name.isEmpty()) {
                    return new EnvContext(memoryBinding, this._env);
                }
                String string2 = name.get(0);
                if (name.size() > 1) {
                    object = memoryBinding.get(string2);
                    if (object instanceof Context) {
                        return ((Context)object).lookup(name.getSuffix(1));
                    }
                    if (!(object instanceof MemoryBinding)) {
                        throw new NotContextException(String.valueOf(string2) + " is not a subcontext");
                    }
                    memoryBinding = (MemoryBinding)object;
                    name = name.getSuffix(1);
                    continue;
                }
                object = memoryBinding.get(string2);
                if (object == null) {
                    throw new NameNotFoundException(String.valueOf(string2) + " not found");
                }
                if (!(object instanceof LinkRef) || !bl) break block11;
                string = ((LinkRef)object).getLinkName();
                if (!string.startsWith(".")) break;
                name = new CompositeName(string.substring(1));
            }
            return NamingManager.getInitialContext(this._env).lookup(string);
        }
        if (object instanceof MemoryBinding) {
            return new EnvContext((MemoryBinding)object, this._env);
        }
        if (object instanceof Reference) {
            try {
                return NamingManager.getObjectInstance(object, name, new EnvContext(memoryBinding, this._env), this._env);
            }
            catch (Exception exception) {
                throw new NamingException(exception.getMessage());
            }
        }
        return object;
    }

    public NamingEnumeration list(String string) throws NamingException {
        if (string.length() == 0) {
            return new MemoryBindingEnumeration(this.getBindings(), true, this);
        }
        return this.list(new CompositeName(string));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        Object object;
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return new MemoryBindingEnumeration(this.getBindings(), true, this);
        }
        String string = name.get(0);
        MemoryBinding memoryBinding = this.getBindings();
        while (name.size() > 1) {
            object = memoryBinding.get(string);
            if (object instanceof Context) {
                return ((Context)object).list(name.getSuffix(1));
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(String.valueOf(string) + " is not a subcontext");
            }
            memoryBinding = (MemoryBinding)object;
            name = name.getSuffix(1);
            string = name.get(0);
        }
        if (string.length() == 0) {
            return new MemoryBindingEnumeration(memoryBinding, true, this);
        }
        object = memoryBinding.get(string);
        if (object instanceof Context) {
            return ((Context)object).list("");
        }
        if (object instanceof MemoryBinding) {
            return new MemoryBindingEnumeration((MemoryBinding)object, true, this);
        }
        throw new NotContextException(String.valueOf(string) + " is not a subcontext");
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (string.length() == 0) {
            return new MemoryBindingEnumeration(this.getBindings(), false, this);
        }
        return this.listBindings(new CompositeName(string));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        Object object;
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return new MemoryBindingEnumeration(this.getBindings(), false, this);
        }
        String string = name.get(0);
        MemoryBinding memoryBinding = this.getBindings();
        while (name.size() > 1) {
            object = memoryBinding.get(string);
            if (object instanceof Context) {
                return ((Context)object).listBindings(name.getSuffix(1));
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(String.valueOf(string) + " is not a subcontext");
            }
            memoryBinding = (MemoryBinding)object;
            name = name.getSuffix(1);
            string = name.get(0);
        }
        if (string.length() == 0) {
            return new MemoryBindingEnumeration(memoryBinding, false, this);
        }
        object = memoryBinding.get(string);
        if (object instanceof Context) {
            return ((Context)object).listBindings("");
        }
        if (object instanceof MemoryBinding) {
            return new MemoryBindingEnumeration((MemoryBinding)object, false, this);
        }
        throw new NotContextException(String.valueOf(string) + " is not a subcontext");
    }

    public Object lookup(String string) throws NamingException {
        Object object = this.getBindings().get(string);
        if (object != null) {
            if (object instanceof LinkRef) {
                String string2 = ((LinkRef)object).getLinkName();
                if (string2.startsWith(".")) {
                    return this.lookup(string2.substring(1));
                }
                return NamingManager.getInitialContext(this._env).lookup(string2);
            }
            if (object instanceof MemoryBinding) {
                return new EnvContext((MemoryBinding)object, this._env);
            }
            if (object instanceof Reference) {
                try {
                    return NamingManager.getObjectInstance(object, new CompositeName(string), this, this._env);
                }
                catch (Exception exception) {
                    throw new NamingException(exception.toString());
                }
            }
            return object;
        }
        return this.internalLookup(new CompositeName(string), true);
    }

    public Object lookup(Name name) throws NamingException {
        return this.internalLookup(name, true);
    }

    public Object lookupLink(String string) throws NamingException {
        return this.internalLookup(new CompositeName(string), false);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.internalLookup(name, false);
    }

    public void rebind(String string, Object object) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void rebind(Name name, Object object) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public Object removeFromEnvironment(String string) {
        return this._env.remove(string);
    }

    public void rename(String string, String string2) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void rename(Name name, Name name2) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public static void setEnvContext(Context context) throws SecurityException, IllegalArgumentException {
        AccessController.checkPermission(NamingPermission.ENC);
        if (!(context instanceof MemoryContext)) {
            throw new IllegalArgumentException("The argument 'context' was not created from " + (class$tyrex$naming$MemoryContextFactory != null ? class$tyrex$naming$MemoryContextFactory : (class$tyrex$naming$MemoryContextFactory = EnvContext.class$("tyrex.naming.MemoryContextFactory"))).getName());
        }
        MemoryBinding memoryBinding = ((MemoryContext)context).getBindings();
        if (!memoryBinding.isRoot()) {
            throw new IllegalArgumentException("The argument 'context' is not a root context");
        }
        ThreadMemoryBinding threadMemoryBinding = (ThreadMemoryBinding)_local.get();
        threadMemoryBinding = new ThreadMemoryBinding(memoryBinding, threadMemoryBinding);
        _local.set(threadMemoryBinding);
    }

    public String toString() {
        return this._path == null ? "" : this._path;
    }

    public void unbind(String string) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public static void unsetEnvContext() throws SecurityException {
        AccessController.checkPermission(NamingPermission.ENC);
        ThreadMemoryBinding threadMemoryBinding = (ThreadMemoryBinding)_local.get();
        if (threadMemoryBinding != null) {
            _local.set(threadMemoryBinding.prev);
        }
    }

    static class ThreadMemoryBinding {
        final MemoryBinding bindings;
        final ThreadMemoryBinding prev;

        ThreadMemoryBinding(MemoryBinding memoryBinding, ThreadMemoryBinding threadMemoryBinding) {
            this.bindings = memoryBinding;
            this.prev = threadMemoryBinding;
        }
    }
}

