/*
 * Decompiled with CFR 0.152.
 */
package tyrex.connector.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import tyrex.connector.jdbc.JDBCManagedConnection;

public final class JDBCConnectionHandle
implements Connection {
    private Connection _connection;
    private boolean _closed = false;
    private JDBCManagedConnection _managed;

    JDBCConnectionHandle(JDBCManagedConnection jDBCManagedConnection, Connection connection) {
        this._managed = jDBCManagedConnection;
        this._connection = connection;
    }

    public void clearWarnings() throws SQLException {
        this.getConnection().clearWarnings();
    }

    public void close() throws SQLException {
        if (this._managed == null) {
            throw new SQLException("Connection has been closed");
        }
        this._managed.notifyClosed();
        this._managed = null;
        this._connection = null;
    }

    public void commit() throws SQLException {
        throw new SQLException("The commit method is not supported in a managed connection. Use UserTransaction to manage transactions");
    }

    public Statement createStatement() throws SQLException {
        return this.getConnection().createStatement();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.getConnection().createStatement(n, n2);
    }

    void disconnect() {
        if (this._managed == null) {
            throw new IllegalStateException("Connection has been closed");
        }
        if (this._connection == null) {
            throw new IllegalStateException("Internal error: proxy connection not associated with any underlying connection");
        }
        this._connection = null;
        this._managed = null;
    }

    protected void finalize() throws Throwable {
        if (this._managed != null) {
            this.close();
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return false;
    }

    public String getCatalog() throws SQLException {
        return this.getConnection().getCatalog();
    }

    private Connection getConnection() throws SQLException {
        if (this._connection != null) {
            return this._connection;
        }
        if (this._managed == null) {
            throw new SQLException("Connection has been closed");
        }
        throw new SQLException("Internal error: suspended connection being used by the application");
    }

    public String getInterface() {
        return "java.sql.Connection";
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.getConnection().getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this.getConnection().getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.getConnection().getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this._managed == null;
    }

    public boolean isReadOnly() throws SQLException {
        return this.getConnection().isReadOnly();
    }

    public String nativeSQL(String string) throws SQLException {
        return this.getConnection().nativeSQL(string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.getConnection().prepareCall(string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.getConnection().prepareCall(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.getConnection().prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.getConnection().prepareStatement(string, n, n2);
    }

    public void rollback() throws SQLException {
        throw new SQLException("The rollback method is not supported in a managed connection. Use UserTransaction to manage transactions");
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (bl) {
            throw new SQLException("The setAutoCommit method is not supported in a managed connection. Use UserTransaction to manage transactions");
        }
    }

    public void setCatalog(String string) throws SQLException {
        this.getConnection().setCatalog(string);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.getConnection().setReadOnly(bl);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.getConnection().setTransactionIsolation(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.getConnection().setTypeMap(map);
    }
}

