/*
 * Decompiled with CFR 0.152.
 */
package tyrex.client;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import tyrex.client.RemoteUserTransaction;

public class ClientUserTransaction
implements UserTransaction,
Serializable {
    private static transient ThreadLocal _globalXid = new ThreadLocal();
    private static transient RemoteUserTransaction _remoteTx;
    private static ResourceBundle _messages;
    private static final String MESSAGES_RESOURCE = "tyrex.client.messages";

    public ClientUserTransaction() throws RemoteException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (_messages == null) {
                try {
                    _messages = ResourceBundle.getBundle(MESSAGES_RESOURCE);
                }
                catch (MissingResourceException missingResourceException) {}
            }
            if (_remoteTx == null) {
                try {
                    _remoteTx = (RemoteUserTransaction)Naming.lookup("/comp/RemoteUserTransaction");
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RemoteException(ClientUserTransaction.getMessage("tyrex.client.malformedURL"));
                }
                catch (NotBoundException notBoundException) {
                    throw new RemoteException(ClientUserTransaction.getMessage("tyrex.client.notBound"));
                }
                catch (RemoteException remoteException) {
                    throw new RemoteException(String.valueOf(ClientUserTransaction.getMessage("tyrex.client.error")) + remoteException.getMessage());
                }
            }
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        byte[] byArray = (byte[])_globalXid.get();
        if (byArray != null) {
            throw new NotSupportedException(ClientUserTransaction.getMessage("tyrex.client.nestedNotSupported"));
        }
        try {
            byArray = _remoteTx.begin();
            _globalXid.set(byArray);
        }
        catch (RemoteException remoteException) {
            if (remoteException.detail != null && remoteException.detail instanceof SystemException) {
                throw (SystemException)remoteException.detail;
            }
            throw new SystemException(remoteException.getMessage());
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        byte[] byArray = (byte[])_globalXid.get();
        if (byArray == null) {
            throw new IllegalStateException(ClientUserTransaction.getMessage("tyrex.client.txInactive"));
        }
        try {
            try {
                _remoteTx.commit(byArray);
            }
            catch (RemoteException remoteException) {
                if (remoteException.detail != null && remoteException.detail instanceof SystemException) {
                    throw (SystemException)remoteException.detail;
                }
                throw new SystemException(remoteException.getMessage());
            }
            Object var3_3 = null;
            _globalXid.set(null);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            _globalXid.set(null);
            throw throwable;
        }
    }

    public static byte[] getGlobalXid() {
        byte[] byArray = (byte[])_globalXid.get();
        return byArray;
    }

    private static synchronized String getMessage(String string) {
        if (_messages == null) {
            return string;
        }
        try {
            return _messages.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public int getStatus() throws SystemException {
        byte[] byArray = (byte[])_globalXid.get();
        if (byArray == null) {
            return 6;
        }
        try {
            return _remoteTx.getStatus(byArray);
        }
        catch (RemoteException remoteException) {
            if (remoteException.detail != null && remoteException.detail instanceof SystemException) {
                throw (SystemException)remoteException.detail;
            }
            throw new SystemException(remoteException.getMessage());
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        byte[] byArray = (byte[])_globalXid.get();
        if (byArray == null) {
            throw new IllegalStateException(ClientUserTransaction.getMessage("tyrex.client.txInactive"));
        }
        try {
            try {
                _remoteTx.rollback(byArray);
            }
            catch (RemoteException remoteException) {
                if (remoteException.detail != null && remoteException.detail instanceof SystemException) {
                    throw (SystemException)remoteException.detail;
                }
                throw new SystemException(remoteException.getMessage());
            }
            Object var3_3 = null;
            _globalXid.set(null);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            _globalXid.set(null);
            throw throwable;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        byte[] byArray = (byte[])_globalXid.get();
        if (byArray == null) {
            throw new IllegalStateException(ClientUserTransaction.getMessage("tyrex.client.txInactive"));
        }
        try {
            _remoteTx.setRollbackOnly(byArray);
        }
        catch (RemoteException remoteException) {
            if (remoteException.detail != null && remoteException.detail instanceof SystemException) {
                throw (SystemException)remoteException.detail;
            }
            throw new SystemException(remoteException.getMessage());
        }
    }

    public void setTransactionTimeout(int n) throws SystemException {
        byte[] byArray = (byte[])_globalXid.get();
        if (byArray != null) {
            try {
                _remoteTx.setTransactionTimeout(byArray, n);
            }
            catch (RemoteException remoteException) {
                if (remoteException.detail != null && remoteException.detail instanceof SystemException) {
                    throw (SystemException)remoteException.detail;
                }
                throw new SystemException(remoteException.getMessage());
            }
        }
    }
}

